
#ifndef  __JBXL_GRAPHIC_HEADER_H_
#define  __JBXL_GRAPHIC_HEADER_H_


/**
OtBbNf[^wb_`   gheader.h   v3.0   '02/8/27
                               			(C) Fumi.Iseki

  ˑ֌W

*/



#include "common.h"
#include "tools.h"

#include <stdlib.h>
#include <sys/stat.h>






///////////////////////////////////////////////////////////////////////////////////////
// CT(Moon) format wb_
//			 
typedef struct _CTHead {
	sWord  xsize;
	sWord  ysize;
	sWord  ctmin;
	sWord  ctmax;
	sWord  cutup; 
	sWord  cutdown;
	sWord  cutleft;
	sWord  cutright;
	sWord  anydata[23];
	sWord  img_flag;
} CTHead;




///////////////////////////////////////////////////////////////////////////////////////
// SUN RASTER File
// see...   man 5 rasterfile 
//
typedef struct _RasHead {
    int  ras_magic;
    int  ras_width;
    int  ras_height;
    int  ras_depth;
    int  ras_length;
    int  ras_type;
    int  ras_maptype;
    int  ras_maplength;
} RasHead;



#define RAS_MAGIC       0x59a66a95
#define RAS_RLE         0x80
#define RT_OLD          0  
#define RT_STANDARD     1 
#define RT_BYTE_ENCODED 2 
#define RT_FORMAT_RGB   3
#define RMT_NONE        0
#define RMT_EQUAL_RGB   1
#define RMT_RAW         2




///////////////////////////////////////////////////////////////////////////////////////
// ʃwb_
//
typedef struct _CmnHead {
	int	kind;				// Kind of Graphics Format		  
	int	xsize;				// Width of Graphics						
	int	ysize;				// Height of Graphics				  
	int	zsize;				// For 3D Data						 
	int	depth;				// Color Depth of Graphics	     (bit  unit)  
	unsigned int bsize;		// Fllowing buf size or Any Data (byte unit) 
	unsigned int lsize;		// Size of Graphics Data		 (byte unit) 
	uByte* buf;				// Ture Header buffer				  
	uByte* grptr;			// Pointer to Data					 
} CmnHead;







///////////////////////////////////////////////////////////////////////////////////////

typedef struct _RGB24Data
{
	uByte  R;
	uByte  G;
	uByte  B;
} RGB24Data;








///////////////////////////////////////////////////////////////////////////////////////
/**
̂łt@C`Ɠǂݍ񂾎̃wb_

Common`
	CmnHead  cmhd   : common header. 36Byte. 
	Graphic@Header : 摜f[^ŗL̃wb_
	Graphic  Data   : f[^

	Cӂ̉摜f[^ۑ鎞Ả摜f[^Ɏʃwb_(CmnHead)
	tĕۑ́D

-----------------------------------------------------------------------------------------------------
UN_KNOWN_DATA
	CmnHead  cmhd   : common header. 36Byte.@iȗj
	Any Graphic	 : Cӂ̃OtBbNf[^
		[Graphic@Header] : 摜f[^ŗL̃wb_
		[Graphic  Data]   : f[^

	Common Header͏ȗiȗꍇ́C{̃t@C`j
	摜tH[}bg͂łȂꍇ̃t@C`D]āCcmhd kindȊOӖȂD
	̌`ŕۑ邱ƂCwb_𓝈IɈƌȊOɓɈӖ͂ȂD


RAS_DATA
	CmnHead  cmhd : common header. 36Byte. iȗj
	RasHead  rshd : SunRaster̃wb_[D32Byte. o int^. 
	Graphic  Data : f[^

	Common Header͏ȗD
	Sun Raster̈ԒPȌ^(Starndard^)
	
	  			  
USERSET_DATA
	CmnHead  cmhd : common header. 36Byte. iȗj
	ANY HEADER	  : [Uw̃wb_D 
	Graphic  Data : f[^

	Common Header͏ȗD܂CANY HEADERꍇD
	wb_`Iy[^i[Ujw肷ꍇ̌^Dwb_ݒ肵āCǂݍ݁E݂̊֐
	ɓnKvD


jCTt@CɊւĂ Gio.h D


*/	
	


///////////////////////////////////////////////////////////////////////////////////////
// wb_^
// 0x0000 - 0x0080 
#define  UN_KNOWN_DATA		0  		// 0x0000	// mȂf[^`iVXeɂCj
#define  PROC_DATA			1  		// 0x0001	// (DLL)ꂽf[^`
#define  CREATE_DATA		2  		// 0x0002	// (DLL)ō쐬ꂽf[^`
#define  MOON_DATA			3  		// 0x0003	// CT DATA
#define  DICOM_DATA			4  		// 0x0004	// DICOM Header
#define  USERSET_DATA		5  		// 0x0005	// [Uw̃f[^`iwb_`w̏ꍇCgpj

#define  RAS_DATA			8  		// 0x0008	// SUN RASTER 8bit
#define  RAS8_DATA			8  		// 0x0008	// SUN RASTER 8bit
#define  RAS16_DATA			9  		// 0x0009	// SUN RASTER 16bit
#define  RAS24_DATA			9  		// 0x0001	// SUN RASTER 24bit

// for CT Data
#define  CT_DATA			16  	// 0x0010	// CT DATA (Moon`) 
#define  CT_3DM		 		18  	// 0x0012	// 3D CT DATAi}`XCXj
#define  CT_3D_VOL			19		// 0x0013	// CT {[f[^
#define  CT_RGN_SL			20  	// 0x0014	// CT Region Slice DATA

// for Well Known Graphic Data
#define  JPEG_DATA			32 		// 0x0020	// JPEG RGB
#define  JPEG_RGB_DATA		32 		// 0x0020	// JPEG RGB
#define  JPEG_MONO_DATA		33  	// 0x0021	// JPEG MONO
#define  JPEG16_RGB_DATA	34  	// 0x0022	// ݗp(16bit->32bitϊ)
#define  JPEG16_ARGB_DATA	35  	// 0x0023	// ݗp(16bit->32bitϊ)
#define  JPEG16_RGBA_DATA	36  	// 0x0024	// ݗp(16bit->32bitϊ)
#define  JPEG_ARGB_DATA		37 		// 0x0025	// ݗp(At@`l͍폜)
#define  JPEG_RGBA_DATA		38 		// 0x0026	// ݗp(At@`l͍폜)

#define  TIFF_DATA			48  	// 0x0030	// TIFF
#define  PNG_DATA			64  	// 0x0040	// PNG


// 0x0100 - 0x4000 p[^ 
#define  HAS_DUMMY1			256  	// 0x0100
#define  HAS_DUMMY2 	  	512  	// 0x0200   
#define  HAS_BASE			1024  	// 0x0400   // iグjl
#define  HAS_ZSPACE  	 	2048  	// 0x0800   
#define  HAS_RZXY		  	4096  	// 0x1000   // with RZxy data 
#define  HAS_RBOUND 	 	8192  	// 0x2000   // with RBound data 
#define  HAS_LENDIAN 		16384	// 0x4000   // gGfBA

#define  HEADER_ERROR  		32768  	// 0x8000	// G[ 
#define  NUM_KDATA   		32767  	// 0x7fff	// Max Numver of Data Format


#define  RZXY_RATE    		10000	// RZxy t@C̃wb_ɖߍލۂ̔䗦i{jD 
#define  ZEROCT_BASE  		4096		



// Data Name
#define	 UN_KNOWN_DATA_STR	"UNKNOWN DATA"
#define	 PROC_DATA_STR		"PROC DATA"
#define	 CREATE_DATA_STR	"CREATE DATA"
#define	 USERSET_DATA_STR	"USERSET DATA"
#define	 DICOM_DATA_STR		"DICOM"
#define  RAS_DATA_STR		"SUN RASTER"
#define	 CT_DATA_STR		"Common Header"
#define	 CT_3DM_STR			"Common 3D"
#define	 MOON_DATA_STR		"CT (Moon)"
#define  JPEG_RGB_DATA_STR	"JPEG RGB"
#define  JPEG_MONO_DATA_STR	"JPEG MONO"
#define  PNG_DATA_STR		"PNG"
#define  TIFF_DATA_STR		"TIFF"
#define  CT_3D_VOL_STR		"3D VOL"



// J[^Cv
// 8bit
#define  GRAPH_COLOR_MONO		0		// 0x0000
#define  GRAPH_COLOR_MONO8		0

// 16bit
#define  GRAPH_COLOR_MONO16		16		// 0x0010

#define  GRAPH_COLOR_R5G6B5		17		// 0x0011
#define  GRAPH_COLOR_RGB16		17

#define  GRAPH_COLOR_R4G4B4A4	18		// 0x0012
#define  GRAPH_COLOR_RGBA16		18

#define  GRAPH_COLOR_A4R4G4B4	19		// 0x0013
#define  GRAPH_COLOR_ARGB16		19

// 24bit
#define  GRAPH_COLOR_R8G8B8		32		// 0x0020
#define  GRAPH_COLOR_RGB24		32
#define  GRAPH_COLOR_RGB		32

#define  GRAPH_COLOR_B8G8R8		48		// 0x0030
#define  GRAPH_COLOR_BGR24		48
#define  GRAPH_COLOR_BGR		48

// 32bit
#define  GRAPH_COLOR_A8R8G8B8	64		// 0x0040
#define  GRAPH_COLOR_ARGB32		64
#define  GRAPH_COLOR_ARGB		64

#define  GRAPH_COLOR_R8G8B8A8	65		// 0x0041
#define  GRAPH_COLOR_RGBA32		65
#define  GRAPH_COLOR_RGBA		65

#define  GRAPH_COLOR_X8R8G8B8	66		// 0x0042
#define  GRAPH_COLOR_XRGB32		66
#define  GRAPH_COLOR_XRGB		66

#define  GRAPH_COLOR_A8B8G8R8	80		// 0x0050
#define  GRAPH_COLOR_ABGR32		80
#define  GRAPH_COLOR_ABGR		80

#define  GRAPH_COLOR_B8G8R8A8	81		// 0x0051
#define  GRAPH_COLOR_BGRA32		81
#define  GRAPH_COLOR_BGRA		81

#define  GRAPH_COLOR_X8B8G8R8	82		// 0x0052
#define  GRAPH_COLOR_XBGR32		82
#define  GRAPH_COLOR_XBGR		82



#define	 STATE_GRAPH_NOERR		0



// GLib ̃G[
#define  ERROR_GRAPH_HEADER		-1
#define  ERROR_GRAPH_MEMORY		-2
#define  ERROR_GRAPH_CANCEL		-3
#define  ERROR_GRAPH_NODATA		-4
#define  ERROR_GRAPH_NOFILE		-5
#define  ERROR_GRAPH_OPFILE		-6
#define  ERROR_GRAPH_RDFILE		-7
#define  ERROR_GRAPH_WRFILE		-8
#define  ERROR_GRAPH_FILESZ		-9
#define  ERROR_GRAPH_IVDARG		-20
#define  ERROR_GRAPH_THROUGH	-888	// G[X[
#define  ERROR_GRAPH			-999



// DICOM
#define  DICOM_STUDY_GROUP  	0x0020
#define  DICOM_IMAGE_GROUP  	0x0028
#define  DICOM_PIXEL_GROUP		0x7fe0

#define  DICOM_PIXEL_ELEMENT  	0x0010
#define  DICOM_XSIZE_ELEMENT  	0x0011
#define  DICOM_YSIZE_ELEMENT  	0x0010
#define  DICOM_PXLSPC_ELEMENT  	0x0030
#define  DICOM_DEPTH_ELEMENT  	0x0100
#define  DICOM_GRYLV_ELEMENT  	0x0101

#define  DICOM_PIXCEL_VR		0x574f		// Not
#define  DICOM_STR_VR			0x5344		// Zc
#define  DICOM_INT_VR			0x5355		// X, Y


#endif

