// CRwGRDoc.cpp : Cve[V t@C
//

#include "stdafx.h"

#include "RwGRDoc.h"
#include "ReadFilesDLG.h"
#include "ProgressBarDLG.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


using namespace jbxwl;




/////////////////////////////////////////////////////////////////////////////
// CRwGRDoc

IMPLEMENT_DYNCREATE(CRwGRDoc, CExDocument)

CRwGRDoc::CRwGRDoc()
{
//	multiSliceData = FALSE;
//	nonCmnHead	   = FALSE;
}



CRwGRDoc::~CRwGRDoc()
{
}




BEGIN_MESSAGE_MAP(CRwGRDoc, CExDocument)
	//{{AFX_MSG_MAP(CRwGRDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()





/////////////////////////////////////////////////////////////////////////////
// CRwGRDoc ff

#ifdef _DEBUG
void CRwGRDoc::AssertValid() const
{
	CExDocument::AssertValid();
}


void CRwGRDoc::Dump(CDumpContext& dc) const
{
	CExDocument::Dump(dc);
}
#endif //_DEBUG




/////////////////////////////////////////////////////////////////////////////
// CRwGRDoc VACY
//
void CRwGRDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂ
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂ
	}
}





/////////////////////////////////////////////////////////////////////////////
// CRwGRDoc R}h
//
BOOL  CRwGRDoc::ReadDataFile(char* str)
{
	char  message[LMESG];
	char* fname = double_bs(str);
	char* fn    = get_file_name(fname);	// t@C
	char* err_fname = NULL;				// G[Nt@C
	CmnHead  hd;

	// O[oJE^̐ݒ
	CProgressBarDLG* counter = NULL;
	counter = new CProgressBarDLG(IDD_PROGBAR, NULL, TRUE);	// fBXpb`[L
	if (counter!=NULL) { 
		SetGlobalCounter(counter);
	}

	init_CmnHead(&hd);

	// }`XCXǂݍ
	if (multiSliceData) {
		// t@Cǂݍݐݒ
		CReadFilesDLG* rsdlg = new CReadFilesDLG(fn);
		if (rsdlg==NULL) { freeNull(fname); return FALSE;}
		if (rsdlg->DoModal()!=IDOK) { 	// LZ{^
			freeNull(fname); 
			pFrame->cancelOperation  = TRUE;
			pFrame->doneErrorMessage = TRUE;
			delete (rsdlg);
			return FALSE;
		}
		startNo	= rsdlg->fromNum;
		endNo	= rsdlg->toNum;
		CString mfname = rsdlg->fName;
		delete (rsdlg);
		//Title   = preTitle + get_file_name((char*)(LPCSTR)mfname);
		Title   = get_file_name((char*)(LPCSTR)mfname);

		if (counter!=NULL) {
			CString mesg;
			mesg.LoadStringA(IDS_STR_RDNG_FILE);
			counter->Start(0, (char*)(LPCSTR)mesg);
		}

		// f[^̓ǂݍ
		hd = SetHeaderDLG.getCmnHead();
		msGraph = readGraphicSlices<sWord>((char*)(LPCSTR)mfname, startNo, endNo, &hd, true);
		if (msGraph.state>=0 && msGraph.state!=Xabs(endNo-startNo)+1) {
			CString mesg, noti;
			mesg.LoadStringA(IDS_STR_ERR_OPEN_FILE);
			noti.LoadStringA(IDS_STR_CNFRM_CNTNUE);
			err_fname = numbering_name((char*)(LPCSTR)mfname, startNo+msGraph.state-1+Sign(endNo-startNo));
			snprintf(message, LMESG-1, "CRwGRDoc::ReadDataFile\n\n" + mesg + "  %s", err_fname);
			MessageBox(pFrame->m_hWnd, message, noti, 0);
			::free(err_fname);
		}
		if (msGraph.state>0) msGraph.state = 0;

		if (msGraph.isNull() && msGraph.state==ERROR_GRAPH_HEADER) {
			err_fname = numbering_name((char*)(LPCSTR)Title, msGraph.zs);
		}
		//msGraph.color = GRAPH_COLOR_MONO16;
	}

	//	ʏ̓ǂݍ݁D	
	else {
		CString mesg;
		mesg.LoadStringA(IDS_STR_RDNG_FILE);
		if (counter!=NULL) counter->Start(0, (char*)(LPCSTR)mesg);
		//Title = preTitle + get_file_name(fname);
		Title = get_file_name(fname);
		hd = SetHeaderDLG.getCmnHead();
		msGraph = readGraphicFile<sWord>(fname, &hd, true);
	}


	this->infHead   = getinfo_CmnHead(hd);
	this->colorMode = msGraph.color;
	freeNull(fname);
	free_CmnHead(&hd);


	// O[oJE^̍폜
	if (counter!=NULL) {
		counter->Stop();
		ClearGlobalCounter();
		delete counter;
	}


	// G[
	if (msGraph.isNull()) {
		CString mesg, noti;

		if (msGraph.state==ERROR_GRAPH_OPFILE) {
			mesg.LoadStringA(IDS_STR_ERR_OPEN_FILE);
			noti.LoadStringA(IDS_STR_ERROR);
			if (multiSliceData) {
				snprintf(message, LMESG-1, "CRwGRDoc::ReadDataFile\n\n" + mesg + "  %s", err_fname);
				MessageBox(pFrame->m_hWnd, message, noti, 0);
				::free(err_fname);
			}
			else {
				MessageBox(pFrame->m_hWnd, "CRwGRDoc::ReadDataFile\n\n" +  mesg, noti, MB_OK);
			}
		}
		else if (msGraph.state==ERROR_GRAPH_MEMORY) {
			mesg.LoadStringA(IDS_STR_ERR_MEMORY);
			noti.LoadStringA(IDS_STR_ERROR);
			MessageBox(pFrame->m_hWnd, "CRwGRDoc::ReadDataFile\n\n" + mesg, noti,  MB_OK);
		}
		else if (msGraph.state==ERROR_GRAPH_CANCEL) {
			mesg.LoadStringA(IDS_STR_CANCEL_OPNFILE);
			noti.LoadStringA(IDS_STR_CANCEL);
			MessageBox(pFrame->m_hWnd, "CRwGRDoc::ReadDataFile\n\n" + mesg, noti,  MB_OK);
			pFrame->cancelOperation = TRUE;
		}
		else {
			mesg.LoadStringA(IDS_STR_ERR_UNKWN);
			noti.LoadStringA(IDS_STR_ERROR);
			MessageBox(pFrame->m_hWnd, "CRwGRDoc::ReadDataFile\n\n" + mesg, noti, MB_OK);
		}
		pFrame->doneErrorMessage = TRUE;

		return FALSE;
	}
	return  TRUE;
}






//
// hasViewData==TRUE Ȃ MakeViewData()͎sȂD
//
BOOL  CRwGRDoc::MakeViewData()
{
	CString mesg, noti;

	// JE^̐ݒ
	CProgressBarDLG* counter = NULL;
	if (msGraph.zs > 10) { 
		//counter = new CProgressBarDLG(IDD_PROGBAR, NULL, NULL, FALSE);
		counter = new CProgressBarDLG(IDD_PROGBAR, NULL, TRUE);	// fBXpb`[L
		if (counter!=NULL) {
			mesg.LoadStringA(IDS_STR_TRNS_DISPDATA);
			SetGlobalCounter(counter);
			counter->Start(0, (char*)(LPCSTR)mesg);
		}
	}

	// f[^ϊ
	cmnHead = TranslateData();

	// JE^̒~ƍ폜
	if (counter!=NULL) {
		counter->Stop();
		ClearGlobalCounter();
		delete counter;
	}


	// G[
	if (cmnHead.kind==HEADER_ERROR) {
		if (cmnHead.xsize==ERROR_GRAPH_MEMORY) {
			mesg.LoadStringA(IDS_STR_ERR_MEMORY);
			noti.LoadStringA(IDS_STR_ERROR);
			MessageBox(pFrame->m_hWnd, "CRwGRDoc::MakeViewData\n\n" + mesg, noti, MB_OK); 
		}
		else if (cmnHead.xsize==ERROR_GRAPH_CANCEL) {
			mesg.LoadStringA(IDS_STR_CANCEL_TRNS_DATA);
			noti.LoadStringA(IDS_STR_CANCEL);
			MessageBox(pFrame->m_hWnd, "CRwGRDoc::MakeViewData\n\n" + mesg, noti,  MB_OK);
			pFrame->cancelOperation = TRUE;
		}
		else {
			mesg.LoadStringA(IDS_STR_ERR_UNKWN);
			noti.LoadStringA(IDS_STR_ERROR);
			MessageBox(pFrame->m_hWnd, "CRwGRDoc::MakeViewData\n\n" + mesg, noti,  MB_OK);
		}
		pFrame->doneErrorMessage = TRUE;
		return FALSE;
	}

	return  TRUE;
}






//
//
//
CmnHead CRwGRDoc::TranslateData()
{
	CmnHead chd;

	int mode = 0;
	if (msGraph.color==GRAPH_COLOR_MONO || msGraph.color==GRAPH_COLOR_MONO16 ||  // \ 8bit
		msGraph.color==GRAPH_COLOR_RGB  || msGraph.color==GRAPH_COLOR_BGR  || 
		msGraph.color==GRAPH_COLOR_XRGB || msGraph.color==GRAPH_COLOR_ARGB || msGraph.color==GRAPH_COLOR_RGBA ||
		msGraph.color==GRAPH_COLOR_XBGR || msGraph.color==GRAPH_COLOR_ABGR || msGraph.color==GRAPH_COLOR_BGRA) {
		// 8bit/pixcel
		mode = MG2CH_OCTET;
	}
	if (ctrlCntrst || msGraph.color==GRAPH_COLOR_MONO16) {
		mode |= MG2CH_CONTRAST;
	}

	//
	chd = copyMSGraph2CmnHead(msGraph, mode, true);	// msGraph͎QƓn

	//
	cMax = vMax = msGraph.max;
	cMin = vMin = msGraph.min;
	if (msGraph.color==GRAPH_COLOR_RGB16 || msGraph.color==GRAPH_COLOR_ARGB16) {
		// 16bit/pixcel
		//vMax = cMax = UWORDMAX;
		//vMin = cMin = 0;
	}
	else if (!ctrlCntrst && cMin>=0 && cMax<=VIEW_8_MAX) {
		vMax = cMax = VIEW_8_MAX;
		vMin = cMin = 0;
	}

	base = msGraph.base;
	
	return chd;
}


