#ifndef  DISABLE_OPENNI



#include  "stdafx.h"

#include  "KinectWnd.h"
#include  "Graph.h"
#include  "Rotation.h"



using namespace jbxl;
using namespace jbxwl;




CKinectWnd::CKinectWnd(void)
{
	pViewData		= NULL;
	pLogDoc			= NULL;
	pSensorFrame	= NULL;
	pSkeletonFrame	= NULL;

	hasDepthData	= FALSE;
	isMirroring		= TRUE;
}





void  CKinectWnd::makeDisplayImage()
{
	int      index;
	XnLabel	 label = 0;
	XnLabel* lbl = NULL;
	uByte*	 src = NULL;
	uByte*   ptr;

	if (pSensorFrame==NULL) return;
	if (pViewData==NULL) return;

	if (imageMD!=NULL) {
		//if (imageData!=NULL) src = imageData;
		//else                 src = (uByte*)imageMD->RGB24Data();
		src = (uByte*)imageMD->RGB24Data();
	}
	if (m_state==OPENNI_DETECT_EXEC && hasDepthData) {
		//if (depthData!=NULL) lbl = depthData;
		//else                 lbl = (XnLabel*)sceneMD->Data();
		lbl = (XnLabel*)sceneMD->Data();
	}

	if (src!=NULL) {
		for(int j=0; j<pViewData->ysize; j++) {
			int lj = j*m_scale;
			int ls = lj*outputMode.nXRes;

			for(int i=0; i<pViewData->xsize; i++) {
				int li = i*m_scale;
				ptr    = &(pViewData->point(i, j));
				index  = (ls + li)*3;
				ptr[0] = src[index+2];		// B
				ptr[1] = src[index+1];		// G
				ptr[2] = src[index];		// R
				ptr[3] = 0;					// A

				if (lbl!=NULL) {
					label = lbl[ls + li];
					if (label>0) {
						if      (label==1){ ptr[2] = 255;}			// R
						else if (label==2){ ptr[1] = 255;}			// G
						else if (label==3){ ptr[0] = 255;}			// B
						else if (label==4){ ptr[0] = ptr[1] = 255;}	// B, G
						else if (label==5){ ptr[0] = ptr[2] = 255;}	// B, R
						else              { ptr[1] = ptr[2] = 255;}	// G, R
					}
				}	
			}
		}
	}

	// No Camera Image
	else {
		for(int j=0; j<pViewData->ysize; j++) {
			int lj = j*m_scale;
			int ls = lj*outputMode.nXRes;

			for(int i=0; i<pViewData->xsize; i++) {
				ptr = &(pViewData->point(i, j));
				ptr[0] = ptr[1] = ptr[2] = 224;
				ptr[3] = 0;

				if (lbl!=NULL) {
					int li = i*m_scale;
					label = lbl[ls + li];
					if (label>0) {
						if      (label==1){ ptr[0] = ptr[1] = 0; ptr[2] = 255;}	// R
						else if (label==2){ ptr[0] = ptr[2] = 0; ptr[1] = 255;}	// G
						else if (label==3){ ptr[1] = ptr[2] = 0; ptr[0] = 255;}	// B
						else if (label==4){ ptr[2] = 0; ptr[0] = ptr[1] = 255;}	// B, G
						else if (label==5){ ptr[1] = 0; ptr[0] = ptr[2] = 255;}	// B, R
						else              { ptr[0] = 0; ptr[1] = ptr[2] = 255;}	// G, R
					}
				}
			}
		}
	}
}




void  CKinectWnd::trackingJoints()
{
	if (user==NULL || skeleton==NULL) return;
	if (!hasDepthData) return;

	nUsers = OPENNI_MAX_USERS_NUM;
	user->GetUsers(dUsers, nUsers);

	// Detect only one user
	int id = -1;
	for (int i=0; i<nUsers; i++) {
		if (skeleton->IsTracking(dUsers[i])) {
			id = i;
			break;
		}
	}

	if (id>=0 && id<OPENNI_MAX_USERS_NUM) {
		XnUserID nId = dUsers[id];

		getJointsPositionData(nId);
		getJointsRotationData(nId);

		convertData((int)nId);
		logingJointsData((int)nId);

		drawSkeleton(BGRA2Int(255,255,255,0));
	}
}




void  CKinectWnd::logingJointsData(int uid)
{
	if (pLogDoc!=NULL) {
		for (int j=1; j<OPENNI_MAX_JOINT_NUM; j++) {
			XnVector3D  pos = jointPositionData((XnSkeletonJoint)j);
			XnMatrix3X3 rot = jointRotationData((XnSkeletonJoint)j);
			pLogDoc->printFormat("%2d (NAME)-> %s\n", j, getJointName((XnSkeletonJoint)j).c_str());
			pLogDoc->printFormat("%2d (POS) -> (%f, %f, %f)\n", j, pos.X, pos.Y, pos.Z);
			pLogDoc->printFormat("%2d (ROT) -> (%f, %f, %f)\n", j, rot.elements[0], rot.elements[1], rot.elements[2]);
			pLogDoc->printFormat("%2d (ROT) -> (%f, %f, %f)\n", j, rot.elements[3], rot.elements[4], rot.elements[5]);
			pLogDoc->printFormat("%2d (ROT) -> (%f, %f, %f)\n", j, rot.elements[6], rot.elements[7], rot.elements[8]);
		}
	}
}




void  CKinectWnd::drawSkeleton(int col)
{
	drawJointConnection(XN_SKEL_HEAD,			XN_SKEL_NECK,			col);
	drawJointConnection(XN_SKEL_NECK,			XN_SKEL_TORSO,			col);

	drawJointConnection(XN_SKEL_NECK,			XN_SKEL_LEFT_SHOULDER,  col);
	drawJointConnection(XN_SKEL_NECK,			XN_SKEL_RIGHT_SHOULDER, col);

	drawJointConnection(XN_SKEL_LEFT_SHOULDER,  XN_SKEL_LEFT_ELBOW,		col);
	drawJointConnection(XN_SKEL_RIGHT_SHOULDER, XN_SKEL_RIGHT_ELBOW,	col);
	drawJointConnection(XN_SKEL_LEFT_ELBOW,		XN_SKEL_LEFT_HAND,		col);
	drawJointConnection(XN_SKEL_RIGHT_ELBOW,	XN_SKEL_RIGHT_HAND,		col);

	drawJointConnection(XN_SKEL_TORSO,			XN_SKEL_LEFT_HIP,		col);
	drawJointConnection(XN_SKEL_TORSO,			XN_SKEL_RIGHT_HIP,		col);	
	drawJointConnection(XN_SKEL_LEFT_HIP,		XN_SKEL_LEFT_KNEE,		col);
	drawJointConnection(XN_SKEL_RIGHT_HIP,		XN_SKEL_RIGHT_KNEE,		col);
	drawJointConnection(XN_SKEL_LEFT_KNEE,		XN_SKEL_LEFT_FOOT,		col);
	drawJointConnection(XN_SKEL_RIGHT_KNEE,		XN_SKEL_RIGHT_FOOT,		col);
}




void  CKinectWnd::drawJointConnection(XnSkeletonJoint joint1, XnSkeletonJoint joint2, int col)
{
	if (pViewData==NULL) return;

	MSGraph<unsigned int> vp;
	vp.xs = pViewData->xsize;
	vp.ys = pViewData->ysize;
	vp.zs = 1;
	vp.gp = (unsigned int*)pViewData->grptr;

	if (depth!=NULL) {

		float cnfd1 = jointPositionConfidence(joint1);
		float cnfd2 = jointPositionConfidence(joint2);
		
		if (cnfd1>OPENNI_JOINT_CONFIDENCE && cnfd2>OPENNI_JOINT_CONFIDENCE) {
			XnVector3D pos1 = jointPositionData(joint1);
			XnVector3D pos2 = jointPositionData(joint2);
			
			XnPoint3D pt[2] = {pos1, pos2};
			depth->ConvertRealWorldToProjective(2, pt, pt);
			int xs = (int)(pt[0].X/m_scale);
			int ys = (int)(pt[0].Y/m_scale);
			int xe = (int)(pt[1].X/m_scale);
			int ye = (int)(pt[1].Y/m_scale);
			if (xs>=0 && xs<vp.xs && xe>=0 && xe<vp.xs && ys>=0 && ys<vp.ys && ye>=0 && ye<vp.ys) {
				MSGraph_Line(vp, xs, ys, xe, ye, col);
			}
		}
	}
}









/////////////////////////////////////////////////////////////////////////////
// Xbh

UINT  jbxwl::kinectEventLoop(LPVOID pParam)
{
	if (pParam==NULL) return -1;

	CKinectWnd* kinect = (CKinectWnd*)pParam;
	if (kinect->context==NULL)      return -1; 
	if (kinect->pSensorFrame==NULL) return -1; 
	
	CExView* pview = kinect->pSensorFrame->pView;
	kinect->pViewData = &pview->viewData;
	
	//
	Loop {
		if (kinect->m_state==OPENNI_DETECT_STOPPING) continue;
		//kinect->context->WaitAndUpdateAll();
		if (kinect->image!=NULL && kinect->imageMD!=NULL) {
			kinect->context->WaitOneUpdateAll(*(kinect->image));
			kinect->image->GetMetaData(*(kinect->imageMD));
			//if (kinect->imageData!=NULL) {
			//	memcpy(kinect->imageData, kinect->imageMD->RGB24Data(), kinect->outputMode.nXRes*kinect->outputMode.nYRes*3);
			//}
		}

		if (kinect->m_state==OPENNI_DETECT_STOPPING) continue;
		kinect->context->WaitOneUpdateAll(*(kinect->depth));
		kinect->hasDepthData = FALSE;
		if (kinect->m_state==OPENNI_DETECT_EXEC && kinect->user!=NULL) {
			kinect->context->WaitOneUpdateAll(*(kinect->user));
			kinect->user->GetUserPixels(0, *kinect->sceneMD);
			kinect->hasDepthData = TRUE;
			//if (kinect->depthData!=NULL) {
			//	memcpy(kinect->depthData, kinect->sceneMD->Data(), kinect->outputMode.nXRes*kinect->outputMode.nYRes*sizeof(XnLabel));
			//}
		}

		if (kinect->m_state==OPENNI_DETECT_STOPPING) continue;
		kinect->makeDisplayImage();			// need Depth Data when detected users are painted

		if (kinect->m_state==OPENNI_DETECT_EXEC) {
			kinect->trackingJoints();		// need Depth Data
		}

		if (kinect->pSensorFrame==NULL) break;
		if (!pview->SetNewSurface())    break;
		if (kinect->pSensorFrame==NULL) break;
		pview->ExecRender();
	}

	return 0;
}





#endif		// ifndef DISABLE_OPENNI
