#include  "StdAfx.h"

#include  "KinectNetwork.h"
#include  "KinectWnd.h"

#include  "buffer.h"
#include  "network.h"







CKinectNetwork::CKinectNetwork(void)
{
	recvSocket = 0;
	sendSocket = 0;
	sharedMem  = NULL;
	pLogDoc	   = NULL;

	printNetMode  = FALSE;
	printChkMode  = FALSE;
	animationUUID = "";
	clientPort	  = SLKNET_UDP_CLPORT;

	memset(recvKey, 0, ANM_COM_LEN_IDKEY);
	memset(&serverDataAddr, 0, sizeof(struct sockaddr_in));

	recvBuffer = make_Buffer(SLKNET_BUFFER_LEN);
	sendBuffer = make_Buffer(SLKNET_BUFFER_LEN);

	// Network̏ see network.c
	init_network();
}





CKinectNetwork::~CKinectNetwork(void)
{
	DEBUG_ERR("CKinectNetwork DESTRUCTOR");

	if (recvKey[0]!='\0') serverLogout();

	closeRecvSocket();
	closeSendSocket();

	free_Buffer(&recvBuffer);
	free_Buffer(&sendBuffer);
}




char  CKinectNetwork::serverLogin(CString server, unsigned short sport, CString groupid)
{
	int    cc;
	struct sockaddr_in sv_addr;

	udp_header udphd;
	memset(&udphd, 0, sizeof(udp_header));
	udphd.com[0] = ANM_COM_REQ_LOGIN;
	memcpy(udphd.key, (char*)(LPCSTR)groupid, ANM_COM_LEN_IDKEY);

	//
	int sock = udp_client_socket((char*)(LPCSTR)server, (int)sport, &sv_addr);		
	cc = udp_send(sock, (char*)&udphd,  sizeof(udp_header), &sv_addr);
	if (cc>0) cc = udp_recv(sock, (char*)&udphd, sizeof(udp_header), &sv_addr);
	if (cc<=0 || udphd.com[1]!=ANM_COM_REPLY_OK) {
		socket_close(sock);
		return udphd.com[1];
	}
	

	// REGIST
	::Sleep(500);	// wait server
	sv_addr.sin_port = udphd.port;
	udphd.com[0] = ANM_COM_REQ_REGIST;
	udphd.port = htons((unsigned short)clientPort);
	memcpy(udphd.uuid, (char*)(LPCSTR)animationUUID, ANM_COM_LEN_UUID);

	cc = udp_send(sock, (char*)&udphd, sizeof(udp_header), &sv_addr);
	socket_close(sock);
	if (cc<=0) return ANM_COM_REPLY_ERROR;

	memcpy(recvKey, udphd.key, ANM_COM_LEN_IDKEY);
	serverDataAddr = sv_addr;

	return ANM_COM_REPLY_OK;
}





void  CKinectNetwork::serverLogout(void)
{
	udp_header udphd;

	memset(&udphd, 0, sizeof(udp_header));
	memcpy(udphd.key, recvKey, ANM_COM_LEN_IDKEY);

	int sock = socket(AF_INET, SOCK_DGRAM, 0);

	udphd.com[0] = ANM_COM_REQ_DELETE;
	udphd.port = htons((unsigned short)clientPort);
	memcpy(udphd.uuid, (char*)(LPCSTR)animationUUID, ANM_COM_LEN_UUID);
	udp_send(sock, (char*)&udphd, sizeof(udp_header), &serverDataAddr);

	//
	udphd.com[0] = ANM_COM_REQ_LOGOUT;
	udp_send(sock, (char*)&udphd, sizeof(udp_header), &serverDataAddr);
	socket_close(sock);

	if (sharedMem!=NULL) {
		sharedMem->clearNetworkAnimationIndex();
		sharedMem->clearNetworkAnimationData();
	}

	memset(&serverDataAddr, 0, sizeof(struct sockaddr_in));
	memset(recvKey, 0, ANM_COM_LEN_IDKEY);
}




void  CKinectNetwork::openRecvSocket(void)
{
	recvSocket = udp_server_socket((int)clientPort);
	return;
}




void  CKinectNetwork::openSendSocket(void)
{
	sendSocket = socket(AF_INET, SOCK_DGRAM, 0);
	return;
}




void  CKinectNetwork::closeRecvSocket(void)
{
	if (recvSocket>0) {
		socket_close(recvSocket);
		recvSocket = 0;
	}
}




void  CKinectNetwork::closeSendSocket(void)
{
	if (sendSocket>0) {
		socket_close(sendSocket);
		sendSocket = 0;
	}
}










////////////////////////////////////////////////////////////////////////////////////////
//
// f[^M
//

UINT  kinectNetRecvLoop(LPVOID pParam)
{
	if (pParam==NULL) return -1;

	CKinectNetwork* kinectNet = (CKinectNetwork*)pParam;

	if (kinectNet->recvSocket<=0 || kinectNet->sharedMem==NULL) return -1;	

	struct sockaddr_in ds_addr;
	time_t ntm, ptm = time(NULL);
	int    num = 0;
	float  frate = 0.0;
	unsigned short delay = 0;

	//
	while (kinectNet->recvSocket>0)
	{
		int cc = udp_recv_Buffer(kinectNet->recvSocket, &(kinectNet->recvBuffer), &ds_addr);		
		if (cc>0) {
			char* ptr = (char*)kinectNet->recvBuffer.buf;
			udp_header* udphd = (udp_header*)ptr;
			int joints = (int)ntohs(udphd->num);
			int size   = (int)ntohs(udphd->sz);

			if (!strncasecmp(udphd->key, kinectNet->recvKey, ANM_COM_LEN_IDKEY)) {
				if (udphd->com[0]==ANM_COM_REQ_DELETE) {
					ptr = NULL;
				}
				else {
					ptr += sizeof(udp_header);
				}
				
				// Log
				if (kinectNet->pLogDoc!=NULL) {
					if (kinectNet->printNetMode) {
						kinectNet->pLogDoc->printFormat("NET: %s  (%2d) [%d]\n", udphd->uuid, joints, size);
					}

					if (kinectNet->printChkMode) {
						num++;
						ntm = time(NULL);
						if (ntm>ptm+SLKNET_FRM_RATE_INTVL && !strncmp(kinectNet->animationUUID, udphd->uuid, ANM_COM_LEN_UUID)) {
							frate = (float)num/(float)(ntm - ptm);
							ptm = ntm;
							num = 0;
							unsigned short tm = ntohs(*(unsigned short*)&(udphd->com[2]));
							delay = GetMsecondsLapTimer(tm);
							int n = kinectNet->sharedMem->getNetworkAnimationIndexNum();
							kinectNet->pLogDoc->printFormat("NET: CHECK: %4.1f packets/s %4d ms  (%2d) [%s]\n", frate, delay, n, udphd->key);							
						}
					}
				}

				//
				kinectNet->sharedMem->updateNetworkAnimation(ptr, udphd->uuid, joints, size);
			}
		}
	}

	return 0;
}

