#pragma once


#include  "KinectSMemory.h"
#include  "LogWndFrame.h"

#include  "xtools++.h"
#include  "Rotation.h"
#include  "WinTools.h"

#include  "anm_data.h"			 // from Animation Server 


#define   SLKNET_DEFAULT_GROUP   "NSL_TEST"
#define   SLKNET_DEFAULT_SERVER  "silver-star.nsl.tuis.ac.jp"

#define   SLKNET_UDP_SLPORT      ANM_SERVER_PORT
#define	  SLKNET_UDP_CLPORT	     8200
#define   SLKNET_UDP_TIMEOUT     10

#define	  SLKNET_BUFFER_LEN      1600	// 1500 + 100	

#define   SLKNET_FRM_RATE_INTVL	 4		// interval is +1s





using namespace jbxl;
using namespace jbxwl;





class CKinectNetwork
{
public:
	CKinectNetwork(void);
	~CKinectNetwork(void);

	int			recvSocket;
	int			sendSocket;
	
	struct sockaddr_in serverDataAddr;

	Buffer		recvBuffer;
	Buffer		sendBuffer;
	char		recvKey[ANM_COM_LEN_IDKEY];

	CKinectSMemory*	sharedMem;
	CLogWndDoc*		pLogDoc;

	CString		animationUUID;
	BOOL		printNetMode;
	BOOL		printChkMode;
	int			clientPort;



public:
	void		closeRecvSocket(void);
	void		closeSendSocket(void);

	char		serverLogin(CString server, unsigned short sport, CString groupid);
	void		serverLogout(void);

	void		openRecvSocket(void);
	void		openSendSocket(void);
};








//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// f[^M
//

UINT  kinectNetRecvLoop(LPVOID pParam);





/////////////////////////////////////////////////////////////////////////////
//
// f[^M
//

template <typename T>  void  sendAnimationData(Vector<double>* posVect, Quaternion* rotQuat, CKinectNetwork* kinectNet)
{
	clear_Buffer(&kinectNet->sendBuffer);
	udp_header* udphd = (udp_header*)kinectNet->sendBuffer.buf;
	T*	 datptr = (T*)(kinectNet->sendBuffer.buf+sizeof(udp_header));
	int* intptr = (int*)datptr;

	*intptr   = 0;
	datptr[1] = (T)posVect[0].x;
	datptr[2] = (T)posVect[0].y;
	datptr[3] = (T)posVect[0].z;
	datptr[4] = (T)rotQuat[0].x;
	datptr[5] = (T)rotQuat[0].y;
	datptr[6] = (T)rotQuat[0].z;
	datptr[7] = (T)rotQuat[0].s;

	datptr += ANM_COM_NUM_DATA;
	intptr = (int*)datptr;

	int num = 1;
	for (int i=1; i<OPENNI_MAX_JOINT_NUM; i++) {
		int n = OpenNI2SLJointNum(i);
		if (n>=0) {
			*intptr   = n;
			datptr[4] = (T)rotQuat[i].x;
			datptr[5] = (T)rotQuat[i].y;
			datptr[6] = (T)rotQuat[i].z;
			datptr[7] = (T)rotQuat[i].s;
			num++;
			datptr += ANM_COM_NUM_DATA;
			intptr = (int*)datptr;
		}
	}

	udphd->com[0] = ANM_COM_REQ_TRANSFER;
	memcpy(udphd->key,  kinectNet->recvKey, ANM_COM_LEN_IDKEY);
	memcpy(udphd->uuid, (char*)(LPCSTR)kinectNet->animationUUID, ANM_COM_LEN_UUID);
	udphd->port = htons((unsigned short)kinectNet->clientPort);
	udphd->num  = htons((unsigned short)num);
	udphd->sz   = htons((unsigned short)sizeof(T));

	unsigned short* ptm = (unsigned short*)&(udphd->com[2]);
	*ptm = htons(GetMsecondsTimer());

	kinectNet->sendBuffer.vldsz = sizeof(udp_header) + num*ANM_COM_NUM_DATA*sizeof(T);
	udp_send_Buffer(kinectNet->sendSocket, &kinectNet->sendBuffer, &kinectNet->serverDataAddr);
}


