#pragma once


#include  "SLJoints.h"
#include  "Rotation.h"



#define	  SLKSMEM_CHANNEL_NUM	    22		// Local 1 + Network (Oneself 1 + Other 20)
#define   SLKSMEM_INDEX_LEN			40		// 36 + 4

#define	  SLKSMEM_INDEX_NAME		"AnimationIndex"
#define   SLKSMEM_DEFAULT_ANIM		"f9073e22-6148-ea6f-8906-8378bfe6d44b"




using namespace jbxl;





class CKinectSMemory
{
public:
	CKinectSMemory(void);
	~CKinectSMemory(void);

	HANDLE		indexHandle;
	char*		ptrAnimIndex;

	HANDLE		mapHandle[SL_MAX_JOINT_NUM];
	double*		ptrMapData[SL_MAX_JOINT_NUM];

	BOOL		isCreated;
	CString		animationUUID;


public:
	BOOL		createSharedMemory(void);
	void		closeSharedMemory (void);
	void		clearSharedMemory (void);

	void		setAnimationIndex(char* uuid, int n=0);

	void		setLocalAnimationIndex(void);
	void		clearLocalAnimationIndex(void);

	int			getNetworkAnimationIndexNum(void);
	int			checkNetworkAnimationIndex(char* uuid);
	int			clearNetworkAnimationIndex(char* uuid);
	void		clearNetworkAnimationIndex(void);

	void		updateLocalAnimationData(Vector<double>* posVec, Quaternion* rotQuat);
	void		clearLocalAnimationData(void);
	void		clearNetworkAnimationData(void);
	void		clearAnimationData(void);

	// Index + Data
	void		updateNetworkAnimation(char* ptr, char* uuid, int joints, int size);
	void		clearNetworkAnimation(char* uuid);
};



