#include "stdafx.h"

#include "SLJoints.h"



// SL/OpenSim Joints
static  std::string _SLJointName[] =	// SL_MAX_JOINT_NUM
{
	"mPelvis",
	"mTorso", "mChest", "mNeck", "mHead",

	"mCollarLeft",  "mShoulderLeft",  "mElbowLeft",  "mWristLeft",
	"mCollarRight", "mShoulderRight", "mElbowRight", "mWristRight",
	
	"mHipLeft",  "mKneeLeft",  "mAnkleLeft",
	"mHipRight", "mKneeRight", "mAnkleRight"
};



/*
 0: DUMMY					=> none
 1: XN_SKEL_HEAD			=> none [mHead(4)]
 2: XN_SKEL_NECK			=> mNeck(3)                          1
 3: XN_SKEL_TORSO			=> mTrso(1)                          |
 4: XN_SKEL_WAIST			=> none               15 - 13 - 12 - 2 -  6 -  7 -  9
 5: XN_SKEL_LEFT_COLLAR		=> none                              |
 6: XN_SKEL_LEFT_SHOULDER	=> mShoulderRight(10)                3
 7: XN_SKEL_LEFT_ELBOW		=> mElbowRight(11)               21      17
 8: XN_SKEL_LEFT_WRIST		=> none                          |       |
 9: XN_SKEL_LEFT_HAND		=> none [mWristRight(12)]        22      18
10: XN_SKEL_LEFT_FINGERTIP	=> none                          |       |
11: XN_SKEL_RIGHT_COLLAR	=> none                          24      20
12: XN_SKEL_RIGHT_SHOULDER	=> mShoulderLeft(6)
13: XN_SKEL_RIGHT_ELBOW		=> mElbowLeft(7)
14: XN_SKEL_RIGHT_WRIST		=> none
15: XN_SKEL_RIGHT_HAND		=> none [mWristLeft(8)]
16: XN_SKEL_RIGHT_FINGERTIP	=> none
17: XN_SKEL_LEFT_HIP		=> mHipRight(16)
18: XN_SKEL_LEFT_KNEE		=> mKneeRight(17)
19: XN_SKEL_LEFT_ANKLE		=> none 
20: XN_SKEL_LEFT_FOOT		=> none [mAnkleRight(18)]
21: XN_SKEL_RIGHT_HIP		=> mHipLeft(13)
22: XN_SKEL_RIGHT_KNEE		=> mKneeLeft(14)
23: XN_SKEL_RIGHT_ANKLE		=> none
24: XN_SKEL_RIGHT_FOOT		=> none [mAnkleLeft(15)]
*/



static  int  _OpenNI2SLJoint[] =	// OPENNI_MAX_JOINT_NUM
{
	-1, 
	-1,  3,  1, -1, 
	-1, 10, 11, -1, -1, -1, 
	-1,  6,  7, -1, -1, -1,
	16, 17, -1, -1,
	13, 14, -1, -1 
};



/*
static  int  _OpenNI2SLJoint[] =	// OPENNI_MAX_JOINT_NUM
{
	-1, 
	 4,  3,  1, -1, 
	-1, 10, 11, 12, -1, -1, 
	-1,  6,  7,  8, -1, -1,
	16, 17, -1, 18,
	13, 14, -1, 15 
};
*/





std::string  SLJointName(int n)
{
	return _SLJointName[n];
}



int  OpenNI2SLJointNum(int n)
{
	return _OpenNI2SLJoint[n]; 
}