/**
	SLKinect.cpp  by Fumi.Iseki (c)

		http://www.nsl.tuis.ac.jp/
*/



#include  "stdafx.h"

#include  "SLKinect.h"

#include  "BasicLib.h"
#include  "MathLib.h"
#include  "GraphLib.h"
#include  "WinBaseLib.h"
#include  "DLGBoxLib.h"
#include  "Rotation.h"

#include  "SensorFrame.h"
#include  "MainFrm.h"

#include  "SetLogMode.h"
#include  "SetViewMode.h"
#include  "SetNetwork.h"
#include  "SetAnimation.h"
#include  "SetDataSave.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#endif



using namespace jbxl;
using namespace jbxwl;




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// CSLKinectApp CNX
//

BEGIN_MESSAGE_MAP(CSLKinectApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, &CSLKinectApp::OnAppAbout)
	// W̃t@C{hLg R}h
	ON_COMMAND(ID_MODEL_WND_OPEN, &CSLKinectApp::OnModelingWndOpen)
	ON_COMMAND(ID_LOG_WND_OPEN, &CSLKinectApp::OnLogWndOpen)
	ON_COMMAND(ID_SNSR_WND_OPEN_1, &CSLKinectApp::OnSnsrWndOpen_x1)
	ON_COMMAND(ID_SNSR_WND_OPEN_2, &CSLKinectApp::OnSnsrWndOpen_x2)
	ON_COMMAND(ID_SNSR_WND_OPEN_3, &CSLKinectApp::OnSnsrWndOpen_x3)
	ON_COMMAND(ID_SNSR_WND_OPEN_4, &CSLKinectApp::OnSnsrWndOpen_x4)
	ON_COMMAND(ID_SETTING_LOGINGMODE, &CSLKinectApp::OnSettingLogingmode)
	ON_COMMAND(ID_SETTING_VIEWMODE, &CSLKinectApp::OnSettingViewmode)
	ON_COMMAND(ID_SETTING_NETWORK, &CSLKinectApp::OnSettingNetwork)
	ON_COMMAND(ID_SETTING_ANIMATION, &CSLKinectApp::OnSettingAnimation)
	ON_COMMAND(ID_MODE_LOCAL, &CSLKinectApp::OnModeLocal)
	ON_COMMAND(ID_MODE_NETWORK, &CSLKinectApp::OnModeNetwork)
	ON_COMMAND(ID_APP_LOGIN, &CSLKinectApp::OnAppLogin)
	ON_COMMAND(ID_APP_LOGOUT, &CSLKinectApp::OnAppLogout)
	ON_COMMAND(ID_APP_DATA_LOAD, &CSLKinectApp::OnAppDataLoad)
	ON_COMMAND(ID_APP_DATA_SAVE, &CSLKinectApp::OnAppDataSave)
	ON_COMMAND(ID_APP_DATA_RECV, &CSLKinectApp::OnAppDataRecv)
	ON_COMMAND(ID_SETTING_DATA_SAVE, &CSLKinectApp::OnSettingDataSave)
END_MESSAGE_MAP()






// CSLKinectApp RXgNV
CSLKinectApp::CSLKinectApp()
{
	pMainFrame		= NULL;
	pLogFrame		= NULL;
	pLogDoc			= NULL;
	pSensorView		= NULL;
	pModelView		= NULL;

	kinect			= NULL;
	kinectNet		= NULL;
	sharedMem		= NULL;

	pDocTemplLOG	= NULL;
	pDocTemplSNR	= NULL;
	pDocTemplMDL	= NULL;

	cameraScale		= 2;


	isMirroring		= TRUE;
	isUseCamera		= TRUE;
	isLoggedIn		= FALSE;
	isRecvData		= FALSE;

	printPosMode	= TRUE;
	printRotMode	= FALSE;
	printQutMode	= TRUE;
	printNetMode    = FALSE;
	printChkMode    = FALSE;

	saveBVHFile		= FALSE;
	savePosMode		= FALSE;
	saveRotMode		= FALSE;
	saveQutMode		= TRUE;

	networkMode		= FALSE;
	networkOutMode	= NETonly;
	networkFastMode	= FALSE;

	animationUUID   = SLKSMEM_DEFAULT_ANIM;

	groupID			= SLKNET_DEFAULT_GROUP;
	animationServer = SLKNET_DEFAULT_SERVER;
	serverPort      = SLKNET_UDP_SLPORT;
	clientPort		= SLKNET_UDP_CLPORT;
}




CSLKinectApp::~CSLKinectApp()
{
	DEBUG_ERR("CSLKinect DESTRUCTOR");

	if (kinect!=NULL) {
		if (kinect->m_state==OPENNI_DETECT_EXEC) {
			kinect->stop_Detection();
		}
		DeleteKinect();
	}

	if (kinectNet!=NULL) {
		delete(kinectNet);
		kinectNet = NULL;
	}

	if (sharedMem!=NULL) {
		delete(sharedMem);
		sharedMem = NULL;
	}

	Dx9ReleaseInterface();
}





// B CSLKinectApp IuWFNgłB

CSLKinectApp theApp;



// CSLKinectApp 

BOOL CSLKinectApp::InitInstance()
{
	CWinApp::InitInstance();

	SetRegistryKey(_T("SLKinect2 by Fumi.Iseki and NSL"));
	LoadStdProfileSettings(4);  // W INI t@C̃IvV[h܂ (MRU ܂)

	//
	CMultiDocTemplate* pDocTemplate;

	pDocTemplate = new CMultiDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CLogWndDoc),
		RUNTIME_CLASS(CLogWndFrame),
		RUNTIME_CLASS(CLogWndView));
	if (!pDocTemplate) return FALSE;
	AddDocTemplate(pDocTemplate);
	pDocTemplLOG = pDocTemplate;

	pDocTemplate = new CMultiDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CExDocument),
		RUNTIME_CLASS(CSensorFrame), 
		RUNTIME_CLASS(CDxDirectView));
	if (!pDocTemplate) return FALSE;
	AddDocTemplate(pDocTemplate);
	pDocTemplSNR = pDocTemplate;

	pDocTemplate = new CMultiDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CExDocument),
		RUNTIME_CLASS(CExFrame), 
		RUNTIME_CLASS(CDx3DDirectView));
	if (!pDocTemplate) return FALSE;
	AddDocTemplate(pDocTemplate);
	pDocTemplMDL = pDocTemplate;


	// Ct[ EBhE쐬
	pMainFrame = new CMainFrame;
	pMainFrame->pApp = this;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME)) return FALSE;
	m_pMainWnd = pMainFrame;

	// Ct[ EBhẼTCY
	int sx = GetSystemMetrics(SM_CXSCREEN)/2;	// X̉𑜓x
	int sy = GetSystemMetrics(SM_CYSCREEN)/2;	// Ỷ𑜓x
	m_pMainWnd->SetWindowPos(NULL, sx-APP_WND_XSIZE/2, sy-APP_WND_YSIZE/2, APP_WND_XSIZE, APP_WND_YSIZE, 0);
	
	// Ct[EBhE̕\
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();



	///////////////////////////////////////////////////////////////////////////////////////////////
	// DirectX9 ̏

	BOOL rslt = Dx9CreateInterface(this);
	if (!rslt) {
		MessageBoxDLG_rc(IDS_STR_ERROR, IDS_STR_FAIL_GET_DX9DEV, m_pMainWnd); // "G[", "DirectX9̏Ɏs܂"
		return FALSE;
	}



	///////////////////////////////////////////////////////////////////////////////////////////////
	// Kinect ̏

	CString mesg, noti;
	mesg.LoadString(IDS_STR_INIT_KINECT);				// "Kinect ̏"
	noti.LoadString(IDS_STR_INFO);						// ""
	CMessageBoxDLG* mesgBox = new CMessageBoxDLG(noti, m_pMainWnd);
	if (mesgBox!=NULL) mesgBox->Display((char*)(LPCSTR)mesg);

	BOOL ret = FALSE;
	kinect = new CExKinectWnd();
	if (kinect!=NULL && kinect->context!=NULL) {
		if (kinect->isUseCamera) ret = kinect->create_Image();
		else ret = TRUE;
		if (ret) ret = kinect->create_Depth();
	}

	delete(mesgBox);

	if (!ret) {
		MessageBoxDLG_rc(IDS_STR_INFO, IDS_STR_NOT_KINECT, m_pMainWnd);	// "", "Kinect ڑĂ܂"
		DeleteKinect();
		//Dx9ReleaseInterface();
		//return FALSE;
	}



	///////////////////////////////////////////////////////////////////////////////////////////////
	// ݒt@C̓ǂݍ

	readConfigFile(SLKINECT_CONFIG_FILE);

	if (kinect!=NULL) {
		kinect->isMirroring		= isMirroring;
		kinect->isUseCamera		= isUseCamera;
		kinect->printPosMode	= printPosMode;
		kinect->printRotMode	= printRotMode;
		kinect->printQutMode	= printQutMode;
		kinect->printNetMode	= printNetMode;
		kinect->printChkMode	= printChkMode;

		kinect->networkMode		= networkMode;
		kinect->networkOutMode	= networkOutMode;
		kinect->networkFastMode	= networkFastMode;

		// ~[O
		kinect->context->SetGlobalMirror(kinect->isMirroring);
	}
	else {
		networkMode = TRUE;
	}

	nowMirroring = isMirroring;



	///////////////////////////////////////////////////////////////////////////////////////////////
	// j[̐ݒ

	updateMenu();

	updateStatusBar();



	///////////////////////////////////////////////////////////////////////////////////////////////
	//

	kinectNet = new CKinectNetwork();
	sharedMem = new CKinectSMemory();

	if (kinect!=NULL) {
		kinect->kinectNet = kinectNet;
		kinect->sharedMem = sharedMem;
	}

	if (kinectNet!=NULL) {
		kinectNet->sharedMem = sharedMem;
		kinectNet->printNetMode = printNetMode;
		kinectNet->printChkMode	= printChkMode;
		kinectNet->clientPort = clientPort;
		kinectNet->animationUUID = animationUUID;
	}

	if (sharedMem!=NULL) {
		sharedMem->animationUUID = animationUUID;
		if (!networkMode || networkOutMode==NETandLOCAL) sharedMem->setLocalAnimationIndex();
	}


	return TRUE;
}







////////////////////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);

// 
protected:
	DECLARE_MESSAGE_MAP()
};



CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}



void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}



BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()



//////////////////////////////////////////////////////////////////
// _CAOs邽߂̃AvP[V R}h
void CSLKinectApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}





//////////////////////////////////////////////////////////////////
// Destruction of child window
//

// Ot[
void CSLKinectApp::FrameDistructor(CExTextFrame* frm)
{
	if (frm==pLogFrame) {
		//DEBUG_ERR("CSLKinectApp::FrameDistructor: Stop Log Window Frame");

		if (kinect!=NULL) kinect->pLogDoc = NULL;
		if (kinectNet!=NULL) kinectNet->pLogDoc = NULL;
		pLogFrame = NULL;
		pLogDoc   = NULL;
		::Sleep(500);
	}

	updateMenu();
}




// ZT[r[
void CSLKinectApp::ViewDistructor(CExView* view)
{
	if (view==pSensorView) {
		if (kinect!=NULL) { 
			if (kinect->pSensorFrame!=NULL) {
				kinect->pSensorFrame = NULL;
				::Sleep(500);
			}
		}

		pSensorView = NULL;
		//DEBUG_ERR("CSLKinectApp::ViewDistructor: Stop Screen View");
	}

	updateMenu();
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// CSLKinectApp j[
//

/////////////////////////////////////////////////////////////////
// t@C
//

void CSLKinectApp::OnAppLogin()
{
	if (isLoggedIn) return;
	
	char ret = kinectNet->serverLogin(animationServer, serverPort, groupID);
	
	if (ret==ANM_COM_REPLY_FORBIDDEN) {
		MessageBoxDLG_rc(IDS_STR_ATTNSN, IDS_STR_FORBIDDEN_SERVER, m_pMainWnd); // "", "̃T[ogp邱Ƃ͂ł܂"
		return;
	}
	else if (ret!=ANM_COM_REPLY_OK) {
		MessageBoxDLG_rc(IDS_STR_ATTNSN, IDS_STR_NOT_LOGIN, m_pMainWnd);		// "", "T[oɃOCł܂ł"
		return;
	}

	isLoggedIn = TRUE;

	CMenu* menu = pMainFrame->GetMenu();
	menu->EnableMenuItem(ID_APP_LOGIN, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	menu->EnableMenuItem(ID_APP_LOGOUT, MF_BYCOMMAND | MF_ENABLED);
	menu->EnableMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_ENABLED);
	if (kinect!=NULL) menu->EnableMenuItem(ID_MODE_LOCAL, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);

	//
	OnAppDataRecv();

	//MessageBoxDLG_rc(IDS_STR_INFO, IDS_STR_SUCCESS_LOGIN, m_pMainWnd);
	updateStatusBar();
}



void CSLKinectApp::OnAppLogout()
{
	if (!isLoggedIn) return;

	kinectNet->serverLogout();
	kinectNet->closeSendSocket();
	isLoggedIn = FALSE;

	CMenu* menu = pMainFrame->GetMenu();
	menu->EnableMenuItem(ID_APP_LOGOUT, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	menu->EnableMenuItem(ID_APP_LOGIN, MF_BYCOMMAND | MF_ENABLED);
	if (kinect!=NULL) menu->EnableMenuItem(ID_MODE_LOCAL, MF_BYCOMMAND | MF_ENABLED);

	// DataRecv
	if (isRecvData) {
		menu->CheckMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_UNCHECKED);
		kinectNet->closeRecvSocket();
		isRecvData = FALSE;
	}

	if (kinect!=NULL && kinect->pSensorFrame!=NULL) {
		((CSensorFrame*)kinect->pSensorFrame)->OnCalibrationStop();
	}

	menu->EnableMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	updateStatusBar();
}




void CSLKinectApp::OnAppDataRecv()
{
	if (kinectNet==NULL) return;

	CMenu* menu = pMainFrame->GetMenu();

	if (!isRecvData) {
		//kinectNet->openRecvSocket((unsigned short)SLKNET_UDP_CLPORT);
		kinectNet->openRecvSocket();
		if (kinectNet->recvSocket<=0) {
			MessageBoxDLG_rc(IDS_STR_ATTNSN, IDS_STR_FAIL_RSCV, m_pMainWnd); // "", "f[^̎Mł܂"
			return;
		}
		isRecvData = TRUE;
		menu->CheckMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_CHECKED);
		//
		AfxBeginThread(kinectNetRecvLoop, (LPVOID)kinectNet, /*THREAD_PRIORITY_HIGHEST*/ THREAD_PRIORITY_NORMAL);
		//AfxBeginThread(kinectNetRecvLoop, (LPVOID)kinectNet, THREAD_PRIORITY_HIGHEST);
	}
	else {
		menu->CheckMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_UNCHECKED);
		sharedMem->clearNetworkAnimationIndex();
		sharedMem->clearNetworkAnimationData();
		kinectNet->closeRecvSocket();
		isRecvData = FALSE;
	}
	updateStatusBar();
}





void CSLKinectApp::OnAppDataLoad()
{
	// TODO: ɃR}h nh R[hǉ܂B
}




void CSLKinectApp::OnAppDataSave()
{
	// TODO: ɃR}h nh R[hǉ܂B
}




/////////////////////////////////////////////////////////////////
//@EBhE
//

void CSLKinectApp::OnModelingWndOpen()
{
	if (kinect==NULL || pModelView!=NULL) return;

	CExFrame* pfrm = CreateDocFrmView(pDocTemplMDL, this);

	if (pfrm!=NULL) {
		pfrm->pDoc->Title		= "Modeling Window";
		pfrm->pDoc->hasReadData = TRUE;                                           
		pfrm->pDoc->hasViewData = TRUE;                                        
		pfrm->pView->cnstXYRate = TRUE;
   		pfrm->pView->colorMode  = GRAPH_COLOR_BGRA;
		pfrm->pView->xsize		= kinect->outputMode.nXRes;
		pfrm->pView->ysize		= kinect->outputMode.nYRes;
		pModelView = (CDx3DDirectView*)pfrm->pView;

		int ret = ExecDocFrmView(pfrm);
		if (ret==0) {

		}
		else if (ret>0) {
			ExecDocFrmViewError(pMainFrame->m_hWnd, ret);
		}
	}
	else {
		ExecDocFrmViewError(pMainFrame->m_hWnd, MSG_DFV_FR_NULL);	// Frameւ̃|C^ NULLł
	}

	return;
}



// Log Window
void CSLKinectApp::OnLogWndOpen()
{
	if (pLogFrame==NULL) {
		pLogFrame = ExecLogWnd(pDocTemplLOG, "Log Window", this);
		pLogDoc = pLogFrame->pDoc;
		if (kinect!=NULL) kinect->pLogDoc = pLogDoc;
		if (kinectNet!=NULL) kinectNet->pLogDoc = pLogDoc;
	}
	
	updateMenu();
	return;
}




void CSLKinectApp::OnSnsrWndOpen_x1()
{
	cameraScale = 1;	// 1/1
	SensorWndOpen();
	return;
}



void CSLKinectApp::OnSnsrWndOpen_x2()
{
	cameraScale = 2;	// 1/2
	SensorWndOpen();
	return;
}



void CSLKinectApp::OnSnsrWndOpen_x3()
{
	cameraScale = 3;	// 1/3
	SensorWndOpen();
	return;
}



void CSLKinectApp::OnSnsrWndOpen_x4()
{
	cameraScale = 4;	// 1/4
	SensorWndOpen();
	return;
}




void CSLKinectApp::SensorWndOpen()
{
	if (kinect==NULL || pSensorView!=NULL) return;

	CExFrame* pfrm = CreateDocFrmView(pDocTemplSNR, this);

	if (pfrm!=NULL) {
		((CSensorFrame*)pfrm)->kinectApp = this;
		pfrm->pDoc->Title		= "Sensor Window";
		pfrm->pDoc->hasReadData = TRUE;                                           
		pfrm->pDoc->hasViewData = TRUE;                                        
		pfrm->pView->cnstXYRate	= TRUE;
   		pfrm->pView->colorMode  = GRAPH_COLOR_BGRA;		// for faster with Little Endian
		pfrm->pView->xsize		= kinect->outputMode.nXRes/cameraScale;
		pfrm->pView->ysize		= kinect->outputMode.nYRes/cameraScale;
		pSensorView = (CDxDirectView*)pfrm->pView;


		// ~[O
		if (nowMirroring!=kinect->isMirroring) {
			if (kinect->m_state==OPENNI_DETECT_EXEC) ((CSensorFrame*)pfrm)->OnCalibrationStop();
			kinect->context->SetGlobalMirror(kinect->isMirroring);
			nowMirroring = kinect->isMirroring;
			::Sleep(100);
		}

		// Camera
		if (kinect->image==NULL && kinect->isUseCamera) {
			CString mesg, noti;
			mesg.LoadString(IDS_STR_CREATE_IMAGE);				// "C[W̍쐬"
			noti.LoadString(IDS_STR_INFO);						// ""
			CMessageBoxDLG* mesgBox = new CMessageBoxDLG(noti, m_pMainWnd);
			if (mesgBox!=NULL) mesgBox->Display((char*)(LPCSTR)mesg);
			if (kinect->m_state==OPENNI_DETECT_EXEC) ((CSensorFrame*)pfrm)->OnCalibrationStop();
			kinect->create_Image();
			if (mesgBox!=NULL) delete(mesgBox);
		}
		else if (kinect->image!=NULL && !kinect->isUseCamera) {
			if (kinect->m_state==OPENNI_DETECT_EXEC) ((CSensorFrame*)pfrm)->OnCalibrationStop();
			kinect->delete_Image();
		}


		//
		int ret = ExecDocFrmView(pfrm);
		if (ret==0) {
			if (kinect!=NULL) {
				kinect->m_scale = cameraScale;
				kinect->pSensorFrame = pfrm;
				if (kinect->image!=NULL && kinect->depth!=NULL) kinect->depth->GetAlternativeViewPointCap().SetViewPoint(*(kinect->image));
				// Thread
				//AfxBeginThread(kinectEventLoop, (LPVOID)kinect, /*THREAD_PRIORITY_HIGHEST*/ THREAD_PRIORITY_NORMAL);
				AfxBeginThread(kinectEventLoop, (LPVOID)kinect, THREAD_PRIORITY_HIGHEST);
			}
		}
		else if (ret>0) {
			ExecDocFrmViewError(pMainFrame->m_hWnd, ret);
		}
	}
	else {
		ExecDocFrmViewError(pMainFrame->m_hWnd, MSG_DFV_FR_NULL);	// Frameւ̃|C^ NULLł
	}

	updateMenu();
	return;
}




/////////////////////////////////////////////////////////////////
//@[h
//

void CSLKinectApp::OnModeLocal()
{
	CMenu* menu = pMainFrame->GetMenu();
	if (networkMode) {
		menu->CheckMenuItem (ID_MODE_LOCAL,   MF_BYCOMMAND | MF_CHECKED);
		menu->CheckMenuItem (ID_MODE_NETWORK, MF_BYCOMMAND | MF_UNCHECKED);
		menu->EnableMenuItem(ID_SETTING_NETWORK, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_APP_LOGIN, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);

		if (isLoggedIn) OnAppLogout();

		networkMode = FALSE;
		if (kinect!=NULL) kinect->networkMode = FALSE;
		writeConfigFile(SLKINECT_CONFIG_FILE);
	}

	if (sharedMem!=NULL) sharedMem->setLocalAnimationIndex();
	updateStatusBar();
}



void CSLKinectApp::OnModeNetwork()
{
	if (sharedMem!=NULL) sharedMem->clearLocalAnimationIndex();

	CMenu* menu = pMainFrame->GetMenu();
	if (!networkMode) {
		menu->CheckMenuItem (ID_MODE_NETWORK, MF_BYCOMMAND | MF_CHECKED);
		menu->CheckMenuItem (ID_MODE_LOCAL,   MF_BYCOMMAND | MF_UNCHECKED);
		menu->EnableMenuItem(ID_SETTING_NETWORK, MF_BYCOMMAND | MF_ENABLED);
		menu->EnableMenuItem(ID_APP_LOGIN,  MF_BYCOMMAND | MF_ENABLED);
		
		networkMode = TRUE;
		if (kinect!=NULL) kinect->networkMode = TRUE;
		writeConfigFile(SLKINECT_CONFIG_FILE);
	}
	updateStatusBar();
}




/////////////////////////////////////////////////////////////////
//@ݒ
//

void CSLKinectApp::OnSettingLogingmode()
{
	CSetLogMode* logdlg = new CSetLogMode(printPosMode, printRotMode, printQutMode, printNetMode, printChkMode, networkMode);
	if (logdlg==NULL) return;
	logdlg->DoModal();

	printPosMode = logdlg->printPosMode();
	printRotMode = logdlg->printRotMode();
	printQutMode = logdlg->printQutMode();
	printNetMode = logdlg->printNetMode();
	printChkMode = logdlg->printChkMode();

	if (kinect!=NULL) {
		kinect->printPosMode = printPosMode;
		kinect->printRotMode = printRotMode;
		kinect->printQutMode = printQutMode;
		kinect->printNetMode = printNetMode;
		kinect->printChkMode = printChkMode;
	}
	
	if (kinectNet!=NULL) {
		kinectNet->printNetMode = printNetMode;
		kinectNet->printChkMode = printChkMode;
	}

	delete(logdlg);
	writeConfigFile(SLKINECT_CONFIG_FILE);
}




void CSLKinectApp::OnSettingViewmode()
{
	CSetViewMode* viwdlg = new CSetViewMode(isMirroring, isUseCamera);
	if (viwdlg==NULL) return;
	viwdlg->DoModal();

	isMirroring = viwdlg->isMirroring();
	isUseCamera = viwdlg->isUseCamera();
	
	if (kinect!=NULL) {
		kinect->isMirroring = isMirroring;
		kinect->isUseCamera = isUseCamera;
	}
	
	delete(viwdlg);
	writeConfigFile(SLKINECT_CONFIG_FILE);
}




void CSLKinectApp::OnSettingNetwork()
{
	NetOutMode preNetworkOutMode = networkOutMode;

	CSetNetwork* netdlg = new CSetNetwork(networkOutMode, networkFastMode, clientPort, animationServer, serverPort, groupID, isLoggedIn);
	if (netdlg==NULL) return;
	netdlg->DoModal();

	networkOutMode  = netdlg->getNetOutMode();
	networkFastMode = netdlg->getNetFastMode();
	groupID = netdlg->getGroupingKey();
	animationServer = netdlg->getAnimationServer();
	serverPort = netdlg->getServerPort();
	clientPort = netdlg->getClientPort();

	if (kinect!=NULL) {
		kinect->networkOutMode  = networkOutMode;
		kinect->networkFastMode = networkFastMode;
	}

	if (kinectNet!=NULL) {
		kinectNet->clientPort = clientPort;
	}

	if (networkOutMode!=preNetworkOutMode && sharedMem!=NULL) {
		if (networkOutMode==NETandLOCAL) {
			sharedMem->setLocalAnimationIndex();
		}
		else {
			sharedMem->clearLocalAnimationIndex();
			sharedMem->clearLocalAnimationData();
		}
	}

	delete(netdlg);
	writeConfigFile(SLKINECT_CONFIG_FILE);
}




void CSLKinectApp::OnSettingAnimation()
{
	CSetAnimation* anmdlg = new CSetAnimation(animationUUID, isLoggedIn);
	if (anmdlg==NULL) return;
	anmdlg->DoModal();

	animationUUID = anmdlg->getAnimationUUID();

	if (kinectNet!=NULL) {
		kinectNet->animationUUID = animationUUID;
	}
	if (sharedMem!=NULL) {
		sharedMem->animationUUID = animationUUID;
		if (!networkMode || networkOutMode==NETandLOCAL) sharedMem->setLocalAnimationIndex();
	}

	delete(anmdlg);
	writeConfigFile(SLKINECT_CONFIG_FILE);
}




void CSLKinectApp::OnSettingDataSave()
{
	BOOL fexst = (BOOL)file_exist(SLKINECT_BVH_TEMPLATE);

	CSetDataSave* datdlg = new CSetDataSave(saveBVHFile, savePosMode, saveRotMode, saveQutMode, fexst);
	if (datdlg==NULL) return;
	datdlg->DoModal();

	saveBVHFile = datdlg->saveBVHFile();
	savePosMode = datdlg->savePosMode();
	saveRotMode = datdlg->saveRotMode();
	saveQutMode = datdlg->saveQutMode();

	delete(datdlg);
	writeConfigFile(SLKINECT_CONFIG_FILE);
}







/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tools
//

BOOL  CSLKinectApp::getBoolfromList(tList* lt, char* key, BOOL dflt)
{
	BOOL  ret = dflt;
	char* val = NULL;

	if (dflt) val = get_strparam_tList(lt, key, "true");
	else      val = get_strparam_tList(lt, key, "false");

	if (val!=NULL) {
		if (!strcasecmp("true", val)) ret = TRUE;
		else ret = FALSE;
		free(val);
	}

	return ret;
}




void  CSLKinectApp::readConfigFile(char* fn)
{    
	Buffer config = MakeWorkingFolderPath(fn, "\\NSL\\SLKinect\\");
	tList* lt = read_index_tList_file((char*)config.buf, ' ');
	free_Buffer(&config);

	if (lt!=NULL) {
		isMirroring		= getBoolfromList(lt, "Mirroring", isMirroring);
		isUseCamera		= getBoolfromList(lt, "UseCamera", isUseCamera);

		printPosMode	= getBoolfromList(lt, "printPosMode", printPosMode);
		printRotMode	= getBoolfromList(lt, "printRotMode", printRotMode);
		printQutMode	= getBoolfromList(lt, "printQutMode", printQutMode);
		printNetMode	= getBoolfromList(lt, "printNetMode", printNetMode);
		printChkMode	= getBoolfromList(lt, "printChkMode", printChkMode);

		saveBVHFile 	= getBoolfromList(lt, "saveBVHFile", saveBVHFile);
		savePosMode		= getBoolfromList(lt, "savePosMode", savePosMode);
		saveRotMode		= getBoolfromList(lt, "saveRotMode", saveRotMode);
		saveQutMode		= getBoolfromList(lt, "saveQutMode", saveQutMode);

		networkMode		= getBoolfromList(lt, "networkMode",  networkMode);
		networkFastMode	= getBoolfromList(lt, "networkFastMode", networkFastMode);
 		networkOutMode	= (NetOutMode)get_intparam_tList(lt, "networkOutMode", (int)networkOutMode);

		animationUUID	= get_strparam_tList(lt, "animationUUID", (char*)(LPCSTR)animationUUID);
		animationServer	= get_strparam_tList(lt, "animationServer", (char*)(LPCSTR)animationServer);
		serverPort		= get_intparam_tList(lt, "serverPort", serverPort);
		clientPort		= get_intparam_tList(lt, "clientPort", clientPort);

		groupID			= get_strparam_tList(lt, "groupID", (char*)(LPCSTR)groupID);

		del_all_tList(&lt);
    }
}




void  CSLKinectApp::writeConfigFile(char* fn)
{    
	Buffer config = MakeWorkingFolderPath(fn, "\\NSL\\SLKinect\\", TRUE);
	
	FILE* fp = fopen((char*)config.buf, "wb");
	free_Buffer(&config);
	if (fp==NULL) return;

	if (isMirroring)  fprintf(fp, "Mirroring %s\n", "TRUE");
	else              fprintf(fp, "Mirroring %s\n", "FALSE");
	if (isUseCamera)  fprintf(fp, "UseCamera %s\n", "TRUE");
	else              fprintf(fp, "UseCamera %s\n", "FALSE");

	if (printPosMode) fprintf(fp, "printPosMode %s\n", "TRUE");
	else              fprintf(fp, "printPosMode %s\n", "FALSE");
	if (printRotMode) fprintf(fp, "printRotMode %s\n", "TRUE");
	else              fprintf(fp, "printRotMode %s\n", "FALSE");
	if (printQutMode) fprintf(fp, "printQutMode %s\n", "TRUE");
	else              fprintf(fp, "printQutMode %s\n", "FALSE");
	if (printNetMode) fprintf(fp, "printNetMode %s\n", "TRUE");
	else              fprintf(fp, "printNetMode %s\n", "FALSE");
	if (printChkMode) fprintf(fp, "printChkMode %s\n", "TRUE");
	else              fprintf(fp, "printChkMode %s\n", "FALSE");

	if (saveBVHFile)  fprintf(fp, "saveBVHFile %s\n", "TRUE");
	else              fprintf(fp, "saveBVHFile %s\n", "FALSE");
	if (savePosMode)  fprintf(fp, "savePosMode %s\n", "TRUE");
	else              fprintf(fp, "savePosMode %s\n", "FALSE");
	if (saveRotMode)  fprintf(fp, "saveRotMode %s\n", "TRUE");
	else              fprintf(fp, "saveRotMode %s\n", "FALSE");
	if (saveQutMode)  fprintf(fp, "saveQutMode %s\n", "TRUE");

	if (networkMode)  fprintf(fp, "networkMode %s\n", "TRUE");
	else              fprintf(fp, "networkMode %s\n", "FALSE");
	if (networkFastMode) fprintf(fp, "networkFastMode %s\n", "TRUE");
	else                 fprintf(fp, "networkFastMode %s\n", "FALSE");
	fprintf(fp, "networkOutMode %d\n", (int)networkOutMode);
	
	fprintf(fp, "animationUUID %s\n", (char*)(LPCSTR)animationUUID);
	fprintf(fp, "animationServer %s\n", (char*)(LPCSTR)animationServer);
	fprintf(fp, "serverPort %d\n", serverPort);
	fprintf(fp, "clientPort %d\n", clientPort);

	fprintf(fp, "groupID %s\n", (char*)(LPCSTR)groupID);

	fclose(fp);
}




void  CSLKinectApp::updateMenu(CMenu* menu)
{
	if (menu==NULL) menu = pMainFrame->GetMenu();

	// Data Save (Temp)
	menu->EnableMenuItem(ID_APP_DATA_LOAD, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	menu->EnableMenuItem(ID_APP_DATA_SAVE, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	menu->EnableMenuItem(ID_SETTING_DATA_SAVE, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);


	// Window Menu
	CMenu* winmn = GetMenu_byStringID(menu, IDS_STR_MENU_WINDOW);

	if (kinect==NULL) {
		if (winmn!=NULL) winmn->EnableMenuItem(0, MF_BYPOSITION | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_SNSR_WND_OPEN_1,   MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_SNSR_WND_OPEN_2,   MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_SNSR_WND_OPEN_3,   MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_SNSR_WND_OPEN_4,   MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_SETTING_VIEWMODE,  MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_SETTING_DATA_SAVE, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	}
	else {
		if (pSensorView!=NULL) {
			if (winmn!=NULL) winmn->EnableMenuItem(0, MF_BYPOSITION | MF_DISABLED | MF_GRAYED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_1, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_2, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_3, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_4, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		}
		else {
			if (winmn!=NULL) winmn->EnableMenuItem(0, MF_BYPOSITION | MF_ENABLED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_1, MF_BYCOMMAND | MF_ENABLED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_2, MF_BYCOMMAND | MF_ENABLED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_3, MF_BYCOMMAND | MF_ENABLED);
			menu->EnableMenuItem(ID_SNSR_WND_OPEN_4, MF_BYCOMMAND | MF_ENABLED);
		}
	}
	

	// 
	if (pLogFrame!=NULL) {
		menu->EnableMenuItem(ID_LOG_WND_OPEN, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	}
	else {
		menu->EnableMenuItem(ID_LOG_WND_OPEN, MF_BYCOMMAND | MF_ENABLED);
	}


	//
	if (networkMode) {
		menu->CheckMenuItem (ID_MODE_NETWORK,    MF_BYCOMMAND | MF_CHECKED);
		menu->EnableMenuItem(ID_SETTING_NETWORK, MF_BYCOMMAND | MF_ENABLED);
		
		// ID_MODE_LOCAL
		menu->CheckMenuItem(ID_MODE_LOCAL, MF_BYCOMMAND | MF_UNCHECKED);
		if (kinect==NULL) {
			menu->EnableMenuItem(ID_MODE_LOCAL, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		}
		else {
			if (isLoggedIn) menu->EnableMenuItem(ID_MODE_LOCAL, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
			else            menu->EnableMenuItem(ID_MODE_LOCAL, MF_BYCOMMAND | MF_ENABLED);
		}
	}
	else {	// ID_MODE_LOCAL
		menu->CheckMenuItem (ID_MODE_LOCAL,      MF_BYCOMMAND | MF_CHECKED);
		menu->EnableMenuItem(ID_MODE_LOCAL,      MF_BYCOMMAND | MF_ENABLED);
		menu->CheckMenuItem (ID_MODE_NETWORK,    MF_BYCOMMAND | MF_UNCHECKED);
		menu->EnableMenuItem(ID_SETTING_NETWORK, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	}

	//
	if (isLoggedIn) {
		menu->EnableMenuItem(ID_APP_LOGOUT, MF_BYCOMMAND | MF_ENABLED);
		menu->EnableMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_ENABLED);
		if (isRecvData) menu->CheckMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_CHECKED);
		else            menu->CheckMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_UNCHECKED);
		menu->EnableMenuItem(ID_SETTING_ANIMATION, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	}
	else {
		menu->EnableMenuItem(ID_APP_LOGOUT, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_APP_DATA_RECV, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		menu->EnableMenuItem(ID_SETTING_ANIMATION, MF_BYCOMMAND | MF_ENABLED);
	}


	// ID_APP_LOGIN
	if (networkMode && !isLoggedIn) {
		if (kinect!=NULL && kinect->m_state!=OPENNI_DETECT_STOPPED) {
			menu->EnableMenuItem(ID_APP_LOGIN, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		}
		else {
			menu->EnableMenuItem(ID_APP_LOGIN, MF_BYCOMMAND | MF_ENABLED);
		}
	}
	else {
		menu->EnableMenuItem(ID_APP_LOGIN, MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
	}
}





void  CSLKinectApp::updateStatusBar()
{
	CString rc;
	CString mesg = " ";

	if (networkMode) {
		rc.LoadString(IDS_STR_NETWORK_MODE);					// lbg[N[h
		mesg = mesg + rc;
		if (isLoggedIn) {
			rc.LoadString(IDS_STR_LOGGING_IN);					// OC
			mesg = mesg + " | " + rc;		
			if (isRecvData) {
				rc.LoadString(IDS_STR_RECEIVING_DATA);			// f[^M
				mesg = mesg + " | " + rc;
			}
		}
		//else {
		//	rc.LoadString(IDS_STR_LOGGED_OUT);					// OAEg
		//	mesg = mesg + " | " + rc;	
		//}
	}
	else {
		rc.LoadString(IDS_STR_LOCAL_MODE);						// [J[h
		mesg = mesg + rc;
	}

	pMainFrame->SetSTausBarText(mesg);
}

