/**
	SLKinect.h  by Fumi.Iseki (c)


*/

#pragma once

#ifndef __AFXWIN_H__
	#error "PCH ɑ΂Ẵt@CCN[hO 'stdafx.h' CN[hĂ"
#endif


#include  "resource.h"       // C V{

#include  "KinectWnd.h"
#include  "MainFrm.h"

#include  "Vector.h"
#include  "Rotation.h"

#include  "WinBaseLib.h"
#include  "GnMFCLib.h"
#include  "MFCLib.h"
#include  "LogWndFrame.h"
#include  "ExKinectWnd.h"
#include  "KinectSMemory.h"
#include  "KinectNetwork.h"



extern     CSLKinectApp theApp;


#define    SLKINECT_VERSION		 "SLKinect2 v2.0"

#define    SLKINECT_CONFIG_FILE	 "SLKinect.cfg"
#define    SLKINECT_BVH_TEMPLATE "bvh_template.data"


// EBhETCY
#define	   APP_WND_XSIZE		 800
#define	   APP_WND_YSIZE		 650




using namespace jbxl;
using namespace jbxwl;






////////////////////////////////////////////////////////////////////////////////////
//
// CSLKinectApp:
//

class CSLKinectApp : public CWinApp, public CAppCallBack
{
public:
	CMainFrame*			pMainFrame;

	CLogWndFrame*		pLogFrame;
	CLogWndDoc*			pLogDoc;
		
	CDxDirectView*		pSensorView;
	CDx3DDirectView*	pModelView;

	CExKinectWnd*		kinect;
	CKinectNetwork*		kinectNet;
	CKinectSMemory*		sharedMem;


public:
	CSLKinectApp();
	~CSLKinectApp();

	void	DeleteKinect() {if (kinect!=NULL) delete(kinect); kinect = NULL;}
	void	SensorWndOpen(void);


	CMultiDocTemplate*  pDocTemplLOG;
	CMultiDocTemplate*  pDocTemplSNR;
	CMultiDocTemplate*  pDocTemplMDL;


public:
	BOOL		networkMode;
	CString		animationUUID;
	CString		animationServer;
	int			serverPort;
	int			clientPort;
	CString		groupID;

	NetOutMode	networkOutMode;
	BOOL		networkFastMode;

	BOOL		isMirroring;
	BOOL		isUseCamera;
	BOOL		isLoggedIn;
	BOOL		isRecvData;

	BOOL		printPosMode;
	BOOL		printRotMode;
	BOOL		printQutMode;
	BOOL		printNetMode;
	BOOL		printChkMode;

	BOOL		saveBVHFile;
	BOOL		savePosMode;
	BOOL		saveRotMode;
	BOOL		saveQutMode;

	BOOL		nowMirroring;

	int			cameraScale;


	BOOL		getBoolfromList(tList* lt, char* key, BOOL dflt);
	void		readConfigFile(char* fn);
	void		writeConfigFile(char* fn);

	void		updateMenu(CMenu* menu = NULL);
	void		updateStatusBar(void);

public:
	virtual BOOL InitInstance();

	virtual void FrameDistructor(CExTextFrame* frm);
	virtual void ViewDistructor(CExView* view);

	afx_msg void OnAppAbout();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnModelingWndOpen();
	afx_msg void OnLogWndOpen();
	afx_msg void OnSnsrWndOpen_x1();
	afx_msg void OnSnsrWndOpen_x2();
	afx_msg void OnSnsrWndOpen_x3();
	afx_msg void OnSnsrWndOpen_x4();
	afx_msg void OnSettingLogingmode();
	afx_msg void OnSettingViewmode();
	afx_msg void OnSettingNetwork();
	afx_msg void OnSettingAnimation();
	afx_msg void OnModeLocal();
	afx_msg void OnModeNetwork();
	afx_msg void OnAppLogin();
	afx_msg void OnAppLogout();
	afx_msg void OnAppDataLoad();
	afx_msg void OnAppDataSave();
	afx_msg void OnAppDataRecv();
	afx_msg void OnSettingDataSave();
};



