// setDataSave.cpp : t@C
//

#include "stdafx.h"
#include "SLKinect.h"
#include "SetDataSave.h"


// CSetDataSave _CAO

IMPLEMENT_DYNAMIC(CSetDataSave, CDialog)

CSetDataSave::CSetDataSave(BOOL bvh, BOOL pos, BOOL rot, BOOL qut, BOOL file, CWnd* pParent /*=NULL*/)
	: CDialog(CSetDataSave::IDD, pParent)
{
	isBVHFile   = bvh;
	posSaveMode = pos;
	rotSaveMode = rot;
	qutSaveMode = qut;

	file_exist	= file;

	orgCBox		= NULL;
	bvhCBox		= NULL;

	posCBox		= NULL;
	rotCBox		= NULL;
	qutCBox		= NULL;
}



CSetDataSave::~CSetDataSave()
{
}



void CSetDataSave::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CSetDataSave, CDialog)
	ON_BN_CLICKED(IDC_RADIO_SAVE_ORG, &CSetDataSave::OnBnClickedRadioSaveOrg)
	ON_BN_CLICKED(IDC_RADIO_SAVE_BVH, &CSetDataSave::OnBnClickedRadioSaveBvh)
END_MESSAGE_MAP()


// CSetDataSave bZ[W nh



BOOL CSetDataSave::OnInitDialog()
{
	CDialog::OnInitDialog();

	orgCBox = (CButton*)GetDlgItem(IDC_RADIO_SAVE_ORG);
	bvhCBox = (CButton*)GetDlgItem(IDC_RADIO_SAVE_BVH);

	posCBox = (CButton*)GetDlgItem(IDC_CHECK_DATA_POSITION);
	rotCBox = (CButton*)GetDlgItem(IDC_CHECK_DATA_MATRIX);
	qutCBox = (CButton*)GetDlgItem(IDC_CHECK_DATA_QUATERNION);


	if (posSaveMode) posCBox->SetCheck(1);
	else             posCBox->SetCheck(0);

	if (rotSaveMode) rotCBox->SetCheck(1);
	else             rotCBox->SetCheck(0);

	if (qutSaveMode) qutCBox->SetCheck(1);
	else             qutCBox->SetCheck(0);

	if (isBVHFile) {
		OnBnClickedRadioSaveBvh();
	}
	else {
		OnBnClickedRadioSaveOrg();
	}

	//
	if (!file_exist) {
		OnBnClickedRadioSaveOrg();
		bvhCBox->EnableWindow(FALSE);
	}

	return TRUE;
}




void CSetDataSave::OnOK()
{
	if (bvhCBox->GetCheck()) isBVHFile = TRUE;
	else                     isBVHFile = FALSE;

	if (posCBox->GetCheck()) posSaveMode = TRUE;
	else                     posSaveMode = FALSE;

	if (rotCBox->GetCheck()) rotSaveMode = TRUE;
	else                     rotSaveMode = FALSE;
	
	if (qutCBox->GetCheck()) qutSaveMode = TRUE;
	else                     qutSaveMode = FALSE;

	if (!isBVHFile && !posSaveMode && !rotSaveMode && !qutSaveMode) return;

	CDialog::OnOK();
}





void CSetDataSave::OnBnClickedRadioSaveOrg()
{
	orgCBox->SetCheck(1);
	bvhCBox->SetCheck(0);

	posCBox->EnableWindow(TRUE);
	rotCBox->EnableWindow(TRUE);
	qutCBox->EnableWindow(TRUE);
}



void CSetDataSave::OnBnClickedRadioSaveBvh()
{
	orgCBox->SetCheck(0);
	bvhCBox->SetCheck(1);

	posCBox->EnableWindow(FALSE);
	rotCBox->EnableWindow(FALSE);
	qutCBox->EnableWindow(FALSE);
}