// SetNetwork.cpp : t@C
//

#include "stdafx.h"
#include "SLKinect.h"
#include "SetNetwork.h"


// CSetNetwork _CAO

IMPLEMENT_DYNAMIC(CSetNetwork, CDialog)

CSetNetwork::CSetNetwork(NetOutMode output, BOOL netfast, int cport, CString server, int sport, CString key, BOOL login, CWnd* pParent /*=NULL*/)
	: CDialog(CSetNetwork::IDD, pParent)
{
	outNetMode  = output;
	fastNetMode = netfast;
	groupKey    = key;
	animServer  = server;
	serverPort  = sport;
	clientPort  = cport;
	
	isLogin		= login;

	outputMemoryButton  = NULL;
	outputNetworkButton = NULL;
	fastNetworkButton	= NULL;
	animServerEBox		= NULL;
	serverPortEBox	    = NULL;
	clientPortEBox		= NULL;
	groupKeyEBox		= NULL;
}



CSetNetwork::~CSetNetwork()
{
}





void CSetNetwork::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CSetNetwork, CDialog)
END_MESSAGE_MAP()




// CSetNetwork bZ[W nh

BOOL CSetNetwork::OnInitDialog()
{
	char buf[LNAME];

	CDialog::OnInitDialog();

	outputMemoryButton  = (CButton*)GetDlgItem(IDC_RADIO_SMEMORY);
	outputNetworkButton = (CButton*)GetDlgItem(IDC_RADIO_NETWORK);
	fastNetworkButton   = (CButton*)GetDlgItem(IDC_CHECK_FASTNETWORK);
	
	animServerEBox		= (CEdit*)GetDlgItem(IDC_EDIT_SERVER_NAME);
	serverPortEBox		= (CEdit*)GetDlgItem(IDC_EDIT_SERVER_PORT);
	clientPortEBox		= (CEdit*)GetDlgItem(IDC_EDIT_CLIENT_PORT);
	groupKeyEBox		= (CEdit*)GetDlgItem(IDC_EDIT_GROUP_KEY);


	if (outNetMode==NETandLOCAL) { 
		outputMemoryButton->SetCheck(1);
		outputNetworkButton->SetCheck(0);
	}
	else {
		outputMemoryButton->SetCheck(0);
		outputNetworkButton->SetCheck(1);
	}

	if (fastNetMode) fastNetworkButton->SetCheck(1);
	else             fastNetworkButton->SetCheck(0);

	memset(buf, 0, LNAME);
	snprintf(buf, LNAME-1, "%d", clientPort);
	clientPortEBox->SetWindowText(buf);

	animServerEBox->SetWindowText((LPCSTR)animServer);

	memset(buf, 0, LNAME);
	snprintf(buf, LNAME-1, "%d", serverPort);
	serverPortEBox->SetWindowText(buf);

	groupKeyEBox->SetWindowText((LPCSTR)groupKey);


	if (isLogin) {
		animServerEBox->EnableWindow(FALSE);
		serverPortEBox->EnableWindow(FALSE);
		clientPortEBox->EnableWindow(FALSE);
		groupKeyEBox->EnableWindow(FALSE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
}





void CSetNetwork::OnOK()
{
	char buf[LNAME];

	if (outputNetworkButton->GetCheck()) outNetMode = NETonly;
	else                                 outNetMode = NETandLOCAL;

	if (fastNetworkButton->GetCheck()) fastNetMode = TRUE;
	else                               fastNetMode = FALSE;

	memset(buf, 0, LNAME);
	animServerEBox->GetWindowText(buf, LNAME);
	animServer.SetString(buf);
	
	memset(buf, 0, LNAME);
	clientPortEBox->GetWindowText(buf, LNAME);
	clientPort = atoi(buf);

	memset(buf, 0, LNAME);
	serverPortEBox->GetWindowText(buf, LNAME);
	serverPort = atoi(buf);
	
	memset(buf, 0, LNAME);
	groupKeyEBox->GetWindowText(buf, LNAME);
	memset(buf+ANM_COM_LEN_IDKEY, 0, LNAME-ANM_COM_LEN_IDKEY);
	groupKey.SetString(buf);


	CDialog::OnOK();
}


