/**
  OpContour(Face)pCu 

			̃t@C̊֐ Contour(=Face)Op`ł邱ƂOƂD
*/



#include "common++.h"
#include "tools++.h"
#include "TriBrep.h"





//
//  폜}[N̕tContour(Face)폜CSContour(Face) RingD
//@Cǂݍ݁ijf[^͍폜ȂD
//
DllExport void  CreateContoursRing(SOLID* solid)
{
	solid->contours.clear();

	BREP_SHELL_RING shells = solid->shells;
	BREP_SHELL_RING::iterator ishell;
	for (ishell=shells.begin(); ishell!=shells.end(); ishell++){
		BREP_FACE*  pbfc;
		BREP_FACE_RING::iterator iface;
		for (iface =(*ishell)->faces.begin(); iface!=(*ishell)->faces.end(); iface++){
			if (((FACE*)(*iface))->deletable && !(((FACE*)(*iface))->initdata)) {
				pbfc = *iface;
				iface = (*ishell)->faces.erase(iface);
				iface--;
				pbfc->shell = NULL;
				delete(pbfc);
			}
			else {
				BREP_CONTOUR_RING::iterator icon;
				for (icon=(*iface)->outer_contours.begin(); icon!=(*iface)->outer_contours.end(); icon++) {
					((FACE*)(*iface))->deletable = false;
					solid->contours.push_back(*icon);
				}
			}
		}
	}
	solid->facetno = (int)solid->contours.size();
}





//
//  S Wing RingD(ContourɌѕtĂȂ̂܂)
//		CreateContoursRing()ɈˑD
//
DllExport void  CreateWingsRing(SOLID* solid)
{
	solid->wings.clear();

	BREP_CONTOUR_RING::iterator icon;
	for (icon=solid->contours.begin(); icon!=solid->contours.end(); icon++) {
		BREP_WING* first = (*icon)->wing;
		if (first!=NULL) {
			BREP_WING* next = first;
			do {
				BREP_WING* wing = next;
				next = wing->next;
				solid->wings.push_back(wing);
				if (!wing->edge->complete) solid->wings.push_back(BrepEdgeOtherWing(wing));
			} while(next!=first);
		}
	}
}





//
//  dEdge Contour RingD
//		CreateContoursRing()ɈˑD
//
DllExport void  CreateSurplusContoursRing(SOLID* solid)
{
//	DEBUG_MODE print_messageln("Start CreateSurplusContoursRing");
	solid->surplus_contours.clear();

	BREP_CONTOUR_RING::iterator icon;
	for (icon=solid->contours.begin(); icon!=solid->contours.end(); icon++){
		if (DupEdgeNumber((CONTOUR*)(*icon))>0) {
			solid->surplus_contours.push_back(*icon);
		}
	}
//	DEBUG_MODE print_messageln("END CreateSurplusContoursRing");
}





//
//  sS Wing RingDWingsRing𗘗pD
//		CreateContoursRing(), CreateWingsRing()ɈˑD
//
DllExport void  CreateShortageWingsRing(SOLID* solid)
{
	solid->shortage_wings.clear();

	BREP_WING_RING::iterator iwing;
	for (iwing=solid->wings.begin(); iwing!=solid->wings.end(); iwing++){
		if ((*iwing)->contour==NULL) solid->shortage_wings.push_back(*iwing);
	}
}





//---------------------------------------------------------------------------------------------------------

/**
void  DeleteSurplusContours(SOLID* solid)
   dEdge Contour(Face)̍폜
		Contours Ring  Wings Ring̓e͕ۏႳD

		vf[^
	 		SĂContour(Face) Ring (Contours Ring)D
					 O̊֐ōsDCreateContoursRing()gpĂǂD
			dGbW̐PȏContour(Face)i[ꂽRingiSurplusContours RingjD
					 O̊֐ōsDCreateSuplusContoursRing()gpĂǂ

	@	ASY
			PDRing̒ɂRӂdEdgeFaceɍ폜}[Nî߁j
				YFace(Contour)폜CFace(Contour)𗠕Ԃēo^ iReverseContoursj
						 dEdgełꍇ͓o^𒆎~
			QDQӂdEdge Faceɍ폜}[NDPƓl̏sD
			RDPӂdEdge Faceɍ폜}[NDPƓl̏sD
			SD̒iKŁCRing̒ɂ Face݂͑Ȃ͂D܂݂ꍇ̓G[D
*/
DllExport void  DeleteSurplusContours(SOLID* solid)
{
	if (solid->surplus_contours.empty()) return;
//	DEBUG_MODE print_messageln("Start DeleteSurplusContours");
	
	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax((int)solid->surplus_contours.size()*3);
	
	BREP_CONTOUR_RING::iterator icon;
	// R̑dEdge Facȅ
	for (icon=solid->surplus_contours.begin(); icon!=solid->surplus_contours.end(); icon++){
		if ((*icon)->dup_edge==3) ((FACE*)((*icon)->face))->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}
	ReverseContours(solid);			// RӂdEdge Face𗠕Ԃ
	CreateShortageWingsRing(solid);
	JoinShortageWings(solid);		// ɂ܂Ƃ܂Edge͈ɂ܂Ƃ߂D

	CreateSurplusContoursRing(solid);
	if (solid->surplus_contours.empty()) {
//		DEBUG_MODE print_messageln("End   DeleteSurplusContours");
		return;
	}

	// Q̑dEdge Facȅ
	for (icon=solid->surplus_contours.begin(); icon!=solid->surplus_contours.end(); icon++){
		if ((*icon)->dup_edge==2) ((FACE*)((*icon)->face))->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}
	ReverseContours(solid);			// QӂdEdge Face𗠕Ԃ
	CreateShortageWingsRing(solid);
	JoinShortageWings(solid);	

	CreateSurplusContoursRing(solid);
	if (solid->surplus_contours.empty()) {
//		DEBUG_MODE print_messageln("End   DeleteSurplusContours");
		return;
	}

	// P̑dEdge Facȅ
	for (icon=solid->surplus_contours.begin(); icon!=solid->surplus_contours.end(); icon++){
		if ((*icon)->dup_edge==1) ((FACE*)((*icon)->face))->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}
	ReverseContours(solid);			// PӂdEdge Face𗠕Ԃ
	CreateShortageWingsRing(solid);
	JoinShortageWings(solid);	
		
	CreateSurplusContoursRing(solid);
	if (!solid->surplus_contours.empty()) {
//		DEBUG_MODE print_messageln("EraseSurplusContour: dEdge Facef[^cĂH");
	}
//	DEBUG_MODE print_messageln("End   DeleteSurplusContours");
	return;
}





/**
void  DeleteStraightEdges(SOLID* solid)
  Vertexɕ񂾏ꍇC[VertexԂɍꂽ Edge(Wing)Ɋ֘A
  Contour(Face)폜
		Contours Ring  Wings Ring̓e͕ۏႳD

	@	vf[^
			SĂWing RingiWings RingjD
					 O̊֐ōsDCreateWingsRing()gpĂǂD
			ContourɊ֘AtĂȂigpĂȂjWingi[ꂽRingiShortageWings RingjD
					 O̊֐ōsDCreateShortageWingsRing() gpĂǂD
*/
DllExport void  DeleteStraightEdges(SOLID* solid)
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start DeleteStraightEdges");

	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax((int)solid->shortage_wings.size());

	BREP_WING_RING::iterator wing1;
	for (wing1=solid->shortage_wings.begin(); wing1!=solid->shortage_wings.end(); wing1++){
		VERTEX* vert[3];
		vert[0] = (VERTEX*)((*wing1)->vertex);
		BREP_WING_RING::iterator wing2;
		for (wing2=solid->shortage_wings.begin(); wing2!=solid->shortage_wings.end(); wing2++){
			if (IsConnectEdges(*wing1, *wing2)) {
				vert[1] = (VERTEX*)((*wing2)->vertex);
				vert[2] = (VERTEX*)(BrepEdgeOtherWing(*wing2)->vertex);
				IsForbiddenEdge(vert);	// ɕ Vertex֎~D
			}
		}
		if (counter!=NULL) counter->StepIt();
	}
	CreateContoursRing(solid);			// YContour(Face)폜CSĂContour(Face) Ring蒼D
	CreateWingsRing(solid);				// WingsRing蒼D
	
//	DEBUG_MODE print_messageln("End   DeleteStraightEdges");
	return;
}





/**
void  DeleteShortageWings(SOLID* solid) 
	sS Wing(Edge)Face(Contour)폜
		Contours Ring  Wings Ring̓e͕ۏႳD

		vf[^
			ShortageWings RingDCreateShortageWingsRing()ō쐬Ăǂ
*/
DllExport void  DeleteShortageWings(SOLID* solid) 
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start DeleteShortageWings");

	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax((int)solid->shortage_wings.size());

	BREP_WING_RING::iterator iwing;
	for (iwing=solid->shortage_wings.begin(); iwing!=solid->shortage_wings.end(); iwing++){
		if ((*iwing)->contour!=NULL) ((FACE*)((*iwing)->contour->face))->deletable = true;
		BREP_WING* othwing = BrepEdgeOtherWing(*iwing);
		if (othwing->contour!=NULL)  ((FACE*) (othwing->contour->face))->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}

	CreateContoursRing(solid);
	CreateWingsRing(solid);
//	DEBUG_MODE print_messageln("End   DeleteShortageWings");
	return;
}






#define  MAX_LOOP_CNT  20

/**
void  FillShortageWings(SOLID* solid, int method, bool mode)
	ȂContour[iSĂ̕sContourȂ邩C[s\ɂȂ܂ŁjD
		Contours Ring, Wings Ring, SohrtageWins Ring̓e͕ۏႳD

		vf[^
			ShortageWings RingDCreateShortageWingsRing()ō쐬Ăǂ

		method    1: OԖڂVertexTASY Next.
				  2: OԖڂVertexTASY Near.

		mode  false: dEdgeF߂D
			  true : dEdgeF߂ȂD
*/
DllExport void  FillShortageWings(SOLID* solid, int method, bool mode)
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start FillShortageWings");

	int wmax = (int)solid->shortage_wings.size();
	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax(wmax);

	int lpc = 0;
	int pno = 1;
	while (solid->shortage_wings.size()>1 && pno!=0 && lpc<MAX_LOOP_CNT) {
		if      (method==1) pno = FillShortageWings_Next(solid, mode);
		else if (method==2) pno = FillShortageWings_Near(solid, mode);
		else {
//			DEBUG_MODE print_messageln("FillShortageWings: mȂ@w肳ꂽ %d", method);
//			DEBUG_MODE print_messageln("End   FillShortageWings");
			return;
		}
		CreateShortageWingsRing(solid);
		//DEBUG_MODE print_messageln("FillShortageWings: sSWingf[^ %d/%d   %d", solid->shortage_wings.size(), wmax, pno);
		lpc++;
	}

//	DEBUG_MODE print_messageln("End   FillShortageWings");
	return;
}






/**
int  FillShortageWings_Next(SOLID* solid, bool mode)
	ȂContour[î݁jDNextASY
		EdgeɌqĂEdgeTĂVertexOp`(Contour)D
		Contours Ring  Wings Ring̓e͕ۏႳD

		vf[^
			ShortageWings RingDCreateShortageWingsRing()ō쐬Ăǂ

		mode  false: dEdgeF߂D
			  true : dEdgeF߂ȂD
*/
DllExport int  FillShortageWings_Next(SOLID* solid, bool mode)
{
	int patchno = 0;

	BREP_WING_RING::iterator wing1;
	for (wing1=solid->shortage_wings.begin(); wing1!=solid->shortage_wings.end(); wing1++){
		//if ((*wing1)->contour==NULL) { 
		if (!IsIncludeCompleteEdge(*wing1)) {
			VERTEX* vert[3];

			vert[0] = (VERTEX*)((*wing1)->vertex);
			BREP_WING_RING::iterator wing2;
			for (wing2=solid->shortage_wings.begin(); wing2!=solid->shortage_wings.end(); wing2++){
				//if ((*wing2)->contour==NULL && IsConnectEdges(*wing1, *wing2)) {
				if (!IsIncludeCompleteEdge(*wing2) && IsConnectEdges(*wing1, *wing2)) {
					vert[1] = (VERTEX*)((*wing2)->vertex);
					vert[2] = (VERTEX*)(BrepEdgeOtherWing(*wing2)->vertex);	// vert[]: Contour\钸_
					SHELL* shell = (SHELL*)(BrepEdgeOtherWing(*wing1)->contour->face->shell);
					if (PatchupContour(shell, vert, mode)) patchno++;
				}
			}
		}
//		if (patchno>5) break;
	}
	CreateContoursRing(solid);
	CreateWingsRing(solid);

	return patchno;
}





#define  MAX_QUEUE_SIZE  1


/**
int  FillShortageWings_Near(SOLID* solid, bool mode)
	ȂContour[î݁jDNearASY
		Edge̒S߂VertexTĎOp`(Contour)D
		Contours Ring  Wings Ring̓e͕ۏႳD

		vf[^
			ShortageWings RingDCreateShortageWingsRing()ō쐬Ăǂ

		mode  false: dEdgeF߂D
			  true : dEdgeF߂ȂD
*/
DllExport int  FillShortageWings_Near(SOLID* solid, bool mode)
{
	int patchno = 0;
	BREP_VERTEX_RING  vertex_ring;

	BREP_WING_RING::iterator wing1;
	for (wing1=solid->shortage_wings.begin(); wing1!=solid->shortage_wings.end(); wing1++){
		//if ((*wing1)->contour==NULL) {
		if (!IsIncludeCompleteEdge(*wing1)) {
		//	double  min = HUGE_VAL;
			VERTEX* vert[3];
			vert[0] = (VERTEX*)((*wing1)->vertex);
			vert[1] = (VERTEX*)(BrepEdgeOtherWing(*wing1)->vertex);
			vert[2] = NULL;
			vertex_ring.clear();

			BREP_WING_RING::iterator wing2;
			for (wing2=solid->shortage_wings.begin(); wing2!=solid->shortage_wings.end(); wing2++){
				if (wing1!=wing2) {
					VERTEX* vrtx = (VERTEX*)((*wing2)->vertex);
					if (vrtx!=vert[0] && vrtx!=vert[1]) {
					/*	int cnt = 0;
						VERTEX* v = vert[1];
						do {
							v = FindConnectEdgeVertex(v);
							cnt++;
						} while (v!=vert[0] && v!=vert[1] && v!=vrtx && v!=NULL && cnt<100);
					*/	
					//	if (v!=vrtx) {
							VECTOR<double> vect = (*wing1)->edge->center - vrtx->point;  
							vrtx->distance2 = vect.norm2();
							SetMinVertex(&vertex_ring, vrtx);
					//	}
					}
				}
			}

			int cnt=0;
			SHELL* shell = (SHELL*)(BrepEdgeOtherWing(*wing1)->contour->face->shell);
			BREP_VERTEX_RING::iterator ivert;
			for (ivert=vertex_ring.begin(); ivert!=vertex_ring.end(); ivert++){
				vert[2] = (VERTEX*)(*ivert);
				if (PatchupContour(shell, vert, mode)) {
					patchno++;
					break;
				}
				cnt++;
				if (cnt>=MAX_QUEUE_SIZE) break;
			}

		}
//		if (patchno>6) break;
	}
	CreateContoursRing(solid);
	CreateWingsRing(solid);

	return patchno;
}




/**
	int  FillShortageWings_Near()p
*/
DllExport void  SetMinVertex(BREP_VERTEX_RING* ring, VERTEX* vrtx)
{
	BREP_VERTEX_RING::iterator ivert;
	for (ivert=ring->begin(); ivert!=ring->end(); ivert++){
		if (vrtx==(*ivert)) return;	// ɓo^ς
		if (vrtx->distance2 < ((VERTEX*)(*ivert))->distance2) {
			ring->insert(ivert, vrtx);
			return;
		}
	}
	if (ivert==ring->end()) ring->push_back(vrtx);
	return;
}






/**
	vertex EdgeŌq vertex̓CŏɌ̂ԂD
*/
DllExport VERTEX*  FindConnectEdgeVertex(VERTEX* vert)
{
	BREP_WING_RING::iterator iwing;
	for (iwing=vert->wing_ring.begin(); iwing!=vert->wing_ring.end(); iwing++){
		if ((*iwing)->contour==NULL) {
			return (VERTEX*)(BrepEdgeOtherWing(*iwing)->vertex);
		}
	}
	return NULL;
}







/**
	Shellɑ΂āCvert[0]`vert[2]̎Op`Contour[D

		mode  true : dEdgeF߂D
			  false: dEdgeF߂ȂD
*/
DllExport bool   PatchupContour(SHELL* shell, VERTEX** vert, bool mode)
{
	if (vert[0]->forbidden_ring!=NULL) {
		BREP_VERTEX_RING::iterator vertex; 
		vertex = std::find(vert[0]->forbidden_ring->begin(), vert[0]->forbidden_ring->end(), vert[2]);
		if (vertex!=vert[0]->forbidden_ring->end()) return false;	// ֎~Ring̒ɌD 
	}

	SOLID* solid = (SOLID*)(shell->solid);
	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();

	FACE*  face  = new FACE(shell);
	CONTOUR* contour = CreateContourByVertex(face, vert, false); 	
	if (contour!=NULL) {
		if (DupEdgeNumber(contour)==0 || mode) {
			CONTOUR* collision;
			face->DataCloseCallback();
			if (!IsCollisionContours(solid, contour, &collision)) {
				solid->contours.push_back(contour);
//				PrintFacetAsciiSTL(contour);
				if (counter!=NULL) counter->StepIt();
				return true;
			}
			else FastDeleteFace(face);
		}
		else FastDeleteFace(face);
	}
	else FastDeleteFace(face); 

	return  false;
}






/**
  폜}[N̕tFace(Contour)폜C_Contour𗠕Ԃēo^.
			 Co^ ContourɑdEdgeꍇ͓o^𒆎~D
@Cǂݍ݁ijf[^͍폜ȂD

		Contours Ring  Wings Ring̓e͕ۏႳD
*/
DllExport void  ReverseContours(SOLID* solid)
{
	// SĂ Faceɑ΂
	BREP_SHELL_RING shells = solid->shells;
	BREP_SHELL_RING::iterator ishell;
	for (ishell=shells.begin(); ishell!=shells.end(); ishell++){
		BREP_FACE_RING::iterator iface;
		for (iface =(*ishell)->faces.begin(); iface!=(*ishell)->faces.end(); iface++){
			// 폜}[NtĂȂ
			if (((FACE*)(*iface))->deletable && !((FACE*)(*iface))->initdata) {
				// tŒ_ VECTOR vɊi[
				VERTEX*  v[3];
				FACE*    pbfc;
				CONTOUR* pbcn;
				BREP_CONTOUR_RING::iterator icon;
				for (icon=(*iface)->outer_contours.begin(); icon!=(*iface)->outer_contours.end(); icon++) {
					BREP_WING* wing = (*icon)->wing;
					for (int i=0; i<3; i++) {
						v[i] = (VERTEX*)(wing->vertex);
						wing = wing->prev;
					}
				}

				// 폜}[NtĂ Face폜
				pbfc = (FACE*)*iface;
				iface = (*ishell)->faces.erase(iface);
				iface--;
				pbfc->shell = NULL;
				delete(pbfc);

				// Ԃ Contouro^
				pbfc = new FACE((SHELL*)*ishell);
				pbcn = CreateContourByVertex(pbfc, v, false); 
				if (pbcn!=NULL) {
					if (DupEdgeNumber(pbcn)==0) {
						pbfc->DataCloseCallback();
					}
					else {
						FastDeleteFace(pbfc);
					}
				}
				else {
					FastDeleteFace(pbfc);
				}
			}
		}
	}

	CreateContoursRing(solid);	
	CreateWingsRing(solid);
}






/**
  sSdEdgeɂȂĂ邪C͈Edgeɂ܂Ƃ߂邱Ƃł̂
  ɂ܂Ƃ߂D
		Contours Ring  Wings Ring̓e͕ۏႳD

	@	vf[^
			ShortageWings RingDCreateShortageWingsRing()ō쐬Ăǂ
*/
DllExport void  JoinShortageWings(SOLID* solid)
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start JoinShortageWings");


	BREP_WING_RING::iterator iwing;
	for (iwing=solid->shortage_wings.begin(); iwing!=solid->shortage_wings.end(); iwing++){
		BREP_WING* wingA = (*iwing);

		if (BrepEdgeOtherWing(wingA)->contour==NULL) {		// NULL
			delete (wingA->edge);
			continue;
		}
		
		if (wingA->edge->edge_ring!=NULL) {
			BREP_EDGE_RING* edge_ring = wingA->edge->edge_ring;
			BREP_EDGE_RING::iterator iedge;
			for (iedge=edge_ring->begin(); iedge!=edge_ring->end(); iedge++){
				if (wingA==(*iedge)->wing1 || wingA==(*iedge)->wing2) continue;
				if ((*iedge)->wing1->contour!=NULL && (*iedge)->wing2->contour!=NULL) continue;

				BREP_WING* wingB;
				if      ((*iedge)->wing1->contour!=NULL) wingB = (*iedge)->wing1;
				else if ((*iedge)->wing2->contour!=NULL) wingB = (*iedge)->wing2;
				else continue;  // NULL炪ɌD deleteR[hɔCD

				if (wingA->vertex==wingB->vertex) {
					if      (wingA->edge->wing1==wingA) wingA->edge->wing1 = wingB;
					else if (wingA->edge->wing2==wingA) wingA->edge->wing2 = wingB;
					if      (wingB->edge->wing1==wingB) wingB->edge->wing1 = wingA;
					else if (wingB->edge->wing2==wingB) wingB->edge->wing2 = wingA;

					BREP_EDGE* sedge = wingB->edge;
					wingB->edge = wingA->edge;
					wingA->edge = sedge;
					wingB->edge->complete = true;
					wingA->edge->complete = false;
					break;
				}
			}
		}
	}
	CreateContoursRing(solid);
	CreateWingsRing(solid);

//	DEBUG_MODE print_messageln("End   JoinShortageWings");
	return;
}







//--------------------------------------------------------------------------------------------


/**
  ContouȓdEdge̐𐔂D
*/
DllExport int   DupEdgeNumber(CONTOUR* contour)
{
	contour->dup_edge = 0;

	BREP_WING* first = contour->wing;
	if (first!=NULL) {
		BREP_WING* next = first;
		do {
			BREP_WING* wing = next;
			next = wing->next;
			if (wing->edge->edge_ring!=NULL) contour->dup_edge++;
		} while(next!=first);
	}
	return  contour->dup_edge;
}





/**
	Face  Vector[3]  Contour D
		vector[0]`vector[2] R_̈ʒuxNgitĂj
*/
DllExport CONTOUR*  CreateContourByVector(FACE* face, VECTOR<double>* vector, bool special)
{
	SOLID*   solid;
	CONTOUR* contour;
	VERTEX*  vertex[3];

	solid = (SOLID*)(face->shell->solid);

	// Vertex ̐
	for (int i=0; i<3; i++) {
		vertex[i] = new VERTEX();
		vertex[i]->point = vector[i];
		vertex[i]->DataCloseCallback();
	}

	// Vertex\bh Octreeɓo^
	VERTEX* vert;
	for (int i=0; i<3; i++) {
		vert = (VERTEX*)AddVertex2Octree((BREP_VERTEX*)vertex[i], solid->octree);
		if (vert==NULL || vert!=vertex[i]) {
			delete vertex[i];
			vertex[i] = vert;
		}
	}

//	vertex[0] = (VERTEX*)AddVertex2Octree((BREP_VERTEX*)vertex[0], solid->octree);
//	vertex[1] = (VERTEX*)AddVertex2Octree((BREP_VERTEX*)vertex[1], solid->octree);
//	vertex[2] = (VERTEX*)AddVertex2Octree((BREP_VERTEX*)vertex[2], solid->octree);

//  @xNǧvZ
//	normal.x = v[0].y*v[1].z-v[0].z*v[1].y+v[1].y*v[2].z-v[1].z*v[2].y+v[2].y*v[0].z-v[2].z*v[0].y;
//	normal.y = v[0].z*v[1].x-v[0].x*v[1].z+v[1].z*v[2].x-v[1].x*v[2].z+v[2].z*v[0].x-v[2].x*v[0].z;
//	normal.z = v[0].x*v[1].y-v[0].y*v[1].x+v[1].x*v[2].y-v[1].y*v[2].x+v[2].x*v[0].y-v[2].y*v[0].x;
//	normal.Normalize();
//  ł͖@xNg͖D

	contour = CreateContourByVertex(face, vertex, special);	

	return  contour;
}






/**
	Face  Vertex[3]  Vertex D
		vertex[0]`vertex[2] R_ VertexitĂj
*/
DllExport CONTOUR*  CreateContourByVertex(FACE* face, VERTEX** vertex, bool special)
{
	// _D
	if (vertex[0]==vertex[1] || vertex[1]==vertex[2] || vertex[0]==vertex[2]) {
		return NULL;
	}
	// R_ɂD
	if (!special) if (IsForbiddenEdge(vertex)) return NULL;

	CONTOUR* contour = new CONTOUR(face);

	// WingD
	BREP_WING*      wing = contour->CreateWing((BREP_VERTEX*)vertex[0], (BREP_VERTEX*)vertex[1]);
	if (wing!=NULL) wing = contour->CreateWing((BREP_VERTEX*)vertex[1], (BREP_VERTEX*)vertex[2]);
	if (wing!=NULL) wing = contour->CreateWing((BREP_VERTEX*)vertex[2], (BREP_VERTEX*)vertex[0]);
	if (wing!=NULL) {
		contour->DataCloseCallback();  // @xNgvZD
	}
	else {
		delete(contour);
		contour = NULL;
	}

	return  contour;
}





//
//  WingɊ֘AEdgeyт̑dEdge͊SH
//		ɂEdge̓CŒ͕Ă邩H
//
DllExport bool  IsIncludeCompleteEdge(BREP_WING* wing)
{
	EDGE* edge = (EDGE*)(wing->edge);
	if (edge->complete) return true;
	if (edge->edge_ring!=NULL) {
		BREP_EDGE_RING::iterator iedge;
		for (iedge=edge->edge_ring->begin(); iedge!=edge->edge_ring->end(); iedge++){
			if ((*iedge)->complete) return true;
		}
	}
	return false;
}







/**
	Oɐ Faceɍ폜D
  @	Oɐ̂łȂ Facew肵ꍇ͌쓮D
  @	Face̐ꍇCdelete(Face) ܂ ~BREP_FACE()s
  @	ƈXfind()ĂяôŎԂ|D
*/
DllExport void  FastDeleteFace(FACE* face)
{
	if (face==NULL) return;
	if (face->shell!=NULL) {
		face->shell->faces.pop_back();
		face->shell = NULL;
	}

	// Destroy its contours
	BREP_CONTOUR*  bpcn;
	BREP_CONTOUR_RING::iterator contour = face->outer_contours.begin();

	while (contour!=face->outer_contours.end()) {
		bpcn = *contour;
		contour = face->outer_contours.erase(contour);
		bpcn->face = NULL;
		delete (bpcn);	
	}
	free(face);
	
	return;
}





/**
	EdgeɊ֘Atꂽ Contourɍ폜\̃}[ND폜͍sȂD
*/
DllExport void  SetDeletableContoursByEdge(EDGE* edge)
{
	if (edge->edge_ring!=NULL) {
		BREP_EDGE_RING::iterator iedge;
		for (iedge=edge->edge_ring->begin(); iedge!=edge->edge_ring->end(); iedge++){
			if ((*iedge)->wing1->contour!=NULL) {
				((FACE*)((*iedge)->wing1->contour->face))->deletable = true;
			}
			if ((*iedge)->wing2->contour!=NULL) {
				((FACE*)((*iedge)->wing2->contour->face))->deletable = true;
			}
		}
	}
	else {
		if (edge->wing1->contour!=NULL) {
			((FACE*)(edge->wing1->contour->face))->deletable = true;
		}
		if (edge->wing2->contour!=NULL) {
			((FACE*)(edge->wing2->contour->face))->deletable = true;
		}
	}
}









//----------------------------------------------------------------------------------------------



/*
	R_ *v[0], *v[1], *v[2] ꒼ɂ邩ǂ𒲂ׂ.
		tolerancěvZ͍člKvH
*/
DllExport int  IsAtLine(VERTEX** v) 
{
	TVECTOR<double> vect  = ToTVector(v[0]);
	TVECTOR<double> vect1 = ToTVector(v[1]);
	TVECTOR<double> vect2 = ToTVector(v[2]) - vect;
	TVECTOR<double> vect3 = ToTVector(v[2]) - vect1;
	vect1 = vect1 - vect;

	int mode = 0;
	double tt;
	double th = ProportionVector(vect2, vect1, tt);
	tt = Max(tt, ZERO_EPS);
	if (th>1.-tt) mode = 1;			// 0->1->2
	else {
		th = ProportionVector(vect1, vect2, tt);
		tt = Max(tt, ZERO_EPS);
		if (th>1.-tt) mode = 2;		// 0->2->1
		else {
			th = ProportionVector(vect3, vect2, tt);
			tt = Max(tt, ZERO_EPS);
			if (th>1.-tt) mode = 3;	// 1->0->2
		}
	}
	return  mode;
}





/**
	Vertex vert[0]`vert[2] ꒼ɕł邩ׂD
	꒼̏ꍇ́CYEdge֎~D
	܂Cɂ Edgeꍇ͊֘A Contour폜D
*/
DllExport bool  IsForbiddenEdge(VERTEX** vert)
{
	EDGE* edge = NULL;
	int mode = IsAtLine(vert);
	if (mode==1) {		// 0->1->2
		if (vert[0]->forbidden_ring==NULL) vert[0]->forbidden_ring = new BREP_VERTEX_RING();
		if (vert[2]->forbidden_ring==NULL) vert[2]->forbidden_ring = new BREP_VERTEX_RING();
		vert[0]->forbidden_ring->push_back(vert[2]);
		vert[2]->forbidden_ring->push_back(vert[0]);
		edge = (EDGE*)BrepFindEdge(vert[0], vert[2]);
	}
	else if (mode==2) {	// 0->2->1
		if (vert[0]->forbidden_ring==NULL) vert[0]->forbidden_ring = new BREP_VERTEX_RING();
		if (vert[1]->forbidden_ring==NULL) vert[1]->forbidden_ring = new BREP_VERTEX_RING();
		vert[0]->forbidden_ring->push_back(vert[1]);
		vert[1]->forbidden_ring->push_back(vert[0]);
		edge = (EDGE*)BrepFindEdge(vert[0], vert[1]);
	}
	else if (mode==3) {	// 2->0->1
		if (vert[1]->forbidden_ring==NULL) vert[1]->forbidden_ring = new BREP_VERTEX_RING();
		if (vert[2]->forbidden_ring==NULL) vert[2]->forbidden_ring = new BREP_VERTEX_RING();
		vert[1]->forbidden_ring->push_back(vert[2]);
		vert[2]->forbidden_ring->push_back(vert[1]);
		edge = (EDGE*)BrepFindEdge(vert[1], vert[2]);
	}
	if (edge!=NULL) SetDeletableContoursByEdge(edge);

	if (mode==0) return false;
	return true;
}









//----------------------------------------------------------------------------------------------


/**
	Contour  ContourƏՓ˂Ă邩ǂ`FbND
				Ȃ....
*/
DllExport bool IsCollisionContours(SOLID* solid, CONTOUR* contour, CONTOUR** collision)
{
	*collision = NULL;

	BREP_CONTOUR_RING::iterator icon;
	for (icon=solid->contours.begin(); icon!=solid->contours.end(); icon++){
		if (!disJunctBounds(contour->face->rbound, (*icon)->face->rbound)) {
		if (!((FACE*)((*icon)->face))->deletable || ((FACE*)((*icon)->face))->initdata) {
		//if (contour!=(*icontour)) {
			int svrtx = CommonVertex((CONTOUR*)(*icon), contour);
			if (svrtx==3) {
				*collision = (CONTOUR*)(*icon);
				return true;
			}
			
			int lineno;
			if (SamePlaneContour((CONTOUR*)(*icon), contour, lineno)) {
				// Rp`̓_
				if (!contour->hasCollisionVector) contour->ComputeDirectRS();
				if (IsInTriangle((CONTOUR*)(*icon), contour)) {
					*collision = (CONTOUR*)(*icon);
					return true;
				}
				if (!((CONTOUR*)(*icon))->hasCollisionVector) ((CONTOUR*)(*icon))->ComputeDirectRS();
				if (IsInTriangle(contour, (CONTOUR*)(*icon))) {
					*collision = (CONTOUR*)(*icon);
					return true;
				}
				
				// 2DՓˌ
				if (CollisionTriContour2D((CONTOUR*)(*icon), contour)) {
					*collision = (CONTOUR*)(*icon);
					return true;
				}
			}
			else {
				if (lineno==1) continue;
				// 3DՓˌ
				if (!contour->hasCollisionVector) contour->ComputeDirectRS();
				if (CollisionTriContour3D((CONTOUR*)(*icon), contour)) {
					*collision = (CONTOUR*)(*icon);
					return true;
				}
				if (!((CONTOUR*)(*icon))->hasCollisionVector) ((CONTOUR*)(*icon))->ComputeDirectRS();
				if (CollisionTriContour3D(contour, (CONTOUR*)(*icon))) {
					*collision = (CONTOUR*)(*icon);
					return true;
				}
			}
//		}
		}
		}
	}
	return false;
}








/**
bool  CollisionTriContour3D(CONTOUR* contour1, CONTOUR* contour2)
	contour1 contour2Փ˂Ă邩ǂ`FbND

		contour2->directRS, directR, directS \ߌvZĂȂ΂ȂȂD
			Ⴆ ComputeDirectRS() gp 
*/
DllExport bool  CollisionTriContour3D(CONTOUR* contour1, CONTOUR* contour2)
{
	double  tc, uc, vc, tm, um, ut, vt, tt, tmt, umt;
	BREP_WING* wing  = contour1->wing;
	TVECTOR<double> directR  = contour2->directR;
	TVECTOR<double> directS  = contour2->directS;
	TVECTOR<double> directRS = contour2->directRS;
	TVECTOR<double> directT;
	TVECTOR<double> directB;
	TVECTOR<double> directQB;
	TVECTOR<double> directN;

	// eӂɂՓˌo
	for (int i=0; i<3; i++) {
		TVECTOR<double> point   = ToTVector((VERTEX*)(wing->vertex));
		TVECTOR<double> directQ = ToTVector((VERTEX*)(contour2->wing->vertex)) - point;

		for (int j=0; j<2; j++) {		
			directN = ToTVector((VERTEX*)(wing->next->vertex));
			if (j==0) directB = directN - point;
			else	  directB = directB + (ToTVector((VERTEX*)(wing->next->next->vertex)) - directN)*0.5;
			directQB = directQ^directB;

			um  = directRS*directB;
			tm  = directQB*directS;
			umt = TVectorMultiTolerance(directRS, directB);
			tmt = TVectorMultiTolerance(directQB, directS);

			if (Xabs(um)>Max(umt, ZERO_EPS) && Xabs(tm)>Max(tmt, ZERO_EPS)) {
				uc =  tm;
				tc = -directQB*directR;
				vc =  directRS*directQ;
				ut = tmt;
				tt = TVectorMultiTolerance(directQB, directR);
				vt = TVectorMultiTolerance(directRS, directQ);

				ut = Max(Collision_Tolerance, (um*ut+umt*uc)/(um*um));
				tt = Max(Collision_Tolerance, (tm*tt+tmt*tc)/(tm*tm));
				vt = Max(Collision_Tolerance, (um*vt+umt*vc)/(um*um));
				uc  = uc/um;
				tc  = tc/tm;
				vc  = vc/um;
				directT = directR + tc*directS;

				if (uc>ut && 1.-uc>ut && tc>tt && 1.-tc>tt && vc>vt && 1.-vc>vt &&
					uc*directT.n>directT.t && (1.-uc)*directT.n>directT.t &&
					tc*directS.n>directS.t && (1.-tc)*directS.n>directS.t && 
					vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
				//	DEBUG_MODE print_messageln("3DՓ %d !!!!  %e  %e  %e", j+1, uc, tc, vc);
				//	PrintFacetAsciiSTL(contour1);
				//	PrintFacetAsciiSTL(contour2);
					return true;
				}
			}
		}
		wing = wing->next;
	}

	return false;
}





DllExport bool  CollisionTriContour2D(CONTOUR* contour1, CONTOUR* contour2)
{
	double  uc, vc, tm, um, ut, vt, tmt, umt;
	BREP_WING* wing = contour1->wing;
	TVECTOR<double> directR  = contour2->directR;
	TVECTOR<double> directS  = contour2->directS;
	TVECTOR<double> directRS = contour2->directRS;
	
	wing = contour1->wing;
	for (int i=0; i<3; i++) {
		TVECTOR<double> point    = ToTVector((VERTEX*)(wing->vertex));
		TVECTOR<double> directB  = ToTVector((VERTEX*)(wing->next->vertex)) - point;
		TVECTOR<double> directQ  = ToTVector((VERTEX*)(contour2->wing->vertex)) - point;
		TVECTOR<double> directQB = directQ^directB;
		directB.norm();

		tm  = directQB*directS;
		um  = directRS*directB;
		tmt = TVectorMultiTolerance(directQB, directS);
		umt = TVectorMultiTolerance(directRS, directB);

		if (Xabs(tm)<=Max(tmt, ZERO_EPS) || Xabs(um)<=Max(umt, ZERO_EPS)) {
			TVECTOR<double> directBR = directB^directR;
			TVECTOR<double> directQR = directQ^directR;
			TVECTOR<double> directQB = directQ^directB;
			uc = ProportionVector(directQB, directBR, ut);
			vc = ProportionVector(directQR, directBR, vt);
			ut = Max(ut, Collision_Tolerance);
			vt = Max(vt, Collision_Tolerance);
			if (uc>ut && 1.-uc>ut && vc>vt && 1.-vc>vt && 
				uc*directR.n>directR.t && (1.-uc)*directR.n>directR.t &&
				vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
	//				DEBUG_MODE print_messageln("ꕽʏ1  %e  %e    %e  %e", uc, vc, ut, vt);
	//				PrintFacetAsciiSTL(contour1);
	//				PrintFacetAsciiSTL(contour2);
					return true;
			}

			directBR = directB^directS;
			directQR = (directQ+directR)^directS;
			directQB = (directQ+directR)^directB;
			uc = ProportionVector(directQB, directBR, ut);
			vc = ProportionVector(directQR, directBR, vt);
			ut = Max(ut, Collision_Tolerance);
			vt = Max(vt, Collision_Tolerance);
			if (uc>ut && 1.-uc>ut && vc>vt && 1.-vc>vt &&  
				uc*directS.n>directS.t && (1.-uc)*directS.n>directS.t &&
				vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
//				DEBUG_MODE print_messageln("ꕽʏ2  %e  %e    %e  %e", uc, vc, ut, vt);
//				PrintFacetAsciiSTL(contour1);
//				PrintFacetAsciiSTL(contour2);
				return true;
			}

			TVECTOR<double> directT = directR + directS;
			directBR = directB^directT;
			directQR = directQ^directT;
			directQB = directQ^directB;
			uc = ProportionVector(directQB, directBR, ut);
			vc = ProportionVector(directQR, directBR, vt);
			ut = Max(ut, Collision_Tolerance);
			vt = Max(vt, Collision_Tolerance);
			if (uc>ut && 1.-uc>ut && vc>vt && 1.-vc>vt &&
				uc*directT.n>directT.t && (1.-uc)*directT.n>directT.t &&
				vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
//				DEBUG_MODE print_messageln("ꕽʏ3  %e  %e    %e  %e", uc, vc, ut, vt);
//				PrintFacetAsciiSTL(contour1);
//				PrintFacetAsciiSTL(contour2);
				return true;
			}
		}

		wing = wing->next;
	}

	return false;
}





DllExport bool  IsInTriangle(CONTOUR* contour1, CONTOUR* contour2)
{
	double  tc, uc, tt, ut;
	TVECTOR<double>  directS  = contour2->directS;
	TVECTOR<double>  directRS = contour2->directRS;
	TVECTOR<double>  directQ, directT, directN;
	BREP_WING* wing = contour1->wing;

	for (int i=0; i<3; i++) {
		for (int j=0; j<2; j++) {
			directN = ToTVector((VERTEX*)(wing->vertex));
			if (j==0) directQ = ToTVector((VERTEX*)(contour2->wing->vertex)) - directN;
			else      directQ = directQ - (ToTVector((VERTEX*)(wing->next->vertex)) - directN)*0.5;

			TVECTOR<double>  directSQ = directS^directQ;
			TVECTOR<double>  directQR = directQ^contour2->directR;
			tc = ProportionVector(directQR, directSQ, tt);
			uc = ProportionVector(directSQ, directRS, ut);
			directT = contour2->directR + tc*directS;
			ut = Max(ut, Collision_Tolerance);
			tt = Max(tt, Collision_Tolerance);
			if (tc>tt && 1.-tc>tt && uc>ut && 1.-uc>ut &&
				tc*directS.n>directS.t && (1.-tc)*directS.n>directS.t &&
				uc*directT.n>directT.t && (1.-uc)*directT.n>directT.t) {
//				DEBUG_MODE print_messageln("Op`̓ %d : %e  %e    %e  %e", j+1, tc, uc, tt, ut);
				//PrintFacetAsciiSTL(contour1);
				//PrintFacetAsciiSTL(contour2);
				return true;
			}
		}
	}
	return false;
}





DllExport bool  SamePlaneContour(CONTOUR* contour1, CONTOUR* contour2, int& lineno)
{
	double  um, umt, tm, tmt;
	BREP_WING* wing = contour1->wing;
	TVECTOR<double>  directB, directQ;

	lineno = 0;
	for (int i=0; i<3; i++) {
		directB = ToTVector((VERTEX*)(wing->next->vertex))     - ToTVector((VERTEX*)(wing->vertex));
		directQ = ToTVector((VERTEX*)(contour2->wing->vertex)) - ToTVector((VERTEX*)(wing->vertex));
		um  = contour2->directRS*directB;
		tm  = contour2->directRS*directQ;
		umt = TVectorMultiTolerance(contour2->directRS, directB);
		tmt = TVectorMultiTolerance(contour2->directRS, directQ);
		if (Xabs(um)<Max(umt, ZERO_EPS) && Xabs(tm)<Max(tmt, ZERO_EPS)) {
			lineno++;
		}
	}

	if (lineno>=2) return true;
	return  false;
}







DllExport int  CommonVertex(CONTOUR* contour1, CONTOUR* contour2)
{
	BREP_VERTEX_RING  vertex_ring;

	int cnt = 0;
	BREP_WING* wing1 = contour1->wing;
	for (int i=0; i<3; i++) {
		bool common = false;
		BREP_WING* wing2 = contour2->wing;
		for (int j=0; j<3; j++) {
			if (wing1->vertex==wing2->vertex) {
				cnt++;
				common = true;
				break;
			}
			wing2 = wing2->next;
		}
		if (!common) vertex_ring.push_back(wing1->vertex);
		wing1 = wing1->next;
	}
	return cnt;

}







DllExport TVector<double>  ToTVector(BREP_VERTEX* v)
{
	TVector<double>  tv;
	tv.x   = v->point.x;
	tv.y   = v->point.y;
	tv.z   = v->point.z;
	tv.n2  = tv.x*tv.x + tv.y*tv.y + tv.z*tv.z;
	tv.n   = sqrt(tv.n2);
	tv.t   = v->tolerance;
	return  tv;
}







/**
unsigned int  CreateSolidFromSTL(STLData* stldata, unsigned int fno, SOLID* solid, bool collision, bool special)

	STLData SOLID𐶐DSOLIDɎgpꂽLȃt@Zbg̐ԂD
	JE^gp\D

	D
			collision : Փ˔sH@				true sDfalse sȂ
			special   : ǂݍ݃f[^ʈɂ邩H	true Dfalse ȂD
						ʈɂꍇCsǂݍ݃f[^폜

	߂l -1 : \bhNULLC܂̓\bh Octree NULL
		   -3 : 삪LZꂽD
*/
DllExport int  CreateSolidFromSTL(STLData* stldata, int fno, SOLID* solid, bool collision, bool special)
{
	SHELL*   shell;
	FACE*    face;
	CONTOUR* contour;
	CVCounter* counter = NULL;
	VECTOR<double>   v[4];

	if (solid==NULL) {
		DEBUG_MODE print_messageln("CreateSolidFromSTL: \bhւ̃|C^ NULLłD");
		return -1;
	}
	if (solid->octree==NULL) {
		DEBUG_MODE print_messageln("CreateSolidFromSTL: Solid Octreeւ̃|C^NULLłD");
		return -1; 
	}

	solid->contours.clear();

	// JE^
	if (solid->counter!=NULL) {
		counter = solid->counter->GetUsableCounter();
		if (counter!=NULL) {
			counter->SetMax(100);
			if (special) counter->ResetRate( 80, fno/COUNTER_RATE);
			else         counter->ResetRate(100, fno/COUNTER_RATE);
		}
	}


	shell = new SHELL(solid);
	for (int i=0; i<fno; i++) {
		// ǂݍ STLf[^ƗpVECTORϐɊi[
		v[0].x = stldata[i].vect[3]; v[0].y = stldata[i].vect[4];  v[0].z = stldata[i].vect[5];
		v[1].x = stldata[i].vect[6]; v[1].y = stldata[i].vect[7];  v[1].z = stldata[i].vect[8]; 
		v[2].x = stldata[i].vect[9]; v[2].y = stldata[i].vect[10]; v[2].z = stldata[i].vect[11];
		//v[3].x = stldata[i].vect[0]; v[3].y = stldata[i].vect[1];  v[3].z = stldata[i].vect[2];
		// t@C̖@xNgf[^͖D

		face = new FACE(shell); 
		contour = CreateContourByVector(face, v, special);
		if (contour!=NULL) {
			// Փ˔
			if (collision) {	
				CONTOUR* collision;
				face->DataCloseCallback();
				if (!IsCollisionContours(solid, contour, &collision)) {
					solid->contours.push_back(contour);				// IsCollisionContours()p
				}
				else {
					((FACE*)(collision->face))->deletable = true;	// ՓˑD
					FastDeleteFace(face);
				}
			}
			else  solid->contours.push_back(contour);
		}
		else  {
			//FastDeleteFace(face);	// ł́CFace  Contour͂P΂PȂ̂ŁD// Debug ̍\ŃG[łD
			deleteNull(face);		// g͋󂾂 delete łH
		}


		if (counter!=NULL && i%COUNTER_RATE==0) {
			counter->StepIt();
			if (counter->isCanceled()) {
				deleteNull(face);
				return -3;
			}
		}
	}
	if (counter!=NULL) counter->PutFill();



	// IsForbiddenEdge()ɂ deletableɂȂĂContour邩Ȃ̂ŁC
	// CreateContoursRing()ō蒼D 	
	CreateContoursRing(solid);
	CreateWingsRing(solid);

	if (special) {  // f[^iǂݍ݃f[^jʈɂD
		// ŁCsKvȃf[^폜D
		// dEdge̍폜
		CreateSurplusContoursRing(solid);	
		if (counter!=NULL) counter->MakeChildCounter(10);
		DeleteSurplusContours(solid);
		if (counter!=NULL) counter->DeleteChildCounter();

		// ɕ Edge̍폜
		CreateShortageWingsRing(solid);
		if (counter!=NULL) counter->MakeChildCounter(10);
		DeleteStraightEdges(solid);     	
		if (counter!=NULL) counter->DeleteChildCounter();

		// c͐΍폜ȂD
		BREP_CONTOUR_RING::iterator icon;
		for (icon=solid->contours.begin(); icon!=solid->contours.end(); icon++) {
			((FACE*)((*icon)->face))->initdata = true;	
			//FacetAsciiData((CONTOUR*)(*icontour));
		}
	}
//	delete(counter);


	CreateSurplusContoursRing(solid);	
	CreateShortageWingsRing(solid); 
	solid->DataCloseCallback();
	return  (int)solid->contours.size();
}







DllExport  bool  IsConnectEdges(BREP_WING* wing1, BREP_WING* wing2)
{
	if (BrepEdgeOtherWing(wing1)->vertex==wing2->vertex) return true;
	return false;
}


