/* vi: set tabstop=4 paste nocindent noautoindent: */

#ifndef  __JBXL_TINY_TREE_H_
#define  __JBXL_TINY_TREE_H_


/** 
@brief   Tiny Tree Graph \Cuwb_
@file    tTree.h
@version
@author  Fumi.Iseki (C)
@date    2008 2/1
@see     tList (_tList), tTree
*/



#include "buffer.h"
#include "tlist.h"




/** 
typedef  tList  	tTree;

@code
tTree \
	tList_data 	ldat		f[^

	tList*	 	next		qm[hւ̃|C^
	tList*	 	prev		em[hւ̃|C^
	tList*		altp		̃m[hւ̃|C^

	tList*		back		qiqjm[hւ̃|C^
	tList*		esis		O̎om[hւ̃|C^
	tList*		ysis		̎om[hւ̃|C^

	int 		depth		[                    
	int			num			qm[h̐ 
	int			ctrl		p         
	int			state   	m[h̏



tList_data \
	int	 		id;			m[hID
	int	 		lv;			m[hlij
	Buffer  	key;		m[h̃L[
	Buffer  	val;		m[hlij
	void*		ptr;		ėpD\̂Ȃǂւ̃|C^Diptr->X  freełȂ̂ŁCXĝ悤ȃ|C^ݒ肵Ă͂Ȃj
	int	 		sz;			*ptr ̃TCY
	struct _tList* 	lst;	Xgf[^ւ̃|C^
@endcode
 */
typedef  tList  		tTree;






/// ldat.ctrl Xgp
#define	TREE_NOCTRL_NODE 				0			///< ̐ij󂯂ĂȂm[hDftHgD
#define	TREE_NOCMP_NODE 				100			///< rΏƂOm[hDʏ͖ňvD
#define	TREE_NOCMP_COPY_NODE 			101			///< rΏƂOCŌɃRs[sm[hDʏ͖ňvD
#define	TREE_COPY_NODE					102			///< ŃRs[sm[hDcopy_tTree_byctrl()ȂǁD
#define	TREE_ALREADY_FOUND_NODE			110			///< ȂǂɂĊɌm[hDƂm肵m[hD
#define	TREE_ALREADY_FOUND_NODE_TEMP 	111			///< ꎞIɔrΏƂOꍇɃm[hDƒɐݒD






////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny Tree Graph Node
//

tTree*  new_tTree_node(void);
tTree   make_tTree_node(tList_data data);


tTree* 	add_tTree_node		   (tTree* pp, tTree* pt);
tTree* 	add_tTree_node_bydata  (tTree* pp, tList_data ldat);
tTree*  add_tTree_node_bystr   (tTree* pp, int id, int lv, const char*  key, const char*  val, void* ptr, int sz);
tTree* 	add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz); 

#define add_tTree_node_int(p, k, v)			add_tTree_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define add_tTree_node_str(p, k, v)        	add_tTree_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define add_tTree_node_Buffer(p, k, v)     	add_tTree_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)

tTree* 	insert_tTree_node		  (tTree* pp, tTree* pt);
tTree*  insert_tTree_node_bydata  (tTree* pp, tList_data ldat);
tTree*  insert_tTree_node_bystr   (tTree* pp, int id, int lv, const char*  key, const char*  val, void* ptr, int sz);
tTree* 	insert_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz); 

#define insert_tTree_node_int(p, k, v)		insert_tTree_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define insert_tTree_node_str(p, k, v)      insert_tTree_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define insert_tTree_node_Buffer(p, k, v)   insert_tTree_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)


tTree*  del_tTree_node(tTree** node); 
tTree*  move_tTree_node(tTree* node, tTree* pp); 
int  	replace_all_tTree_node(tTree* pp, char* key, char* src, char* dst, int len);

#define set_tTree_node_bydata(p, k)						set_tList_node_bydata((p), (k))
#define set_tTree_node_bystr(p, i, l, k, v, d, s) 		set_tList_node_bystr((p), (i), (l), (k), (v), (d), (s))
#define set_tTree_node_byBuffer(p, i, l, k, v, d, s) 	set_tList_node_byBuffer((p), (i), (l), (k), (v), (d), (s))

#define set_tTree_node_int(p, k, d) 	 	set_tList_node_bystr((p), (k), (v), NULL, NULL, NULL, 0)
#define set_tTree_node_str(p, k, d)  		set_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define set_tTree_node_Buffer(p, k, d)		set_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)

#define dup_tTree_node(p)					dup_tList_node(p)

/** 
void  free_tTree_node(tList** p)
m[h̃obt@(f[^)̊JD
@param  p  -- Jm[hւ̃|C^D
*/
#define	free_tTree_node(p)						free_tList_node(p)




////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny Tree Graph
//

tTree*  del_tTree(tTree** pp); 
void   	del_all_tTree(tTree** pp);
tTree*	del_children_tTree(tTree** pp);
tTree*	del_sisters_children_tTree(tTree** pp);
#define free_tTree(t)  del_tTree((t))

void   	adjust_tTree_depth(tTree* pp);
void   	print_tTree(FILE* fp, tTree* pp, const char* sp);

tTree* 	add_tTree(tTree* pp, tTree* pt);
tTree* 	div_tTree(tTree* pp);
tTree*	dup_merge_tTree(tTree* pp, tTree* tp);
void  	merge_tTree(tTree* pp, tTree* pt);
void  	exchange_tTree(tTree* tl, tTree* tt);
int		count_tTree(tTree* pp);

/**
tList*  find_tTree_top(tList* p)
c[̃gbvi[gj
@param p c[̈ꕔւ̃|C^
*/
#define	find_tTree_top(p)	find_tList_top((p))

tTree*	find_tTree_end(tTree* pp);


// /u
tTree*  strncmp_tTree    (tTree* pp, const char*  key, int len, int no);
tTree*  strncasecmp_tTree(tTree* pp, const char*  key, int len, int no);

tTree*  cmp_sisters_tTree (tTree* tp, tTree* tr);
int  	check_match_tTree (tTree* tp, tTree* tr);
int 	find_match_tTree  (tTree* pp, tTree* pt);
int 	replace_tTree_node(tTree* pp, tTree* pt);
void 	copy_tTree_byctrl (tTree* pt);

tList*	find_match_tTree_endlist(tTree* pp, tTree* pt);
tList*	find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te);
void   	clear_tTree_ctrl(tTree* pp);

Buffer	get_value_tTree  (tTree* pp, tTree* pt);
#define	set_value_tTree(p, t)	replace_tTree_node((p), (t))


// ⏕I֐
tTree*  next_strncmp_vertical_tTree    (tTree* pp, const char* key, int len, int no, int* nn);
tTree*  next_strncasecmp_vertical_tTree(tTree* pp, const char* key, int len, int no, int* nn);

tTree*  next_strncmp_horizon_tTree    (tTree* pp, const char* key, int len, int no, int* nn);
tTree*  next_strncasecmp_horizon_tTree(tTree* pp, const char* key, int len, int no, int* nn);



/**/


#endif


