/* vi: set tabstop=4 paste nocindent noautoindent: */

#ifndef  __JBXL_TINY_XML_H_
#define  __JBXL_TINY_XML_H_


/** 
@brief   Tiny XML Cuwb_ 
@file    txml.h
@version 1.0
@author  Fumi.Iseki (C)
@date    2009 2/10


@par ^Cg
Tiny XML txml.h v1.0 @n
TuZbgŁ@`XML ȈՃp[T Cuwb_

@see tXML

@attention
SẴp^[̃p[X\ۏႷ̂ł͂܂@n
G XMĹi炭jp[Xł܂D@n
<?xml ... ?> ȊO <? ..... ?>  <! .....  > ͏Ȃiǂݍ݂͍sj@n
GeBeB͏ȂD@n
*/


#include "ttree.h"


/** 
typedef  tTree  tXML;

@b tXML  (@b tList, @b tTree, @b _tList Ɠ)
@see tTree 

1. ^Of[^ tXMLF

	int	 	ldat.id		^O̎ʁDXML_ANCHOR_TAG, XML_TAG_NAME, XML_TAG_CONTENT, ..........
	int	 	ldat.lv		ʂ^Olłqm[ȟ
	int	 	ldat.sz		gp
	Buffer  ldat.key	^O܂̓^Ol
	Buffer  ldat.val	<! ... > ̖f[^ <!-- ... -->̃Rgi[ 
	void*	ldat.ptr	gp 
	tXML*	ldat.lst	Xgւ̃|C^Dldat.lst->ldat.keyɑCldat.lst->ldat.valɑl("'t)i[

	tXML*	next		q^Oijւ̃|C^
	tXML*	prev		e^Oւ̃|C^
	tXML*	altp		̑ւ̃|C^iėpj 
	tXML*	back		q^Oiqjւ̃|C^ 
	tXML*	esis		O̎oioj^Oւ̃|C^
	tXML*	ysis		̎oij^Oւ̃|C^

	int		depth   	[					
	int		num	 		qm[h̐iSĂ̎qm[h̐j	
	int		ctrl		p
	int		state   	m[h̏  XML_PARSED, XM_TAG_OPEND, XML_TAG_ENDED, XML_PARSE_ERROR, ....


2. p[XXMLi[c[\

	<?xml version="1.0" ?><A><B><C>ABC</C><D />EFG</B><E /><!-- comment --></A> 
	
  	NULL (XML_ANCHOR_TAG) -> xml (XML_DOC_TAG)
						  -> A (XML_TAG_NAME) -> B (XML_TAG_NAME) -> C (XML_TAG_NAME) -> ABC (XML_TAG_CONTENT)
                                                                  -> D (XML_TAG_NAME)
																  -> EFG (XML_TAG_CONTENT)
											  -> E (XML_TAG_NAME)
											  -> @COMMENT_TAG (XML_COMMENT_TAG) 	// Rg͎̏bI


3, ^Oim[hj (ldat.id)

	XML_ANCHOR_TAG			AJ[^O
	XML_TAG_NAME			^Ol[
	XML_TAG_CONTENT			^O̓eiRegj
	XML_DOC_TAG				<? xml... ?> ^O
	XML_COMMENT_TAG			Rg^O
	XML_DATA_TAG			<! ... > ^O
	XML_PROCESS_TAG 		XML_DOC_TAG ȊO <? ... ?>^O


4.  (state)

	XML_DEFAULT_STATE		m[h́CɃp[Xꂽǂ̔͂܂sĂȂD
	XML_PARSED				AJ[^Oɂ̂ݐݒ肳DXMLc[͐Ƀp[XꂽƂD
	XML_TAG_STARTED			̃m[h̓I[vԂɂD <tagname>
	XML_TAG_ENDED			̃m[h͐ɃN[YD </tagname>
	XML_TAG_EMPTY			̃m[h͋vf^Oł <  />, <!--  -->, <!   >, <?   ?> ̌^

	XML_NOT_CLOSED			ŏIIɃ^OȂC߂łƂ܂ł͉߂D
	XML_MULTI_ROOT			AJ[^Oɂ̂ݐݒ肳DXMLc[ 2ȏ̓Ɨc[

	XML_PARSE_ERROR			߃G[
	XML_SEQUENCE_ERROR		AJ[zăc[낤ƂD
	XML_MEMORY_ERROR		̊mۃG[
*/
typedef  tTree  tXML;





// ^O	(ldat.id)
#define  XML_ANCHOR_TAG				0
#define  XML_TAG_NAME				1
#define  XML_TAG_CONTENT			2
#define  XML_DOC_TAG				3
#define  XML_COMMENT_TAG			4
#define  XML_DATA_TAG				5
#define  XML_PROCESS_TAG			6


// ^O(m[h)̏ԁDG[ 0ȉɂD(state)
#define  XML_DEFAULT_STATE			0
#define  XML_PARSED					1	
#define  XML_TAG_STARTED			2
#define  XML_TAG_ENDED				3
#define  XML_TAG_EMPTY				4
#define  XML_MULTI_ROOT				9
// warning
#define  XML_NOT_CLOSED				101
// error
#define  XML_PARSE_ERROR			-1
#define  XML_SEQUENCE_ERROR			-2
#define  XML_MEMORY_ERROR			-9


// XML Format
#define  XML_ONELINE_FORMAT			0
#define  XML_CRLF_FORMAT			1
#define  XML_INDENT_FORMAT			2


// p^O (ldat.key.buf)
#define  XML_COMMENT_TAG_KEY		"@COMMENT_TAG"
#define  XML_DATA_TAG_KEY			"@DATA_TAG"




/////////////////////////////////////////////////////////////////////////////////////////////
//
// XML Functions
//

#define new_xml_node()	new_tTree_node()


// Paser
tXML*	xml_parse(char* pp);
tXML*	xml_parse_file(const char* pp);
tXML*	xml_parse_seq(tXML* xml,  char* pp);
tXML*	xml_main_parse(tXML* xml, char* pp, int skip);

int 	xml_parse_content(char* pp, char** content);
tList*	xml_parse_attr(char* pp);
int  	xml_parse_start_tag(char* pp, char** tag_name, char** tag_attr, int* tag_end);
int  	xml_parse_end_tag(char* pp, char** tag_name);
int  	xml_parse_processing_tag(char* pp, char** tag_name, char** tag_attr);
int  	xml_parse_comment_tag(char* pp, char** comment);
int  	xml_parse_data_tag(char* pp, char** data);

void 	close_xml(tXML* pp);
int	 	isnot_xml_name(unsigned char* pp);

tXML*	init_xml_doc(void);
char*   get_first_tag_name(tXML* xml);

#define find_xml_top(p)		find_tList_top(p)
#define find_xml_end(p)		find_tTree_end(p)


// tp[X
Buffer	xml_inverse_parse(tXML* pp, int mode);
void	xml_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent);
void	xml_opentag_to_Buffer (tXML* pp, Buffer* buf, int mode, int indent);
void	xml_closetag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent);
void	xml_attr_to_Buffer(tList* pp, Buffer* buf);


// Operation
tXML* 	add_xml_tag(tXML* xml, const char* name);
tXML* 	insert_xml_tag(tXML* xml, const char* name);

tXML* 	add_xml_attr(tXML* xml, const char* attr);
tXML* 	add_xml_attr_str  (tXML* xml, const char* name, const char* value);
tXML* 	add_xml_attr_int  (tXML* xml, const char* name, int   value);
tXML* 	add_xml_attr_float(tXML* xml, const char* name, float value);

tXML* 	add_xml_content(tXML* xml, const char* value);
tXML* 	append_xml_content(tXML* xml, const char* value);
int		add_xml_content_area(tXML* xml, int len);

Buffer 	make_xml_attr_bystr  (const char* name, const char* value);
Buffer 	make_xml_attr_byint  (const char* name, int   value);
Buffer 	make_xml_attr_byfloat(const char* name, float value);

#define make_xml_attr_str(n, v) 	make_xml_attr_bystr  ((n), (v))
#define make_xml_attr_int(n, v) 	make_xml_attr_byint  ((n), (v))
#define make_xml_attr_float(n, v) 	make_xml_attr_byfloat((n), (v))

char*	xml_get_tag_content(tXML* tag);
char*	xml_get_tag_attr(tXML* tag, const char* attr);

tXML*	dup_merge_xml(tXML* pp, tXML* tp);

tXML* 	del_xml(tXML** pp);
void  	del_all_xml(tXML** pp);
tXML* 	del_sister_xml(tXML** pp);
tXML*	del_sisters_children_xml(tXML** pp);

#define free_xml(p)  del_xml((p))

void 	print_xml(FILE* fp, tXML* pp, int mode);
void 	print_xml_node(FILE* fp, tXML* pp);
void 	print_xml_tree(FILE* fp, tXML* pp, const char* space);
void 	print_sister_xml_tree(FILE* fp, tXML* pp, const char* space);



///////////////////////////////////////////////////////////////////////////////////////////
// Search and Get/Set	Ώۂ͂PԍŏɈv

tXML*	get_xml_tag(tXML* pp, tXML* pt);
int		set_xml_tag(tXML* pp, tXML* pt, const char* val);
int 	set_xml_end_tag(tXML* pp, tXML* pt);

tXML*	get_xml_content(tXML* pp, tXML* pt);
int 	set_xml_content(tXML* pp, tXML* pt, const char* val);
tList*	get_xml_attr(tXML* pp, tXML* pt);
int		set_xml_attr(tXML* pp, tXML* pt, tList* at);

tXML*	get_xml_tag_bystr(tXML* pp, const char* str);
int		set_xml_tag_bystr(tXML* pp, const char* str, const char* val);
int 	set_xml_end_tag_bystr(tXML* pp, const char* str);

tXML*	get_xml_content_bystr(tXML* pp, const char* str);
int 	set_xml_content_bystr(tXML* pp, const char* str, const char* val);
tList*	get_xml_attr_bystr(tXML* pp, const char* str);
int		set_xml_attr_bystr(tXML* pp, const char* pt, tList* at);

int		get_xml_int_content(tXML* pp, tXML* pt);
int		get_xml_int_content_bystr(tXML* pp, const char* str);
float	get_xml_float_content(tXML* pp, tXML* pt);
float	get_xml_float_content_bystr(tXML* pp, const char* str);
double	get_xml_double_content(tXML* pp, tXML* pt);
double	get_xml_double_content_bystr(tXML* pp, const char* str);
char*	get_xml_char_content(tXML* pp, tXML* pt);								// free Ă͂Ȃ
char*	get_xml_char_content_bystr(tXML* pp, const char* str);					// free Ă͂Ȃ

char*   get_xml_char_attr(tXML* pp, tXML* pt, const char* attr);				// free Ă͂ȂD
char*   get_xml_char_attr_bystr(tXML* pp, const char* str, const char* attr);	// free Ă͂ȂD
int     get_xml_int_attr(tXML* pp, tXML* pt, const char* attr);	
int     get_xml_int_attr_bystr(tXML* pp, const char* str, const char* attr);
double  get_xml_double_attr(tXML* pp, tXML* pt, const char* attr);
double  get_xml_double_attr_bystr(tXML* pp, const char* str, const char* attr);

int		replace_xml_content(tXML*pp, tXML* pt, const char* src, const char* dst);
int		replace_xml_content_bystr(tXML*pp, const char* str, const char* src, const char* dst);

#define get_xml_tag_str(p, s) 				get_xml_tag_bystr((p), (s))
#define set_xml_tag_str(p, s, v) 			set_xml_tag_bystr((p), (s), (v))
#define set_xml_end_tag_str(p, s)  			set_xml_end_tag_bystr((p), (s))
#define get_xml_content_str(p, s) 	 		get_xml_content_bystr((p), (s))
#define set_xml_content_str(p, s, v) 		set_xml_content_bystr((p), (s), (v))
#define get_xml_attr_str(p, s) 		 		get_xml_attr_bystr((p), (s))
#define set_xml_attr_str(p, t, a) 	 		set_xml_attr_bystr((p), (t), (a))
#define replace_xml_content_str(p, t, r, d) replace_xml_content_bystr((p), (t), (r), (d))


#define get_xml_int_content_str(p, s) 		get_xml_int_content_bystr((p), (s))
#define	get_xml_double_content_str(p, s) 	get_xml_double_content_bystr((p), (s));
#define get_xml_char_content_str(p, s)		get_xml_char_content_bystr((p), (s));
#define get_xml_char_attr_str(p, s, v)		get_xml_char_sttr_bystr((p), (s), (v));

#define get_xml_str_content(p, s)			get_xml_char_content((p), (s));
#define get_xml_str_content_str(p, s)		get_xml_char_content_bystr((p), (s));
#define get_xml_str_content_bystr(p, s)		get_xml_char_content_bystr((p), (s));
#define get_xml_str_attr(p, s)				get_xml_char_attr((p), (s));
#define get_xml_str_attr_str(p, s, v)		get_xml_char_attr_bystr((p), (s), (v));
#define get_xml_str_attr_bystr(p, s, v)		get_xml_char_attr_bystr((p), (s), (v));
#define get_xml_int_attr_str(p, s, v)		get_xml_int_attr_bystr((p), (s), (v));
#define get_xml_double_attr_str(p, s, v)	get_xml_double_attr_bystr((p), (s), (v));


// Operation for Multi Tags
tList*	get_xml_tag_list(tXML* pp, tXML* pt);
tList*	get_xml_content_list(tXML* pp, tXML* pt);
int		set_xml_content_list(tXML* pp, tXML* pt, const char* content);

tList*	get_xml_tag_list_bystr(tXML* pp, const char* str);
tList*	get_xml_content_list_bystr(tXML* pp, const char* str);
int		set_xml_content_list_bystr(tXML* pp, const char* str, const char* content);

#define	get_xml_tag_list_str(p, s) 			get_xml_tag_list_bystr((p), (s))
#define	get_xml_content_list_str(p, s) 		get_xml_content_list_bystr((p), (s))
#define	set_xml_content_list_str(p, s, c)	set_xml_content_list_bystr((p), (s), (c))



///////////////////////////////////////////////////////////////////////////////////////////
// Search XML Tag (tTreep̊֐Ƃقړ)

int  	find_match_xml(tXML* pp, tXML* pt);
tXML*  	find_match_xml_endlist(tXML* pp, tXML* pt);
tList*  find_match_xml_endlist_rcsv(tXML* pp, tXML* pt, tXML* te);
tXML*  	find_match_xml_end_tag(tXML* pp, tXML* pt);

int  	check_match_xml(tXML* tp, tXML* tr);
tXML*  	cmp_sisters_xml(tXML* tp, tXML* tr);




/////////////////////////////////////////////////////////////////////////////////////////////
//
// Simple Tag Functions.
//
int		get_tag_integer(tXML* tp, const char* name, int no);
Buffer  get_tag_content(tXML* tp, const char* name, int no);

int		return_exist_tag(tXML* tp, const char* name, int no, Buffer* value);

int		replace_all_tag_integer (tXML* tp, const char* name, int src, int dst);
int		replace_all_tag_contents(tXML* tp, const char* name, const char* src, const char* dst);
int 	replace_all_tag_contents_rcsv(tXML* tp, const char* name, const char* src, const char* dst);

int 	replace_all_tag_byid(tXML* tp, const char* src, const char* dst, int id);
int 	replace_all_tag_byid_rcsv(tXML* tp, const char* src, const char* dst, int id);




/**/

#endif
