
#ifndef  __JBXL_CPP_LOG_RING_BUFFER_H__
#define  __JBXL_CPP_LOG_RING_BUFFER_H__



/**
@brief    Logp Ring Buffer c[ wb_
@file     LogRingBuffer.h
@author   Fumi.Iseki (C)
*/



#include "xtools++.h"


//
namespace jbxl {




// kindData
#define  LOG_RB_UNKNOWN_DATA		0
#define  LOG_RB_TEXT_DATA			1
#define  LOG_RB_TEXT_HALF_DATA		2
#define  LOG_RB_BINARY_DATA			3
#define  LOG_RB_BINHEX_DATA			4


// inputSrc
#define  LOG_RB_MESG				0
#define  LOG_RB_MESSAGE				0
#define  LOG_RB_INFO				1
#define  LOG_RB_INFORMATION			1
#define  LOG_RB_DEBUG				2
#define  LOG_RB_WARN				3
#define  LOG_RB_WARNING				3
#define  LOG_RB_ERR					4
#define  LOG_RB_ERROR				4




class CLogRingBuffer
{
public:
	CLogRingBuffer(int size) { init(size);}
	virtual ~CLogRingBuffer(void);

public:
	int		init(int size);
	void	clear(void);
	void	putRingBuffer(Buffer buf, int input=LOG_RB_MESG, int kind=LOG_RB_UNKNOWN_DATA);
	void	rewriteBinHexRingBuffer(int n, int input);
	void	putRingFormat(int input, char* fmt, ...);
	void    putRingFormat(int input, char* fmt, va_list args);

	Buffer	getRingBuffer(void);		// obt@̐擪ǂݍށDf[^|C^ړD
	Buffer	getRingBuffer(int pos);		// obt@̈ʒuw肵ēǂݍށDf[^|C^̈ړD

	int		getMaxBufSize(void)		{ return maxBufSize;}
	int		getMaxLineX(void)		{ return maxLineX;}
	int		getMaxLineY(void)		{ return maxLineY;}
	int		getTotalSize(void)		{ return tlDataSize;}
	int		getLastPosition(void)	{ return wPos;}

	int		getLengthX(int n)		{ if(n<0) n+=maxBufSize; return (int)strlen((const char*)pBuf[n%maxBufSize].buf);}
	int		getKindData(int n)		{ if(n<0) n+=maxBufSize; return kindData[n%maxBufSize];}

public:
	Buffer* pBuf;


protected:
	int		maxBufSize;		// Buffer ̐DC̐D
	int		tlDataSize;

	int		maxLineX;		// ReLXgXTCY
	int		maxLineY;		// ReLXgYTCY
	int		indentSize;		// 

	int		rPos;
	int		wPos;

	int*	kindData;		//
	int*	inputSrc;		//
};






}		// namespace


#endif

