

#include "https_tool.h"


#ifdef ENABLE_SSL


/** 
@brief   HTTPS c[Cu
@file    https_tool.c
@author  Fumi.Iseki (C)
*/



/**
int  send_https_header(int sofd, SSL* ssl, tList* pp, int mode)

wb_Xg̓e HTTPSʐMőMD
wb_ Content-Length ̒l͑삵ȂD

@param  sofd    ڑւ̃\Pbg
@param  ssl     ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param  pp      Mwb_i[郊Xgւ̃|C^D
@param  mode    @b ON:  wb_XgɃRec̈ꕔ΂MD
@param  mode    @b OFF: wb_XgɃRec̈ꕔĂMȂD

@retval  0ȏ  mode==OFF: MSf[^oCgD
                mode==ON : MRec̃oCgD
@retval  0  G[
@retval -1      Xgւ̃|C^ NULL
*/
int  send_https_header(int sofd, SSL* ssl, tList* pp, int mode)
{
	int	   hs=0, sz=0;
	Buffer buf;

	if (pp==NULL) return -1;

	buf = restore_protocol_header(pp, (char*)": ", mode, &hs);
	if (buf.vldsz>0) {
		sz  = ssl_tcp_send_Buffer(sofd, ssl, &buf);
		if (mode==ON) sz = sz - hs;
	}

	free_Buffer(&buf);
	return sz;
}




/**
int  send_https_Buffer(int sofd, SSL* ssl, tList* pl, Buffer* buf)

wb_ƃobt@̓e HTTPʐMőMD

@param  sofd   ڑւ̃\Pbg
@param  ssl    ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param  pl     t@Cɐ旧đMwb_i[郊Xgւ̃|C^D
@param  buf    MReci[ꂽ Bufferϐւ̃|C^D

@retval  0ȏ Mf[^̑STCY(Byte)
@retval -1     Xgւ̃|C^ NULL
@retval -2     buf ̃G[
*/
int  send_https_Buffer(int sofd, SSL* ssl, tList* pl, Buffer* buf)
{
	int	sz;
	Buffer snd;
	tList* pp;

	if (pl==NULL) return -1;
	if (buf==NULL || buf->vldsz<0 || buf->buf==NULL) return -2;

	// Content-Length ̏
	pp = pl;
	while(pp!=NULL) {
		if (!strcasecmp((const char*)(pp->ldat.key.buf), "Content-Length")) {
			copy_i2Buffer(buf->vldsz, &(pp->ldat.val));
			break;
		}
		pp = pp->next;
	}

	snd = restore_protocol_header(pl, (char*)": ", OFF, NULL);
	cat_Buffer(buf, &snd);

	sz = ssl_tcp_send_Buffer(sofd, ssl, &snd);
	free_Buffer(&snd);

	return sz;
}




/**
int  send_https_file(int sofd, SSL* ssl, tList* pl, const char* fname)

wb_ƃt@C̓e HTTPSʐMőMD

@param  sofd   ڑւ̃\Pbg
@param  ssl    ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param  pl     t@Cɐ旧đMwb_i[郊Xgւ̃|C^D
@param  fname  Mt@CDwb_̂ݑꍇ NULL

@retval  0ȏ Mf[^̑STCY(Byte)
@retval -1     Xgւ̃|C^ NULL
@retval -2     mۃG[
*/
int  send_https_file(int sofd, SSL* ssl, tList* pl, const char* fname)
{
	int   sz = 0;
	FILE* fp = NULL;
	char num[20];
	tList* pp;
	unsigned char* html;
	Buffer  buf;


	if (pl==NULL) return -1;
	if (fname!=NULL) sz = file_size((char*)fname);
	if (sz<=0) sz = 0;
	snprintf(num, 18, "%d", sz);

	// Content-Length ̏
	pp = pl;
	while(pp!=NULL) {
		if (!strcasecmp((const char*)(pp->ldat.key.buf), "Content-Length")) {
			copy_s2Buffer(num, &(pp->ldat.val));
			break;
		}
		pp = pp->next;
	}

	buf = restore_protocol_header(pl, (char*)": ", OFF, NULL);


	if (fname!=NULL && sz!=0) fp = fopen(fname, "rb");
	if (fp!=NULL) {
		html = (unsigned char*)malloc(sz+1);
		if (html==NULL) {
			fclose(fp);
			free_Buffer(&buf);
			return -2;
		}

		memset(html, 0, sz+1);
		fread(html, sz, 1, fp); 
		fclose(fp);

		cat_b2Buffer(html, &buf, sz);
		free(html);
	}

	sz = ssl_tcp_send_Buffer(sofd, ssl, &buf);
	free_Buffer(&buf);

	return sz;
}




/**
int  recv_https_header(int sofd, SSL* ssl, tList** pl, int* len, FILE* fp, int* state)

HTTPSʐM̃wb_MāCXgɊi[D@n
NULLłȂ fp w肳ꂽꍇCMSẴf[^t@CɕۑD

@param       sofd   ڑւ̃\Pbg
@param       ssl    ڑւ SSL\PbgDSSLʐMłȂꍇ NULLwD
@param[out]  *pl    wb_񂪊i[郊Xgւ̃|C^DNULLȂi[ȂD
@param[out]  len    wb_ "Content-Length" ̒li̒lj. 
                    "Content-Length" ݂Ȃ @b HTTP_HEADER_UNKNOWN_LEN (0)D
                    `N`Ȃ @b HTTP_HEADER_CHUNKED (0)D
                    1̃ZbVŃ{fB]̂ȂC@b HTTP_HEADER_CLOSED_SESSION (0)D
@param       fp     MSẴf[^ۑ邽߂̃t@C|C^DNULL̏ꍇ͕ۑȂD
@param[out]  state  T[oƂ̐ڑԁDڑȂ TRUEDؒfꍇ FALSEDNULLw肵ĂǂD

@retval  0ȏ      MSoCg
@retval  0          ؒf
@retval -1          MG[
@retval -2           sofdw肵
@retval -3          len NULL w肵
*/
int  recv_https_header(int sofd, SSL* ssl, tList** pl, int* len, FILE* fp, int* state)
{
	int  cc, sz;
	Buffer mbuf;
	tList* lp;
	int  connect = TRUE;

	if (sofd<=0)   return -2;
	if (len==NULL) return -3;
	*len = HTTP_HEADER_UNKNOWN_LEN;

	mbuf = make_Buffer(RECVBUFSZ);

	sz  = 0;
	lp  = NULL;
	*pl = NULL;
	do {
		cc = ssl_tcp_recv_Buffer(sofd, ssl, &mbuf);
		if (cc>0) {
			if (fp!=NULL) fwrite(mbuf.buf, cc, 1, fp);
			lp = get_protocol_header_list_seq(lp, mbuf, ':', TRUE, TRUE);
			sz += cc;

			if (sz==cc) { 		// is HTTPS?
				tList* ll = find_tList_top(lp);
				if (get_http_header_method(ll)==HTTP_UNKNOWN_METHOD) {
					connect = HTTP_HEADER_NOT_HTTP;
					*pl = ll;
					break;
				}
			}
		}
		else {
			connect = FALSE;
			break;
		}

		*pl = find_tList_top(lp);
	} while(strncasecmp_tList(*pl, (char*)HDLIST_END_KEY, 0, 1)==NULL);


	/******************************************************/
	//if (pl!=NULL && *pl!=NULL) {
	//	print_message("=== HTTPS Header Dump ===\n");
	//	print_tList(stderr, *pl);
	//}
	/******************************************************/

	if (connect==HTTP_HEADER_NOT_HTTP) {
		if (mbuf.vldsz>0) {
			Buffer key = make_Buffer_bystr(HDLIST_CONTENTS_KEY);
			add_tList_node_Buffer(*pl, key, mbuf);
			free_Buffer(&key);
			delete_protocol_header(pl, (char*)HDLIST_FIRST_LINE_KEY, 1);
		}
		*len = HTTP_HEADER_NOT_HTTP;
		connect = FALSE;
	}
	free_Buffer(&mbuf);

	if (state!=NULL) *state = connect;
	if (sz==0 && cc==0) return 0;	   // ؒf
	if (sz==0 && cc<0)  return -1;
	if (*pl==NULL) 		return -1;
	if (*len==HTTP_HEADER_NOT_HTTP) return cc;


	// Rec̒𓾂D
	if (len!=NULL) {
		Buffer hbuf = search_protocol_header(*pl, (char*)HDLIST_FIRST_LINE_KEY, 1);
		if (hbuf.buf!=NULL) {
			if (!strncasecmp((char*)hbuf.buf, "GET ", 4)) {
				*len = 0;
			}
			free_Buffer(&hbuf);
		}

		if (*len==HTTP_HEADER_UNKNOWN_LEN) {
			if (is_http_header_field(*pl, (char*)"Transfer-Encoding", (char*)"chunked", 1)) {
				*len = HTTP_HEADER_CHUNKED;
			}
		}

		if (*len==HTTP_HEADER_UNKNOWN_LEN) {
			hbuf = search_protocol_header(*pl, (char*)"Content-Length", 1);
			if (hbuf.buf!=NULL) {
				*len = atoi((const char*)hbuf.buf);
				free_Buffer(&hbuf);
			}
		}

		if (*len==HTTP_HEADER_UNKNOWN_LEN) {
			if (get_http_version_num(*pl)<=1.0 && get_http_status_num(*pl)>=200) {
				if (is_http_header_field(*pl, (char*)"Connection", (char*)"close", 1)) {
					*len = HTTP_HEADER_CLOSED_SESSION;
				}
			}
		}

	}

	return sz;
}




/**
int  recv_https_content(int sofd, SSL* ssl, Buffer* buf, int len, int tm, FILE* fp, int* state)

HTTPSbZ[W recv_https_header() ŎMwb_ɈāCRecMD

fp NULLłȂ΁CMf[^iRecj̓t@CɂۑD

@param          sofd   ڑւ̃\Pbg
@param          ssl    ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param[in,out]  buf    SRecۑϐDŏɁCrecv_https_header()ŎMRecĒuD
@param          len    Mwb_ "Content-Length" ̒lDMf[^̃TCỸ`FbNɎgpD
@param          tm     ^CAEgbD
@param          fp     MRecۑt@CfBXNv^DNULLȂۑȂD
@param[out]     state  T[oƂ̐ڑԁDڑȂ TRUEDؒfꍇ FALSEDNULLw肵ĂǂD

@retval 0ȏ          SRec̃TCY(Byte)Drecv_https_header()ŎMRec܂ށD
@retval 0          G[
*/
int  recv_https_content(int sofd, SSL* ssl, Buffer* buf, int len, int tm, FILE* fp, int* state)
{
	int	cc, sz;
	Buffer rcv;

	if (state!=NULL) *state = TRUE;
	sz = buf->vldsz;
    if (sz>0 && fp!=NULL) fwrite(buf->buf, sz, 1, fp);


	// Rec̎cM
	rcv = make_Buffer(RECVBUFSZ);
	while(sz<len) {
		//
		cc = ssl_tcp_recv_Buffer_wait(sofd, ssl, &rcv, tm);
		if (cc>0) {
			if (fp!=NULL) fwrite(rcv.buf, cc, 1, fp);
			cat_Buffer(&rcv, buf);
			sz += cc;
		}
		else {
			if (state!=NULL) *state = FALSE;
			sz = cc;
			break;
		}
		memset(rcv.buf, 0, cc);
	}

	free_Buffer(&rcv);
	return sz;
}




/**
int  recv_https_chunked(int sofd, SSL* ssl, Buffer* buf, int tm, FILE* fp, int* state)

HTTPbZ[W recv_https_header() ŎMwb_ɈāCChunk[h̃Recf[^MD

fp NULLłȂ΁CMf[^iRecj̓t@CɂۑD

@param          sofd   ڑւ̃\Pbg
@param          ssl    ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param[in,out]  buf    SRecۑϐDŏɁCrecv_https_header()ŎMRecĒuD
@param          tm     ^CAEgbD
@param          fp     MRecۑt@CfBXNv^DNULLȂۑȂD
@param[out]     state  T[oƂ̐ڑԁDڑȂ TRUEDؒfꍇ FALSEDNULLw肵ĂǂD

@retval 0ȏ          SRec̃TCY(Byte)Drecv_https_header()ŎMRec܂ށD
@retval 0          G[
*/
int  recv_https_chunked(int sofd, SSL* ssl, Buffer* buf, int tm, FILE* fp, int* state)
{
	int	cc, sz, i;
	int chnksz, len;
	if (state!=NULL) *state = TRUE;

	Buffer tmp = make_Buffer(RECVBUFSZ);

	sz = buf->vldsz;
	if (sz<=0) {	// chunk ̃TCY܂񂾃f[^ǂݍ
		cc = ssl_tcp_recv_Buffer_wait(sofd, ssl, &tmp, tm);
		if (cc<=0) {
			if (state!=NULL) *state = FALSE;
			free_Buffer(&tmp);
			return cc;
		}
	}
	else {          // ɃRecꍇ tmpֈړ 
		cat_Buffer(buf, &tmp);
		clear_Buffer(buf);
	}


	//
	chnksz = sz = get_chunked_size((char*)tmp.buf, &len);

	//print_message("+++++++++ CHNKSZ = %d\n", chnksz);

	while (chnksz>0) {
		//
		if (chnksz+len>tmp.vldsz) {
			cc = recv_https_chunked_remain(sofd, ssl, &tmp, chnksz+len, tm);
			if (cc<=0) {
				sz = cc;
				break;
			}
		}
	
		Buffer cat = tmp;
		cat.buf = tmp.buf + len;
		cat.vldsz = chnksz;
		cat_Buffer(&cat, buf);
		tmp.buf[tmp.vldsz] = '\0';

		//  chunkpɃf[^߂
		for (i=0; i<tmp.vldsz-chnksz-len; i++) {
			tmp.buf[i] = tmp.buf[chnksz+len+i];
		}
		tmp.vldsz = tmp.vldsz - chnksz - len;
		tmp.buf[tmp.vldsz] = '\0';

		if (tmp.vldsz==0) {
			cc = ssl_tcp_recv_Buffer_wait(sofd, ssl, &tmp, tm);
			if (cc<=0) {
				sz = cc;
				break;
			}
		}
		chnksz = get_chunked_size((char*)tmp.buf, &len);
		sz += chnksz;
	}

	if (fp!=NULL) fwrite(buf->buf, buf->vldsz, 1, fp);


	free_Buffer(&tmp);
	return sz;
}




/**
int  recv_https_chunked_remain(int sofd, SSL* ssl, Buffer* buf, int chnksz, int tm)

chunk ̎c̃f[^ǂݍށD chunk̃f[^ǂݍ܂\D

@param          sofd    ڑւ̃\Pbg
@param          ssl     ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param[in,out]  buf     c̃RecۑϐDŏɁCrecv_http_header()ŎMRecĒuD
@param          chnksz  ŒǂݍނׂTCYDchunk̃TCY
@param          tm      ^CAEgbD

@retval 1ȏ           ǂݍ񂾃Rec̃TCY(Byte)Drecv_http_header()ŎMRec܂ށD
@retval 0ȉ           G[
*/
int  recv_https_chunked_remain(int sofd, SSL* ssl, Buffer* buf, int chnksz, int tm)
{
	int cc = 0;
	int sz = buf->vldsz;
	if (chnksz<=sz) return 0;

	Buffer rcv = make_Buffer(RECVBUFSZ);

	while (chnksz>sz) {
		memset(rcv.buf, 0, cc);
		cc = ssl_tcp_recv_Buffer_wait(sofd, ssl, &rcv, tm);
		if (cc<=0) {
			sz = cc;
			break;
		}
		cat_Buffer(&rcv, buf);
		sz += cc;
	}

	free_Buffer(&rcv);
	return sz;
}





/**
int  recv_https_closed(int sofd, SSL* ssl, Buffer* buf, int tm, FILE* fp)

HTTPbZ[W recv_https_header() ŎMwb_ɈāCChunk[h̃Recf[^MD

fp NULLłȂ΁CMf[^iRecj̓t@CɂۑD

@param          sofd   ڑւ̃\Pbg
@param          ssl    ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param[in,out]  buf    SRecۑϐDŏɁCrecv_https_header()ŎMRecĒuD
@param          tm     ^CAEgbD
@param          fp     MRecۑt@CfBXNv^DNULLȂۑȂD

@retval 0ȏ          SRec̃TCY(Byte)Drecv_https_header()ŎMRec܂ށD
@retval 0          G[
*/
int  recv_https_closed(int sofd, SSL* ssl, Buffer* buf, int tm, FILE* fp)
{
	int	cc, sz, tout;
	Buffer rcv;


	sz = buf->vldsz;

	rcv = make_Buffer(RECVBUFSZ);
	while ((tout=recv_wait(sofd, tm))) {
		cc = ssl_tcp_recv_Buffer(sofd, ssl, &rcv);
		if (cc>0) {
			if (fp!=NULL) fwrite(rcv.buf, cc, 1, fp);
			cat_Buffer(&rcv, buf);
			sz += cc;
		}
		else {
			break;
		}
		memset(rcv.buf, 0, cc);
	}
	free_Buffer(&rcv);

	if (!tout) return RECV_TIMEOUTED;

	return sz;
}




/**
int  recv_https_Buffer(int sofd, SSL* ssl, tList** pl, Buffer* buf, int tsecond, int* hdonly, int* state)

HTTPSbZ[WMāCBufferϐ *bufɕۑDgzip̃GR[h͍sȂD

buf̃obt@̈͗\ߊmۂĂ邱ƁD

@param       sofd      ڑւ̃\Pbg
@param       ssl       ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param[out]  *pl       Mwb_i[郊Xgւ̃|C^DKvȂȂ NULLłǂD
@param[out]  buf       Reci[ Bufferϐւ̃|C^Dobt@͗\ߊmۂĒuD 
@param       tsecond   ŏ̎M܂ł̃^CAEg(s)
@param[out]  hdonly    f[^wb_݂̂̏ꍇ TRUE, Recꍇ FALSEDNULLw肵ĂǂD
@param[out]  state     T[oƂ̐ڑԁDڑȂ TRUEDؒfꍇ FALSEDNULLw肵ĂǂD

@retval  0ȏ         MRec̃TCY(Byte)
@retval -1             MG[
@retval -2             buf G[
@retval RECV_TIMEOUTED ^CAEgD
*/
int  recv_https_Buffer(int sofd, SSL* ssl, tList** pl, Buffer* buf, int tsecond, int* hdonly, int* state)
{
	int	   cc=0, hs, len;
	Buffer cnt;
	int	   connect;
	tList* lp;

	
	if (buf==NULL || buf->buf==NULL) return -2;
	if (hdonly!=NULL) *hdonly = FALSE;

	// wb_̎M
	hs = recv_https_header(sofd, ssl, &lp, &len, NULL, &connect);
	if (state!=NULL) *state = connect;
	if (hs<=0)  return hs;											// G[
	if (len==0 || len==HTTP_HEADER_UNKNOWN_LEN) {					// wb_̂
		if (hdonly!=NULL) *hdonly = TRUE;
		return hs;
	}


	// wb_ɕꍞ񂾃Rec̎o
	cnt = search_protocol_header(lp, (char*)HDLIST_CONTENTS_KEY, 1);
	if (cnt.buf!=NULL) {
		cc = cnt.vldsz;
		hs = hs - cc;
		copy_Buffer(&cnt, buf);
		free_Buffer(&cnt);
	}


	// Rec̎M
	if (connect) {
		if (len>0) {
			cc = recv_https_content(sofd, ssl, buf, len, tsecond, NULL, &connect);
		}
		else if (len==HTTP_HEADER_CHUNKED) {
			cc = recv_https_chunked(sofd, ssl, buf, tsecond, NULL, &connect);
		}
		else {	//if (len==HTTP_HEADER_CLOSED_SESSION) {
			cc = recv_https_closed(sofd, ssl, buf, tsecond, NULL);
			connect = FALSE;
		}
	}


	// for Chunked
	if (is_http_header_field(lp, (char*)"Transfer-Encoding", (char*)"chunked", 1)) {
		delete_protocol_header(&lp, (char*)"Transfer-Encoding", 0);	
		add_protocol_header(lp, (char*)"Content-Length", itostr(cc));	
	}


	if (pl!=NULL) *pl = lp;
	else del_tList(&lp);

	if (cc>0) cc = cc + hs;

	if (state!=NULL) *state = connect;
	return cc;
}




/**
int  recv_https_file(int sofd, SSL* ssl, tList** pl, const char* fname, const char* wdir, int tsecond, int* hdonly, int* state)

HTTPSbZ[WMāCRect@CɕۑDEncoding gzip̏ꍇ͓WJD

@param       sofd      ڑւ̃\Pbg
@param       ssl       ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param[out]  *pl       Mwb_i[郊Xgւ̃|C^D
@param       fname     ۑt@C
@param       wdir      ƗpfBNgwDNULL̏ꍇ /tmp ɂȂD
@param       tsecond   ŏ̎M܂ł̃^CAEg(s)
@param[out]  hdonly    f[^wb_݂̂̏ꍇ TRUE, Recꍇ FALSEDNULLw肵ĂǂD
@param[out]  state     T[oƂ̐ڑԁDڑȂ TRUEDؒfꍇ FALSEDNULLw肵ĂǂD

@retval  1ȏ         Mt@C̃TCY(Byte)iwb_܂ށj
@retval  0             ؒf
@retval -1             MG[
@retval RECV_TIMEOUTED ^CAEgD
*/
int  recv_https_file(int sofd, SSL* ssl, tList** pl, const char* fname, const char* wdir, int tsecond, int* hdonly, int* state)
{
	int	   cc=0, hs, len;
	Buffer buf, cnt;
	FILE*  fp = NULL;
	const char tmpd[] = "/tmp";
	int   connect;
	

	if (hdonly!=NULL) *hdonly = FALSE;

	// wb_̎M
	hs = recv_https_header(sofd, ssl, pl, &len, NULL, &connect);
	if (state!=NULL) *state = connect;
	if (hs<=0) return hs;											// G[
	if (len==0 || len==HTTP_HEADER_UNKNOWN_LEN) { 					// wb_̂
		if (hdonly!=NULL) *hdonly = TRUE;
		return hs;
	}

	//print_message("++ RECV HEADER ++++++++++\n");
	//print_tList(stderr, *pl);
	//print_message("+++++++++++++++++++++++++\n");


	// wb_ɕꍞ񂾃Rec̎o
	buf = make_Buffer(RECVBUFSZ);
	cnt = search_protocol_header(*pl, (char*)HDLIST_CONTENTS_KEY, 1);
	if (cnt.buf!=NULL) {
		/*DEBUG_MODE {
			if (len==HTTP_HEADER_CHUNKED) {
				char* line = get_line((char*)cnt.buf, 1);
				int chnksz = hexstr2i(line);
				print_message("RECV_HTTPS_FILE: INFO: Chunk Size in Header = %d\n", chnksz);
				freeNull(line);
			}
		}*/
		cc = cnt.vldsz;
		hs = hs - cc;
		copy_Buffer(&cnt, &buf);
		free_Buffer(&cnt);
	}


	// Rec̎M
	if (connect) {
		if (len>0) {
			cc = recv_https_content(sofd, ssl, &buf, len, tsecond, NULL, &connect);
		}
		else if (len==HTTP_HEADER_CHUNKED) {
			cc = recv_https_chunked(sofd, ssl, &buf, tsecond, NULL, &connect);
			//print_message("+++++++++ RECVSZ = %d\n", buf.vldsz);
		}
		else { //if (len==HTTP_HEADER_CLOSED_SESSION) {
			cc = recv_https_closed(sofd, ssl, &buf, tsecond, NULL);
			connect = FALSE;
		}
	}


	if (cc>0) {
		// Rect@C֕ۑ
		if (fname!=NULL) fp = fopen(fname, "wb");
		if (fp!=NULL) {
			fwrite(buf.buf, buf.vldsz, 1, fp);
			fclose(fp);
		}
		free_Buffer(&buf);


		//
		if (fname!=NULL) {
			buf = search_protocol_header(*pl, (char*)"Content-Encoding", 1);

			// Encoding 
			if (buf.buf!=NULL) {
				// gzip or deflate
				if (!strncasecmp((const char*)buf.buf, "gzip", 	  4) ||
					!strncasecmp((const char*)buf.buf, "deflate", 7)) {
					#ifdef DISABLE_ZLIB
						DEBUG_MODE print_message("RECV_HTTPS_FILE: WARNING: Content-Encoding is [%s]. But zlib is not installed!!\n", buf.buf);
					#else
						if (wdir==NULL) wdir = tmpd;
						cc = gz_decode_file_replace(fname, wdir);
						delete_protocol_header(pl, (char*)"Content-Encoding",  0);

						// for chunked
						if (is_http_header_field(*pl, (char*)"Transfer-Encoding", (char*)"chunked", 1)) {
							delete_protocol_header(pl, (char*)"Transfer-Encoding", 0);	
							add_protocol_header(*pl, (char*)"Content-Length", itostr(cc));	
						}
					#endif
				}

				else { 
					DEBUG_MODE print_message("RECV_HTTPS_FILE: WARNING: unknown Content-Encoding [%s]\n", buf.buf);
				}
				free_Buffer(&buf);
			}
			
			// No Encofing
			else {
				// for chunked
				if (is_http_header_field(*pl, (char*)"Transfer-Encoding", (char*)"chunked", 1)) {
					delete_protocol_header(pl, (char*)"Transfer-Encoding", 0);	
					add_protocol_header(*pl, (char*)"Content-Length", itostr(cc));	
				}
			}
		}
		cc = cc + hs;
	}


	if (state!=NULL) *state = connect;
	return cc;
}




/**
int   save_https_xml(int cofd, SSL* ssl, tList** pl, tXML** xml, char** recvfn, const char* wdir, int timeout, int* state)

M XMLʐMf[^t@Cɕۑ

@param       cofd      ڑւ̃\Pbg
@param       ssl       ڑւ SSL\PbgDSSLʐMłȂꍇ NULL wD
@param[out]  *pl       Mwb_i[郊Xgւ̃|C^D
@param[out]  *xml      p[Xꂽf[^i[XML\̂ւ̃|C^ 
@param[out]  *recvfn   ۑt@C
@param       wdir      ƗpfBNgw肷DNULL̏ꍇ /tmp ɂȂD
@param       timeout   ŏ̎M܂ł̃^CAEg(s)
@param[out]  state     T[oƂ̐ڑԁDڑȂ TRUEDؒfꍇ FALSEDNULLw肵ĂǂD

@retval  1ȏ         Mt@C̃TCY(Byte)iwb_܂ށj
@retval  0             ؒf
@retval -1             MG[
@retval RECV_TIMEOUTED ^CAEgD
*/
int   save_https_xml(int cofd, SSL* ssl, tList** pl, tXML** xml, char** recvfn, const char* wdir, int timeout, int* state)
{
	int header;

	if (pl==NULL || recvfn==NULL) return 0;

	*pl = NULL;
	if (xml!=NULL) *xml = NULL;
	*recvfn = temp_filename(wdir, WORK_FILENAME_LEN);
   
	int cc = recv_https_file(cofd, ssl, pl, *recvfn, wdir, timeout, &header, state);
	if (cc<=0 || *pl==NULL) {
		free(*recvfn);
		*recvfn = NULL;
		if (cc==0) return 0;
		return -1;
	}


	if (header) {
		free(*recvfn);
		*recvfn = NULL;
	}
	else {

		if (xml!=NULL && *pl!=NULL && *recvfn!=NULL && cc>0) {
			Buffer buf = search_protocol_header(*pl, (char*)"Content-Type", 1);
			//application/llsd+xml; charset=UTF-8
			//if (buf.buf!=NULL && strstrcase((const char*)buf.buf, "xml")!=NULL) {
				*xml = xml_parse_file(*recvfn);
				//if (*xml!=NULL && (*xml)->state!=XML_PARSED) del_xml(xml);
				if (*xml!=NULL && (*xml)->state<0) del_xml(xml);
			//}
			free_Buffer(&buf);
		}
	}

	return  cc;
}



#endif
