
#ifndef  __JBXL_CPP_WINDOW_H_
#define  __JBXL_CPP_WINDOW_H_



/**
@brief    OtBbNp[hWnT|[gwb_
@file     Window.h
@version  2.1
@author   Fumi.Iseki (C)
*/



#include "Graph.h"



//
namespace jbxl {



/*
template <typename T> void  wSetPixel(MSGraph<T> vp, double x, double y, int cc)
template <typename T> T     wGetPixel(MSGraph<T> vp, double x, double y)
template <typename T> void  wLine(MSGraph<T> vp, double x1, double y1, double x2, double y2, int cc)

template <typename T> void  wDraw(MSGraph<T>* vp, double x, double y, int cc)
template <typename T> void  wDraw_rel(MSGraph<T>* vp, double x, double y, int cc)


template <typename T> void  wSetPixel3D(MSGraph<T> vp, double x, double y, double z, int cc)
template <typename T> T		wGetPixel3D(MSGraph<T> vp, double x, double y, double z)
template <typename T> void  wLine3D(MSGraph<T> vp, double x1, double y1, double z1, double x2, double y2, double z2, int cc)

template <typename T> void  wDraw3D(MSGraph<T>* vp, double x, double y, double z, int cc)
template <typename T> void  wDraw_rel3D(MSGraph<T>* vp, double x, double y, double z, int cc)
*/




/**
template <typename T> void  wSetPixel(MSGraph<T> vp, double x, double y, int cc)

[hWnɓ_łD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   _ xW([hWn)D
@param  y   _ yW([hWn)D
@param  cc  _̋PxlD
*/
template <typename T> void  wSetPixel(MSGraph<T> vp, double x, double y, int cc)
{
    int i = (int)((x - vp.wZeroX)*vp.wRateX);
	int j = (int)((vp.wZeroY - y)*vp.wRateY);

	if (i>=0 && i<vp.xs && j>=0 && j<vp.ys) vp.point(i, j) = (T)cc;
}




/**
template <typename T> void  wSetPixel3D(MSGraph<T> vp, double x, double y, double z, int cc)

3̃[hWnɓ_łD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   _ xW([hWn)D
@param  y   _ yW([hWn)D
@param  z   _ zW([hWn)D
@param  cc  _̋PxlD
*/
template <typename T> void  wSetPixel3D(MSGraph<T> vp, double x, double y, double z, int cc)
{
    int i = (int)((vp.wZeroX - x)*vp.wRateX);
	int j = (int)((y - vp.wZeroY)*vp.wRateY);
	int k = (int)((vp.wZeroZ - z)*vp.wRateZ);

	if (i>=0 && i<vp.xs && j>=0 && j<vp.ys && k>=0 && k<vp.zs) vp.point(i, j, k) = (T)cc;
}




/**
template <typename T> T wGetPixel(MSGraph<T> vp, double x, double y)

[hWn̓_̃f[^𓾂D

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   _ xW([hWn)D
@param  y   _ yW([hWn)D
*/
template <typename T> T wGetPixel(MSGraph<T> vp, double x, double y)
{
    int i = (int)((x - vp.wZeroX)*vp.wRateX);
    int j = (int)((vp.wZeroY - y)*vp.wRateY);

 	if (i>=0 && i<vp.xs && j>=0 && j<vp.ys) return vp.point(i, j);
	else  return vp.zero;
}




/**
template <typename T> T		wGetPixel3D(MSGraph<T> vp, double x, double y, double z)

3̃[hWn̓_̃f[^𓾂D

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   _ xW([hWn)D
@param  y   _ yW([hWn)D
@param  z   _ zW([hWn)D
*/
template <typename T> T		wGetPixel3D(MSGraph<T> vp, double x, double y, double z)
{
    int i = (int)((vp.wZeroX - x)*vp.wRateX);
    int j = (int)((y - vp.wZeroY)*vp.wRateY);
	int k = (int)((vp.wZeroZ - z)*vp.wRateZ);

	if (i>=0 && i<vp.xs && j>=0 && j<vp.ys && k>=0 && k<vp.zs) return vp.point(i, j, k);
	else  return vp.zero;
}




/**
template <typename T> void  wLine(MSGraph<T> vp, double x1, double y1, double x2, double y2, int cc)

[hWnɐD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x1  ̎n_ xW([hWn)D
@param  y1  ̎n_ yW([hWn)D
@param  x2  ̏I_ xW([hWn)D
@param  y2  ̏I_ yW([hWn)D
@param  cc  ̋PxlD
*/
template <typename T> void  wLine(MSGraph<T> vp, double x1, double y1, double x2, double y2, int cc)
{
    int  i1, j1, i2, j2;

    i1 = (int)((x1 - vp.wZeroX)*vp.wRateX);
    i2 = (int)((x2 - vp.wZeroX)*vp.wRateX);
    j1 = (int)((vp.wZeroY - y1)*vp.wRateY);
    j2 = (int)((vp.wZeroY - y2)*vp.wRateY);

    MSGraph_Line<T>(vp, i1, j1, i2, j2, cc);
}




/**
template <typename T> void  wLine3D(MSGraph<T> vp, double x1, double y1, double z1, double x2, double y2, double z2, int cc)

3̃[hWnɐD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x1  ̎n_ xW([hWn)D
@param  y1  ̎n_ yW([hWn)D
@param  z1  ̎n_ zW([hWn)D
@param  x2  ̏I_ xW([hWn)D
@param  y2  ̏I_ yW([hWn)D
@param  z2  ̏I_ zW([hWn)D
@param  cc  ̋PxlD
*/
template <typename T> void  wLine3D(MSGraph<T> vp, double x1, double y1, double z1, double x2, double y2, double z2, int cc)
{
    int  i1, j1, k1, i2, j2, k2;

    i1 = (int)((vp.wZeroX - x1)*vp.wRateX);
    i2 = (int)((vp.wZeroX - x2)*vp.wRateX);
	j1 = (int)((y1 - vp.wZeroY)*vp.wRateY);
    j2 = (int)((y2 - vp.wZeroY)*vp.wRateY);
	k1 = (int)((vp.wZeroZ - z1)*vp.wRateZ);
	k2 = (int)((vp.wZeroZ - z2)*vp.wRateZ);

    MSGraph_Line3D<T>(vp, i1, j1, k1, i2, j2, k2, cc);
}







template <typename T> void  wCircle3D(MSGraph<T> vp, Vector<double> ox, Vector<double> ex, double rr, int cc, int mode)
{
	double rate = Max(vp.wRateX, vp.wRateY);
	rate = Max(rate, vp.wRateZ);
	int r = (int)(rr*rate);

	ox.x = (vp.wZeroX - ox.x)*vp.wRateX;
	ox.y = (ox.y - vp.wZeroY)*vp.wRateY;
	ox.z = (vp.wZeroZ - ox.z)*vp.wRateZ;

	ex.x = -ex.x*vp.wRateX;
	ex.y =  ex.y*vp.wRateY;
	ex.z = -ex.z*vp.wRateZ;

	MSGraph_Circle3D(vp, ox, ex, r, cc, mode);
}







/**
template <typename T> void  wDraw(MSGraph<T>* vp, double x, double y, int cc)

[hWnŌn_w肵n_֐Dw肵n_n_ƂȂD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   ̏I_ xW([hWn)D
@param  y   ̏I_ yW([hWn)D
@param  cc  ̋PxlD
*/
template <typename T> void  wDraw(MSGraph<T>* vp, double x, double y, int cc)
{
    wLine<T>(*vp, vp->wNowX, vp->wNowY, x, y, cc);
	vp->wMove(x, y);
}




/**
template <typename T> void  wDraw3D(MSGraph<T>* vp, double x, double y, double z, int cc)

3̃[hWnŌn_w肵n_֐Dw肵n_n_ƂȂD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   ̏I_ xW([hWn)D
@param  y   ̏I_ yW([hWn)D
@param  z   ̏I_ zW([hWn)D
@param  cc  ̋PxlD
*/
template <typename T> void  wDraw3D(MSGraph<T>* vp, double x, double y, double z, int cc)
{
	wLine3D<T>(*vp, vp->wNowX, vp->wNowY, vp->wNowZ, x, y, z, cc);
	vp->wMove(x, y, z);
}




/**
template <typename T> void  wDraw_rel(MSGraph<T>* vp, double x, double y, int cc)

[hWnŌn_N_ƂđΓIɐD̏I_n_ƂȂD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   n_ xւ̈ړ([hWn)D
@param  y   n_ yւ̈ړ([hWn)D
@param  cc  ̋PxlD
*/
template <typename T> void  wDraw_rel(MSGraph<T>* vp, double x, double y, int cc)
{
    double x2 = vp->wNowX + x;
    double y2 = vp->wNowY + y;

    wLine<T>(*vp, vp->wNowX, vp->wNowY, x2, y2, cc);
	vp->wMove(x2, y2);
}




/**
template <typename T> void  wDraw_rel3D(MSGraph<T>* vp, double x, double y, double z, int cc)

3̃[hWnŌn_N_ƂđΓIɐD̏I_n_ƂȂD

@param  vp  Ώۂ̃OtBbNf[^D
@param  x   n_ xւ̈ړ([hWn)D
@param  y   n_ yւ̈ړ([hWn)D
@param  z   n_ zւ̈ړ([hWn)D
@param  cc  ̋PxlD
*/
template <typename T> void  wDraw_rel3D(MSGraph<T>* vp, double x, double y, double z, int cc)
{
    double x2 = vp->wNowX + x;
    double y2 = vp->wNowY + y;
    double z2 = vp->wNowZ + z;

	wLine3D<T>(*vp, vp->wNowX, vp->wNowY, vp->wNowZ, x2, y2, z2, cc);
	vp->wMove(x2, y2, z2);
}



}		// namespace


#endif
