
#include "MaterialParam.h"



using namespace jbxl;





///////////////////////////////////////////////////////////////////////////////////////////////////
//
// MaterialParam NX
//

void  MaterialParam::init(void)
{
	enable	 = false;

	texture  = init_Buffer();
	bumpmap  = init_Buffer();
	for (int i=0; i<4; i++) color[i] = 1.0;
    glow	 = 0.0;
	specular = 0.0;
	bright	 = 0.0;

	mflags   = 0;
	mapping  = 0;

	shiftU 	 = 0.0;
	shiftV 	 = 0.0;
	scaleU 	 = 1.0;
	scaleV 	 = 1.0;
	rotate 	 = 0.0;

	flipU	 = false;
	flipV	 = false;

	return;
}


void  MaterialParam::execShift(UVMap<double>* uv, int num)
{
	for (int i=0; i<num; i++) {
		uv[i].u += shiftU;
		uv[i].v += shiftV;
	}
}


void  MaterialParam::execInvShift(UVMap<double>* uv, int num)
{
	for (int i=0; i<num; i++) {
		uv[i].u -= shiftU;
		uv[i].v -= shiftV;
	}
}


void  MaterialParam::execScale(UVMap<double>* uv, int num)
{
	double uu, vv;

	for (int i=0; i<num; i++) {
		uu = (uv[i].u - 0.5)*scaleU;
		vv = (uv[i].v - 0.5)*scaleV;
		uv[i].u = uu + 0.5;
		uv[i].v = vv + 0.5;
	}
}


void  MaterialParam::execInvScale(UVMap<double>* uv, int num)
{
	double uu, vv;

	for (int i=0; i<num; i++) {
		uu = (uv[i].u - 0.5)/scaleU;
		vv = (uv[i].v - 0.5)/scaleV;
		uv[i].u = uu + 0.5;
		uv[i].v = vv + 0.5;
	}
}


void  MaterialParam::execRotate(UVMap<double>* uv, int num)
{
	double uu, vv;
	double cs = cos(rotate);
	double sn = sin(rotate);

	for (int i=0; i<num; i++) {
		uu = uv[i].u - 0.5;
		vv = uv[i].v - 0.5;
		uv[i].u =  uu*cs + vv*sn + 0.5;
		uv[i].v = -uu*sn + vv*cs + 0.5;
	}
}


void  MaterialParam::execInvRotate(UVMap<double>* uv, int num)
{
	double uu, vv;
	double cs = cos(rotate);
	double sn = -sin(rotate);

	for (int i=0; i<num; i++) {
		uu = uv[i].u - 0.5;
		vv = uv[i].v - 0.5;
		uv[i].u =  uu*cs + vv*sn + 0.5;
		uv[i].v = -uu*sn + vv*cs + 0.5;
	}
}


void  MaterialParam::execTrans(UVMap<double>* uv, int num)
{
	if (flipU) { execFlipU(uv, num); flipU = false;}	
	if (flipV) { execFlipV(uv, num); flipV = false;}	
	if (isSetScale())  execScale (uv, num);
	if (isSetRotate()) execRotate(uv, num);
	if (isSetShift())  execShift (uv, num);

	return;
}


void  MaterialParam::execInvTrans(UVMap<double>* uv, int num)
{
	if (flipU) { execFlipU(uv, num); flipU = false;}	
	if (flipV) { execFlipV(uv, num); flipV = false;}	
	if (isSetShift())  execInvShift (uv, num);
	if (isSetRotate()) execInvRotate(uv, num);
	if (isSetScale())  execInvScale (uv, num);

	return;
}



void  MaterialParam::PrintParam(FILE* fp)
{
	if (!enable) {
		fprintf(fp, "MaterialParam is disable\n");
		return;
	}
	fprintf(fp, "MaterialParam.texture  = %s\n", texture.buf);
	fprintf(fp, "MaterialParam.bumpmap  = %s\n", bumpmap.buf);
	fprintf(fp, "MaterialParam.color    = (%f,%f,%f,%f) [RGBA]\n", color[0], color[1], color[2], color[3]);
	fprintf(fp, "MaterialParam.glow     = %f\n", glow);
	fprintf(fp, "MaterialParam.specular = %f\n", specular);
	fprintf(fp, "MaterialParam.bright   = %f\n", bright);
	fprintf(fp, "MaterialParam.mflags   = %d\n", mflags);
	fprintf(fp, "MaterialParam.mapping  = %d\n", mapping);
	fprintf(fp, "MaterialParam.shiftU   = %f\n", shiftU);
	fprintf(fp, "MaterialParam.shiftV   = %f\n", shiftV);
	fprintf(fp, "MaterialParam.scaleU   = %f\n", scaleU);
	fprintf(fp, "MaterialParam.scaleV   = %f\n", scaleV);
	fprintf(fp, "MaterialParam.rotate   = %f\n", rotate);

	if (flipU) fprintf(fp, "MaterialParam.flipU    = true\n");
    else       fprintf(fp, "MaterialParam.flipU    = false\n");
    if (flipV) fprintf(fp, "MaterialParam.flipV    = true\n");
    else       fprintf(fp, "MaterialParam.flipV    = false\n");
	fflush(fp);

	return;
}




////////////////////////////////////////////////////////////////////////////////

/**
@brief eNX`CJ[ׂ

*/
bool  jbxl::isSameMaterial(MaterialParam a, MaterialParam b)
{
	if (strcmp_Buffer(a.texture, b.texture)) return false;

	for (int i=0; i<4; i++) {
		if (a.color[i]!=b.color[i]) return false;
	}

//	if (a.glow!=b.glow) return false;

	return true;
}


