/**
	DirectX9 Cu

*/

#include "Dx9.h"


using namespace jbxl;
using namespace jbxwl;




LPDIRECT3D9     jbxwl::GpD3D	= NULL;
LPDIRECTINPUT8  jbxwl::GpDInput = NULL;

LPDIRECTINPUTDEVICE8  jbxwl::GpDMouse    = NULL;		// }EX̃C^[tFCX
LPDIRECTINPUTDEVICE8  jbxwl::GpDKeyBoard = NULL;		// L[{[h̃C^[tFCX


BOOL  jbxwl::Dx9DividePrimitiveMode	= TRUE;				// `惂[h
BOOL  jbxwl::Dx9ReverseZMode		= FALSE;			// Z][hifor 3D CTj





/**
	@\F  DirectX9̃foCXւ̃C^[tFCX𓾂D
	F	hinst  AvP[ṼCX^Xnhiʏ this->m_hInstancewj 
	F  
*/
BOOL  jbxwl::Dx9CreateInterface(CWinApp*  wapp) 
{
	GpD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if (GpD3D==NULL) {
		DEBUG_INFO("jbxwl::Dx9CreateInterface: ERROR: OtBbNfoCX̎擾Ɏs܂");
		return FALSE;
	}

	HRESULT hr = DirectInput8Create(wapp->m_hInstance, DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&GpDInput, NULL);
	if (GpDInput==NULL) {
		DEBUG_INFO("jbxwl::Dx9CreateInterface: ERROR: CvbgfoCX̎擾Ɏs܂");
		DXRELEASE(GpD3D);
		return FALSE;
	}
	else {
		GpDMouse = Dx9CreateMouse(GpDInput, wapp->m_pMainWnd->m_hWnd);
		if (GpDMouse==NULL) {
			Sleep(1000);
			GpDMouse = Dx9CreateMouse(GpDInput, wapp->m_pMainWnd->m_hWnd);
			if (GpDMouse==NULL) {
				DEBUG_INFO("jbxwl::Dx9CreateInterface(): ERROR: }EXfoCX̎擾Ɏs܂");
				DXRELEASE(GpD3D);
				DXRELEASE(GpDInput);
				return FALSE;
			}
		}
		GpDKeyBoard = Dx9CreateKeyBoard(GpDInput, wapp->m_pMainWnd->m_hWnd);
		if (GpDKeyBoard==NULL) {
			Sleep(1000);
			GpDKeyBoard = Dx9CreateKeyBoard(GpDInput, wapp->m_pMainWnd->m_hWnd);
			if (GpDKeyBoard==NULL) {
				DEBUG_INFO("jbxwl::Dx9CreateInterface(): ERROR: L[{[hfoCX̎擾Ɏs܂");
				DXRELEASE(GpDMouse);
				DXRELEASE(GpD3D);
				DXRELEASE(GpDInput);
				return FALSE;
			}
		}
	}

	return TRUE;
}






void    jbxwl::Dx9ReleaseInterface()
{
	DXRELEASE(GpDMouse);
	DXRELEASE(GpDKeyBoard);
	DXRELEASE(GpDInput);
	DXRELEASE(GpD3D);
}






/**
	@\F  DirectX9̃OtBbNfoCX𓾂D
	F	gpD3D		DirectX9̃C^[tFCX 
			*d3dParam	foCX쐬̂߂̃p[^
			hWnd		foCX쐬EBhẼEBhEnh  
	ߒlF  DirectX9foCX
	F  
*/
LPDIRECT3DDEVICE9  jbxwl::Dx9CreateGraphic(LPDIRECT3D9 gpD3D, D3DPRESENT_PARAMETERS* d3dParam, HWND hWnd)
{
	LPDIRECT3DDEVICE9  d3dDevice=NULL;
	HRESULT hr;

	hr = gpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, d3dParam, &d3dDevice);
	if (FAILED(hr)) {
		hr = gpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, d3dParam, &d3dDevice);
		if (FAILED(hr)) {
			hr = gpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, d3dParam, &d3dDevice);
			if (FAILED(hr)) return (LPDIRECT3DDEVICE9)NULL;
		}
	}
	return d3dDevice;
}








/**


*/
LPDIRECTINPUTDEVICE8  jbxwl::Dx9CreateMouse(LPDIRECTINPUT8 gpDInput, HWND hWnd)
{
	LPDIRECTINPUTDEVICE8  gpdmouse=NULL;

	HRESULT hr = gpDInput->CreateDevice(GUID_SysMouse, &gpdmouse, NULL);
	if (FAILED(hr) || gpdmouse==NULL) return NULL;

	hr = gpdmouse->SetDataFormat(&c_dfDIMouse);
	if (FAILED(hr)) return NULL;

	hr = gpdmouse->SetCooperativeLevel(hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	if (FAILED(hr)) return NULL;

//	[h 
/*	DIPROPDWORD  diprop;
	diprop.diph.dwSize = sizeof(diprop);
	diprop.diph.dwHeaderSize = sizeof(diprop.diph);
	diprop.diph.dwObj = 0;
	diprop.diph.dwHow = DIPH_DEVICE;
	diprop.dwData = DIPROPAXISMODE_ABS;
	hr = gpdmouse->SetProperty(DIPROP_AXISMODE, &diprop.diph);
	if (FAILED(hr)) {
		DEBUG_INFO("Dx9CreateMouse: SetProprty");
		return NULL;
	}
/**/

	hr = gpdmouse->Acquire();
	if (FAILED(hr)) return NULL;

	return gpdmouse;  
}





//
//  sS  !!!
//
LPDIRECTINPUTDEVICE8  jbxwl::Dx9CreateKeyBoard(LPDIRECTINPUT8 gpDInput, HWND hWnd)
{
	LPDIRECTINPUTDEVICE8  gpdkeyboard=NULL;

	HRESULT hr = gpDInput->CreateDevice(GUID_SysKeyboard, &gpdkeyboard, NULL);
	if (FAILED(hr)) return NULL;

	hr = gpdkeyboard->SetDataFormat(&c_dfDIKeyboard);
	if (FAILED(hr)) return NULL;

	hr = gpdkeyboard->SetCooperativeLevel(hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	if (FAILED(hr)) return NULL;
	else            return gpdkeyboard;  
}








/*
	@\F  obNobt@𓾂D
	F	gpD3DDevice		DirectX9foCX 
			*pgpBackBuffer	lobNobt@Dsꍇ NULL
	ߒlF  obNobt@̃TCYDG[̏ꍇ  <0
	F  
*/
POINT  jbxwl::Dx9GetBackBuffer(LPDIRECT3DDEVICE9 gpD3DDevice, LPDIRECT3DSURFACE9* pgpBackBuffer)
{
	POINT  pt;
	pt.x = pt.y = -1;

	HRESULT hr = gpD3DDevice->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, pgpBackBuffer);
	if (FAILED(hr)) return pt;

	pt = Dx9GetSurfaceSize(pgpBackBuffer);
	return pt;
}





/*
	@\F   cmnHeadT[tFCX쐬Dibp[֐j
	F	gpD3DDevice		DirectX9foCX 
			*pgpSurface		쐬T[tFCX
			cmnhead			̃f[^Lq CmnHead ^f[^D
	ߒlF  sʂ BOOL
	F  T|[gf[^`  DirectX9 (jpg, png, bmp, ......), SUN Raster, CT_DATA
			쐬T[tFCX̃Ǘ D3DPOOL_DEFAULTɂȂD
*/
BOOL  jbxwl::Dx9SurfaceFromMemory(LPDIRECT3DDEVICE9 gpD3DDevice, LPDIRECT3DSURFACE9* pgpSurface, CmnHead cmnHead)
{
	BOOL ret;

	if (cmnHead.kind==HEADER_ERROR) return FALSE;
	int chk = cmnHead.kind & 0x00ff;

	if (chk==UN_KNOWN_DATA) ret = Dx9SurfaceFromMemoryFile(gpD3DDevice, pgpSurface, cmnHead);
	else					ret = Dx9SurfaceFromByteMemory(gpD3DDevice, pgpSurface, cmnHead);
	return  ret;
}




//
//	 cmnHeadT[tFCX쐬D
//  DirectX9 T|[gf[^(UN_KNOWN)pDcmnHead.grptr̃t@C`f[^wD
//
BOOL  jbxwl::Dx9SurfaceFromMemoryFile(LPDIRECT3DDEVICE9 gpD3DDevice, LPDIRECT3DSURFACE9* pgpSurface, CmnHead cmnHead)
{
	//HRESULT hr = gpD3DDevice->CreateOffscreenPlainSurface(
	//		cmnHead.xsize, cmnHead.ysize, (D3DFORMAT)cmnHead.depth, D3DPOOL_DEFAULT, pgpSurface, NULL);

	HRESULT hr = gpD3DDevice->CreateOffscreenPlainSurface(cmnHead.xsize, cmnHead.ysize,  D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, pgpSurface, NULL);
	if (FAILED(hr)) return FALSE;

    hr = D3DXLoadSurfaceFromFileInMemory(*pgpSurface, NULL, NULL, cmnHead.grptr, cmnHead.lsize, NULL, D3DX_FILTER_NONE, 0, (D3DXIMAGE_INFO*)cmnHead.buf);
	if (FAILED(hr)) return FALSE;

	return TRUE;
}




//
//	 cmnHeadT[tFCX쐬D
//  RAS_DATA(SUN Raster), CT_DATAȂǂ̓Ǝt@CpD\f[^ 8bit
//
BOOL  jbxwl::Dx9SurfaceFromByteMemory(LPDIRECT3DDEVICE9 gpD3DDevice, LPDIRECT3DSURFACE9* pgpSurface, CmnHead cmnHead)
{
    HRESULT hr = gpD3DDevice->CreateOffscreenPlainSurface(cmnHead.xsize, cmnHead.ysize, D3DFMT_R5G6B5, D3DPOOL_DEFAULT, pgpSurface, NULL);
	if (FAILED(hr)) return FALSE;

	RECT    rect;
	rect.left   = 0;
	rect.top    = 0;
	rect.right  = cmnHead.xsize - 1;
	rect.bottom = cmnHead.ysize - 1;
    hr = D3DXLoadSurfaceFromMemory(*pgpSurface, NULL, NULL, cmnHead.grptr, D3DFMT_L8,  cmnHead.xsize, NULL, &rect, D3DX_FILTER_NONE, 0);
//	hr = D3DXLoadSurfaceFromMemory(*pgpSurface, NULL, NULL, cmnHead.grptr, D3DFMT_L16, cmnHead.xsize*2, NULL, &rect, D3DX_FILTER_NONE, 0);
	if (FAILED(hr)) return FALSE;
	return TRUE;
}





/*
	@\F   cmnHeadeNX`쐬Dibp[֐j
	F	gpD3DDevice		DirectX9foCX 
			*pgpSurface		쐬eNX`
			cmnhead			̃f[^Lq CmnHead ^f[^D
	ߒlF  sʂ BOOL
	F  T|[gf[^`  DirectX9 (jpg, png, bmp, ......), SUN Raster, CT_DATA
			쐬eNX`̃Ǘ D3DPOOL_DEFAULTɂȂD
*/
BOOL  jbxwl::Dx9TextureFromMemory(LPDIRECT3DDEVICE9 gpD3DDevice, LPDIRECT3DTEXTURE9* pgpTexture, CmnHead cmnHead)
{
	BOOL ret;

	if (cmnHead.kind==HEADER_ERROR) return FALSE;
	int chk = cmnHead.kind & 0x00ff;

	if (chk==UN_KNOWN_DATA) ret = Dx9TextureFromMemoryFile(gpD3DDevice, pgpTexture, cmnHead);
	else					ret = Dx9TextureFromByteMemory(gpD3DDevice, pgpTexture, cmnHead);
	return  ret;
}





//
//	 cmnHeadeNX`쐬D
//  DirectX9 T|[gf[^(UN_KNOWN)pDcmnHead.grptr̃t@C`f[^wD
//
BOOL  jbxwl::Dx9TextureFromMemoryFile(LPDIRECT3DDEVICE9 gpD3DDevice, LPDIRECT3DTEXTURE9* pgpTexture, CmnHead cmnHead)
{
	HRESULT	hr = D3DXCreateTextureFromFileInMemoryEx(
				gpD3DDevice, cmnHead.grptr, cmnHead.lsize, 0, 0, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, //D3DPOOL_MANAGED, 
				D3DX_FILTER_LINEAR, D3DX_FILTER_LINEAR, 0, NULL, NULL, pgpTexture);
	if (FAILED(hr)) return FALSE;
	return  TRUE;
}





//
//	 cmnHeadeNX`쐬D
//  RAS_DATA(SUN Raster), CT_DATAȂǂ̓Ǝt@CpDeNX`f[^ 8bit
//
BOOL  jbxwl::Dx9TextureFromByteMemory(LPDIRECT3DDEVICE9 gpD3DDevice, LPDIRECT3DTEXTURE9* pgpTexture, CmnHead cmnHead)
{
	HRESULT hr;
	RECT    rect;
	LPDIRECT3DSURFACE9 surface;

	hr = D3DXCreateTexture(gpD3DDevice, cmnHead.xsize, cmnHead.ysize, 0, D3DUSAGE_RENDERTARGET, D3DFMT_L8, D3DPOOL_DEFAULT, pgpTexture);
	if (FAILED(hr)) return FALSE; 

	hr = (*pgpTexture)->GetSurfaceLevel(0, &surface);
	if (FAILED(hr)) return FALSE; 

	rect.left   = 0;
	rect.top    = 0;
	rect.right  = cmnHead.xsize - 1;
	rect.bottom = cmnHead.ysize - 1;
	hr = D3DXLoadSurfaceFromMemory(surface, NULL, NULL, cmnHead.grptr, D3DFMT_L8, cmnHead.xsize, NULL, &rect, D3DX_FILTER_LINEAR, 0);
	DXRELEASE(surface);

	if (FAILED(hr)) return FALSE;
	return TRUE;
}





/*
	@\F  DrawPrimitivẽbp[DDx9DividePrimitiveMode TRUE̎C
	        ɕ DrawPrimitiveĂяoD

	F	gpD3DDevice		DirectX9foCX 
			ptyepe			v~eBu^Cv
			unit			P̃v~eBu߂ɕKvȒ_D
			bsize			v~eBu̐

	ߒlF  sʂ HRESULT

	F  ̃J[h  Primitive̐ƌ쓮ꍇ̂ŁC
			DXMAXPRIMITIVEĕ\D
*/
HRESULT  jbxwl::Dx9DrawPrimitive(LPDIRECT3DDEVICE9 gpD3DDevice, D3DPRIMITIVETYPE ptype, UINT unit, UINT bsize)
{
	HRESULT hr;
	
	if (Dx9DividePrimitiveMode) {	// `惂[h
		UINT  iter = bsize / DXMAXPRIMITIVE;
		UINT  imod = bsize % DXMAXPRIMITIVE;

		unsigned int i;
		for (i=0; i<iter; i++) {
			hr = gpD3DDevice->DrawPrimitive(ptype, i*unit*DXMAXPRIMITIVE, DXMAXPRIMITIVE);
			if (FAILED(hr)) return hr;
		}
		hr = gpD3DDevice->DrawPrimitive(ptype, i*unit*DXMAXPRIMITIVE, imod);
		//if (FAILED(hr)) Dx9DividePrimitiveMode = FALSE;                 
	}
	else {							// m[}[h
		hr = gpD3DDevice->DrawPrimitive(ptype, 0, bsize);
		//if (FAILED(hr)) Dx9DividePrimitiveMode = TRUE;                 
	}

	return hr;
}









POINT  jbxwl::Dx9GetSurfaceSize(LPDIRECT3DSURFACE9* lpsf)
{
	D3DSURFACE_DESC  desc;
	POINT  pt;

	(*lpsf)->GetDesc(&desc);
	pt.x = desc.Width;
	pt.y = desc.Height;

	return pt;
}















