/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBXL_MATRIX_LIBRARY_H_
#define  __JBXL_MATRIX_LIBRARY_H_


/** 
@brief   }gbNXxNgCu wb_
@file    matrix.h
@author  Fumi.Iseki (C)
*/


#include "common.h"
#include "mt.h"

#include <math.h>
#include <float.h>





#ifndef va_start
    #include <stdarg.h>
#endif



typedef struct _ivector {
    int x;					///< x
    int y;					///< y
    int z;					///<  z
    double n;				///< xNg̑傫
} ivector;



typedef struct _vector {
    double x;				///< x
    double y;				///< y
    double z;				///< z
    double n;				///< xNg̑傫
} vector;



typedef struct _quaternion {
    double s;				///< s
    double x;				///< x
    double y;				///< y
    double z;				///< z
    double n;				///< xNg̑傫
} quaternion;





/**
}gbNX^  imatrix

imatrix^̈ (s, , ....)ƂȂ,ۂɂ͌̕
Ƀi[(OtBbNƂ͋t gdata.c)̂
ڃɃANZXꍇ͒ӂKvłD
*/
typedef struct _imatrix {
    int n;					///< 
    int r;					///< Svf sz[0]+sz[1]+...+sz[n-1]
    int *sz;				///< e̗vf sz[0]?sz[n-1]
    int *mx;				///< vf mx[0]?mx[r-1] 
} imatrix;




/**
}gbNX^  matrix

matrix^̈ (s, , ....)ƂȂ,ۂɂ͌̕
Ƀi[(OtBbNƂ͋t gdata.c)̂
ڃɃANZXꍇ͒ӂKvłD
 */
typedef struct _matrix {
    int n;					///< 
    int r;					///< Svf sz[0]+sz[1]+...+sz[n-1] 
    int *sz;				///< e̗vf sz[0]?sz[n-1]
    double *mx;				///< vf mx[0]?mx[r-1] 
} matrix;




#define  in_vector(a, b)   ((a).x*(b).x+(a).y*(b).y+(a).z*(b).z)							///< xNg a, b̓ςƂD
#define  add_vector(a, b)  set_vector((a).x+(b).x,(a).y+(b).y,(a).z+(b).z)					///< xNg a, b𑫂Z, ʂxNgŕԂD
#define  sub_vector(a, b)  set_vector((a).x-(b).x,(a).y-(b).y,(a).z-(b).z)					///< xNg a, bZ, ʂxNgŕԂD
#define  add_ivector(a, b) set_ivector((a).x+(b).x,(a).y+(b).y,(a).z+(b).z)					///< xNg a, b𑫂Z, ʂ𐮐xNgŕԂD
#define  sub_ivector(a, b) set_ivector((a).x-(b).x,(a).y-(b).y,(a).z-(b).z)					///< xNg a, bZ, ʂ𐮐xNgŕԂD
#define  normal_vector(a)  {(a).r = sqrt((double)(a).x*(a).x+(a).y*(a).y+(a).z*(a).z);}		///< xNg ȃ傫vZD


#define Vt(m, i)  	((m).mx[(i)-1])															///< 1}gbNX iԖڂ̗vfԂD1琔D
#define Mx(m, i, j)	((m).mx[(j)-1+(m).sz[1]*((i)-1)])										///< 2}gbNX(i,j)vfԂD   1琔D

#define Mx1(m, i)  	   	   ((m).mx[(i)-1])													///< 1}gbNX iԖڂ̗vfԂD1琔D
#define Mx2(m, i, j)	   ((m).mx[(j)-1+(m).sz[1]*((i)-1)])								///< 2}gbNX(i,j)vfԂD   1琔D
#define Mx3(m, i, j, k)    ((m).mx[(k)-1+(m).sz[2]*((j)-1)+(m).sz[1]*(m).sz[2]*((i)-1)])	///< 3}gbNX(i,j,k)vfԂD 1琔D
#define Mx4(m, i, j, k, l) ((m).mx[(l)-1+(m).sz[3]*((k)-1)+(m).sz[2]*(m).sz[3]*((j)-1) +\
							(m).sz[1]*(m).sz[2]*(m).sz[3]*((i)-1)])							///< 4}gbNX(i,j,k,l)vfԂD1琔D



/**/
vector   unit_vector(vector a);
vector   unit_ivector(ivector a);
vector   set_vector(double x, double y, double z);
ivector  set_ivector(int x, int y, int z);
vector   ex_vector(vector a, vector b);

ivector  f2ivector(vector a);
vector   i2vector(ivector a);

matrix   make_matrix1(int n);
matrix   make_matrix2(int n, int m);
matrix   make_matrix (int n, int* sz);

imatrix  make_imatrix1(int n);
imatrix  make_imatrix2(int n, int m);
imatrix  make_imatrix (int n, int* sz);



double*  get_matrix(matrix a, ...);
matrix   add_matrix(matrix a, matrix b);
matrix   sub_matrix(matrix a, matrix b);
matrix   mlt_matrix(matrix a, matrix b);
void     copy_matrix(matrix a, matrix b);
void     free_matrix(matrix* a);
void     clear_matrix(matrix* a);
void     print_matrix(FILE* fp, matrix a);

int*     get_imatrix(imatrix a, ...);
imatrix  add_imatrix(imatrix a, imatrix b);
imatrix  sub_imatrix(imatrix a, imatrix b);
imatrix  mlt_imatrix(imatrix a, imatrix b);
void     copy_imatrix(imatrix a, imatrix b);
void     free_imatrix(imatrix* a);
void     clear_imatrix(imatrix* a);
void     print_imatrix(FILE* fp, imatrix a);


//
matrix   decompQR(matrix xx, imatrix col);
matrix   trans_matrix(matrix a);
matrix   minimum2(matrix a, matrix x);
matrix   invrU_matrix(matrix x);

/**/


#endif
