/* vi: set tabstop=4 nocindent noautoindent: */


/** 
@brief   wpCu
@file    mt.c
@author  Fumi.Iseki (C)
*/



#include "mt.h"



double   EPS = 1.0e-6;



/**
double  power(float x, float y)

x y x^yvZD

*/
double  power(float x, float y)
{
    if (y==0.0)      return 1.0;
    else if (x==0.0) return 0.0;
    else return (exp((y)*log(x)));
}




/**
float  fact(int n)

n̊K n! vZDn>0 łȂꍇ 1.0 ԂD 

*/
float  fact(int n)
{
	int   i;
	float ret = 1.0;

    if (n>0) for (i=1; i<=n; i++)  ret = ret*(float)i;
	return ret;
}
    



/**
float  perm(int n, int m)

p[e[V nPm vZD

*/
float  perm(int n, int m)
{
	int   i;
    float p;

    if (m>n || n<=0 || m<=0) return 0.;

	p = 1.0;
	for (i=n-m+1; i<=n; i++) p = p*(float)i;

    return p;
}




/**
float  comb(int n, int m)

Rrl[V nCm vZD 

*/
float  comb(int n, int m)
{
	int i;
    float c, p;

    if (m>n || n<=0 || m<=0) return 0.;

	p = c = 1.0;
	for (i=n-m+1; i<=n; i++) p = p*(float)i;
    for (i=1;     i<=m; i++) c = c*(float)i;

    return p/c;
}





#define  MAX_ITRTN_NEWTON_METHOD  30	///< j[g@ŉ߂ۂ́CőJԂ񐔁D


/**	
int    newton_method(PTR_DFFUNC func, PTR_DFFUNC dfunc, double* t0, double eps)

j[g@ func()==0 ̓_߂D@n
֐̌` double func(double)

@param         func   double func(double) ^̊֐ւ̃|C^
@param         dfunc  func()̓֐ւ̃|C^D
@param[in,out] t0     in: TJn_ix̏lj, out: D
@param         eps    덷D1ɑ΂ 1.0e-8 ȂǁD

@return        ߂܂ł̌JԂ񐔁D0 ̏ꍇ͎sD
@see PTR_DFFUNC, MAX_ITRTN_NEWTON_METHOD
*/
int    newton_method(PTR_DFFUNC func, PTR_DFFUNC dfunc, double* t0, double eps)
{
	double tt  = *t0;
	double ff  = (*func)(tt);

	int n = 1;
	while (n<MAX_ITRTN_NEWTON_METHOD && Xabs(ff)>eps) {
		//
		double df = (*dfunc)(tt);
		if (Xabs(df)<eps) return 0;

		tt = tt - ff/df;
		ff = (*func)(tt);
		n++;
	}

	if (n==MAX_ITRTN_NEWTON_METHOD) return 0;
	*t0 = tt;
	return n;
}


