/* vi: set tabstop=4 nocindent noautoindent: */



/** 
@brief   lbg[NpCu
@file    network.c
@author  Fumi.Iseki (C)
*/



#include "network.h"
#include <time.h>





/**
int  udp_server_socket(int port)   

UDP̃T[o\Pbg,ڑ҂ԂɂȂD

̊֐ŌĂяolbg[N֐: socket(), bind()

@param  port |[gԍ

@retval  0ȏ 쐬ꂽ\PbgLqqD
@retval -1     \Pbg쐬łȂD
@retval -3     oChɎsD
*/
int  udp_server_socket(int port) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = (int)socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	// TIME_WAIT ȂݒD
/*	struct linger lg;
	lg.l_onoff  = 1;
	lg.l_linger = 0;
	err = setsockopt(sofd, SOL_SOCKET, SO_LINGER, &lg, sizeof(lg));
	if (err<0) {
		socket_close(sofd);
		return -2;
	} 
*/
	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}




/**
int  udp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 

UDP̃T[o\Pbg,ڑ҂ԂɂȂDIvV̎wisetsockoptj\D

̊֐ŌĂяolbg[N֐: socket(), setsockopt(), bind()

@param  port    |[gԍ
@param  opt     IvV̎
@param  optval  IvVf[^
@param  optlen  optval ̒

@retval  0ȏ  쐬ꂽ\PbgLqqD
@retval -1      \Pbg쐬łȂD
@retval -2      \PbgIvV̐ݒɎsD
@retval -3      oChɎsD
*/
int  udp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = (int)socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		} 
	}

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}




/**
int  udp_client_socket(char* hostname, int port, struct sockaddr_in* sv_addr)

UDP̃NCAg\PbgD
Iꍇ, *sv_addrɃT[ȍ񂪊i[D

̊֐ŌĂяolbg[N֐: socket(), gethostbyname()

@param  hostname T[o
@param  port     T[o|[gԍ
@param  sv_addr	 sockaddr_in \̂ւ̃|C^

@retval  0ȏ   쐬ꂽ\PbgLqqD
@retval	-1       \Pbg쐬łȂD
@retval -2       T[o̎擾ɎsD
*/
int  udp_client_socket(char* hostname, int port, struct sockaddr_in* sv_addr)
{
	int  sofd;
	struct hostent* shost;
 
	sofd = (int)socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) return -1;
 
	shost = gethostbyname(hostname); 
	if (shost==NULL) {
		socket_close(sofd);
		return -2;
	}

	memset(sv_addr, 0, sizeof(*sv_addr));
	sv_addr->sin_family = AF_INET;
	sv_addr->sin_port   = htons(port);
	memcpy(&(sv_addr->sin_addr), shost->h_addr, shost->h_length);
   
	return sofd;
}




/**
int  udp_bind(int sofd, int port)  

UDP\PbgɃ|[goChD

@param  sofd  oCh\Pbg̋LqqD
@param  port  |[gԍ

@retval sofd  
@retval	-1    s
*/
int  udp_bind(int sofd, int port) 
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}




/**
int  udp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen) 

UDP\PbgɃ|[goChDIvV̎wisetsockoptj\D

@param  sofd    oCh\Pbg̋LqqD
@param  port    |[gԍ
@param  opt     IvV̎
@param  optval  IvVf[^
@param  optlen  optval ̒

@retval  0ȏ  쐬ꂽ\PbgLqqD
@retval -1      oChɎsD
@retval -2      \PbgIvV̐ݒɎs
 */
int  udp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen) 
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		} 
	}

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}




/**
int  tcp_server_socket(int port)

TCP̃T[o\PbgCbXɂڑv󂯂ԂɂD@n
̊֐ɑ accept()֐ĂԎɂ,ۂ̐ڑ҂ԂƂȂD

̊֐ŌĂяolbg[N֐ socket(), bind(), listen()

@param  port |[gԍD

@retval  0ȏ 쐬ꂽ\PbgLqqD
@retval -1     \Pbg̍쐬ɎsD
@retval -3     oChɎsD
@retval -4     bX̐ݒɎsD
*/
int  tcp_server_socket(int port) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = (int)socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	err = listen(sofd, 10);
	if (err==-1) {
		socket_close(sofd);
		return -4;
	}

	return sofd;
}




/**
int  tcp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 

TCP̃T[o\PbgCbXɂڑv󂯂ԂɂD@n
̊֐ɑ accept()֐ĂԎɂ,ۂ̐ڑ҂ԂƂȂD
IvV̎wisetsockoptj\D

̊֐ŌĂяolbg[N֐ socket(), setsockopt(), bind(), listen()

@param  port    |[gԍ
@param  opt     IvV̎
@param  optval  IvVf[^
@param  optlen  optval ̒

@retval  0ȏ  쐬ꂽ\PbgLqqD
@retval -1      \Pbg̍쐬ɎsD
@retval -2      \PbgIvV̐ݒɎsD
@retval -3      oChɎsD
@retval -4      bX̐ݒɎsD
*/
int  tcp_server_socket_setopt(int port, int opt, const void* optval, int optlen) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = (int)socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		}
	}

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	err = listen(sofd, 10);
	if (err==-1) {
		socket_close(sofd);
		return -4;
	}

	return sofd;
}




/**
int  tcp_server_bind(int port)

TCP̃T[õ\PbgLqqCoChD
tcp_server_socket() Ƃ̈Ⴂ listen()֐ĂяoȂ_ɂD

̊֐ŌĂяolbg[N֐: socket(), bind()

@param  port   |[gԍD

@retval  0ȏ 쐬ꂽ\PbgLqqD
@retval -1     \Pbg̍쐬ɎsD
@retval -3     oChɎsD
*/
int  tcp_server_bind(int port) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = (int)socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}





/**
int  tcp_server_bind_setopt(int port, int opt, const void* optval, int optlen) 

TCP̃T[õ\PbgLqqCoChDIvV̎wisetsockoptj\D
tcp_server_socket() Ƃ̈Ⴂ listen()֐ĂяoȂ_ɂD

̊֐ŌĂяolbg[N֐: socket(), setsockopt(), bind()

@param  port    |[gԍ
@param  opt     IvV̎
@param  optval  IvVf[^
@param  optlen  optval ̒

@retval  0ȏ  쐬ꂽ\PbgLqqD
@retval -1      \Pbg̍쐬ɎsD
@retval -2      \PbgIvV̐ݒɎsD
@retval -3      oChɎsD
 */
int  tcp_server_bind_setopt(int port, int opt, const void* optval, int optlen) 
{
	int  sofd, err;
	struct sockaddr_in sv_addr;
 
	sofd = (int)socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		}
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}




/**
int  tcp_client_socket(char* hostname, int port)

TCP̃NCAg\PbgCT[oɐڑD

̊֐ŌĂяolbg[N֐: socket(), gethostbyname(), connect()

@param  hostname T[o
@param  port     T[o|[gԍ

@retval  0ȏ   쐬ꂽ\PbgLqqD
@retval -1       \Pbg̍쐬ɎsD
@retval -2       T[o̎擾ɎsD
@retval -3       T[oւ̐ڑɎsD
  */
int  tcp_client_socket(char* hostname, int port) 
{
	int sofd, err;
	struct hostent	 *shost;
	struct sockaddr_in sv_addr;

	sofd = (int)socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	shost = gethostbyname(hostname); 
	if (shost==NULL) {
		socket_close(sofd);
		return -2;
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	memcpy(&sv_addr.sin_addr, shost->h_addr, shost->h_length);

	err = connect(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -3;
	}

	return sofd;
}




/**
int  tcp_client_bind_socket(char* hostname, int sport, int cport)  

TCP̃NCAg\PbgCT[oɐڑD

̊֐ŌĂяolbg[N֐: socket(), bind(), gethostbyname(), connect()

@param  hostname T[o
@param  sport    T[o|[gԍ
@param  cport    ̃|[gԍ

@retval  0ȏ   쐬ꂽ\PbgLqqD
@retval -1       \Pbg̍쐬ɎsD
@retval -2       oChɎsD
@retval -3       T[o̎擾ɎsD
@retval -4       T[oւ̐ڑɎsD
 */
int  tcp_client_bind_socket(char* hostname, int sport, int cport)  
{
	int sofd, err;
	struct hostent  *shost;
	struct sockaddr_in sv_addr;

	sofd = (int)socket(AF_INET, SOCK_STREAM, 0);
	if (sofd<0) return -1;
 
	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(cport);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -2;
	}

	shost = gethostbyname(hostname); 
	if (shost==NULL) {
		socket_close(sofd);
		return -3;
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(sport);
	memcpy(&sv_addr.sin_addr, shost->h_addr, shost->h_length);

	err = connect(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -4;
	}

	return sofd;
}




/**
int  tcp_bind(int sofd, int port)  

TCP\PbgɃ|[goChD

@param  sofd  oCh\Pbg̋LqqD
@param  port  |[gԍ

@retval sofd  
@retval	-1    s
*/
int  tcp_bind(int sofd, int port)  
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}




/**
int  tcp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen)  

TCP\PbgɃ|[goChDIvV̎wisetsockoptj\D

@param  sofd    oCh\Pbg̋LqqD
@param  port    |[gԍ
@param  opt     IvV̎
@param  optval  IvVf[^
@param  optlen  optval ̒

@retval  0ȏ  쐬ꂽ\PbgLqqD
@retval -1      oChɎsD
@retval -2      \PbgIvV̐ݒɎsD
*/
int  tcp_bind_setopt(int sofd, int port, int opt, const void* optval, int optlen)  
{
	int  err;
	struct sockaddr_in sv_addr;
 
	if (sofd<=0) return sofd;

	if (opt>0) {
		#ifdef WIN32
			err = setsockopt(sofd, SOL_SOCKET, opt, (const char*)optval, optlen);
		#else
			err = setsockopt(sofd, SOL_SOCKET, opt, optval, optlen);
		#endif
		if (err<0) {
			socket_close(sofd);
			return -2;
		} 
	}

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	sv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	err = bind(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) {
		socket_close(sofd);
		return -1;
	}

	return sofd;
}




/**
int  accept_intr(int sock, struct sockaddr* cl_addr, socklen_t* cdlen)

accept()ŃubNɊ荞݂|āCaccept()sŏIĂ
Ď{sł悤ɂ邽߂̃bp[֐ (for Solaris)

@param  sock    \Pbg
@param  cl_addr \Pbg̏񂪓 sockaddr \̂ւ̃|C^
@param  cdlen   sockaddr \́i*cl_addrj̃TCY

@retval  0ȏ  accept() ō쐬ꂽ\PbgLqqD
@retval -1      G[D
 */
int accept_intr(int sock, struct sockaddr* cl_addr, socklen_t* cdlen)
{
	int nsofd = 0;

	do {
		nsofd = (int)accept(sock, cl_addr, cdlen);
	} while (nsofd==-1 && errno==EINTR);

	//if (nsofd<0) Error("accept_intr");

	return nsofd;
}




/*
int  tcp_connect(int sofd, char* hostname, int port)

TCP̃NCAg\PbgʂāCT[oɐڑD

̊֐ŌĂяo֐: gethostbyname(), connect()

@param  sofd      \PbgLqq
@param  hostname  T[o
@param  port      T[o|[gԍ

@retval  0  
@retval -1  T[o̎擾ɎsD
@retval -2  T[oւ̐ڑɎsD
 */
int  tcp_connect(int sofd, char* hostname, int port) 
{
	int  err;
	struct hostent  *shost;
	struct sockaddr_in sv_addr;

	shost = gethostbyname(hostname); 
	if (shost==NULL) return -1;

	memset(&sv_addr, 0, sizeof(sv_addr));
	sv_addr.sin_family = AF_INET;
	sv_addr.sin_port   = htons(port);
	memcpy(&sv_addr.sin_addr, shost->h_addr, shost->h_length);

	err = connect(sofd, (struct sockaddr*)&sv_addr, sizeof(sv_addr));
	if (err<0) return -2;
	return 0;
}




/**
int  socket_close(int sofd)

M̃f[^jāC\PbgSɕD

@attention fork() ꍇCevZX socket_close()ƁCqvZX̃\PbgɂeyڂD

@param  sofd   N[Y\PbgLqqwD

@retval  1ȏ ŌɎMoCg
@retval  0     ؒfD
@retval -1     G[
*/
int  socket_close(int sofd)
{
	int  err = -1;

	if (sofd>0) {
		#ifdef WIN32
			err = shutdown(sofd, 2);
			closesocket(sofd);
		#else
			err = shutdown(sofd, SHUT_RDWR);
			close(sofd);
		#endif
	}
	return err;
}






/////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
int  udp_recv(int sock, char* rmsg, int size, struct sockaddr_in* sv_addr)

recvform() bsO֐DUDPf[^MD

@param  sock	\PbgLqq
@param  rmsg    Mpf[^obt@
@param  size    f[^obt@̃TCY
@param  sv_addr T[ȍ񂪊i[ꂽ sockaddr_in \̂ւ̃|C^D

@retval  1ȏ  MoCgD
@retval  0      ؒfD
@retval -1      s
*/
int  udp_recv(int sock, char* rmsg, int size, struct sockaddr_in* sv_addr)
{
	int cc;
 	socklen_t cadlen;

	cadlen = sizeof(*sv_addr);
	memset(rmsg, 0, size);
	cc = recvfrom(sock, rmsg, size, 0, (struct sockaddr*)sv_addr, &cadlen);

	return cc;
}




/**
int  udp_send(int sock, char* smsg, int size, struct sockaddr_in* sv_addr)

sendto() bsO֐DUDPoRŃf[^𑗂D

f[^(smsg)̃TCY size0ȉw肵ꍇ́Csmsg͕
ƌȂăTCYIɌvZD

@param  sock    \PbgLqq
@param  smsg    Mf[^
@param  size    Mf[^ismsgj̃TCYDTCY 0ȉ̏ꍇ smsg͕łƂ݂ȂD
@param  sv_addr T[ȍi[ sockaddar_in \̂ւ̃|C^D

@retval  0ȏ  MoCgD
@retval -1      s
*/
int  udp_send(int sock, char* smsg, int size, struct sockaddr_in* sv_addr)
{
	int cc;

	if (size<=0) size = (int)strlen(smsg);
//	hton_ar(smsg, size);
	cc = sendto(sock, smsg, size, 0, (struct sockaddr*)sv_addr, sizeof(*sv_addr));

	return cc;
}




/**
int  tcp_recv(int sock, char* rmsg, int size)

recv()bsO֐DTCPoRŃf[^MD

@param  sock   \PbgLqq
@param  rmsg   Mpf[^obt@
@param  size   f[^obt@̃TCY

@retval  1ȏ MoCgD
@retval  0     ؒfD
@retval -1     s
*/
int  tcp_recv(int sock, char* rmsg, int size)
{
	int cc;

	memset(rmsg, 0, size);
	cc = recv(sock, rmsg, size, 0);

	return cc;
}




/**
int  tcp_send(int sock, char* smsg, int size)

send()bsO֐DTCPoRŃf[^𑗂D

f[^(smsg)̃TCY size0ȉw肵ꍇ́Csmsg͕łƌȂ,TCYIɌvZD

@param  sock   \PbgLqq
@param  smsg   Mf[^
@param  size   Mf[^ismsgj̃TCYDTCY 0ȉ̏ꍇ smsg͕łƂ݂ȂD

@retval  0ȏ MoCgD
@retval -1     sD
*/
int  tcp_send(int sock, char* smsg, int size)
{
	int cc;

	if (size<=0) size = (int)strlen(smsg);
	cc = send(sock, smsg, size, 0);

	return cc;
}




/**
int  udp_recv_wait(int sock, char* rmsg, int size, struct sockaddr_in* sv_addr, int tm)

UDPoRŃf[^MD

^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, recv_wait()
֐Ăяo_œǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D

@param  sock     \PbgLqq
@param  rmsg     Mpf[^obt@
@param  size     f[^obt@̃TCY
@param  sv_addr  T[ȍ񂪊i[ꂽ sockaddar_in \̂ւ̃|C^D
@param  tm	     ^CAEgԁDbPʁD

@retval  1ȏ   MoCgD
@retval  0       ؒfD
@retval -1       sD
@retval RECV_TIMEOUTED	^CAEgD
*/
int  udp_recv_wait(int sock, char* rmsg, int size, struct sockaddr_in* sv_addr, int tm)
{
	int  cc;

	if (recv_wait(sock, tm)) {
		cc = udp_recv(sock, rmsg, size, sv_addr); 
	}
	else {
		return RECV_TIMEOUTED;
	}
	return cc;
}




/**
int  tcp_recv_wait(int sock, char* mesg, int sz, int tm)

TCPoRŃf[^MD

^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, recv_wait()
֐Ăяo_œǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D

@param  sock    \PbgLqq
@param 	mesg    Mpf[^obt@
@param 	sz	    f[^obt@̃TCY
@param	tm	    ^CAEgԁDbPʁD

@retval  1ȏ  MoCgD
@retval  0	    炭͑葤ZbVN[YD
@retval -1	    MG[D
@retval RECV_TIMEOUTED  ^CAEgD
*/
int  tcp_recv_wait(int sock, char* mesg, int sz, int tm)
{
	int  cc;

	if (recv_wait(sock, tm)) {
		cc = recv(sock, mesg, sz, 0); 
	}
	else {
		return RECV_TIMEOUTED;
	}
	return cc;
}




/**
int  tcp_send_mesgln(int sock, char* mesg)

TCPbZ[W()ɉs(@\r@\n)tđMD

@param  sock    \PbgLqq
@param  mesg    MpbZ[W

@retval  0ȏ  MoCgD
@retval -1      sD
*/
int  tcp_send_mesgln(int sock, char* mesg)
{
	int   cc, sz;
	char* buf;

	sz = (int)strlen(mesg) + 3;	/* CR+LF+0x00 */
	buf = (char*)malloc(sz);
	if (buf==NULL) return -1;

	strncpy(buf, mesg, sz);
	strncat(buf, "\r\n", 2);
//	hton_ar(buf, strlen(buf));
	cc = send(sock, buf, (int)strlen(buf), 0);

	free(buf);
	return cc;
}





/**
int  tcp_recv_mstream(int sock, char* mesg, int sz, mstream* sb, int tm)

TCPoRŃbZ[W()MDMbZ[W̓bZ[WXg[obt@ɈUobt@OC
̊֐ɂsǂݏoDmesgɂ͍ő sz-1i[D
Cobt@̈s̃f[^ sz-1傫ꍇ́C͂ݏô͎ĂD

mesgɊi[鎞Cs̉sR[h͍폜Csɂ͕K '\0' D
^CAEg̐ݒ肪\Ń^CAEg 0w肵ꍇ, Ăяo_
ǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D

bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_ŊmۂD
Ů֐gpāCMf[^obt@OC\PbgN[Y܂ŁC
ǂݎɂ͕KXg[gpĂ̊֐Ăяo΂΂ȂȂD
Ŗꍇ͎Mf[^͕̐ۏ؂ȂD

@param  sock\PbgLqq
@param  mesg    Mpf[^obt@D\ߏ\ȃ̈mۂĂD
@param  sz      f[^obt@̃TCY
@param  sb      Oobt@^̃Xg[obt@D obt@mۂĂȂ΁CIɊmۂD
@param  tm      ^CAEgԁDbPʁD

@retval  1ȏ  mesgɊi[bZ[W̃oCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2       NULL̃f[^D
@retval -3      bZ[Wobt@̂Ŋmۂ悤ƂCmۂɎsD
@retval -4      bZ[Wobt@Ƀf[^݂͑͂Cs̗RɂlɎsD
@retval -5      bZ[Wobt@̃f[^̒Cmesg̒傫D͂ݏô͎ĂꂽD
@retval RECV_TIMEOUTED  ^CAEgD
*/
int  tcp_recv_mstream(int sock, char* mesg, int sz, mstream* sb, int tm)
{
	int  cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	memset(mesg, 0, sz);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = tcp_recv_wait(sock, mesg, sz, tm);
		if (cc<=0) return cc;
		put_mstream(sb, (unsigned char*)mesg);
		memset(mesg, 0, sz);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	if (strlen((const char*)pp)>=(unsigned int)sz) {
		memcpy(mesg, pp, sz-1);
		free(pp);
		return -5;
	}
	memcpy(mesg, pp, strlen((const char*)pp));

	free(pp);
	return (int)strlen(mesg);
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// AhX
//

/**
char*  get_hostname_bynum(unsigned char* num) 

oCiIPAhXi4bytejzXgtD 

@param  num  oCiIPAhXi4bytejD 
@return zXgijDv free
*/
char*  get_hostname_bynum(unsigned char* num) 
{
	int   len;
	char* hname;
	struct hostent* hent;

	#ifdef WIN32
		hent = gethostbyaddr((const char*)num, 4, AF_INET);
	#else
		hent = gethostbyaddr(num, 4, AF_INET);
	#endif
	
	if (hent==NULL) return NULL;

	len = (int)strlen(hent->h_name);
	hname = (char*)malloc(len+1);
	if (hname==NULL) {
		free(hent);
		return NULL;
	}
	memcpy(hname, hent->h_name, len+1);

	return hname;	
}




/**
char*  get_hostname(char* ipaddr) 

IPAhXijzXgtD 

FQDNw肵ꍇ́Cċt̂ŁCFQDÑ`FbNɎgpłD

@param  ipaddr IPAhXij܂ FQDN 
@return zXgijDv free
*/
char*  get_hostname(char* ipaddr) 
{
	char*  name;
	unsigned char* num;

	num  = to_address_num4(ipaddr, 1);
	if (num==NULL) return NULL;

	name = get_hostname_bynum(num); 
	free(num);

	return name;	
}

	



#ifdef WIN32

/**
unsigned char*  get_myipaddr_num() 

[JȃC^[tFCX oCi IPAhXƃlbg}XNԂD

@return  [IPAhX],[lbg}XN] ̒8bytẽoCiDv free

@attention Windows ̏ꍇ lbg}XN͎擾łȂD
@see get_localip(), get_localip_bydest()
*/
unsigned char*  get_myipaddr_num() 
{
	unsigned char* ipnum  = NULL;
	char* ipaddr = get_localip();

	if (ipaddr!=NULL) {
		ipnum = to_address_num8(ipaddr, 0);
		free(ipaddr);
	}

	return ipnum;
}


// #define get_myipaddr()  get_localip_bydest("202.26.158.1")


#else

/**
unsigned char*  get_myipaddr_num() 

lbg[NC^[tFCXCԍŏɌ UPԂŁC
[vobNłȂC^[tFCXIPAhXƃlbg}XNԂD@n
CC^[tFCX̐ MAXIFNO ȓłCȏ͖D

gIPAhXm@ƂẮC gethostname()  gethostbyname() g@D

@code
	struct hostent  *shost;
	.....................
	gethostname(hostname, sizeof(hostname));
	shost = gethostbyname(hostname);
@endcode

܂Cget_localip() ̕@gD

@return  [IPAhX],[lbg}XN] ̒8bytẽoCiDv free

@see get_localip(), get_localip_bydest()
*/
unsigned char*  get_myipaddr_num() 
{
	int	i, sofd, len;

	unsigned char*  addr = NULL;
	struct ifconf  ifc;
	struct ifreq*  ifq;
	struct ifreq*  ifp;


	len = sizeof(struct ifreq)*MAXIFNO;
	ifp = ifq = (struct ifreq*)malloc(len);
	if (ifq==NULL) return NULL;
	ifc.ifc_len = len;
	ifc.ifc_req = ifq;

	sofd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sofd<0) {
      	perror("get_myipaddr_num: socket");
		return NULL;
	}


	// C^[tFCX̎擾
	if (ioctl(sofd, SIOCGIFCONF, &ifc)<0) {
		socket_close(sofd);
		free(ifq);
		return NULL;
	}


	ifp = ifq;
	for (i=0; i<MAXIFNO; i++) {

		// C^[tFCX̃tO擾
		if (ioctl(sofd, SIOCGIFFLAGS, ifp)<0) {
			socket_close(sofd);
			free(ifq);
			return NULL;
		}

		if ((ifp->ifr_flags&IFF_UP) && !(ifp->ifr_flags&IFF_LOOPBACK)) {
			int j;
			unsigned char* p = (unsigned char*)ifp->ifr_addr.sa_data;

			addr = (unsigned char*)malloc(8);
			if (addr==NULL) {
				socket_close(sofd);
				free(ifq);
				return NULL;
			}

			// AhX擾
			if (ioctl(sofd, SIOCGIFADDR, ifp)<0) {
				socket_close(sofd);
				free(ifq);
				free(addr);
				return NULL;
			}
			for (j=0; j<4; j++) addr[j] = p[j+2];

			// lbg}XN擾
			if (ioctl(sofd, SIOCGIFNETMASK, ifp)<0) {
				socket_close(sofd);
				free(ifq);
				free(addr);
				return NULL;
			}
			for (j=0; j<4; j++) addr[j+4] = p[j+2];

			return addr;
		}
		ifp++;
	}
	
	socket_close(sofd);
	free(ifq);
	return NULL;
}


/**
char*  get_myipaddr() 

lbg[NC^[tFCXCԍŏɌ UPԂŁC
[vobNłȂC^[tFCXIPAhX lbg}XNԂD@n
CC^[tFCX̐ MAXIFNO ȓłC葽͖̂D

lbg}XNKvȂȂ get_localip() gpĂǂD

@return [IPAhX]/[lbg}XN] ̕Dv free

@attention Windows ̏ꍇ lbg}XN͎擾łȂD
*/
char*  get_myipaddr() 
{
	char* addr;
	unsigned char* n;

	n = get_myipaddr_num();
	if (n==NULL) return NULL;

	addr = (char*)malloc(32);
	if (addr==NULL) {
		free(n);
		return NULL;
	}
	memset(addr, 0, 32);

	snprintf(addr, 31, "%d.%d.%d.%d/%d.%d.%d.%d", n[0], n[1], n[2], n[3], n[4], n[5], n[6], n[7]);

	free(n);
	return addr;
}

#endif




/**
char*  get_localip_bydest(char* dest)

ڑw肵āC֐ڑ C^[tFCXIPAhX𓾂Dg IPAhX𓾂̕@D

@param  dest ڑ IPAhX ܂ FQDN

@return IPAhX()ւ̃|C^Dv free
*/
char*  get_localip_bydest(char* dest)
{
    int   err, sofd;
	socklen_t len;
	char* addr;
	char* ip;
	struct sockaddr_in localif;  
	struct sockaddr_in remote;             
	
	if (dest==NULL) return NULL; 	
	ip = get_ipaddr_byname(dest);
	if (ip ==NULL)  return NULL;

	memset(&localif, 0, sizeof(struct sockaddr_in));  
	memset(&remote,  0, sizeof(struct sockaddr_in));  
	remote.sin_family      = AF_INET;  
	remote.sin_addr.s_addr = inet_addr(ip);  
	remote.sin_port        = htons(9999);             
	free(ip);

	sofd = (int)socket(AF_INET, SOCK_DGRAM, 0);  
	if (sofd<0) return NULL;

  	err = connect(sofd, (struct sockaddr*)&remote, sizeof(remote));
  	if (err<0) {
      	socket_close(sofd);
     	return NULL;
    }

  	len = sizeof(localif);
  	err = getsockname(sofd, (struct sockaddr *)&localif, &len);
	if (err<0) {
      	socket_close(sofd);
      	return NULL;
    }
  	socket_close(sofd);

	addr = get_ipaddr(localif.sin_addr);
  	return addr;
}
           



/**
char*  get_ipaddr(struct in_addr sin_addr)

in_addr\̂ IPAhXlD

@param  sin_addr  sockaddr_in \̂ sin_addr oD
@return IPAhX()ւ̃|C^Dv free

@code
   struct sockaddr_in addr
   .........;
   ipaddr = get_ipaddr(addr.sin_addr); 
@endcode
*/
char*  get_ipaddr(struct in_addr sin_addr)
{
	char* ip;
	unsigned char* pp;

	pp = (unsigned char*)&(sin_addr);
	if (pp[0]==0) return NULL;

	ip = (char*)malloc(16);
	if (ip==NULL) return NULL;
	memset(ip, 0, 16);

	snprintf(ip, 15, "%d.%d.%d.%d", pp[0], pp[1], pp[2], pp[3]);

	return ip;
}




/**
unsigned char*  get_ipaddr_num(struct in_addr sin_addr)

in_addr \̂ IPAhXlD

@param  sin_addr  sockaddr_in \̂ sin_addr oD
@return IPAhX(oCi)ւ̃|C^i4bytejDv free

@code
	struct sockaddr_in addr
	.........;
	ipaddr = get_ipaddr_num(addr.sin_addr); 
@endcode
*/
unsigned char*  get_ipaddr_num(struct in_addr sin_addr)
{
	unsigned char* ip;
	unsigned char* pp;

	ip = (unsigned char*)malloc(4);
	if (ip==NULL) return NULL;

	pp = (unsigned char*)&(sin_addr);
	memcpy(ip, pp, 4);

	return ip;
}




/**
char*  get_ipaddr_byname(char* hostname)

zXg IPAhXlD

@param  hostname zXg
@return IPAhX()ւ̃|C^Dv free
*/
char*  get_ipaddr_byname(char* hostname)
{
	struct hostent *host;
	char* ip;
	unsigned char* pp;

	host = gethostbyname(hostname); 
	if (host==NULL) return NULL;

	ip = (char*)malloc(16);
	if (ip==NULL) return NULL;
	memset(ip, 0, 16);

	pp = (unsigned char*)(host->h_addr);
	snprintf(ip, 15, "%d.%d.%d.%d", pp[0], pp[1], pp[2], pp[3]);

	return ip;
}




/**
char*  get_ipaddr_byname_num(char* hostname)

zXg IPAhXlD

@param  hostname zXg
@return IPAhX(oCi)ւ̃|C^i4bytejDv free
*/
unsigned char*  get_ipaddr_byname_num(char* hostname)
{
	struct hostent *host;
	unsigned char* ip;
	unsigned char* pp;

	host = gethostbyname(hostname); 
	if (host==NULL) return NULL;
	ip = (unsigned char*)malloc(4);
	if (ip==NULL) return NULL;

	pp = (unsigned char*)(host->h_addr);
	memcpy(ip, pp, 4);

	return ip;
}




/**
char*  get_mynetaddr()

̃lbg[NAhXԂ

@return lbg[NAhX()ւ̃|C^Dv free
*/
char*  get_mynetaddr()
{
	char* net;
	unsigned char* pp;

	pp = get_mynetaddr_num();
	if (pp==NULL) return NULL;

	net = (char*)malloc(16);
	if (net==NULL) {
		free(pp);
		return NULL;
	}
	memset(net, 0, 16);

	snprintf(net, 15, "%d.%d.%d.%d", pp[0], pp[1], pp[2], pp[3]);

	free(pp);
	return net;
}




/**
unsigned char*  get_mynetaddr_num()

̃lbg[NAhXԂ

@return lbg[NAhX(oCi)ւ̃|C^i4bytejDv free
*/
unsigned char*  get_mynetaddr_num()
{
	int  i;
	unsigned char* net;
	unsigned char* ip;
	unsigned char* mk;
		
	ip = get_myipaddr_num();
	if (ip==NULL) return NULL;
	mk = &(ip[4]);

	net = (unsigned char*)malloc(4);
	if (net==NULL) {
		free(ip);
		return NULL;
	}

	for (i=0; i<4; i++) net[i] = ip[i] & mk[i];

	free(ip);
	return net;
}




/**


*/
struct sockaddr_in  get_sockaddr(char* hostname, unsigned short cport)
{
	struct sockaddr_in  ss_addr;
	struct hostent *shost;

	// Serveȑ ss_addrɊi[
	shost = gethostbyname(hostname);
	if (shost==NULL) {
		DEBUG_MESG("GET_HOST_INFO: Error: cannot find hostname %s\n", hostname);
		ss_addr.sin_family = 0;
		ss_addr.sin_port   = 0;
		return ss_addr;
	}

	memset(&ss_addr, 0, sizeof(ss_addr));
	ss_addr.sin_family = AF_INET;
	ss_addr.sin_port   = htons(cport);
	memcpy(&(ss_addr.sin_addr), shost->h_addr, shost->h_length);

	return ss_addr;
}




struct sockaddr_in  get_sockaddr_bynum(char* ipnum, unsigned short cport)
{
	struct sockaddr_in  ss_addr;

	memset(&ss_addr, 0, sizeof(ss_addr));
	ss_addr.sin_family = AF_INET;
	ss_addr.sin_port   = htons(cport);
	memcpy(&(ss_addr.sin_addr), ipnum, 4);

	return ss_addr;
}





struct sockaddr_in  get_local_sockaddr(unsigned short cport)
{
	struct sockaddr_in  ss_addr;
	struct hostent *shost;


	// localhost ̏ ss_addrɊi[
	shost = gethostbyname("127.0.0.1");

	memset(&ss_addr, 0, sizeof(ss_addr));
	ss_addr.sin_family = AF_INET;
	ss_addr.sin_port   = htons(cport);
	memcpy(&(ss_addr.sin_addr), shost->h_addr, shost->h_length);

	return ss_addr;
}




/**
int  is_same_sockaddr(struct sockaddr_in addr1, struct sockaddr_in addr2) 

addr1  addr2i[ IPAhXƃ|[gԍǂ

@param  addr1  r sockaddr_in \
@param  addr2  r sockaddr_in \

@retval TRUE   zXg
@retval FALSE  ႤzXg
*/
int  is_same_sockaddr(struct sockaddr_in addr1, struct sockaddr_in addr2) 
{
	int i, len;
	unsigned char *p1, *p2;

	p1  = (unsigned char*)&(addr1.sin_addr);
	p2  = (unsigned char*)&(addr2.sin_addr);
	len = sizeof(addr1.sin_addr);

	for (i=0; i<len; i++) {
		if (p1[i]!=p2[i]) return FALSE;
	}

	p1  = (unsigned char*)&(addr1.sin_port);
	p2  = (unsigned char*)&(addr2.sin_port);
	len = sizeof(addr1.sin_port);

	for (i=0; i<len; i++) {
		if (p1[i]!=p2[i]) return FALSE;
	}

	return TRUE;
}




/**
int  is_same_network_num(unsigned char* addr1, unsigned char* addr2, unsigned char* mask)

^AhX addr1  addr2lbg[NɑĂ邩ǂ`FbND

@param  addr1  rAhXi^j4Byte
@param  addr2  rAhXi^j4Byte
@param  mask   lbg}XNi^j4Byte

@retval TRUE   lbg[NłD
@retval FALSE  lbg[NłȂ
*/
int  is_same_network_num(unsigned char* addr1, unsigned char* addr2, unsigned char* mask)
{
	int i;

	if (addr1==NULL || addr2==NULL) return FALSE;

	if (mask==NULL) {
		for (i=0; i<4; i++) {
			if (addr1[i] != addr2[i]) return FALSE;
		}
	}
	else {
		for (i=0; i<4; i++) {
			if ((addr1[i]&mask[i]) != (addr2[i]&mask[i])) return FALSE;
		}
	}
	return TRUE;
}




/**
int  is_same_network(char* addr1, char* addr2, char* mask)

^AhX addr1  addr2lbg[NɑĂ邩ǂ`FbND@n
addr1, addr2  FQDNłD

@param  addr1  rAhXi^j
@param  addr2  rAhXi^j
@param  mask   lbg}XNi^j

@retval TRUE   lbg[NłD
@retval FALSE  lbg[NłȂD
*/
int  is_same_network(char* addr1, char* addr2, char* mask)
{
	int  ret;
	unsigned char* a1;
	unsigned char* a2;
	unsigned char* mk;

	if (addr1==NULL || addr2==NULL || mask==NULL) return FALSE;

	a1 = to_address_num4(addr1, 1);
	a2 = to_address_num4(addr2, 1);
	mk = to_address_num4(mask,  0);
	if (a1==NULL || a2==NULL || mk==NULL) {
		freeNull(a1);
		freeNull(a2);
		freeNull(mk);
		return FALSE;
	}

	ret = is_same_network_num(a1, a2, mk);
	freeNull(a1);
	freeNull(a2);
	freeNull(mk);
	
	return TRUE;
}




/**
unsigned char*  to_address_num8(char* addr, int mode)

^̃AhX [IPAhX]/[lbg}XN] (F202.26.159.140/255.255.255.0j
^̃AhXiunsigned char* num[8]j8Byte ֕ϊD

ȗꂽꏊ 0Ƃ݂ȂiF202.26/255  202.26.0.0/255.0.0.0j @n
lbg}XNŜȗꂽꍇ IPAhXɈˑD(202.26.  202.26.0.0/255.255.0.0) @n
CIDER`ɂΉDClbg}XN̑Ó̓`FbNȂD

@param  addr ϊ镶^IPAhX
@param  mode @b 0:     IPAhXȊỐipj NULL ԂD
@param  mode @b 0ȊO: FQDNIPAhXɕϊĕԂiԂj

@return [IPAhX],[lbg}XN] ̒8bytẽoCiDv free
*/
unsigned char*  to_address_num8(char* addr, int mode)
{
	unsigned char* num;
	char* ps;
	char* pc;
	char* uc = NULL;
	int   i;

	if (addr==NULL) return NULL;

	num = (unsigned char*)malloc(8);
	if (num==NULL) return NULL;
	memset(num, 0, 8);


	// IPAhX̕ϊ
 	ps = awk(addr, '/', 1);
	if (ps==NULL) {
		free(num);
		return NULL;
	}

	i = (int)strlen(ps) - 1;
	while (i>0 && ps[i]=='.') i--;
	if (i>0) {
		if (isalpha(ps[i])) {
			if (mode==0) { // mode==0Ȃ FQDN->IPAhX ͍sȂȂD
				free(num);
				free(ps);
				return NULL;
			}
			uc = (char*)get_ipaddr_byname_num(ps);
			if (uc==NULL) {
				free(num);
				free(ps);
				return NULL;
			}
		}
	}

	if (uc==NULL) { 						// IPAhX\L̏	
		for (i=0; i<4; i++) {
			pc = awk(ps, '.', i+1);
			if (pc==NULL) break;
			num[i] = (unsigned char)atoi(pc);
			free(pc);
		}
	}
	else { 									// zXg\L̏
		for (i=0; i<4; i++) num[i] = uc[i];
		free(uc);
	}
	free(ps);


 	ps = awk(addr, '/', 2);

	// Tulbg}XNȗꂽꍇ̏
	if (ps==NULL) {
		int f = OFF;
		for (i=3; i>=0; i--) {
			if (num[i]!=0 || f==ON) {
				num[i+4] = 0xff;
				f = ON;
			}
			else {
				num[i+4] = 0;
			}
		}
		return num;
	}


	// Tulbg}XN̏
	for (i=0; i<4; i++) {
		pc = awk(ps, '.', i+1);
		if (pc==NULL) break;
		num[i+4] = (unsigned char)atoi(pc);
		free(pc);
	}
	free(ps);


	// CIDER`Ή
	if (num[4]<=32 && num[5]==0 && num[6]==0 && num[7]==0) {
		int nn, cl = (int)num[4];
		for (i=0; i<4; i++) {
			nn = 8 - Max(0, Min(8, cl-8*i));
			num[i+4] = 0xff<<nn;
		}
	}

	return  num;
}




/**
char*  to_address_char8(unsigned char* n)

^ IPAhX n 8Byte𕶎^́@[IPAhX]/[lbg}XN]@ɕϊD

n ͕Klbg}XN̏܂݁C 8BytełȂƂȂD8Byte菭Ȃꍇ
炭ZOe[VG[ND@n
to_address_num()Ƒ΂ŎĝSD

@param  n   8byte oCi [IPAhX],[lbg}XN]
@return [IPAhX]/[lbg}XN] `̕Dv free

@see to_address_num()
*/
char*  to_address_char8(unsigned char* n)
{
	char* addr;
	if (n==NULL) return NULL;

	addr = (char*)malloc(32);
	if (addr==NULL) return NULL;
	memset(addr, 0, 32);

	snprintf(addr, 31, "%d.%d.%d.%d/%d.%d.%d.%d", n[0], n[1], n[2], n[3], n[4], n[5], n[6], n[7]);

	return addr;
}




/**
unsigned char*  to_address_num4(char* addr, int mode)

^̃AhX [IPAhX] (F202.26.159.140j
^̃AhXiunsigned char* num[4]j4Byte ֕ϊD

ȗꂽꏊ 0Ƃ݂ȂiF202.26  202.26.0.0j

@param  addr  ϊ镶^IPAhX
@param  mode  @b 0:     IPAhXȊỐipj NULL ԂD
@param  mode  @b 0ȊO: FQDNIPAhXɕϊĕԂiԂj

@return [IPAhX] ̒4bytẽoCiDv free
*/
unsigned char*  to_address_num4(char* addr, int mode)
{
	unsigned char* num;
	char* pc;
	char* uc = NULL;
	int   i;

	if (addr==NULL) return NULL;

	num = (unsigned char*)malloc(4);
	if (num==NULL) return NULL;
	memset(num, 0, 4);


	// IPAhX̕ϊ
	i = (int)strlen(addr) - 1;
	while (i>0 && addr[i]=='.') i--;
	if (i>0) {
		if (isalpha(addr[i])) {
			if (mode==0) { // mode==0Ȃ FQDN->IPAhX ͍sȂȂD
				free(num);
				return NULL;
			}
			uc = (char*)get_ipaddr_byname_num(addr);
			if (uc==NULL) {
				free(num);
				return NULL;
			}
		}
	}

	if (uc==NULL) { 						// IPAhX\L̏	
		for (i=0; i<4; i++) {
			pc = awk(addr, '.', i+1);
			if (pc==NULL) break;
			num[i] = (unsigned char)atoi(pc);
			free(pc);
		}
	}
	else { 									// zXg\L̏
		for (i=0; i<4; i++) num[i] = uc[i];
		free(uc);
	}

	return  num;
}




/**
char*  to_address_char4(unsigned char* n)

^ IPAhX n 4Byte𕶎^ [IPAhX] ɕϊD

n ͕K 4BytełȂƂȂD4Byte菭Ȃꍇ͋炭ZOe[VG[ND@n
to_address_num4()Ƒ΂ŎĝSD

@param  n   4bytẽoCi [IPAhX]
@return [IPAhX] `̕Dv free

@see to_address_num4()
*/
char*  to_address_char4(unsigned char* n)
{
	char* addr;
	if (n==NULL) return NULL;

	addr = (char*)malloc(16);
	if (addr==NULL) return NULL;
	memset(addr, 0, 16);

	snprintf(addr, 15, "%d.%d.%d.%d", n[0], n[1], n[2], n[3]);

	return addr;
}




/**
int   recv_wait(int sock, int tm)

Ȉ Mwait. \PbgɃf[^M܂ő҂DXbhΉ

@param  sock  Ď\Pbg
@param  tm    ^CAEg̕b

@retval ^    obt@Ƀf[^D
@retval U    ^CAEgD
*/
int   recv_wait(int sock, int tm)
{
	int    nd;
	fd_set mask;
	struct timeval timeout;
	time_t otm, ntm;

	otm = time(NULL);
	do {
		timeout.tv_sec  = tm;
		timeout.tv_usec = 0;
		FD_ZERO(&mask);
		FD_SET(sock, &mask);

		//DEBUG_MESG("Waiting sock = %d for %ds.\n", sock, tm);
		nd  = select(sock+1, &mask, NULL, NULL, &timeout);
		ntm = time(NULL);
	} while ((nd<0 || !FD_ISSET(sock, &mask)) && (int)(ntm-otm)<=tm);

	return FD_ISSET(sock, &mask); 	
}




int   recv_wait_twin(int sock1, int sock2, int tm)
{
	int	   ret = 0;
	int    nm, nd;
	fd_set mask;
	struct timeval timeout;
	time_t otm, ntm;

	nm  = Max(sock1, sock2);
	otm = time(NULL);
	do {
		timeout.tv_sec  = tm;
		timeout.tv_usec = 0;
		FD_ZERO(&mask);
		FD_SET(sock1, &mask);
		FD_SET(sock2, &mask);
		nd  = select(nm+1, &mask, NULL, NULL, &timeout);
		ntm = time(NULL);
	} while ((nd<0 || (!FD_ISSET(sock1, &mask) && !FD_ISSET(sock2, &mask))) && (int)(ntm-otm)<=tm);


	if (FD_ISSET(sock1, &mask)) ret += 1;
	if (FD_ISSET(sock2, &mask)) ret += 2;

	return ret;
}




/**
int   send_wait(int sock, int tm)

Ȉ Mwait. f[^M\ɂȂ܂ő҂DXbhΉ

@param  sock Ď\Pbg
@param  tm	 ^CAEg̕b

@retval ^   obt@Ƀf[^D
@retval U   ^CAEgD
*/
int   send_wait(int sock, int tm)
{
	int    nd;
	fd_set mask;
	struct timeval timeout;
	time_t otm, ntm;

	otm = time(NULL);
	do {
		timeout.tv_sec  = tm;
		timeout.tv_usec = 0;
		FD_ZERO(&mask);
		FD_SET(sock, &mask);

		//DEBUG_MESG("Waiting sock = %d for %ds.\n", sock, tm);
		nd  = select(sock+1, NULL, &mask, NULL, &timeout);
		ntm = time(NULL);
	} while ((nd<0 || !FD_ISSET(sock, &mask)) && (int)(ntm-otm)<=tm);

	return FD_ISSET(sock, &mask); 	
}




/**
void  udp_hole_punching(int sock, struct sockaddr_in addr, int nm)

sock gāCaddr nmoCg NULLf[^𑗐MD

@param  sock \PbgLqq
@param  addr ̃zXg̏񂪊i[ sockaddr_in \
@param  nm   Mf[^(NULL)̒
*/
void  udp_hole_punching(int sock, struct sockaddr_in addr, int nm)
{
	char data[LBUF];

	if (nm<=0) nm = 4;				// for SLVoice
	else if (nm>LBUF) nm = LBUF;

	memset(data, 0, nm);
	udp_send(sock, data, nm, &addr);

	return;
}








////////////////////////////////////////////////////////////////////////////////////////
// get_valid_..._socket
//

int  get_valid_udp_socket(int min, int max, unsigned short* port)
{
	int  i, sock, range;

	range = max - min + 1;
	*port = rand()%range + min;

	i = 1;
	sock = udp_server_socket((int)*port);
	while(sock<=0 && i<range) {
		(*port)++;
		if (*port>max) *port = ((int)*port)%max + min - 1;
		sock = udp_server_socket((int)*port);
		i++;
	}

	if (sock<=0) *port = 0;

	return sock;
}




int  get_valid_tcp_server_socket(int min, int max, unsigned short* port)
{
	int  i, sock, range;

	range = max - min + 1;
	*port = rand()%range + min;

	i = 1;
	sock = tcp_server_socket((int)*port);
	while(sock<=0 && i<range) {
		(*port)++;
		if (*port>max) *port = ((int)*port)%max + min - 1;
		sock = tcp_server_socket((int)*port);
		i++;
	}

	if (sock<=0) *port = 0;

	return sock;
}




int  get_valid_tcp_client_socket(int min, int max, char* hname, unsigned short sport, unsigned short* cport)
{
	int  i, sock, range;

	range  = max - min + 1;
	*cport = rand()%range + min;

	i = 1;
	sock = tcp_client_bind_socket(hname, (int)sport, (int)*cport);
	while(sock<0 && i<range) {
		(*cport)++;
		if (*cport>max) *cport = ((int)*cport)%max + min - 1;
		sock = tcp_client_bind_socket(hname, (int)sport, (int)*cport);
		i++;
	}

	if (sock<=0) *cport = 0;

	return sock;
}





//////////////////////////////////////////////////////////////////////////////////
//
// for WinSock
//

#ifdef WIN32
	WSADATA WsaData;
#endif


int  init_network(void)
{
	int ret = 0;

#ifdef WIN32
	ret = WSAStartup(MAKEWORD(2,0), &WsaData);
	if (ret!=0) WSACleanup();
#endif

	return  ret;
}



void  cleanup_network(void)
{
#ifdef WIN32
	WSACleanup();
#endif
}

