/* vim: set tabstop=4 paste nocindent noautoindent ff=unix: */


/** 
@brief   ėpgc[vO 
@file    xtools.c
@version 1.1
@author  Fumi.Iseki (C)
@date    2009 2/13

@par e
ɁCBuffer^, tList^ƃlbg[ÑCu@n
őɎgȂǁCΕ֗Ȋ֐D

@see Buffer, _tList
*/


#include "xtools.h"





//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Networks
//

/**
int  udp_recv_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)

recvform()bsO֐DUDPf[^MD

@param  sock	 \PbgLqq
@param  str	     MpbZ[Wobt@ւ̃|C^D\߃obt@mۂĂD
@param  sv_addr  T[ȍ񂪊i[ꂽ sockaddar_in \̂ւ̃|C^D
 
@return Mɍs΂̃oCgD s-1ԂD

@see recvform()
*/
int  udp_recv_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)
{
	int cc, cadlen;

	cadlen = sizeof(*sv_addr);
	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;
	cc = recvfrom(sock, (char*)str->buf, str->bufsz, 0, (struct sockaddr*)sv_addr, (socklen_t*)&cadlen);
	if (cc>=0) str->vldsz = cc;

	return cc;
}



/**
int  udp_send_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)

sendto() bsO֐DUDPoRŃf[^𑗂D

@param  sock     \PbgLqq
@param  str	     Mf[^
@param  sv_addr  T[ȍi[ sockaddar_in \̂ւ̃|C^D

@return Mɍs΂̃oCgD s-1ԂD

@see sendto()
*/
int  udp_send_Buffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)
{
	int cc;
	
	if (str->vldsz<0) str->vldsz = (int)strlen((const char*)str->buf);
	cc = sendto(sock, (char*)str->buf, str->vldsz, 0, (struct sockaddr*)sv_addr, sizeof(*sv_addr));

	return cc;
}



/**
int  tcp_recv_Buffer(int sock, Buffer* str)

TCPoRŃf[^MDobt@OȂD

@param  sock  \PbgLqq
@param  str	  MpbZ[Wobt@ւ̃|C^D\߃obt@mۂĂD

@return Mɍs΂̃oCgDs-1ԂD
*/
int  tcp_recv_Buffer(int sock, Buffer* str)
{
	int cc;

	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;
	cc = recv(sock, (char*)str->buf, str->bufsz, 0);
	if (cc>=0) str->vldsz = cc;
	return cc;
}



/**
int  tcp_send_Buffer(int sock, Buffer* str)

TCPoRŃf[^𑗐MD

@param  sock  \PbgLqq
@param  str	  Mpf[^obt@D

@return ꍇ͂̑MoCgDsꍇɂ-1Ԃ (send()̖߂l)D
*/
int  tcp_send_Buffer(int sock, Buffer* str)
{
	int cc;

	if (str->vldsz<0) str->vldsz = (int)strlen((const char*)str->buf);
	cc = send(sock, (char*)str->buf, str->vldsz, 0);
	return cc;
}



/**
int  udp_send_sBuffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)

UDPoRŕf[^𑗂D

@param  sock     \PbgLqq
@param  str	     Mf[^
@param  sv_addr  T[ȍi[ sockaddar_in \̂ւ̃|C^D

@return Mɍs΂̃oCgDs-1ԂD
*/
int  udp_send_sBuffer(int sock, Buffer* str, struct sockaddr_in* sv_addr)
{
	int cc;
	
	cc = sendto(sock, (char*)str->buf, (int)strlen((const char*)str->buf), 0, (struct sockaddr*)sv_addr, sizeof(*sv_addr));
	return cc;
}



/**
int  tcp_recv_Buffer_wait(int sock, Buffer* str, int tm)

TCPoRŕf[^MD

^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, recv_wait()֐Ăяo_
ǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D

@param  sock    \PbgLqq
@param  str	    MpbZ[Wobt@ւ̃|C^D\߃obt@mۂĂD
@param  tm      ^CAEgԁDbPʁD

@retval  1ȏ  MꂽoCgD
@retval	 0      MG[D炭͑葤ZbVN[YD
@retval	-1      MG[D
@retval	RECV_TIMEOUTED ^CAEgD
*/
int  tcp_recv_Buffer_wait(int sock, Buffer* str, int tm)
{
	int cc;

	str->vldsz = 0;
	cc = tcp_recv_wait(sock, (char*)str->buf, str->bufsz, tm);
	if (cc>=0) str->vldsz = cc;

	return cc;
}



/**
int  udp_recv_Buffer_wait(int sock, Buffer* str, struct sockaddr_in* sv_addr, int tm)

UDPoRŕf[^MD

^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, recv_wait()֐Ăяo_œǂݍ݉\f[^Ȃ΂Ƀ^CAEg
ƂȂ (RECV_TIMEOUTED Ԃ)D

@param 	sock	 \PbgLqq
@param 	str	     MpbZ[Wobt@D\߃mۂĂD
@param  sv_addr  T[ȍ񂪊i[ꂽ sockaddar_in \̂ւ̃|C^D
@param  tm       ^CAEgԁDbPʁD
 
@retval  0ȏ   MoCgD
@retval -1       MsD
@retval	RECV_TIMEOUTED	^CAEgD
*/
int  udp_recv_Buffer_wait(int sock, Buffer* str, struct sockaddr_in* sv_addr, int tm)
{
	int cc;

	str->vldsz = 0;
	cc = udp_recv_wait(sock, (char*)str->buf, str->bufsz, sv_addr, tm);
	if (cc>=0) str->vldsz = cc;

	return cc;
}



/**
int  tcp_send_sBuffer(int sock, Buffer* str)

TCPoRŕf[^𑗐MD

@param  sock    \PbgLqq
@param  str     Mpf[^obt@D

@retval  0ȏ  MoCgD
@retval -1      s (send()̖߂l)D
*/
int  tcp_send_sBuffer(int sock, Buffer* str)
{
	int cc;

	cc = send(sock, (char*)str->buf, (int)strlen((const char*)str->buf), 0);
	return cc;
}



/**
int  tcp_send_sBufferln(int sock, Buffer* str)

TCPbZ[W()ɉs(@\r@\n)tđMD

@param  sock    \PbgLqq
@param  str     MpbZ[Wobt@D

@retval  0ȏ  MoCgis܂ށjD
@retval - 1     s (send()̖߂l)D
*/
int  tcp_send_sBufferln(int sock, Buffer* str)
{
	int   cc;
	Buffer buf;

   	buf = dup_Buffer(*str);
	cat_s2Buffer("\r\n", &buf);
	cc = send(sock, (char*)buf.buf, (int)strlen((const char*)buf.buf), 0);
	free_Buffer(&buf);

	return cc;
}



/**
int  tcp_recv_mstreamBuffer(int sock, Buffer* mesg, mstream* sb, int tm)

TCPoRŃbZ[W()MD

MbZ[W̓bZ[WXg[ ɈUobt@OC̊֐ɂsǂݏoD
mesgɊi[鎞Cs̉sR[h͍폜Csɂ͕K \0 D

^CAEg̐ݒ肪\Ń^CAEg 0w肵ꍇ, Ăяo_
ǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D
bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_ŊmۂD

Ů֐gpāCMf[^obt@OC\Pbg
N[Y܂ŁCǂݎɂ͕KXg[gpĂ̊֐Ăяo΂΂ȂȂD
Ŗꍇ͎Mf[^͕̐ۏ؂ȂD

@param 	sock    \PbgLqq
@param 	mesg    Mpf[^obt@Dobt@mۂKv͂ȂD
@param 	sb 	    bZ[Wobt@iO^̃Xg[obt@j
                obt@mۂĂȂ΁CIɊmۂD
@param 	tm	    ^CAEgԁDbPʁD

@retval  1ȏ  mesgɊi[bZ[W̃oCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2       NULL̃f[^D
@retval -3      bZ[Wobt@̂Ŋmۂ悤ƂCmۂɎsD
@retval -4      bZ[Wobt@Ƀf[^݂͑͂Cs̗RɂlɎsD
@retval RECV_TIMEOUTED  ^CAEgD
*/
int  tcp_recv_mstreamBuffer(int sock, Buffer* mesg, mstream* sb, int tm)
{
    int    cc;
	unsigned char* pp;

    if (mesg==NULL || sb==NULL) return -2;
	*mesg = make_Buffer(LBUF);

    if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

    while (sb->datano==0) {
        cc = tcp_recv_Buffer_wait(sock, mesg, tm);
        if (cc<=0) {
			free_Buffer(mesg);
			return cc;
		}
        put_mstream(sb, mesg->buf);
		clear_Buffer(mesg);
    }

    pp = get_mstream(sb);
    if (pp==NULL) return -4;
	copy_s2Buffer((char*)pp, mesg);
    free(pp);

    return mesg->vldsz;
}



/**
int  tcp_recv_linesBuffer(int sock, Buffer* mesg, int tm)

TCPoRŃbZ[W()MD

si\nŏI邱Ƃۏ؂j̃f[^oƂ̂łȈՃobt@@\tD
炳Ɉs̃f[^oɂ́Cget_line() ȂǂgpD@n
܂Clbg[N蒼ڈsÂoɂ́Ctcp_recv_mstreamBuffer() gقǂD

@param  sock    \PbgLqq
@param  mesg    Mpf[^obt@D\߃mۂĂD
@param 	tm      ^CAEgԁDbPʁD

@retval  1ȏ  MꂽoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2      bufNULL
@retval RECV_TIMEOUTED^CAEgD

@bug Mf[^K LFŏI邱ƂۏႳĂꍇɂgpłȂD
     ܂ėpIɂ́ugȂv

*/
int  tcp_recv_linesBuffer(int sock, Buffer* mesg, int tm)
{
	int    cc;
	Buffer buf;

	if (mesg==NULL) return -2;
	buf = make_Buffer(LBUF);

	cc = tcp_recv_Buffer_wait(sock, &buf, tm);
	while (cc>0) {
		cat_Buffer(&buf, mesg);
		if (buf.buf[cc-1]==CHAR_LF) break;
		clear_Buffer(&buf);
		cc = tcp_recv_Buffer_wait(sock, &buf, tm);
	}
	free_Buffer(&buf);
		
	if (cc<=0) {
		free_Buffer(mesg);
		return cc;
	}

	return mesg->vldsz;
}



/**
Buffer  comp_hostport(char* host, unsigned short port)

zXgƃ|[gԍC"zXg:|[gԍ" ̕𐶐D

@param  host  zXgC܂IPAhX
@param  port  |[gԍ

@return "zXg:|[gԍ" ̕񂪊i[ꂽobt@^f[^D
*/
Buffer  comp_hostport(char* host, unsigned short port)
{
	Buffer buf;
	char   hostport[LBUF];

	hostport[0] = '\0';

	if (host!=NULL) {
		if (port!=0) snprintf(hostport, LBUF-1, "%s:%d", host, port);
		else         snprintf(hostport, LBUF-1, "%s", host);
	}
	else {
		if (port!=0) snprintf(hostport, LBUF-1, "%d", port);
	}

	buf = make_Buffer_bystr(hostport);

	return buf;
}



/**
int    decomp_hostport(Buffer buf, Buffer* host, unsigned short* port)

"zXg:|[gԍ" `̕񂩂CzXgƃ|[gԍ𕪗D

@param      buf   "zXg:|[gԍ" `̓̕Bufferf[^
@param[out] host  "zXg" i[ĕԂD
@param[out] port  |[gԍ i[ĕԂD

@retval TRUE      
@retval FALSE     s
*/
int    decomp_hostport(Buffer buf, Buffer* host, unsigned short* port)
{
	if (buf.buf==NULL) return FALSE;

	if (port!=NULL) {
		int i = 0;
		while (buf.buf[i]!='\0' && buf.buf[i]!=':') i++;
		if (buf.buf[i]!='\0') *port = (unsigned short)atoi((char*)&buf.buf[i+1]);
		else *port = 0;
	}

	if (host!=NULL) {
		Buffer hostport = dup_Buffer(buf);
	
		int i = 0;
		while (hostport.buf[i]!='\0' && hostport.buf[i]!=':') i++;
		hostport.buf[i] = '\0';
		hostport.vldsz  = (int)strlen((char*)hostport.buf);
		*host = hostport;
	}

	return TRUE;
}



/**
Buffer   comp_url(char* protocol, char* host, unsigned short port, char* dir)

"vgR://zXg:|[gԍ/fBNg" ̕𐶐D

@param  protocol  vgR
@param  host      zXg
@param  port      |[gԍ
@param  dir       fBNg

@return "vgR://zXg:|[gԍ/fBNg" ̕񂪊i[ꂽobt@^f[^D
*/
Buffer   comp_url(char* protocol, char* host, unsigned short port, char* dir)
{
	Buffer url;
	char   num[20];

	url = make_Buffer(LNAME);

	if (protocol!=NULL) {
		copy_s2Buffer(protocol, &url);
		cat_s2Buffer("://", &url);
	}

	cat_s2Buffer(host, &url);

	if (port!=0) {
		snprintf(num, 10, ":%d", port);
		cat_s2Buffer(num, &url);
	}

	if (dir!=NULL) {
		if (dir[0]!='/') cat_s2Buffer("/", &url);
		cat_s2Buffer(dir, &url);
	}

	return url;
}



/**
int   decomp_url(Buffer url, Buffer* srvurl, Buffer* protocol, Buffer* srvfqdn, unsigned short* sport, Buffer* srvdir)

URL𕪉D

łURĽ`
- protocol://www.xxx.yyy.zzz:80/AA/BB
- www.xxx.yyy.zzz:80/AA/BB

KvȂɂ NULLw\D

@param url URL̓ BufferϐD
       url  https://AAA.BBB.CCC:80/xxx/yyy/zzz ̏ꍇ
@param[out] srvurl    https://AAA.BBB.CCC:80   v free
@param[out]	protocol  https                    v free
@param[out]	srvfqdn   AAA.BBB.CCC              v free
@param[out]	sport     80
@param[out]	srvdir    /xxx/yyy/zzz             v free

@retval	TRUE   𐬌
@retval FALSE  s
*/
int   decomp_url(Buffer url, Buffer* srvurl, Buffer* protocol, Buffer* srvfqdn, unsigned short* sport, Buffer* srvdir)
{
	Buffer item1, item2, item3, item4, wrk;

	if (srvurl  !=NULL) *srvurl   = init_Buffer();
	if (protocol!=NULL) *protocol = init_Buffer();
	if (srvfqdn !=NULL) *srvfqdn  = init_Buffer();
	if (srvdir  !=NULL) *srvdir   = init_Buffer();
	if (sport   !=NULL) *sport    = 0;
	if (url.buf ==NULL) return FALSE;

	item1 = init_Buffer();
	item2 = init_Buffer();
	item3 = init_Buffer();
	item4 = init_Buffer();
	 
	if (strstr((char*)url.buf, "://")!=NULL) {
		// http(s)://www.tuis.ac.jp:8100/..... 
		item1 = awk_Buffer(url, '/', 1);	// http(s):
		item2 = awk_Buffer(url, '/', 3);	// www.tuis.ac.jp:8100
		if (protocol!=NULL) {
			*protocol = dup_Buffer(item1);
			protocol->buf[protocol->vldsz-1] = '\0';
			protocol->vldsz--;
		}
	}
	else {
		// www.tuis.ac.jp:8100/..... 
		item2 = awk_Buffer(url, '/', 1);	// www.tuis.ac.jp:8100
	}

	if (item2.buf!=NULL) {
		item3 = awk_Buffer(item2, ':', 1);  // www.tuis.ac.jp
		if (item3.buf==NULL) {
			free_Buffer(&item1);
			free_Buffer(&item2);
			return FALSE;
		}
		item4 = awk_Buffer(item2, ':', 2);  // 8100
	}
	else {
		free_Buffer(&item1);
		return FALSE;
	}
	 

	if (item4.buf!=NULL && sport!=NULL) {
		*sport = (unsigned short)atoi((char*)item4.buf);
	}
	 
	wrk = make_Buffer(LBUF);
	if (item1.buf!=NULL) {
		copy_Buffer(&item1, &wrk);
		cat_s2Buffer("//",  &wrk);
	}
	cat_Buffer(&item2,  &wrk);

	if (item3.buf!=NULL) {
		if (srvfqdn!=NULL) *srvfqdn = item3;
		else free_Buffer(&item3);
	}
	 
	if (srvdir!=NULL) {
		*srvdir = make_Buffer_bystr((char*)(url.buf+strlen((char*)(wrk.buf))));
		if ((srvdir->buf)[0]=='\0') copy_s2Buffer("/", srvdir);
	}

	if (srvurl!=NULL) *srvurl = wrk;
	else free_Buffer(&wrk);


	free_Buffer(&item1);
	free_Buffer(&item2);
	free_Buffer(&item4);
	 
	return TRUE;
}										   



/**
struct sockaddr_in  get_sockaddr_Buffer(Buffer buf)

FQDN:port ܂ IPaddress:port ̌` Bufferϐ \Pbg𓾂D@n
get_sockaddr() (in network.c)  Buffer

@param  buf  "FQDN:|[gԍ" ܂ "IPAhX:|[gԍ" `̃f[^D
@return sockaddr_in \̌^̃\Pbg

@see get_sockaddr()
*/
struct sockaddr_in  get_sockaddr_Buffer(Buffer buf)
{
	int i, port = 0;
	struct sockaddr_in  addr;
	memset(&addr, 0, sizeof(struct sockaddr_in));

	if (buf.buf==NULL) return addr;
	
	i = 0;
	while (buf.buf[i]!='\0' && buf.buf[i]!=':') i++;
	buf.buf[i] = '\0';

	port = atoi((char*)&buf.buf[i+1]);
	addr = get_sockaddr((char*)buf.buf, port);

	return addr;
}



Buffer get_hostport_sockaddr(struct sockaddr_in addr)
{
	Buffer buf;
	char  hostport[LBUF];
	char* ip = get_ipaddr(addr.sin_addr);
    unsigned short port = ntohs(addr.sin_port);

	snprintf(hostport, LBUF, "%s:%d", ip, port);
	
	buf = make_Buffer_bystr(hostport);
	return buf;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// File I/O 
//

/**
int   save_taggedBuffer(Buffer buf, FILE* fp, unsigned int mode, int prfm)

Bufferw肳ꂽ`ɏ]ă^OtŃt@CɕۑD

@param  buf    ۑD
@param  fp     t@C|C^D
@param  mode   ۑf[^̎ʂƕۑ@ FBRTL_ }NŎw肷D
               Cۑ@݂͌̂Ƃ @b FBRTL_ORIGINAL, @b FBRTL_BASE64 ̂݃T|[gD
@param  prfm   ۑ@ @b FBRTL_ORIGINAL ȊOw肵ꍇČ`ɕϊ邩ǂw肷D
               ̊֐OŁCɕϊĂꍇ FALSE w肷D
               (TERUE: ϊD FALSE: ϊȂ)

@retval TRUE   D
@retval FALSE  sDt@C̓e͕ۏ؂ȂD

@attention ǂǂ̌`ŕۑ邩́CvO}ۏ؂Ȃ΂ȂȂD
           ł邾f[^`w肷ׂłD

QlF
@code
tag@	tag.buf[0]  ۑf[^̎
		tag.buf[1]  ۑ`@@		FBRTL_ORIGINAL, FBRTL_BASE64 T|[g
@endcode

@see  xtool.h
*/
int   save_taggedBuffer(Buffer buf, FILE* fp, unsigned int mode, int prfm)
{	
	int	    cc;
	Buffer  tag, enc;

	tag = make_Buffer(2);
	if (tag.buf==NULL) return FALSE;
	tag.buf[0] = mode & 0x0f;			// f[^̎
	tag.buf[1] = mode & 0xf0;			// f[^̌`

	// FBRTL_ORIGINAL, FBRTL_BASE64 ȊO͖T|[g
	if (tag.buf[1]==FBRTL_ORIGINAL || !prfm) {
		enc = dup_Buffer(buf);
	}
	else if (tag.buf[1]==FBRTL_BASE64) {
		enc = encode_base64_Buffer(buf);
	}
	else {							
		enc = dup_Buffer(buf);
	}

	tag.vldsz = 2;
	cc = save_Buffer2_fp(tag, enc, fp); 
	free_Buffer(&enc);
	free_Buffer(&tag);

	if (!cc) return FALSE;
	return  TRUE;
}



/**
Buffer   read_taggedBuffer(FILE* fp, unsigned int* mode)

Buffer^Oɏ]ăt@CǂݍށD

@param      fp    t@C|C^D
@param[in]  mode  ǂݏof[^̎ʂƓǂݏõf[^` FBRTL_ }NŎw肷D
                  ۑĂf[^Ɠǂݏof[^̎ʂvȂꍇ́Cf[^ԂȂD
                  C@b FBRTL_ANY w肵ꍇ͈vȂƂf[^ԂD
@param[out] mode  ǂݏõf[^`݂͌̂Ƃ @b FBRTL_ORIGINAL, @b FBRTL_BASE64 ̂݃T|[gD
                  ^[ɁCۑĂf[^̎ʂ̂ FBRTL_ }NŊi[D

@retval TRUE      D
@retval FALSE     sD

@attention f[^`CFBRTL_ORIGINAL, FBRTL_BIN, FBRTL_DERŕۑĂꍇ́C̃f[^`
           ΂Čǂ̓vO}ӔCȂ΂ȂȂD

QlF  
@code
tag@	tag.buf[0]  ۑf[^̎
		tag.buf[1]  ۑ`@@		FBRTL_ORIGINAL, FBRTL_BASE64 T|[g
@endcode

@see  xtool.h
*/
Buffer   read_taggedBuffer(FILE* fp, unsigned int* mode)
{	
	unsigned char mthd, kind;
	Buffer   tmp, tag, enc, buf;

	buf = init_Buffer();
	if (mode==NULL) return buf;

	if (!read_Buffer2_fp(&tag, &enc, fp)) return buf;

	kind = *mode & 0x0f;				// f[^̎
	mthd = *mode & 0xf0;				// f[^̌`
	if (kind!=tag.buf[0] && kind!=FBRTL_ANY) {
		free_Buffer(&enc);
		free_Buffer(&tag);
		return buf;
	}

	// FBRTL_ORIGINAL, FBRTL_BASE64 ȊO͖T|[g
	if (mthd==tag.buf[1]) {				// ۑ`ƌĂяo`͓
		buf = dup_Buffer(enc);
	}
	else {
		// ۑf[^IWi
		if (tag.buf[1]==FBRTL_BASE64) {
			tmp = decode_base64_Buffer(enc);
		}
		else {
			tmp = dup_Buffer(enc);
		}

		// IWiĂяo`
		if (mthd==FBRTL_BASE64) {
			buf = encode_base64_Buffer(tmp);
		}
		else {
			buf = dup_Buffer(tmp);
		}
		free_Buffer(&tmp);
	}

	*mode = (unsigned int)tag.buf[0];	// f[^
	free_Buffer(&enc);
	free_Buffer(&tag);

	return  buf;
}



/**
Buffer  fgets_mstreamBuffer(Buffer buf, mstream* sb)

bZ[W buf.buf ̓bZ[WXg[ɈUobt@OC̊֐ɂsǂݏoD@n
ʂԂ鎞Cs̉sR[h͍폜Csɂ͕K @\0 D

bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_ŊmۂD@n
Ů֐gpāCMf[^obt@OCŌ܂œǂݎɂ
KXg[gpĂ̊֐Ăяo΂΂ȂȂDŖꍇ͎Mf[^
͕̐ۏ؂ȂD

@param      buf  obt@ɈUi[郁bZ[W̓Buffer^ϐDbuf.bufNULLłD
@param[in]  sb   Xg[obt@iOobt@^̃Xg[obt@jDobt@mۂĂȂ΁CIɊmۂD
@param[out] sb   @b state -1: bZ[WXg[쒆ɃG[D 1: bZ[WXg[ɗLȃf[^ȂDreturn  NULL

@return oւ̃|C^
*/
Buffer  fgets_mstreamBuffer(Buffer buf, mstream* sb)
{
	Buffer   ret;
	unsigned char* pp;

	ret = init_Buffer();

	pp = fgets_mstream(buf.buf, sb);
	if (pp!=NULL) {
		ret = make_Buffer(LBUF);
		copy_s2Buffer((char*)pp, &ret);
		free(pp);
	}
	return ret;
}





/////////////////////////////////////////////////////////////////////////////////////////////////
//
// Run Length
//

/**
int  get_runlength_byte(unsigned char* buf, int len, int pos)

kĂȂԂ pos(Byte)̈ʒuC0̘AkĂf[^ł͂ǂ̈ʒuɗ邩vZD

@param  buf     Ak(0)ĂoCif[^
@param  len     buf ̒
@param  pos     kĂȂꍇ̈ʒuD

@return  0ȏ  AkĂf[^ł̈ʒuD
@retval	-1      0x00 ŏIĂ
@retval -2      0x00, 0x00 ݂iAk̃f[^ł͂Ȃ̂ł́Hj
*/
int  get_runlength_byte(unsigned char* buf, int len, int pos)
{
	int i, sz;

	sz = -1;
	for (i=0; i<len; i++) {
		if (buf[i]==0x00) {
			if (i+1>=len) return -1;
			if (buf[i+1]==0x00) return -2;
			sz += buf[i+1];
			if (sz>=pos) return i;
			i++;
		}
		else sz++;

		if (sz>=pos) return i;
	}

	return -1;
}



/**
Buffer  decode_runlength(unsigned char* buf, int len, int sz)

0̘Akꂽ buf szoCg̒ʏ̃f[^oD

@param  buf  Ak(0)ĂoCif[^
@param  len  buf ̒i`FbNpj
@param  sz   oTCYD0̏ꍇ͑SāD

@return 𓀂ꂽf[^܂ Buffer^ϐ
*/
Buffer  decode_runlength(unsigned char* buf, int len, int sz)
{
	int    i, j, k;
	Buffer ret = init_Buffer();

	// 𐔂
	i = j = 0;
	if (sz<=0) {
		while (j<len) {
			if (buf[j]==0x00) {
				if (j+1<len) {
					if (buf[j+1]==0x00) return ret;
					i += (int)buf[j+1];
					j += 2;
				}
				else break;
			}
			else {
				i++;
				j++;
			}
		}

		if (j==len) sz = i;
		else return ret;
	}
		
	ret = make_Buffer(sz);
	if (ret.buf==NULL) return ret;

	i = j = 0;
	while (i<sz && j<len) {
		if (buf[j]==0x00) {
			if (j+1<len) {
				for (k=0; k<(int)buf[j+1]; k++) ret.buf[i++] = 0x00;
				j += 2;
			}
			else break;
		}	
		else ret.buf[i++] = buf[j++];
	}

	if (i==sz) ret.vldsz = sz;
	else free_Buffer(&ret);

	return ret;
}



Buffer  encode_runlength(unsigned char* buf, int len)
{
	int    i, j, k;
	Buffer ret = init_Buffer();

	ret = make_Buffer(2*len);
	if (ret.buf==NULL) return ret;

	i = j = 0;
	while (j<len) {
		ret.buf[i] = buf[j];

		if (buf[j]==0x00) {
			k = 0;
			while (buf[j]==0x00 && j<len) {
				k++;
				j++;
			}
			ret.buf[i+1] = (unsigned char)k;
			i += 2;
		}
		else {
			i++;
			j++;
		}
	}

	ret.vldsz = i;
	return ret;
}





////////////////////////////////////////////////////////////////////////////////////
//
//  Buffer z
// 

/**
Buffer*  get_Buffer_dim_tList(tList* lp)

Xg𕪉āCL[̔z𑢂

@param  lp  ΏۃXg

@return Xg̃L[Rs[Buffer^zւ̃|C^D
        evf stateɂ̗vfȍ~̗vfi܂ށji[D
        Ȃ킿C0Ԗڂ̗vf stateɂ͔z̑傫\D

*/
Buffer*  get_Buffer_dim_tList(tList* lp)
{
	int     nn, mx;
	tList*  lt;
	Buffer* buf;
	Buffer* ret;

	if (lp==NULL) return NULL;

	lt = lp;
	nn = 0;
	while(lt!=NULL && lt->ldat.key.buf!=NULL) {
		nn++;
		lt = lt->next;
	}
	if (nn==0) return NULL;

	mx = nn;
	buf = ret = (Buffer*)malloc(sizeof(Buffer)*mx);
	if (ret==NULL) return NULL;
	
	nn = 0;
	while(lp!=NULL && lp->ldat.key.buf!=NULL) {
		*buf = dup_Buffer(lp->ldat.key);
		buf->state = mx - nn;
		nn++;
		buf++;
		lp = lp->next;
	}
		
	return ret;
}



/**
Buffer*  get_Buffer_dim_tList_value(tList* lp)

Xg𕪉āCo[̔z𑢂

@param  lp  ΏۃXg

@return Xg̃o[Rs[Buffer^zւ̃|C^D
        evf stateɂ̗vfȍ~̗vfi܂ށji[D
        Ȃ킿C0Ԗڂ̗vf stateɂ͔z̑傫\D
*/
Buffer*  get_Buffer_dim_tList_value(tList* lp)
{
	int     nn, mx;
	tList*  lt;
	Buffer* buf;
	Buffer* ret;

	if (lp==NULL) return NULL;

	lt = lp;
	nn = 0;
	while(lt!=NULL && lt->ldat.val.buf!=NULL) {
		nn++;
		lt = lt->next;
	}
	if (nn==0) return NULL;

	mx = nn;
	buf = ret = (Buffer*)malloc(sizeof(Buffer)*mx);
	if (ret==NULL) return NULL;
	
	nn = 0;
	while(lp!=NULL && lp->ldat.val.buf!=NULL) {
		*buf = dup_Buffer(lp->ldat.val);
		buf->state = mx - nn;
		nn++;
		buf++;
		lp = lp->next;
	}
		
	return ret;
}



/**
Buffer*	 awk_Buffer_dim(Buffer buf, char cc)

cc؂LƂ, obt@̍ڂzɂĕԂD

@param  buf  Ώ Buffer^ϐD
@param  cc   ؂蕶D

@return ccŋ؂ꂽڂbufɊi[Buffer^zւ̃|C^D
        evf stateɂ̗vfȍ~̗vfi܂ށji[D
        Ȃ킿C0Ԗڂ̗vf stateɂ͔z̑傫i[D

@see awk()
*/
Buffer*	 awk_Buffer_dim(Buffer buf, char cc)
{
	Buffer* bf = NULL;

	tList*  lp = awk_Buffer_tList(buf, cc);
	if (lp!=NULL) bf = get_Buffer_dim_tList(lp);
	del_all_tList(&lp);
	
	return  bf;
}



/**
Buffer*	 cawk_Buffer_dim(Buffer buf, char cc)

cc؂LƂ, obt@̍ڂzɂĕԂD
A cc(؂)͈̋؂Ƃ݂ȂD

@param  buf  Ώ Buffer^ϐD
@param  cc   ؂蕶D

@return ccŋ؂ꂽڂbufɊi[Buffer^zւ̃|C^D
        evf stateɂ̗vfȍ~̗vfi܂ށji[D
        Ȃ킿C0Ԗڂ̗vf stateɂ͔z̑傫i[D
	
@see cawk()
*/
Buffer*	 cawk_Buffer_dim(Buffer buf, char cc)
{
	Buffer* bf = NULL;

	tList*  lp = cawk_Buffer_tList(buf, cc);
	if (lp!=NULL) bf = get_Buffer_dim_tList(lp);
	del_all_tList(&lp);
	
	return  bf;
}



/**
Buffer*  decompline_Buffer_dim(Buffer buf, int mode)

buf sɕDs̋؂ CRLF, CR, LF 

oCif[^Ăꍇ́CoCif[^Ǝvf[^ȍ~sƂĕԂD
]čŌ̃f[^̓oCił\D

@param  buf   f[^̓Ă Bufferϐ
@param  mode  @b ON: s CR, LF폜ȂD@b OFF: s CR, LF폜D

@return sւ̃|C^i[ꂽzւ̃|C^Def[^ state ɔz̑傫D
        gI del_Buffer_dim()ŃD
*/
Buffer*  decompline_Buffer_dim(Buffer buf, int mode)
{
	Buffer* dim;
	int i, n, m;

	if (buf.buf==NULL) return NULL;

	n = i = 0;
	while(buf.buf[i]!='\0' && i<buf.vldsz) {
		if (buf.buf[i]==CHAR_CR) {
			n++;
			if (i+1<buf.vldsz && buf.buf[i+1]==CHAR_LF) i++;
		}
		else if (buf.buf[i]==CHAR_LF) n++;
		else if (i+1<buf.vldsz  && buf.buf[i+1]=='\0') n++;
		else if (i+1==buf.vldsz || buf.buf[i+1]=='\0') n++;
		i++;
	}
	if (n==0) n = 1;			// buf.buf[0]=='\0' ̏ꍇ

	dim = (Buffer*)malloc(sizeof(Buffer)*n);
	if (dim==NULL) return NULL;

	int nxt = 0;
	for (m=0; m<n-1; m++) {
		int cnt = 0;
		int fwd = 0;
		while (buf.buf[nxt+cnt]!=CHAR_CR && buf.buf[nxt+cnt]!=CHAR_LF && nxt+cnt<buf.vldsz)  cnt++;

		if (buf.buf[nxt+cnt]==CHAR_CR || buf.buf[nxt+cnt]==CHAR_LF) fwd++;
		if (buf.buf[nxt+cnt]==CHAR_CR && nxt+cnt+1<buf.vldsz && buf.buf[nxt+cnt+1]==CHAR_LF) fwd++;
		if (mode==ON) cnt += fwd;

		dim[m] = make_Buffer(cnt);
		for (i=0; i<cnt; i++) {
			dim[m].buf[i] = buf.buf[nxt+i];
		}
		dim[m].vldsz = cnt;
		dim[m].state = n;

		if (mode==ON) nxt += cnt;
		else          nxt += cnt + fwd;
	}

	// m == n-1  ԍŌ̗̈
	dim[n-1] = make_Buffer(buf.vldsz-nxt);
	for (i=0; i<buf.vldsz-nxt; i++) {
		dim[n-1].buf[i] = buf.buf[nxt+i];
	}
	dim[n-1].vldsz = buf.vldsz - nxt;
	dim[n-1].state = n;


	return dim;
}



/**
Buffer  join_Buffer_dim(Buffer* dim, const char* deli)
	
Bufferz̓eqĈ̃f[^ɂD
*/
Buffer  join_Buffer_dim(Buffer* dim, const char* deli)
{
	int    i, nn;
	Buffer buf;

	buf = init_Buffer();
	if (dim==NULL) return buf;

	buf = make_Buffer(LBUF);
	nn  = dim->state;

	for (i=0; i<nn; i++) {
		cat_Buffer(dim, &buf);
		if (deli!=NULL && i!=nn-1) cat_s2Buffer(deli, &buf);
		dim++;
	}

	return buf;
}



/**
void  del_Buffer_dim(Buffer** dim)

IɊmۂꂽ Buffer̔z폜D
*/
void  del_Buffer_dim(Buffer** dim)
{
	int  i, nn;
	Buffer* buf;

	if (dim==NULL || *dim==NULL) return;
	buf = *dim;
	
	nn = buf->state;
	if (nn<=0) free_Buffer(buf);

	for (i=0; i<nn; i++) {
		free_Buffer(buf);
		buf++;
	}

	free(*dim);
	*dim = NULL;
	return;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Xg Buffer 
// 

/**
tList*  get_tList_line_Buffer(Buffer buf, int n)

datansڂ𕪉ăXgɊi[ĕԂD

@param buf  f[^i[ꂽBuffer^ϐ
@param n    ǂݏos
@return     ACei[Xgւ̃|C^Dsꍇ NULL
*/
tList*  get_tList_line_Buffer(Buffer buf, int n)
{
	if (buf.buf==NULL || n<=0) return NULL;

    Buffer line = get_line_Buffer(buf, n);
	if (line.buf==NULL) return NULL;

    char*  packline = pack_char((char*)line.buf, ' ');
    free_Buffer(&line);
	if (packline==NULL) return NULL;

    tList* list = awk_tList(packline, ' ');
    free(packline);

    return list;
}



/**
tList*  get_tList_seq_data_Buffer(Buffer buf, int* ptr)

@param buf  f[^i[ꂽBuffer^ϐ
@param ptr  ǂݏoJnꏊւ̃|C^D
@return     ACei[Xgւ̃|C^Dsꍇ NULL
*/
tList*  get_tList_seq_data_Buffer(Buffer buf, int* ptr)
{
	if (buf.buf==NULL || *ptr<0) return NULL;
	if (*ptr>=buf.vldsz) return NULL;

    Buffer line = get_seq_data_Buffer(buf, ptr);
	if (line.buf==NULL) return NULL;

    char*  packline = pack_char((char*)line.buf, ' ');
    free_Buffer(&line);
	if (packline==NULL) return NULL;

    tList* list = awk_tList(packline, ' ');
    free(packline);

    return list;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Extend tList
//

/**
int	  set_item_tList(tList* list, char* key, int no, char deli, int nm, char* value)

key L[ɂ noԖڂ̃m[h̒l̒ŁCdeli؂ɂ nmԖڂ̍ځij
value ݒ肷D

@param  list   Ώۂ̃wb_i[Xg
@param  key    wb_ʁD
@param  no     wb_ʂꍇCԖڂ̃m[hw肷DP琔D
		       no 0ȉ̏ꍇ keyvSẴm[hɑ΂đsD
@param  deli   m[hlij̋؂蕶D
@param  nm     deli ؂蕶ƂĉԖڂ̍ڂH 1琔D
@param  value  ݒ肷镶D

@return ݒsm[hD
*/
int	  set_item_tList(tList* list, char* key, int no, char deli, int nm, char* value)
{
	int	cn = 0;
	tList* lp;

	if (list==NULL || key==NULL || value==NULL) return -1;

	if (no>0) {
		lp = strncasecmp_tList(list, key, 0, no);
		if (lp!=NULL) {
			int rep = set_item_tList_node(lp, deli, nm, value);
			if (rep) cn = 1;
		}
	}   
	else {	  // no<=0
		int nn = 1;
		cn = 0;
		lp = strncasecmp_tList(list, key, 0, nn);
		while (lp!=NULL) {
			int rep = set_item_tList_node(lp, deli, nm, value);
			if (rep) cn++;
			lp = strncasecmp_tList(list, key, 0, ++nn);
		}
	}

	return cn;
}



int	  set_item_tList_node(tList* lp, char deli, int nm, char* value)
{
	int	 rep = FALSE;
	char dl[2] = " ";
	Buffer* bp;


	if (lp==NULL || value==NULL) return FALSE;

	dl[0] = deli;

	bp = cawk_Buffer_dim(lp->ldat.val, deli);
	if (bp!=NULL && bp->state>=nm) {
		Buffer buf = make_Buffer_bystr(value);
		free_Buffer(&bp[nm-1]);
		bp[nm-1] = buf;

		free_Buffer(&lp->ldat.val);
		lp->ldat.val = join_Buffer_dim(bp, dl);
		rep = TRUE;
	}
	del_Buffer_dim(&bp);

	return rep;
}



/**
int	  replace_item_tList(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)

key L[ɂ noԖڂ̃m[h̒l̒ŁCdeli؂ɂ nmԖڂ̍ځij
srcval valueŒuD

@param  list    Ώۂ̃wb_i[Xg
@param  key     wb_ʁD
@param  no	    wb_ʂꍇCԖڂ̃m[hw肷D1琔D
                no 0ȉ̏ꍇ keyvSẴm[hɑ΂đsD
@param  deli    m[hlij̋؂蕶D
@param  nm	    deli ؂蕶ƂĉԖڂ̍ڂH 1琔D
@param  srcval  uΏۂ̕DNULLȂw肵ڂ̕S
@param  value   u镶D

@return usm[hD
*/
int	  replace_item_tList(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)
{
	int	cn = 0;
	tList* lp;

	if (list==NULL || key==NULL || value==NULL) return -1;
	if (srcval==NULL) {
		return 	set_item_tList(list, key, no, deli, nm, value);
	}

	if (no>0) {
		lp = strncasecmp_tList(list, key, 0, no);
		if (lp!=NULL) {
			int rep = replace_item_tList_node(lp, deli, nm, srcval, value);
			if (rep) cn = 1;
		}
	}   
	else {	  // no<=0
		int nn = 1;
		cn = 0;
		lp = strncasecmp_tList(list, key, 0, nn);
		while (lp!=NULL) {
			int rep = replace_item_tList_node(lp, deli, nm, srcval, value);
			if (rep) cn++;
			lp = strncasecmp_tList(list, key, 0, ++nn);
		}
	}

	return cn;
}



int	  replace_item_tList_node(tList* lp, char deli, int nm, char* srcval, char* value)
{
	int	 rep = FALSE;
	char dl[2] = " ";
	Buffer* bp;
	Buffer  buf;


	if (lp==NULL || value==NULL) return FALSE;
	if (nm<=0) nm = 1;
	if (srcval==NULL) {
		return set_item_tList_node(lp, deli, nm, value);
	}

	dl[0] = deli;

	bp = cawk_Buffer_dim(lp->ldat.val, deli);
	if (bp!=NULL && bp->state>=nm) {
       	buf = replace_sBuffer(bp[nm-1], srcval, value);
		free_Buffer(&bp[nm-1]);
		bp[nm-1] = buf;
		free_Buffer(&lp->ldat.val);
		lp->ldat.val = join_Buffer_dim(bp, dl);
		rep = TRUE;
	}
	del_Buffer_dim(&bp);

	return rep;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////
//
// File/Directory Tools
//
/**
tList*  get_dir_files(const char* dirn)

w肳ꂽfBNgɂt@C̈ꗗ擾D@n
Windows ̏ꍇ  Unicodep

@param  dirn  fBNg
@return t@Cobt@ildat.valjɊi[Xgւ̃|C^D

@attention t@C̎ނ͋ʂȂD'.'Ŏn܂t@C̓XgɓȂD
*/
tList*  get_dir_files(const char* dirn)
{
	tList* lp = NULL;

#ifdef WIN32
	tList* ln = NULL;
//	WIN32_FIND_DATA  FindFileData;
	WIN32_FIND_DATAA FindFileData;
	HANDLE hFind;

	Buffer pth = make_Buffer_bystr(dirn);
	if (pth.buf[strlen((char*)pth.buf)-1]!='\\') cat_s2Buffer("\\", &pth);
	Buffer buf = dup_Buffer(pth);
	cat_s2Buffer("*", &buf);

//	hFind = FindFirstFile((LPCTSTR)(buf.buf), &FindFileData);
	hFind = FindFirstFileA((LPCSTR)(buf.buf), &FindFileData);
	if (hFind!=INVALID_HANDLE_VALUE) {
		Buffer tmp;	
		do {
			if (FindFileData.cFileName[0]!='.') { 
				tmp = dup_Buffer(pth);
				cat_s2Buffer(FindFileData.cFileName, &tmp);
				ln = add_tList_node_str(ln, NULL, tmp.buf);
				if (lp==NULL) lp = ln;
				free_Buffer(&tmp);
			}
		} while (FindNextFileA(hFind, &FindFileData));

		FindClose(hFind);
	}
	free_Buffer(&buf);
	free_Buffer(&pth);

#else

	tList* ln=NULL;
	DIR *dp;
	struct dirent *dir;
	
	Buffer pth = make_Buffer_bystr(dirn);
	if (pth.buf[strlen((char*)pth.buf)-1]!='/') cat_s2Buffer("/", &pth);

	dp = opendir(dirn);
	if (dp!=NULL ){
		Buffer tmp;
		dir = readdir(dp);
		while (dir != NULL ){
			if (dir->d_name[0]!='.') { 
				tmp = dup_Buffer(pth);
				cat_s2Buffer(dir->d_name, &tmp);
				ln = add_tList_node_str(ln, NULL, (char*)tmp.buf);
				if (lp==NULL) lp = ln;
				free_Buffer(&tmp);
			}
			dir = readdir(dp);
		}

		closedir(dp);
	}
	free_Buffer(&pth);

#endif

	return lp;
}



tList*  get_dir_files_rcsv(const char* dirn)
{
	tList* lp = get_dir_files(dirn);
	if (lp==NULL) return NULL;

	tList* lt = lp;
	while (lt!=NULL) {
		tList* lc = get_dir_files_rcsv((char*)lt->ldat.val.buf);
		if (lc!=NULL) add_tList_end(lp, lc);
		lt = lt->next;
	}

	return lp;
}



void  cut_file_extension(Buffer* path)
{
	if (path==NULL) return;

	int count = path->vldsz - 1;
	while (count>=0) {
		if (path->buf[count]=='.') {
			path->buf[count] = '\0';
			path->vldsz = strlen((char*)path->buf);
			break;
		}
		count--;
	}
}



/**
t@C̊gq extɂDt@CɊgqꍇ exttD
*/
void  change_file_extension(Buffer* path, const char* ext)
{
	if (path==NULL) return;

	int count = path->vldsz - 1;
	while (count>=0) {
		if (path->buf[count]=='.') {
			path->buf[count] = '\0';
			path->vldsz = strlen((char*)path->buf);
			if (ext[0]!='.') cat_s2Buffer(".", path);
			cat_s2Buffer(ext, path);
			break;
		}
		count--;
	}
	//
	if (count<0) {
		if (ext[0]!='.') cat_s2Buffer(".", path);
		cat_s2Buffer(ext, path);
	}
}





///////////////////////////////////////////////////////////////////////////////////////////////////

/**
\[X̖OCt@C̃pX𓾂D߂l freeĂ͂ȂD

@param name \[X
@param lp   \[XXgDkeyɖOCvalɃpXi[ĂD
@return \[XɑΉpXD
*/
char*  get_resource_path(char* name, tList* lp)
{
	if (name==NULL) return NULL;

	while (lp!=NULL) {
		if (!strcasecmp((char*)lp->ldat.key.buf, name)) {
			return (char*)lp->ldat.val.buf;
		}
		lp = lp->next;
	}

	return NULL;
}



/**
fBNg pathāC\[XXgɃt@CǉCXg̐擪ԂD@n
\[XXg̃L[́C\[X̃t@C̐擪 keylenƂDkeylen 0ȉȂt@CŜL[ƂD

@param path   fBNg
@param keylen L[D0ȉȂt@CŚD
@param list   ǉsXgDNULLȂVXg쐬ĕԂD
@return \[X̃Xg
*/
tList*  add_resource_list(const char* path, int keylen, tList* list)
{
	if (path==NULL) return list;

	tList* lp = get_dir_files(path);
	if (lp!=NULL) list = add_tList_end(list, lp);

	// Generate Key. t@C̐擪 keylenL[ɂD
	while (lp!=NULL) {
		Buffer fn = make_Buffer_bystr(get_file_name((char*)lp->ldat.val.buf));
		if (keylen<=0) {
			lp->ldat.key = make_Buffer_bystr((char*)fn.buf);
			lp = lp->next;
		}
		else if (fn.vldsz>=keylen) {
			fn.buf[keylen] = '\0';
			fn.vldsz = keylen;
			lp->ldat.key = make_Buffer_bystr((char*)fn.buf);
			lp = lp->next;
		}
		else {
			lp = del_tList_node(lp);
		}
		free_Buffer(&fn);
	}

	return list;
}




