/* vi: set tabstop=4 nocindent paste : */


/**
ȈՃf[^x[XCu for Berkeley BD4:  bdb_tool.c  v2.0

  wb_
	  #include "bdb_tool.h"

  Cu
	  -ldb-4.2  for Berkeley DB4



  Berkeley DB̃}jA
		http://pybsddb.sourceforge.net/reftoc.html

*/



#include "bdb_tool.h"



#ifdef  ENABLE_BERKELEYDB




/**
DB*  open_fdb(char* fname, unsigned int mode)
  
	@\: f[^x[X̃I[vD
		  f[^x[Xt@C fnameI[vD
		  ݂Ȃꍇ̓t@C쐬D

	: fname -- f[^x[X̃t@C(ʏgq͏)D

	߂l: f[^x[Xt@C̃t@CfBXNv^D
			f[^x[Xt@C݂,쐬ɂsꍇ NULL ԂD

*/
DB*  open_fdb(char* fname, unsigned int mode)
{
	DB* dp;

	if (fname==NULL) return NULL;

	int ret = db_create(&dp, NULL, 0);
	if (ret==0) {
		ret = dp->open(dp, NULL, fname, NULL, DB_HASH, (u_int32_t)mode, 0600);
	}

	if (ret!=0) {
		DEBUG_MODE {
			dp->err(dp, ret, "DB->open");
			print_message("dbname is %s\n", fname);
		}
		return NULL;
	}
	return dp;
}




/**
void  close_fdb(DB** dp)

	@\Ff[^x[X̃N[YDf[^SătbVD

*/
void  close_fdb(DB** dp)
{
	if (dp==NULL || *dp==NULL) return;

	(*dp)->close((*dp), 0);
	*dp = NULL;
	return;
}




/**
int  check_fdb_file(char* fname)
  
	@\: f[^x[X̃`FbND
		  f[^x[Xt@C fname݂邩ǂ`FbND
		  ݂Ȃꍇ̓t@C쐬D

	: fname -- f[^x[X̃t@C(ʏgq͏)D

	߂l: f[^x[Xt@C݂D܂͍쐬ɐꍇɂ TRUEԂD
			f[^x[Xt@C݂,쐬ɂsꍇ FALSEԂD

*/
int  check_fdb_file(char* fname)
{
	DB* dp = open_fdb(fname, DB_CREATE);

	if (dp==NULL)  return FALSE;
	close_fdb(&dp);
	return TRUE;
}




/**
int   set_fdb_data(DB* dp, Buffer id, Buffer dbdata)

	@\: fBXNv^gf[^x[Xւ̓o^D
		  f[^x[XfBXNv^ dp ɃL[ id  dbdata o^D
		  L[ŊɃf[^o^Ăꍇ dbdataŒuD
		  t@C̃I[vƃN[Y͍sȂD

	: dp	 -- f[^x[XfBXNv^
		  id	 -- f[^x[X̃L[D
		  dbdata -- f[^x[Xɓo^f[^D

	߂l: f[^̓o^ɐꍇ̓f[^̒ԂD
			̓f[^̃TCYȂꍇ -1ԂD
			f[^̓o^Ɏsꍇ 0ԂD

*/
int   set_fdb_data(DB* dp, Buffer id, Buffer dbdata)
{
	DBT  key, data;
	int  ret;
 
	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	key.data = id.buf;
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return -1;
	}

	data.data = dbdata.buf;
	data.size = dbdata.vldsz;
	if (data.size<=0) return -1;

	ret = dp->put(dp, NULL, &key, &data, 0);
	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->put");
		return 0;
	}
	return  data.size;
}




/**
int   set_fdb_data_file(char* fname, Buffer id, Buffer dbdata)

	@\: f[^x[Xւ̓o^D
		  f[^x[Xt@C fname ɃL[ id  dbdata o^D
		  L[ŊɃf[^o^Ăꍇ dbdataŒuD
		  t@C̃I[vƃN[YsD

	: fname  -- f[^x[X̃t@C(ʏgq͏)D
		  id	 -- f[^x[X̃L[D
		  dbdata -- f[^x[Xɓo^f[^D

	߂l: f[^̓o^ɐꍇ̓f[^̒ԂD
			f[^x[Xt@C̃I[vɎsꍇC̓f[^̃TCYȂꍇ -1ԂD
			f[^̓o^Ɏsꍇ 0ԂD

*/
int   set_fdb_data_file(char* fname, Buffer id, Buffer dbdata)
{
	DBT  key, data;
	DB*  dp;
	int  ret;
 
	dp = open_fdb(fname, DB_CREATE);
	if (dp==NULL) return -1;

	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	key.data  = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return -1;
	}

	data.data = (char*)dbdata.buf;
	data.size = dbdata.vldsz;
	if (data.size<=0) return -1;

	ret = dp->put(dp, NULL, &key, &data, 0);
	close_fdb(&dp);

	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->put");
		return 0;
	}
	return  data.size;
}




/**
Buffer  get_fdb_data(DB* dp, Buffer id)

	@\: f[^x[Xf[^擾D
		  f[^x[XfBXNv^ dp L[ id Ńf[^lD
		  L[ id͕łȂ΂ȂȂD
		  t@C̃I[vƃN[Y͍sȂD

		  ꍇɂ, ߂lƂ Buffer^f[^ւ̃|C^ԂD
		  ǂݎf[^̌^̓vO}cĂȂ΂ȂȂD
		  ǂݎf[^͎gpI free_Buffer()֐ɂJȂ΂ȂȂD

		  f[^̎擾Ɏsꍇ -2,̊mۂɎsꍇ -3  stateɊi[ĕԂD
		  sꍇ͂̏ꍇ, oϐ buf̒lNULLɂȂĕԂD

	: dp	 -- f[^x[X̃t@CfBXNv^D
		  id	 -- ǂݎf[^̃L[D

	߂l:  ǂݎf[^(Buffer^f[^)ւ̃|C^ԂD

	Fdata.data freeĂ͂ȂD

*/
Buffer  get_fdb_data(DB* dp, Buffer id)
{
	int  ret;
	DBT  key, data;
	Buffer dbdata;

	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	dbdata   = init_Buffer();
	key.data = (void*)id.buf;
	key.size = (u_int32_t)id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) {
			dbdata.state = -2;
			return dbdata;
		}
	}

	ret = dp->get(dp, NULL, &key, &data, 0);
	if (ret!=0) {
		dbdata.state = -2;
		return  dbdata;
	}

	dbdata = make_Buffer(data.size+1);		// +1 is for string
	if (dbdata.buf==NULL) {
		dbdata.state = -3;
		return  dbdata;
	}
	memcpy(dbdata.buf, data.data, data.size);
	dbdata.vldsz = data.size;
	dbdata.buf[data.size] = '\0';			// for string

	return  dbdata;
}




/**
Buffer  get_fdb_data_file(char* fname, Buffer id)

	@\: f[^x[Xf[^擾D
		  f[^x[Xt@C fname L[ id Ńf[^lD
		  L[ id͕łȂ΂ȂȂD
		  t@C̃I[vƃN[YsD

		  ꍇɂ, ߂lƂ Buffer^f[^ւ̃|C^ԂD
		  ǂݎf[^̌^̓vO}cĂȂ΂ȂȂD
		  ǂݎf[^͎gpI free_Buffer()֐ɂJȂ΂ȂȂD

		  f[^x[Xt@C fnamẽI[vɎsꍇ Buffer^ϐ
		  oϐ state -1i[ĕԂDf[^̎擾Ɏs
		  ꍇ -2,̊mۂɎsꍇ -3i[ĕԂD
		  sꍇ͂̏ꍇ,oϐbuf̒lNULLɂȂĕԂD

	: fname  -- f[^x[X̃t@C(ʏgq͏)D
		  id	 -- ǂݎf[^̃L[D

	߂l:  ǂݎf[^(Buffer^f[^)ւ̃|C^ԂD

	Fdata.data freeĂ͂ȂD

*/
Buffer  get_fdb_data_file(char* fname, Buffer id)
{
	int  ret;
	DBT  key, data;
	DB*  dp;
	Buffer dbdata;

	dbdata = init_Buffer();
	dp = open_fdb(fname, DB_RDONLY);
	if (dp==NULL) {
		dbdata.state = -1;
		return  dbdata;
	}

	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	key.data = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) {
			dbdata.state = -2;
			return dbdata;
		}
	}

	ret = dp->get(dp, NULL, &key, &data, 0);
	close_fdb(&dp);
	if (ret!=0) {
		dbdata.state = -2;
		return  dbdata;
	}

	dbdata = make_Buffer(data.size+1);		// +1 is for string
	if (dbdata.buf==NULL) {
		dbdata.state = -3;
		return  dbdata;
	}

	dbdata.vldsz = data.size;
	memcpy(dbdata.buf, data.data, data.size);
	dbdata.buf[data.size] = '\0';			// for string

	return  dbdata;
}




/**
int   del_fdb_data(DB* dp, Buffer id)

	@\: f[^x[X̍폜D
		  f[^x[XfBXNv^ dp L[ id ̃f[^폜D
		  L[ id͕łȂ΂ȂȂD
		  t@C̃I[vƃN[Y͍sȂD

	: dp	-- f[^x[XfBXNv^
		  id	-- 폜f[^̃L[D

	߂l: f[^̍폜ɐꍇ TRUEԂD
			f[^̍폜Ɏsꍇ FALSEԂD

*/
int   del_fdb_data(DB* dp, Buffer id)
{
	DBT  key;
	int  ret;
 
	memset(&key, 0, sizeof(DBT));
	key.data = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return FALSE;
	}
	ret = dp->del(dp, NULL, &key, 0);

	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->del");
		return FALSE;
	}
	return  TRUE;
}




/**
int   del_fdb_data_file(char* fname, Buffer id)

	@\: f[^x[X̍폜D
		  f[^x[Xt@C fname L[ id ̃f[^폜D
		  L[ id͕łȂ΂ȂȂD
		  t@C̃I[vƃN[YsD

	: fname -- f[^x[X̃t@C(ʏgq͏)D
		  id	-- 폜f[^̃L[D

	߂l: f[^̍폜ɐꍇ TRUEԂD
			f[^̍폜Ɏsꍇ FALSEԂD

*/
int   del_fdb_data_file(char* fname, Buffer id)
{
	DBT  key;
	DB*  dp;
	int  ret;
 
	dp = open_fdb(fname, 0);
	if (dp==NULL) return FALSE;

	memset(&key, 0, sizeof(DBT));
	key.data = (char*)(id.buf);
	key.size = id.vldsz;
	if (key.size<=0) {
		key.size = strlen((char*)id.buf);
		if (key.size<=0) return FALSE;
	}

	ret = dp->del(dp, NULL, &key, 0);
	close_fdb(&dp);

	if (ret!=0) {
		DEBUG_MODE dp->err(dp, ret, "DB->del");
		return FALSE;
	}
	return  TRUE;
}





/**
tList*  get_all_fdb_data(DB* dp)

	@\: f[^x[XŜ̎擾 

	: db -- f[^x[XʎqD

*/
tList*  get_all_fdb_data(DB* dp)
{
	int  ret;
	DBT  key, data;
	DBC* crsp;

	tList* lt = NULL;
	tList* lp = NULL;
	Buffer id, dt;

	if (dp==NULL) return NULL;

	dp->cursor(dp, NULL, &crsp, 0);
	if (crsp==NULL) return NULL;
	
	memset(&key,  0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	ret = crsp->c_get(crsp, &key, &data, DB_NEXT);
	while (ret==0) {
		id = make_Buffer_bin(key.data,  key.size);
		dt = make_Buffer_bin(data.data, data.size);
		lt = add_tList_node_Buffer(lt, id, dt);
		if (lp==NULL) lp = lt;
		free_Buffer(&id);
		free_Buffer(&dt);

		ret = crsp->c_get(crsp, &key, &data, DB_NEXT);
	}

	crsp->c_close(crsp);

	return lp;
}





/**
tList*  get_all_fdb_data_file(char* fname)

	@\: f[^x[XŜ̎擾 

	: *fname -- f[^x[X̃t@C

*/
tList*  get_all_fdb_data_file(char* fname)
{
	DB*    dp;
	tList* lp = NULL;

	if (fname==NULL) return NULL;

	dp = open_fdb(fname, DB_RDONLY);
	if (dp==NULL) return NULL;

	lp = get_all_fdb_data(dp);
	close_fdb(&dp);

	return lp;
}





#endif
