#ifndef  DISABLE_ZLIB 

/**
@brief   ZLIBkpCu
@file    gzip_tool.c
@author  Fumi.Iseki (C)


@attention
̃vO zlib gpĂ܂D@n
*/


#include "gz_tool.h"




////////////////////////////////////////////////////////////////////////////////////////////////
//
//

/**
Buffer  gz_decode_data(Buffer enc)

gzipf[^ enc𓀂ĕԂDf[^G[ĂC𓀉\ȂƂ܂ł͉𓀂D@n

@param  enc  𓀂 gzipf[^i[ꂽ BufferϐD
@return 𓀃f[^i[ꂽ BufferϐD
*/
Buffer  gz_decode_data(Buffer enc)
{
	Buffer dec = init_Buffer();

	if (enc.buf==NULL) return dec;

	z_stream zstrm;
	zstrm.zalloc 	= Z_NULL;
	zstrm.zfree  	= Z_NULL;
	zstrm.opaque 	= Z_NULL;
	zstrm.next_in  	= Z_NULL;
	zstrm.avail_in 	= 0;

	int ret = inflateInit2(&zstrm, 47);
	if (ret!=Z_OK) return dec;

	//
	dec = make_Buffer(enc.vldsz*5);
	Buffer wrk = make_Buffer(BUFSZ);

	zstrm.next_in  = enc.buf;
	zstrm.avail_in = (size_t)enc.vldsz;

	do {
		zstrm.next_out  = wrk.buf;
		zstrm.avail_out = (size_t)wrk.bufsz; 

		ret = inflate(&zstrm, Z_NO_FLUSH);
		if (ret!=Z_OK && ret!=Z_STREAM_END) {
			wrk.vldsz = wrk.bufsz - zstrm.avail_out;
			cat_Buffer(&wrk, &dec);
			inflateEnd(&zstrm);
			free_Buffer(&wrk);
			//
			DEBUG_MODE print_message("GZ_DECODE_DATA: ERROR: inflate error = %d\n", ret);
			dec.state = -1;
			return dec;
		}

		wrk.vldsz = wrk.bufsz - zstrm.avail_out; 
		cat_Buffer(&wrk, &dec);

  		if (ret==Z_STREAM_END && zstrm.avail_in!=0) {
       		ret = inflateReset(&zstrm);
		} 

	} while (ret!=Z_STREAM_END && zstrm.avail_in>0);
	//

	inflateEnd(&zstrm);
	free_Buffer(&wrk);

	return dec;
}



/**
deflatef[^ gzip̃f[^\ɕϊD

zlib̊֐Q deflateʂ悤Ȃ̂ŁCzlib̊֐𒼐ڎgpꍇ͂̊֐͕KvȂD@n
t@CƂĕۑꍇ́Cgzip headertailertKv邪CkOCRC32ISIZE͒ʏ͌vZłȂD@n
]Ă header tailertt@C gunzuipR}hł͉𓀂łȂDzcat ̓G[oC𓀎͉̂\D@n
header tailertĂCzlib̊֐Qł͎gp\@n

@param[out] def ϊ deflatẽf[^ۑꂽ Bufferϐւ̃|C^D
@sa http://www.ietf.org/rfc/rfc1952.txt
*/
void  deflate2gzip(Buffer* def)
{
	unsigned char gzip_header[] = { 0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff};
	unsigned char gzip_tailer[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};	// CRC32 4Byte, ISIZE 4Byte

	Buffer gzp = init_Buffer();

	if (def->buf[0]==GZIP_DEFLATE_ID1 && def->buf[1]==GZIP_DEFLATE_ID2) {
		gzp = make_Buffer(def->vldsz+16);
		cat_b2Buffer(gzip_header, &gzp, 10);
		cat_b2Buffer(def->buf+2, &gzp, def->vldsz-2);		
		cat_b2Buffer(gzip_tailer, &gzp, 8);
		free_Buffer(def);
		*def = gzp;
	}

	return;
}





////////////////////////////////////////////////////////////////////////////////////////////////
//
// FILE I/O
// 

/**
int  gz_decode_fp(FILE* infp, FILE* otfp)

gzipt@C infn𓀂 t@C otfn֕ۑDf[^G[ĂC𓀉\ȂƂ܂ł͉𓀂D

@param  infp 𓀂 gzipt@C̃t@C|C^D
@param  otfp 𓀂ꂽt@C̃t@C|C^D
@return 񂾃t@C̃TCYD
*/
int  gz_decode_fp(FILE* infp, FILE* otfp)
{
	if (infp==NULL || otfp==NULL) return 0;
	
	int sz = 0;
	unsigned char inbuf[LBUF];
	unsigned char otbuf[BUFSZ];

	//
	z_stream zstrm;
	zstrm.zalloc 	= Z_NULL;
	zstrm.zfree  	= Z_NULL;
	zstrm.opaque 	= Z_NULL;
	zstrm.next_in  	= Z_NULL;
	zstrm.avail_in 	= 0;

	int ret = inflateInit2(&zstrm, 47);
	if (ret!=Z_OK) return -1;

	do {
		zstrm.next_in  = inbuf;
		zstrm.avail_in = fread(inbuf, 1, LBUF, infp);

		do {
			zstrm.next_out  = otbuf;
			zstrm.avail_out = BUFSZ; 

			ret = inflate(&zstrm, Z_NO_FLUSH);
			if (ret!=Z_OK && ret!=Z_STREAM_END) {
				fwrite(otbuf, BUFSZ-zstrm.avail_out, 1, otfp);			
				//
				inflateEnd(&zstrm);
				DEBUG_MODE print_message("GZ_DECODE_FP: ERROR: inflate error = %d\n", ret);
				if (sz==0) sz = -1;
				return sz;
			}

			int otsz = BUFSZ - zstrm.avail_out; 
			fwrite(otbuf, otsz, 1, otfp);			
			sz += otsz;

      		if (ret==Z_STREAM_END && zstrm.avail_in!=0) {
        		ret = inflateReset(&zstrm);
			} 

		} while (ret!=Z_STREAM_END && zstrm.avail_in>0);
		//
	} while(!feof(infp));

	inflateEnd(&zstrm);

	return sz;
}



/*
int  gz_encode_gzfp(FILE* fp, gzFile* gf)

t@C fpk gzipt@C gf֕ۑDfread() œǂŁCgzwrite() ŏށD

@param  fp ǂݍݗp̒ʏt@Cւ̃|C^D
@param  gf ݗpgzipt@Cւ̃|C^D
@return ǂݍ񂾃t@C̃TCYD
*/
int  gz_encode_gzfp(FILE* fp, gzFile* gf)
{
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];

	if (*gf==NULL) return -1;

	memset(buf, 0, RECVBUFSZ);
	sz = cc = fread(buf, RECVBUFSZ, 1, fp);
	while(cc>0) {
		gzwrite(*gf, (voidp)buf, cc);
		memset(buf, 0, cc);
		cc = fread(buf, RECVBUFSZ, 1, fp);
		sz += cc;
	}

	return sz;
}



/**
int  gz_decode_gzfp(gzFile* gf, FILE* fp)

gzip t@C gf𓀂 t@C fp֕ۑD gzread()œǂ fwrite()ŏށD

@param  gf ǂݍݗp gzipt@Cւ̃|C^D
@param  fp ݗp̒ʏt@Cւ̃|C^D
@return 񂾃t@C̃TCYD
*/
int  gz_decode_gzfp(gzFile* gf, FILE* fp)
{
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];

	if (*gf==NULL) return -1;

	memset(buf, 0, RECVBUFSZ);
	sz = cc = gzread(*gf, (voidp)buf, RECVBUFSZ);
	while(cc>0) {
		fwrite(buf, cc, 1, fp);
		memset(buf, 0, cc);
		cc = gzread(*gf, (voidp)buf, RECVBUFSZ);
		sz += cc;
	}

	return sz;
}



/**
int  gz_encode_file(const char* fmfn, const char* tofn)

t@C fmfnk gzipt@C tofn֕ۑDfread()œǂŁCgzwrite()ŏށD

@param  fmfn kt@C
@param  tofn kꂽ gzip t@C
@return ǂݍ񂾃t@C(fmfn)̃TCYD
*/
int  gz_encode_file(const char* fmfn, const char* tofn)
{
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];
	gzFile gf;
	FILE*  fp;

	fp = fopen(fmfn, "rb");
	if (fp==NULL) return -1;

	gf = gzopen(tofn, "wb");
	if (gf==NULL) {
		fclose(fp);
		return -1;
	}

	memset(buf, 0, RECVBUFSZ);
	sz = cc = fread(buf, RECVBUFSZ, 1, fp);
	while(cc>0) {
		gzwrite(gf, (voidp)buf, cc);
		memset(buf, 0, cc);
		cc = fread(buf, RECVBUFSZ, 1, fp);
		sz += cc;
	}

	gzclose(gf);	
	fclose(fp);

	return sz;
}



/**
int  gz_decode_file(const char* fmfn, const char* tofn)

gzipt@C fmfn𓀂 t@C tofn֕ۑD

@param  fmfn 𓀂 gzipt@C
@param  tofn 𓀂ꂽt@C
@return 񂾃t@C(tofn)̃TCYD
*/
int  gz_decode_file(const char* fmfn, const char* tofn)
{
	FILE* infp;
	FILE* otfp;

	infp = fopen(fmfn, "rb");
	if (infp==NULL) return -1;

	otfp = fopen(tofn, "wb");
	if (otfp==NULL) {
		fclose(infp);
		return -1;
	}

	int sz = gz_decode_fp(infp, otfp);

	fclose(infp);
	fclose(otfp);

	return sz;

/*
	int  cc, sz;
	unsigned char buf[RECVBUFSZ];
	gzFile gf;
	FILE*  fp;

	gf = gzopen(fmfn, "rb");
	if (gf==NULL) return -1;

	fp = fopen(tofn, "wb");
	if (fp==NULL) {
		gzclose(gf);
		return -1;
	}

	memset(buf, 0, RECVBUFSZ);
	sz = cc = gzread(gf, (voidp)buf, RECVBUFSZ);
	while(cc>0) {
		fwrite(buf, cc, 1, fp);
		memset(buf, 0, cc);
		cc = gzread(gf, (voidp)buf, RECVBUFSZ);
		sz += cc;
	}

	gzclose(gf);	
	fclose(fp);

	return sz;
*/
}



/**
int  gz_decode_file_replace(const char* fn, const char* tempdir)

gzipt@C fn𓀂āCʏ̃t@CŒuD

@param  fn 𓀂 gzipt@C
@param  tempdir ƗpfBNgDNULLD
@return 񂾃t@C(tofn)̃TCYD
*/
int  gz_decode_file_replace(const char* fn, const char* tempdir)
{
	int cc;
	char* tempfn;

	tempfn = temp_filename(tempdir, 16);
	cc = gz_decode_file(fn, tempfn);
	if (cc<=0) {
		unlink(tempfn);
		free(tempfn);
		return cc;
	}

	unlink(fn);
	rename(tempfn, fn);
	freeNull(tempfn);

	return cc;
} 





#endif
