/* vi: set tabstop=4 nocindent noautoindent: */



#include "ssl_tool.h"


#ifdef  ENABLE_SSL


/**
@brief   SSLÍpCu
@file    ssl_tool.c
@author  Fumi.Iseki (C)

@par Cu
--L/usr/local/ssl/lib -lcrypto 


@par ]f[^ieLXgj`
@code
ʏ]f[^F            [f[^][\r][\n]
ʏ]f[^isjF  [f[^][\r][\n][f[^][\r][\n]...[\r][\n][END][\r][\n]
Í̓]f[^F      [Íf[^][\r][\n] isj
                                   | [f[^][\r][\n]....[\r][\n][END][\r][\n]

jf[^]ƂC\r\n ̃f[^̍Ōɂ̂CÍꂽf[^̍Ōɂ̂C悭ӂȂƂȂD
@endcode


@attention
̃vO openSSL gpĂ܂D@n
This product includes software developed by the OpenSSL Project
for use in the OpenSSL Toolkit. (http://www.openssl.org/)
*/



Buffer* Base64_DHspki  = NULL;
Buffer* Base64_RSAspki = NULL;


Buffer* CRYPT_SharedKey 	   = NULL;
const 	EVP_CIPHER* CRYPT_Type = NULL;
DH*	  	DHkey 				   = NULL;

int    	KEYEX_Algorism = 0;
int     CRYPT_Algorism = 0;


/*
typedef struct dh_st
{
	BIGNUM* p;
	BIGNUM* g;
	BIGNUM* pub_key;
	BIGNUM*	priv_key; 
} DH;
 */




///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
int  gen_CRYPT_SharedKey(int keyex, Buffer spki)

ASY keyex ŁCLvZD

SPKIƔ閧͌vZς݂łȂ΂ȂȂD
ꂽL Buffer* CRYPT_SharedKey Ɋi[D

@b keyex @n
@b SSL_SH: Diffie-Hellman ̏ꍇ́CDH* DHkey̔閧CDH_generate_key() i܂ 
gen_DHspki(), get_DHspki_fs(), get_DHspki_ff()łǂjɂvZi܂̓[hjC
DH* DHkey Ɋi[ĂȂ΂ȂȂD@n
@b RSA: RSȀꍇ,,,,,,,,,,,,@n

@param  keyex  ASYD݃T|[gĂ̂ SSL_DH ̂݁D
@param  spki    SPKI 

@retval TRUE   
@retval FALSE  s

@see DH_generate_key()
*/
int  gen_CRYPT_SharedKey(int keyex, Buffer spki)
{
	if (spki.buf==NULL) return FALSE;

	KEYEX_Algorism = keyex;

	if (CRYPT_SharedKey!=NULL) del_Buffer(&CRYPT_SharedKey);
	CRYPT_SharedKey = new_Buffer();

	if	    (KEYEX_Algorism==SSL_DH)  *CRYPT_SharedKey = get_DHsharedkey(spki); // L𓾂
	else if (KEYEX_Algorism==SSL_RSA) *CRYPT_SharedKey = dup_Buffer(spki);		// 
	else {
		KEYEX_Algorism  = 0;
		del_Buffer(&CRYPT_SharedKey);
		CRYPT_SharedKey = NULL;
		return FALSE;
	}

//	dump_Buffer(*CRYPT_SharedKey);
	return TRUE;
}




/**
int    has_CRYPT_SharedKey(void)

ftHgL CRYPT_SharedKey Ă邩ǂԓD

@retval TRUE   ĂD
@retval FALSE  ĂȂD
*/
int    has_CRYPT_SharedKey(void)
{
	if (CRYPT_SharedKey==NULL)	  	return FALSE;
	if (CRYPT_SharedKey->buf==NULL) return FALSE;
	return  TRUE;
}




/**
void	clear_CRYPT_parameter()

Ípp[^D

*/
void	clear_CRYPT_parameter()
{
	free_EVPAPI_Buffer();

	if (CRYPT_SharedKey!=NULL) {
		del_Buffer(&CRYPT_SharedKey);
		CRYPT_SharedKey = NULL;
	}

	CRYPT_Algorism  = 0;
	KEYEX_Algorism  = 0;
}









///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

int    tcp_send_crypt_Buffer(int sock, Buffer* data, Buffer* key)
{
	int	 cc = -2;
	Buffer buf;

	if (data==NULL) return -1;

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			buf = encode_EVPAPI_Buffer(*data, *key);
			cc = tcp_send_Buffer(sock, &buf);
			free_Buffer(&buf);
		}
	}
	else {
		cc = tcp_send_Buffer(sock, data);
	}

	return cc;
}




int   udp_send_crypt_Buffer(int sock, Buffer* data,  struct sockaddr_in* sv, Buffer* key)
{
	int	 cc = -2;
	Buffer buf;

	if (data==NULL) return -1;

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			buf = encode_EVPAPI_Buffer(*data, *key);
			cc = udp_send_Buffer(sock, &buf, sv);
			free_Buffer(&buf);
		}
	}
	else {
		cc = udp_send_Buffer(sock, data, sv);
	}

	return cc;
}




int  tcp_recv_crypt_Buffer(int sock, Buffer* data, Buffer* key)
{  
    Buffer  buf;

	buf = make_Buffer(MAXBUFSZ);
	int cc = tcp_recv_Buffer(sock, &buf);
	if (cc<=0) {
		free_Buffer(&buf);
		return cc;
	}
   
    if (CRYPT_Algorism) {
        if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
        	Buffer dec = decode_EVPAPI_Buffer(buf, *key);
			copy_Buffer(&dec, data);
        	free_Buffer(&dec);
		}
		else return -2;
    }
	else {
		copy_Buffer(&buf, data);
	}

	cc = data->vldsz;
	free_Buffer(&buf);
    return cc;
}




int  udp_recv_crypt_Buffer(int sock, Buffer* data, struct sockaddr_in* sv, Buffer* key)
{  
    Buffer  buf;

	buf = make_Buffer(MAXBUFSZ);
	int cc = udp_recv_Buffer(sock, &buf, sv);
	if (cc<=0) {
		free_Buffer(&buf);
		return cc;
	}
   
    if (CRYPT_Algorism) {
        if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
        	Buffer dec = decode_EVPAPI_Buffer(buf, *key);
			copy_Buffer(&dec, data);
        	free_Buffer(&dec);
		}
		else return -2;
    }
	else {
		copy_Buffer(&buf, data);
	}

	cc = data->vldsz;
	free_Buffer(&buf);
    return cc;
}




Buffer  get_plain_Buffer(Buffer data, Buffer* key)
{
	Buffer buf = init_Buffer();

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			buf = decode_EVPAPI_Buffer(data, *key);
		}
	}
	return buf;
}




Buffer  get_crypt_Buffer(Buffer data, Buffer* key)
{
	Buffer buf = init_Buffer();

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			buf = encode_EVPAPI_Buffer(data, *key);
		}
	}
	return buf;
}




/**
int    tcp_send_crypt_mesg(int sock, char* mesg, Buffer* key)

ÍΉ̓]֐D

Íf[^̍Ōɂ͕K @\r@\n Df[^̍Ō @\r@\n ̓[U̐ӔCŕtiʏ͂jD
CRYPT_Algorism  0 łȂꍇɂ͈Í(+@\r@\n)đD

tcp_send_crypt_mesgln(), tcp_send_crypt_sBufferln() ͍Ō̉sR[h
舵̂Œ`ȂǂiƎvjD`ꍇ tcp_send_mesgln(),
tcp_send_sBufferln()Ƃ͎gقȂ邱ƂɂȂ̂ŒӂKvD

@param  sock   \Pbg
@param  mesg   ]f[^D
@param  key    Íւ̃|C^DNULL̏ꍇ̓ftHgiCRYPT_SharedKeyjgD

@retval 0ȏ  ]f[^
@retval 0  ʐMG[

@code
tcp_send_crypt_mesg(sock, "OK\r\n");
@endcode
*/
int    tcp_send_crypt_mesg(int sock, char* mesg, Buffer* key)
{
	int	 cc = -2;
	Buffer buf, enc;

	if (mesg==NULL) return -1;
	DEBUG_ESCP(" SEND -> [%s]\n", mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			buf = make_Buffer_bystr(mesg);
			enc = encode_EVPAPI_Buffer(buf, *key);
			free_Buffer(&buf);
			if (enc.vldsz>0) {
				buf = encode_base64_Buffer(enc);
				free_Buffer(&enc);

				DEBUG_ESCP("CSEND -> [%s]\n", (char*)buf.buf);
				cc = tcp_send_sBufferln(sock, &buf);
				free_Buffer(&buf);
			}
		}
	}
	else {
		cc = tcp_send_mesg(sock, mesg);
	}

	return cc;
}




/**
int    tcp_send_crypt_sBuffer(int sock, Buffer* mesg, Buffer* key)

ÍΉ̓]֐D

Íf[^̍Ōɂ͕K @\r@\n Df[^̍Ō @\r@\n ̓[U̐ӔCŕtiʏ͂jD
CRYPT_Algorism  0 łȂꍇɂ͈Í(+@\r@\n)đD

tcp_send_crypt_mesgln(), tcp_send_crypt_sBufferln() ͍Ō̉sR[h
舵̂Œ`ȂǂiƎvjD`ꍇ tcp_send_mesgln(),
tcp_send_sBufferln()Ƃ͎gقȂ邱ƂɂȂ̂ŒӂKvD

@param  sock   \Pbg
@param  mesg   ]f[^D
@param  key    Íւ̃|C^DNULL̏ꍇ̓ftHgiCRYPT_SharedKeyjgD

@retval 0ȏ  ]f[^
@retval 0  ʐMG[

@code
tcp_send_crypt_mesg(sock, "OK\r\n");
@endcode
*/
int    tcp_send_crypt_sBuffer(int sock, Buffer* mesg, Buffer* key)
{
	int	 cc = -2;
	Buffer buf, enc;

	if (mesg==NULL) return -1;
	DEBUG_ESCP(" SEND -> [%s]\n", (char*)mesg->buf);

	if (CRYPT_Algorism) {
		//
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			enc = encode_EVPAPI_Buffer(*mesg, *key);
			if (enc.vldsz>0) {
				buf = encode_base64_Buffer(enc);
				free_Buffer(&enc);

				DEBUG_ESCP("CSEND -> [%s]\n", (char*)buf.buf);
				cc = tcp_send_sBufferln(sock, &buf);
				free_Buffer(&buf);
			}
		}
	}
	else {
		cc = tcp_send_sBuffer(sock, mesg);
	}

	return cc;
}




/**
Buffer  get_plain_message(char*  mesg, Buffer* key)

֐D̑O Base64̃R[hsȂD

@b CRYPT_Algorism  0 ̏ꍇ͕ϊsȂȂD 

@param  mesg  ϊ郁bZ[W
@param  key   Íւ̃|C^DNULL̏ꍇ̓ftHgi@b CRYPT_SharedKeyjgD

@return ϊꂽbZ[W
*/
Buffer  get_plain_message(char* mesg, Buffer* key)
{
	Buffer  buf, dec;

	buf = make_Buffer_bystr(mesg);
	DEBUG_ESCP(" MESG -> [%s]\n", mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			dec = decode_base64_Buffer(buf);
			if (dec.vldsz>0) {
				free_Buffer(&buf);
				buf = decode_EVPAPI_Buffer(dec, *key);
				free_Buffer(&dec);
				DEBUG_ESCP("DMESG -> [%s]\n", (char*)buf.buf);
			}
		}
	}
	return buf;
}





/**
Buffer  get_plain_sBuffer(Buffer mesg, Buffer* key)

֐D̑O Base64̃R[hsȂD

@b CRYPT_Algorism  0 ̏ꍇ͕ϊsȂȂD 

@param  mesg  ϊ郁bZ[W
@param  key   Íւ̃|C^DNULL̏ꍇ̓ftHgi@b CRYPT_SharedKeyjgD

@return ϊꂽbZ[W
*/
Buffer  get_plain_sBuffer(Buffer mesg, Buffer* key)
{
	Buffer buf, dec;

	buf = dup_Buffer(mesg);
	DEBUG_ESCP(" MESG -> [%s]\n", (char*)mesg.buf);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			dec = decode_base64_Buffer(buf);
			if (dec.vldsz>0) {
				free_Buffer(&buf);
				buf = decode_EVPAPI_Buffer(dec, *key);
				free_Buffer(&dec);
				DEBUG_ESCP("DMESG -> [%s]\n", (char*)buf.buf);
			}
		}
	}
	return buf;
}




/**
Buffer  get_crypt_message(char*  mesg, Buffer* key)

Í֐DÍɉ Base64sȂD

@b CRYPT_Algorism  0 ̏ꍇ͕ϊsȂȂD 

@param  mesg  ϊ郁bZ[W
@param  key   Íւ̃|C^DNULL̏ꍇ̓ftHgi@b CRYPT_SharedKeyjgD

@return ϊꂽbZ[W
*/
Buffer  get_crypt_message(char* mesg, Buffer* key)
{
	Buffer  buf, enc;

	buf = make_Buffer_bystr(mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			enc = encode_EVPAPI_Buffer(buf, *key);
			if (enc.vldsz>0) {
				free_Buffer(&buf);
				buf = encode_base64_Buffer(enc);
				free_Buffer(&enc);
			}
		}
	}
	return buf;
}




/**
Buffer  get_crypt_sBuffer(Buffer mesg, Buffer* key)

֐DÍɉ Base64sȂD

@b CRYPT_Algorism  0 ̏ꍇ͕ϊsȂȂD 

@param  mesg  ϊ郁bZ[W
@param  key   Íւ̃|C^DNULL̏ꍇ̓ftHgi@b CRYPT_SharedKeyjgD

@return ϊꂽbZ[W
*/
Buffer  get_crypt_sBuffer(Buffer mesg, Buffer* key)
{
	Buffer  buf, enc;

	buf = dup_Buffer(mesg);

	if (CRYPT_Algorism) {
		if (key==NULL) key = CRYPT_SharedKey;
		if (key!=NULL) {
			enc = encode_EVPAPI_Buffer(buf, *key);
			if (enc.vldsz>0) {
				free_Buffer(&buf);
				buf = encode_base64_Buffer(enc);
				free_Buffer(&enc);
			}
		}
	}
	return buf;
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Client's Side Check 
//

/**
int    check_server_spki(char* filename, Buffer ipaddr, Buffer spki)

T[o瓾 SPKICȑOۑĂ SPKIƔrāCT[o̐D

t@CSPKIꍇ́CVK̃T[oƂāCIPAhXSPKIۑD
NCAgŃT[o̔FɎgpD

@param  filename  ۑĂt@C
@param  ipaddr    T[oIPAhXi^jF192.168.1.1
@param  spki      T[oSPKI(DER)D

@retval TRUE      T[oSPKI͈ȑOۑSPKIɈvD܂͐VK̃T[oD
@retval FALSE     T[oSPKI͈ȑOۑSPKIɈvȂD
 */
int    check_server_spki(Buffer ipaddr, Buffer spki, char* filename)
{
	Buffer  buf;
	FILE*	fp;

	buf = init_Buffer();

	fp = fopen(filename, "rb");
	if (fp!=NULL) {
		buf = read_spki_with_ipaddr(ipaddr, fp);
		fclose(fp);
		if (buf.buf!=NULL) {
			if (bincmp_Buffer(buf, spki)) {
				free_Buffer(&buf);
				return FALSE;
			}
		}
	}

	if (buf.buf==NULL) {
		fp = file_chmod_open(filename, (char*)"a", S_IRUSR | S_IWUSR);
		save_spki_with_ipaddr(ipaddr, spki, fp);
		fclose(fp);
	}

	return TRUE;
}





/**
int    save_spki_with_ipaddr(Buffer ipa, Buffer pki, FILE* fp)

T[ǒJiX.509 SubjectPublicKeyInfojʎqipa ƋɃt@CɕۑD

ʎqɂ͒ʏ IPAhXgpD@n
ʎqC̏ŕۑDɃt@C݂ꍇ̓f[^̓t@C̍ŌɒǉD@n
ʎqIPAhXgp邱ƂɂCNCAgł̃T[oF؂ɎgpD

@param  ipa   ʎqDʏ̓T[oIPAhXD
@param  pki   ۑ錮iDERjD
@param  fp    ۑ̃t@CLqq

@retval TRUE  D
@retval FALSE sD
*/
int    save_spki_with_ipaddr(Buffer ipa, Buffer pki, FILE* fp)
{	
	unsigned int  md;

	if (fp==NULL) return FALSE;

	md = FBRTL_IPADDRESS | FBRTL_STRING;
	if (!save_taggedBuffer(ipa, fp, md, FALSE)) return FALSE;

	md = FBRTL_SPKI | FBRTL_ORIGINAL;
	if (!save_taggedBuffer(pki, fp, md, FALSE)) return FALSE;

	return  TRUE;
}




/**
Buffer  read_spki_with_ipaddr(Buffer ipa, FILE* fp)

IPAhX ipaT[ǒJiX.509 SubjectPublicKeyInfojt@CǂݍށD

@param  ipa  IPAhX
@param  fp   ǂݍރt@CLqq

@return IPAhXipa ̌(DER)D
*/
Buffer  read_spki_with_ipaddr(Buffer ipa, FILE* fp)
{
	unsigned int md;
	Buffer	ips, pki;

	pki = init_Buffer();
	if (ipa.buf==NULL) return pki;

	md  = FBRTL_IPADDRESS | FBRTL_STRING;

	ips = read_taggedBuffer(fp, &md);
	while (!feof(fp) && strcmp_Buffer(ipa, ips)) {
		ips = read_taggedBuffer(fp, &md);
	}
		
	if (!strcmp_Buffer(ipa, ips)) {
		md  = FBRTL_SPKI | FBRTL_ORIGINAL;	
		pki = read_taggedBuffer(fp, &md);
	}
	free_Buffer(&ips);

	return pki;
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// EVP API
//

/**
int    init_EVPAPI_Buffer(int type)

ʌÍ̃ASYw肷D

xɁiɁj̈ÍIuWFNg͎włȂD
ݒNAɂ free_EVPAPI_Buffer()gpD

@param  type   ÍIuWFNgiÍ@j

@retval TRUE   D
@retval FALSE  sD

OpenSSL̈ÍIuWFNg̎ށiꕔjD
@code
- AES:      EVP_aes_#_X()  # 128, 192, 256  X ecb, cbc, cfb, ofb  FEVP_aes_128_cbc()
- Blowfish: EVP_bf_X()  X ecb, cbc, cfb, ofb
- DES:      EVP_des_X() X ecb, cbc, cfb, ofb
- 3DES:     EVP_des_ede(),  EVP_des_ede_X()    X cbc, cfb, ofb
            EVP_des_ede3(), EVP_des_ede3_X()   X cbc, cfb, ofb
- RC4:      EVP_rc4(), EVP_rc4_40()
@endcode
*/
int    init_EVPAPI_Buffer(int type)
{
	if (type==SSL_AES128CBC) {
		CRYPT_Type	 	= EVP_aes_128_cbc();
		CRYPT_Algorism 	= SSL_AES128CBC;
	}
	else if (type==SSL_3DES3CBC) {
		CRYPT_Type 		= EVP_des_ede3_cbc();
		CRYPT_Algorism 	= SSL_3DES3CBC;
	}
	else {
		CRYPT_Type	   = NULL;
		CRYPT_Algorism = 0;
		return FALSE;
	}

	return TRUE;
}




/**
void free_EVPAPI_Buffer(void)

Íp[^NAD

*/
void free_EVPAPI_Buffer(void)
{
	CRYPT_Type	   = NULL;
	CRYPT_Algorism = 0;
}





/**
Buffer  decode_EVPAPI_Buffer(Buffer buf, Buffer shkey)

init_EVPAPI_Buffer() ɂĎw肳ꂽ@ɂ Íbuf𕜍D

@param  buf    Íf[^
@param  shkey  LL[
@return ij
*/
Buffer  decode_EVPAPI_Buffer(Buffer buf, Buffer shkey)
{
	int		sz, ss;
	Buffer dec;
	EVP_CIPHER_CTX* ctx;
	unsigned char*  iv;

	dec = init_Buffer();
	if (CRYPT_SharedKey==NULL || CRYPT_Type==NULL) return dec;

	iv  = (unsigned char*)&(shkey.buf[shkey.vldsz - SSL_IV_SIZE]);

	ctx = (EVP_CIPHER_CTX*)malloc(sizeof(EVP_CIPHER_CTX));
	EVP_CIPHER_CTX_init(ctx);
	//EVP_DecryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, NULL);
	EVP_DecryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, iv);

	dec = make_Buffer(buf.vldsz + EVP_CIPHER_CTX_block_size(ctx) + 1);
	if (dec.buf==NULL) return dec;

	EVP_DecryptUpdate(ctx, dec.buf, &sz, buf.buf, buf.vldsz);
	EVP_DecryptFinal_ex(ctx, &(dec.buf[sz]), &ss);
	dec.vldsz = sz + ss;
	dec.buf[dec.vldsz] = '\0';

	EVP_CIPHER_CTX_cleanup(ctx);
	free(ctx);
	return dec;
}





/**
Buffer  encode_EVPAPI_Buffer(Buffer buf, Buffer shkey)

init_EVPAPI_Buffer() ɂĎw肳ꂽ@ɂ buf ÍD

 @b CRYPT_SharedKey gD
Í @b SSL_ENC_BLCKSZ ByteɁCÍiubNÍj

@param  buf    Íf[^
@param  shkey  LL[
@return Í
*/
Buffer  encode_EVPAPI_Buffer(Buffer buf, Buffer shkey)
{
	int		i, len, ss=0, sz;
	Buffer enc;
	EVP_CIPHER_CTX* ctx;
	unsigned char*  iv;

	enc = init_Buffer();
	if (CRYPT_SharedKey==NULL || CRYPT_Type==NULL) return enc;

	iv  = (unsigned char*)&(shkey.buf[shkey.vldsz - SSL_IV_SIZE]);

	ctx = (EVP_CIPHER_CTX*)malloc(sizeof(EVP_CIPHER_CTX));
	EVP_CIPHER_CTX_init(ctx);
	//EVP_EncryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, NULL);
	EVP_EncryptInit_ex(ctx, CRYPT_Type, NULL, shkey.buf, iv);

	len = buf.vldsz;
	enc = make_Buffer(len + EVP_CIPHER_CTX_block_size(ctx));
	if (enc.buf==NULL) return enc;

	for (i=0; i<len/SSL_ENC_BLCKSZ; i++) {
		EVP_EncryptUpdate(ctx, &(enc.buf[ss]), &sz, &(buf.buf[i*SSL_ENC_BLCKSZ]), SSL_ENC_BLCKSZ);
		ss += sz;
	}
	if (len%SSL_ENC_BLCKSZ!=0) {
		EVP_EncryptUpdate(ctx, &(enc.buf[ss]), &sz, &(buf.buf[i*SSL_ENC_BLCKSZ]), len%SSL_ENC_BLCKSZ);
		ss += sz;
	}
	EVP_EncryptFinal_ex(ctx, &(enc.buf[ss]), &sz);
	enc.vldsz = ss + sz;

	EVP_CIPHER_CTX_cleanup(ctx);
	free(ctx);
	return  enc;
}






///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Diffie-Hellman @
//

/**
int    save_DHspki_with_private(Buffer pki, FILE* fp)

Diffie-Hellman ̌JiX.509 SubjectPublicKeyInfojpkiƃvCx[g
(ϐDHkey擾)t@CɕۑDJCvCx[g̏
܂DɃt@C݂ꍇC̓e͏㏑D

@param  pki   ۑ錮iDERjD
@param  fp    t@C|C^ 

@retval TRUE  D
@retval FALSE sDt@C̓e͕ۏ؂ȂD
*/
int    save_DHspki_with_private(Buffer pki, FILE* fp)
{	
	unsigned int  md;
	Buffer pv;

	if (fp==NULL || DHkey==NULL) return FALSE;

	md = FBRTL_SPKI | FBRTL_ORIGINAL;
	if (!save_taggedBuffer(pki, fp, md, FALSE)) return FALSE;

	pv = get_DHprivatekey(DHkey);
	if (pv.buf==NULL) return FALSE;

	md = FBRTL_PRIV_KEY | FBRTL_ORIGINAL;
	if (!save_taggedBuffer(pv,  fp, md, FALSE)) return FALSE;
	free_Buffer(&pv);

	return  TRUE;
}




/**
Buffer  read_DHspki_with_private(FILE* fp)

Diffie-Hellman ̌JiX.509 SubjectPublicKeyInfojƃvCy[gt@CǂݍށD

@param  fp  t@C|C^ 
@return ǂݍ񂾌D
*/
Buffer  read_DHspki_with_private(FILE* fp)
{
	int  n, code;
	DH*  dh=NULL;
	unsigned int  md;
	Buffer	pp, pv, pk, gk, yk;

	pp = init_Buffer();
	if (fp==NULL) return pp;

	md = FBRTL_SPKI | FBRTL_ORIGINAL;
	pp = read_taggedBuffer(fp, &md);
	if (pp.buf==NULL) return pp;

	dh = DH_new();
	if (dh==NULL) {
		free_Buffer(&pp);
		return pp;
	}
	
	pk = get_DHPkey(pp);
	gk = get_DHGkey(pp);
	yk = get_DHYkey(pp);

	dh->p = BN_bin2bn((const unsigned char*)(pk.buf), pk.vldsz, NULL);
	dh->g = BN_bin2bn((const unsigned char*)(gk.buf), gk.vldsz, NULL);
	dh->pub_key = BN_bin2bn((const unsigned char*)(yk.buf), yk.vldsz, NULL);

	free_Buffer(&pk);
	free_Buffer(&gk);
	free_Buffer(&yk);

	// ̃`FbN
	n = DH_check(dh, &code);
	if (n!=1 || code!=0) {
		DH_free(dh);
		free_Buffer(&pp);
		return pp;
	}

	// Private KEY ̓ǂݍ
	md = FBRTL_PRIV_KEY | FBRTL_ORIGINAL;
	pv = read_taggedBuffer(fp, &md);
	if (pv.buf==NULL) return pp;

	dh->priv_key = BN_bin2bn((const unsigned char*)(pv.buf), pv.vldsz, NULL);
	free_Buffer(&pv);

	if (DHkey!=NULL) DH_free(DHkey);
	DHkey = dh;

	return  pp;
}




/**
Buffer  get_DHspki_ff(char* filename, int ks)

Generate DH SPKI from File.

t@C Diffie-Hellman ̌ǂݍށD

ȉ̏ꍇɂks̃TCY̌VɐCt@CɕۑĂԂD
-# t@C݂ȂCǂݍ߂Ȃ
-# t@CɃvCx[gۑĂȂ
-# t@C̒̌̒ ksZ


ϐ DH* DHkey DȞp[^D

@param  filename  ۑĂt@C
@param  ks        Vɐꍇ̌(Bit)D

@return DER`̌JD
*/
Buffer  get_DHspki_ff(char* filename, int ks)
{
	Buffer  pki;
	FILE*	fp;

	pki = init_Buffer();
	if (filename==NULL || DHkey==NULL) return pki;

	if (file_exist(filename)) {
		DEBUG_MESG("Load DH public key. ");
		fp = fopen(filename, "rb");
		pki = read_DHspki_with_private(fp);
		fclose(fp);
		DEBUG_MESG("... done.\n");
		if (pki.buf!=NULL) {
			if (DH_size(DHkey)<(ks+7)/8 || DHkey->priv_key==NULL) free_Buffer(&pki);
		}
	}

	if (pki.buf==NULL) {
		DEBUG_MESG("Generate DH public key.\n");
		pki = gen_DHspki(ks);
		DEBUG_MESG("... done.\n");

		fp = file_chmod_open(filename, (char*)"w", S_IRUSR | S_IWUSR);
		if (fp!=NULL) {
			save_DHspki_with_private(pki, fp);
			fclose(fp);
		}
	}

	/*
	DEBUG_MODE {
		Buffer enc;
		enc = encode_base64_Buffer(pki);
		DEBUG_MESG("SPKI = [%s]\n", enc.buf);
		free_Buffer(&enc);
	}*/
	return pki;
}




/**
Buffer  gen_DHspki(int ks)

Diffie-Hellman ̌𐶐,J̊SȏiX.509 SubjectPublicKeyInfojDER`ŕԂD@n
ϐ DH* DHkey DȞp[^D

@param  ks  (Bit)D512 1024wD
@return DER`̌JD
*/
Buffer  gen_DHspki(int ks)
{
	int	   sz, n, code;
	Buffer px, pp, pk;

	pk = init_Buffer();

	//if (!RAND_load_file("/dev/random", 1024)) return pk;
	DEBUG_MESG("Load /dev/urandom.");
	if (!RAND_load_file("/dev/urandom", 1024)) return pk;

	do {
		DEBUG_MESG(" Generate parameters.");
		if (DHkey!=NULL) DH_free(DHkey);
		DHkey = DH_generate_parameters(ks, DH_GENERATOR_2, NULL, NULL);
		n = DH_check(DHkey, &code);
	} while (n!=1 || code!=0);

	DEBUG_MESG(" Generate key.");
	sz = DH_generate_key(DHkey);				// J(DH->pub_key)Ɣ閧(DH->priv_key)̐
	if (sz==0) {
		DH_free(DHkey);
		DHkey = NULL;
		return pk;
	}

	DEBUG_MESG(" Check key size.");
	sz = i2d_DHparams(DHkey, NULL);			 	// p^̃TCY 
	pp = px = make_Buffer(sz);				  	// p^郁m 
	if (pp.buf==NULL) {
		DH_free(DHkey);
		DHkey = NULL;
		return pk;
	}
	pp.vldsz = i2d_DHparams(DHkey, &(px.buf));  // p^(P,G) DER`ցDpp.bufɊi[D 
												// px.buf͔j󂳂D

//	sz = DH_size(DHkey);
	sz = BN_num_bytes(DHkey->pub_key);
	px = make_Buffer(sz);
	if (px.buf==NULL) {
		DH_free(DHkey);
		DHkey = NULL;
		free_Buffer(&pp);
		return pk;
	}

//	for (i=0; i<sz; i++) px.buf[i] = ((unsigned char*)(DHkey->pub_key->d))[sz-i-1];
	px.vldsz = BN_bn2bin(DHkey->pub_key, px.buf);

	pk = join_DHpubkey(pp, px);					// pp -> DHp^(P,G),  px-> Y

	free_Buffer(&pp);
	free_Buffer(&px);

	return pk;
}





/**
Buffer  gen_DHspki_fs(Buffer pki)

Generate DH SPKI from Server's SPKI.

T[ǒJ̏iX.509 SubjectPublicKeyInfo, DER`j̒ P,G
̌JiX.509 SPKI, DER`joD@n
ϐ DH* DHkey DȞp[^D

@param  pki ̌JiDER`j
@return ̌J̏iX.509 SubjectPublicKeyInfo, DER`j
*/
Buffer  gen_DHspki_fs(Buffer pki)
{
	int	   sz, n, code;
	Buffer px, pp, pk;
	Buffer pkey, gkey;

	//
	pk = init_Buffer();
	//
	if (DHkey!=NULL) DH_free(DHkey);
	DHkey = DH_new();
	if (DHkey==NULL) return pk;

	pkey = get_DHPkey(pki);
	gkey = get_DHGkey(pki);
	if (pkey.buf==NULL || gkey.buf==NULL) {
		free_Buffer(&pkey);
		free_Buffer(&gkey);
		DH_free(DHkey);
		DHkey = NULL;
		return pk;
	}

	//
	DHkey->p = BN_bin2bn((const unsigned char*)(pkey.buf), pkey.vldsz, NULL);
	DHkey->g = BN_bin2bn((const unsigned char*)(gkey.buf), gkey.vldsz, NULL);
	free_Buffer(&pkey);
	free_Buffer(&gkey);

	//
	n = DH_check(DHkey, &code);
	if (n!=1 || code!=0) {
		DH_free(DHkey);
		DHkey = NULL;
		return pk;
	}

	sz = DH_generate_key(DHkey);
	if (sz==0) {
		DH_free(DHkey);
		DHkey = NULL;
		return pk;
	}

	//
	sz = i2d_DHparams(DHkey, NULL);			 		// p^̃TCY 
	pp = px = make_Buffer(sz);				  		// p^郁m 
	if (pp.buf==NULL) {
		DH_free(DHkey);
		DHkey = NULL;
		return pk;
	}
	pp.vldsz = i2d_DHparams(DHkey, &(px.buf));  	// p^(P,G) DER`ցDpp.bufɊi[D 
													// px.buf͔j󂳂D
	sz = BN_num_bytes(DHkey->pub_key);
	px = make_Buffer(sz);
	if (px.buf==NULL) {
		DH_free(DHkey);
		DHkey = NULL;
		free_Buffer(&pp);
		return px;
	}
	px.vldsz = BN_bn2bin(DHkey->pub_key, px.buf);	// J(Y) DER` 

	pk = join_DHpubkey(pp, px);						// pp -> DHp^(P,G),  px-> Y

	free_Buffer(&pp);
	free_Buffer(&px);

	return pk;
}





/**
Buffer get_DHsharedkey(Buffer dec)

̌J̏iX.509 SubjectPublicKeyInfo, DER`jDHkeyǐjɋʂoD

ϐ DH* DHkey gpDDHkey ɂ DH_generate_key(DHkey)igen_DHspki() ܂ 
gen_DHspki_fs()łjɂđSẴp[^iP,G,Y,閧jݒ肳ĂȂ΂ȂȂD 

@param  dec  ̌J
@return ʌioCij

	QlFman -M /usr/local/ssl/man bn
*/
Buffer get_DHsharedkey(Buffer dec)
{
	Buffer  ykey, skey;
	
	skey = init_Buffer();
	ykey = get_DHYkey(dec);
	if (ykey.buf==NULL) return skey;

	skey = get_DHsharedkey_fY(ykey);
	
	free_Buffer(&ykey);
	return skey;
}







/**
Buffer get_DHsharedkey_fY(Buffer ykey)

́iDiffie-Hellman ́jYDHkeyǐjɋʌoD

  ϐ DHkey gpD DHkey ɂ DH_generate_key()igen_DHspki() ܂ 
  gen_DHspki_fs()łjɂđSẴp[^iP,G,Y,閧jݒ肳
  Ȃ΂ȂȂD 

@param  ykey   YiJj
@return ʌioCij

	QlFman -M /usr/local/ssl/man bn
*/
Buffer get_DHsharedkey_fY(Buffer ykey)
{
	int sz, n;
	Buffer  buf;
	BIGNUM* yk;

	buf = init_Buffer();
	if (DHkey==NULL) return buf;

	yk = BN_bin2bn((const unsigned char*)(ykey.buf), ykey.vldsz, NULL);

	sz  = DH_size(DHkey);
	buf = make_Buffer(sz);
	n	= DH_compute_key((unsigned char*)buf.buf, yk, DHkey);
	buf.vldsz = sz;

	BN_free(yk);
	return buf;
}




/**
Buffer	get_DHYkey(Buffer param)

X.509 SubjectPublicKeyInfo DER`CDiffie-Hellman YoD 

@param  param  X.509 SubjectPublicKeyInfo DER`
@return YioCij

QlF
@code
	[SEQ  [SEQ	[OBJ  Algor]
				[SEQ  [INT  P-key]
					  [INT  G-key]
					  [INT  P-keysize - 1]
				]
		  ]
		  [BIT  Seed(0x00)  [INT  Y-key]]
	]
@endcode
*/
Buffer	get_DHYkey(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_BIT, sz, &lp);
	if (sz<0) return pp;
	sz++;						// for Seed(0x00)

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}




/**
Buffer	get_DHPkey(Buffer param)

X.509 SubjectPublicKeyInfo DER`CDiffie-Hellman PoD 

@param  param  X.509 SubjectPublicKeyInfo DER`
@return PioCij

QlF
@code
	[SEQ  [SEQ	[OBJ  Algor]
				[SEQ  [INT  P-key]
					  [INT  G-key]
					  [INT  P-keysize - 1]
				]
		  ]
		  [BIT  Seed(0x00)  [INT  Y-key]]
	]
@endcode
*/
Buffer	get_DHPkey(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_OBJ, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}



	

/**
Buffer	get_DHGkey(Buffer param)

X.509 SubjectPublicKeyInfo DER`CDiffie-Hellman GoD 
ʂ 2  5D

@param  param  X.509 SubjectPublicKeyInfo DER`
@return GioCij

QlF
@code
	[SEQ  [SEQ	[OBJ  Algor]
		  		[SEQ  [INT  P-key]
					  [INT  G-key]
					  [INT  P-keysize - 1]
		  		]
		  ]
		  [BIT  Seed(0x00)  [INT  Y-key]]
	] 
@endcode
*/
Buffer	get_DHGkey(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_OBJ, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;
	sz = sz + lp;

	sz = skip_DERtag(param, ASN1_INT, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}





/**
Buffer	get_DHalgor(Buffer param)

X.509 SubjectPublicKeyInfo DER`CASY(Algor)oD 

@param  param  X.509 SubjectPublicKeyInfo DER`
@return ASYioCij

QlF
@code
	[SEQ  [SEQ  [OBJ  Algor]
		  		[SEQ  [INT  P-key]
					  [INT  G-key]
					  [INT  P-keysize - 1]
		  		]
		  ]
		  [BIT  Seed(0x00)  [INT  Y-key]]
	]  
@endcode
*/
Buffer	get_DHalgor(Buffer param)
{
	int	 i, lp, sz=0;
	Buffer  pp;
	pp = init_Buffer();

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_SEQ, sz, &lp);
	if (sz<0) return pp;

	sz = skip_DERtag(param, ASN1_OBJ, sz, &lp);
	if (sz<0) return pp;

	pp = make_Buffer(lp);
	if (pp.buf==NULL) return pp;
	for (i=0; i<lp; i++) pp.buf[i] = param.buf[sz+i];
	pp.vldsz = lp;
	return pp;
}




/**
Buffer  get_DHprivatekey(DH* dh)

DH dh vCx[goĕԂD

@param  dh  DHD
@return vCx[g
*/
Buffer  get_DHprivatekey(DH* dh)
{
	int	sz;
	Buffer pv;

	sz = BN_num_bytes(dh->priv_key);
	pv = make_Buffer(sz);
	if (pv.buf==NULL) return pv;
	pv.vldsz = BN_bn2bin(dh->priv_key, pv.buf);

	return pv;
}




/**
Buffer	join_DHpubkey(Buffer param, Buffer key)

Diffie-Hellman ̌̂߂ X.509 SubjectPublicKeyInfo 擾D

DHp^(P+G)DH(Y)DER`,SȌDER`D

@param  param  DHp[^(P,G)Di2d_DHparams()ɂ DER`D
@param  key   DHJ(Y) DER`D

@return DER`̌JD[[Algor + [P + G + PKeySize]] + [BIT [Y]]]


QlF param ̃f[^`
@code
	[SEQ  [INT  P-key]
		  [INT  G-key]
	]
@endcode
łD Y-key  L̃f[^𐶐D
@code
	[SEQ  [SEQ  [OBJ  Algor]
				[SEQ  [INT  P-key]
					  [INT  G-key]
					  [INT  P-keysize - 1]
				]  
		  ]
		  [BIT(gpbit)  [INT  Y-key]]
	]  
@endcode

@attention
DH̃ASY {0x06,0x07,0x2a,0x86,0x48,0xce,0x3e,0x02,0x01} Ǝv̂,RSÃASYœ悤H
*/
Buffer	join_DHpubkey(Buffer param, Buffer key)
{
//	unsigned char dh_algor[]={0x06,0x07,0x2a,0x86,0x48,0xce,0x3e,0x02,0x01};			// DH  ?
	unsigned char dh_algor[]={0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x03,0x01};	// RSA ?
											//  RSAASYH 
	int len_dh_algor = 11;

	int ls, lp, la, sz;
	Buffer  px, pp, pm;

	// [P + G]  pp 
	pp = init_Buffer();
	sz = skip_DERtag(param, ASN1_SEQ, 0, &lp);
	if (sz<0) return pp;

	pp.buf	 = param.buf   + sz;
	pp.bufsz = param.bufsz - sz;
	pp.vldsz = param.vldsz - sz;

	// [TCY]  pm 
	px = int2DER(key.vldsz*8-1);
	pm = toDER(px, ASN1_INT);
	ls = pm.vldsz;
	free_Buffer(&px);

	// pp[P + G] + pm[TCY]  pm 
	px = make_Buffer(lp+ls); 
	memcpy(px.buf,	pp.buf, lp);
	memcpy(px.buf+lp, pm.buf, ls);  
	px.vldsz = lp + ls;
	free_Buffer(&pm);			  // pp freeĂ͂Ȃ 
	pm = toDER(px, ASN1_SEQ); 
	ls = pm.vldsz;
	free_Buffer(&px);

	// dh_algor[ASY] + pm[P + G + TCY]  px 
	la = len_dh_algor; 
	pp = make_Buffer(ls+la); 
	memcpy(pp.buf,  dh_algor, la);
	memcpy(pp.buf+la, pm.buf, ls);
	pp.vldsz = ls + la;
	free_Buffer(&pm);		 
	px = toDER(pp, ASN1_SEQ);
	ls = px.vldsz;
	free_Buffer(&pp);  

	// px[ASY + P + G + TCY] + pp[Y]  pm 
	pm = toDER(key, ASN1_INT);
	pp = toDER(pm,  ASN1_BIT);
	lp = pp.vldsz;
	free_Buffer(&pm); 
	pm = make_Buffer(ls+lp);
	memcpy(pm.buf,	px.buf, ls);
	memcpy(pm.buf+ls, pp.buf, lp);
	pm.vldsz = ls + lp;
	free_Buffer(&px);
	free_Buffer(&pp);  

	pp = toDER(pm, ASN1_SEQ);
	free_Buffer(&pm);
	return pp;
}







///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ASN.1 DER
//

/**
int  skip_DERtag(Buffer param, char tag, int ls, int* lp) 

^OIuWFNg param̒ ls ̈ʒu[^O(tag)][^Ol̒]
XLbvāC[^Ol]̈ʒu(returnl)Ƃ̃^Ol̒ *lp ԂD

@param      param  ^OIuWFNgS
@param      tag    ݂̃^OimF̂߂Ɏwj
@param      ls     ^OIuWFNgS̓ł̑Jn_  
@param[out] lp     ֐IɁC̃^Õ^Ol̒i[Dl͎w肵ȂD

@return            ̃^Õ^Ol̐擪ʒuD

@code
QlF       ls
    [^OIuWFNg] = .....[^O(tag)][^Ol̒(*lp)][^Ol][^O].......
                    return
    [^Ol]ƂāC̒[^OIuWFNg]܂ޏꍇiKw\蓾j
@endcode
*/
int  skip_DERtag(Buffer param, unsigned char tag, int ls, int* lp) 
{
	int i, sz=-1;

	if ((unsigned char)param.buf[ls]==tag) {
		if ((unsigned char)param.buf[ls+1]>=0x80) {
			sz = (int)param.buf[ls+1] - 128;
			*lp = 0;
			for (i=ls+2; i<ls+sz+2; i++) {
				*lp *= 256;
				*lp += (unsigned char)param.buf[i];
			}	
		}
		else {
			sz = 0;
			*lp = (int)param.buf[ls+1];
		}
		//if ((unsigned char)param.buf[ls]==ASN1_BIT) sz++;
		sz = ls + sz + 2;
	}

	return sz;
}







/**
Buffer  toDER(Buffer pt, char tag)

f[^ DER`ɕϊD
݂ ASN1_INT, ASN1_SEQ, ASN1_BIT ݂̂T|[gD

@param  pt   ϊf[^
@param  tag  f[^`̃^ODASN1_INT, ASN1_SEQ, ASN1_BIT T|[gDftHg  ANS1_SEQD

@return DER`֕ϊꂽf[^D
*/
Buffer  toDER(Buffer pt, char tag)
{
	int  sz, len, pp;
	unsigned char  cnt=0;
	Buffer	buf;

	len = get_DER_length(pt, tag);  
	buf = make_Buffer(len);
	sz = pt.vldsz;
	pp = len - sz;
	memcpy(buf.buf+pp, pt.buf, sz);

	pp--;
	if (tag==ASN1_INT) {
		if (pt.buf[0]>=0x80) {
			sz++;
			buf.buf[pp--] = 0x00;
		}
	}
	else if (tag==ASN1_BIT) {
		sz++;
		buf.buf[pp--] = 0x00;
	}

	buf.buf[0] = tag;
	if (sz>=128) {
		cnt++;
		while (sz>=256) {
			buf.buf[pp--] = sz % 256;
			sz >>= 8;
			cnt++;
		}
		buf.buf[pp] = (unsigned char)sz;
		buf.buf[1]  = 0x80 + cnt;
	}
	else {
		buf.buf[1] = (unsigned char)sz;
	}

	buf.vldsz = len;
	return buf;
}




/**
Buffer  int2DER(int n)

 DER`̃oCiɕϊD,INT^O͕tȂD

@param  n  ϊ鐮l
@return DER̃oi`D

@bug ̊֐ł,int^͈̔͂̐lȂD
*/
Buffer  int2DER(int n)
{
	int  ii, div, cnt;
	Buffer str;

	cnt = 1;
	div = n;
	while(div>=256) {
		div >>= 8;
		cnt++;
	}

	str = make_Buffer(cnt);
	ii = cnt - 1;

	while(n>=256) {
		str.buf[ii--] = (unsigned char)(n % 256);
		n >>= 8;
	}
	str.buf[0] = (unsigned char)n;
	str.vldsz  = cnt;

	return str;
}




/**
int  get_DER_length(Buffer pt, char tag)

f[^DER`ɕϊꍇ̒vZD
 
@param  pt   vZΏۂ̃f[^D
@param  tag  f[^`̃^ODASN1_INT, ASN1_SEQ, ASN1_BIT T|[gDftHg ANS1_SEQD

@return f[^DER`ɕϊꍇ̒DG[̏ꍇ 0D
*/
int  get_DER_length(Buffer pt, char tag)
{
	int  sz, div, cnt=0;

	sz = pt.vldsz;
	if (tag==ASN1_INT) {
		if (pt.buf[0]>=0x80) sz++;
	}
	else if (tag==ASN1_BIT) sz++;	

	div = sz;
	if (div>=128) cnt++;
	while (div>=256) {
		div >>= 8;
		cnt++;
	}
	sz = sz + cnt + 2;
	return sz;
}
	
	





///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// SSL/TLS
//
// 		Reference: 	http://h71000.www7.hp.com/doc/83final/BA554_90007/ch04s03.html
//					http://x68000.q-e-d.net/~68user/net/
//

/**
<b>SSL/TLS ֐</b>

@attention
F̊֐Qł́CSSL_CTX*  SSL* ̕ϐ͈ΈɑΉĂ
͈C\[XՂȂD
*/



/**
void  ssl_init()

SSL/TLS ̏sDɐ旧āC̏sĂǂD

*/
void  ssl_init()
{
	SSL_library_init();
	SSL_load_error_strings();
}




/**
SSL*  ssl_client_connect(int sock)

SSL/TLS̃Xg[쐬C\PbgƊ֘AtD@n
ɂ葊iSSLׂT[ojSSL/TLSʐM\ɂȂD

@param  sock     SSLʐMs\Pbg
@param  ca       F؋ǂ̎ȏؖ PEM`
@param  mode     T[oؖ̃`FbNsH
@param  mode     @b ON:  sDF؃G[̏ꍇ NULL ԂD
@param  mode     @b OFF: ł͍sȂDca  NULL̏ꍇ͋I OFFɂȂD

@retval NULLȊO SSLpXg[ւ̃|C^D
@retval NULL     G[D̏ꍇ ERR_print_errors_fp(stderr); ŒÕG[em邱ƂłD

@attention ̊֐ɂĎ擾 SSL* ϐ́CK ssl_close() ŃN[Y邱ƁD
           SSL_shutdown(), SSL_free() gpꍇ SSL_CTX* ϐJłȂ̂ŁC[NND
*/
SSL*  ssl_client_socket(int sock, char* ca, int mode)
{
	int      ret;
	SSL*  	 ssl;
	SSL_CTX* ssl_ctx;

	//
	ssl_ctx = SSL_CTX_new(SSLv23_client_method());
	if (ssl_ctx==NULL) return NULL;

	ssl = SSL_new(ssl_ctx);
	if (ssl==NULL) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		SSL_CTX_free(ssl_ctx);
		return NULL;
	}

	// F؋ǃf[^ǂݍށiPEMf[^j
	if (ca!=NULL) SSL_CTX_load_verify_locations(ssl_ctx, ca, NULL);
	else mode = OFF;

	ret = SSL_set_fd(ssl, sock);
	if (ret!=1) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		ssl_close(ssl);
		return NULL;
	}

	// T[o֐ڑ
	ret = SSL_connect(ssl);
	if (ret!=1) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		ssl_close(ssl);
		return NULL;
	}

	// T[oؖ̃`FbN
	if (mode==ON) {
		long lrt = SSL_get_verify_result(ssl);
		if (lrt!=X509_V_OK) {
			//DEBUG_MODE ERR_print_errors_fp(stderr);
			ssl_close(ssl);
			return NULL;
		}
	}

	return ssl;
}





/**
SSL*  ssl_server_socket(int sock, char* crt_fn, char* key_fn)

SSL/TLS̃T[opTCPXg[쐬C\PbgƊ֘AtD@n
ɐ旧 TCP̐ڑmĒuȂ΂ȂȂD

@param  sock    SSLʐMs\PbgDsock  accept() ̖߂lgpD
@param  crt_fn  T[oؖ̃t@CiPEM`j
@param  key_fn  T[o̔閧̃t@CiPEM`j

@return SSLpXg[ւ̃|C^DG[̏ꍇ NULLԂD

@attention ̊֐ɂĎ擾 SSL* ϐ́CK ssl_close() ŃN[Y邱ƁD
           SSL_shutdown(), SSL_free() gpꍇ SSL_CTX* ϐJłȂ̂ŁC[NND

*/
SSL*  ssl_server_socket(int sock, char* crt_fn, char* key_fn)
{
	int  ret;
	SSL*  	 ssl;
	SSL_CTX* ssl_ctx;

	//
	ssl_ctx = SSL_CTX_new(SSLv23_server_method());
	if (ssl_ctx==NULL) return NULL;

	// T[oؖƔ閧̓ǂݍ
	if (crt_fn!=NULL && key_fn!=NULL) {
		ret = SSL_CTX_use_certificate_file(ssl_ctx, crt_fn, SSL_FILETYPE_PEM);
		if (ret!=1) {
			//DEBUG_MODE ERR_print_errors_fp(stderr);
			SSL_CTX_free(ssl_ctx);
			return NULL;
		}
		ret = SSL_CTX_use_PrivateKey_file(ssl_ctx, key_fn, SSL_FILETYPE_PEM);
		if (ret!=1) {
			//DEBUG_MODE ERR_print_errors_fp(stderr);
			SSL_CTX_free(ssl_ctx);
			return NULL;
		}
		SSL_CTX_set_verify(ssl_ctx, SSL_VERIFY_PEER, NULL);
		SSL_CTX_set_verify_depth(ssl_ctx, 1);
	}


	ssl = SSL_new(ssl_ctx);
	if (ssl==NULL) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		SSL_CTX_free(ssl_ctx);
		return NULL;
	}

	ret = SSL_set_fd(ssl, sock);
	if (ret!=1) {
		//DEBUG_MODE ERR_print_errors_fp(stderr);
		ssl_close(ssl);
		return NULL;
	}

	return ssl;
}





/**
void  ssl_close(SSL* ssl)

SSLXg[N[YCgpϐJD

@param  ssl  N[Y SSLpXg[
*/
void  ssl_close(SSL* ssl)
{
	if (ssl!=NULL) {
		//SSL_CTX* p = ssl->ctx;
		SSL_shutdown(ssl);
		SSL_free(ssl);
		//if (p!=NULL) SSL_CTX_free(p);
	}
}





/**
tList*  ssl_get_cert_info(SSL* ssl)

SSLXg[ؖ̏𓾂Dɐ旧 ڑ connect ĂȂƂȂD

@param  ssl  SSLpXg[

@return SSL̏i[Xgւ̃|C^D
        lł́Ccipher, version, subject, issuer, before, after

*/
tList*  ssl_get_cert_info(SSL* ssl)
{
	tList* lt;
	tList* lp;
	char* pp;
	char  buf[LBUF];
	X509* x509;
	BIO*  bio;


	pp = (char*)SSL_get_cipher(ssl);
	lt = lp = add_tList_node_str(NULL, "cipher", pp);

	pp = SSL_get_cipher_version(ssl);
	lp = add_tList_node_str(lp, "version", pp);


	x509 = SSL_get_peer_certificate(ssl); 
	if (x509==NULL) return lt;

	bio = BIO_new(BIO_s_mem());
	if (bio==NULL) {
		X509_free(x509);
		return lt;
	}

	X509_NAME_print_ex(bio, X509_get_subject_name(x509), 0, XN_FLAG_RFC2253);
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "subject", buf);

	X509_NAME_print_ex(bio, X509_get_issuer_name(x509), 0, XN_FLAG_RFC2253);
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "issuer", buf);

	ASN1_TIME_print(bio, X509_get_notBefore(x509));
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "before", buf);

	ASN1_TIME_print(bio, X509_get_notAfter(x509));
	BIO_gets(bio, buf, LBUF);
	lp = add_tList_node_str(lp, "after", buf);

	BIO_free(bio);
	X509_free(x509);

	return lt;
}







/////////////////////////////////////////////////////////////////
// SSL communications

/**    
int  ssl_recv(SSL* ssl, char* rmsg, int size)
     
SSL_read()bsO֐DSSLoRŃf[^MD
     
@param  ssl     SSLpXg[
@param  rmsg    Mpf[^obt@
@param  size    f[^obt@̃TCY
     
@retval  1ȏ  MoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D

@see tcp_recv() 
*/  
int  ssl_recv(SSL* ssl, char* rmsg, int size)
{
	int cc;

	memset(rmsg, 0, size);
	cc = SSL_read(ssl, rmsg, size-1);
	 
	return cc;
}




/**    
int  ssl_send(SSL* ssl, char* smsg, int size)
     
SSL_write()bsO֐DSSLoRŃf[^𑗂D

f[^(smsg)̃TCY size0ȉw肵ꍇ́Asmsg͕łƌȂ,TCYIɌvZD
     
@param  ssl    SSLpXg[
@param  smsg   Mf[^
@param  size   Mf[^ismsgj̃TCYDTCY 0ȉ̏ꍇ smsg͕łƂ݂ȂD
     
@retval  0ȏ MoCgD
@retval -1     sD

@see also tcp_send()
*/
int  ssl_send(SSL* ssl, char* smsg, int size)
{
	int cc;

	if (size<=0) size = strlen(smsg);
	cc = SSL_write(ssl, smsg, size);
	
	return cc;
}




/**    
int  ssl_recv_wait(int sock, SSL* ssl, char* mesg, int sz, int tm)
      
SSLoRŃf[^MD

^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, recv_wait()
֐Ăяo_œǂݍ݉\f[^Ȃ΂Ƀ^CAEg
ƂȂ (RECV_TIMEOUTEDԂ)D
   
@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  mesg    Mpf[^obt@
@param  sz      f[^obt@̃TCY
@param  tm      ^CAEgԁDbPʁD
   
@retval  1ȏ  MoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval RECV_TIMEOUTED  ^CAEgD

@see tcp_recv_wait() 
*/
int  ssl_recv_wait(int sock, SSL* ssl, char* mesg, int sz, int tm)
{
	int  cc;
				 
	if (recv_wait(sock, tm)) {
		cc = ssl_recv(ssl, mesg, sz);
		if (cc<=0) DEBUG_MESG("SSL_RECV_MESG: Session Closed.\n");
	}
	else {
		DEBUG_MESG("SSL_RECV_MESG: Time Out.\n");
		return RECV_TIMEOUTED;
	}
	return cc;
}




/**    
int  ssl_send_mesgln(SSL* ssl, char* mesg)
      
SSLbZ[W()ɉs(@\r@\n)tđMD
   
@param  ssl    SSLpXg[
@param  mesg   MpbZ[W
   
@retval  0ȏ MoCgis܂ށjD
@retval -1     s(send()̖߂l)D
*/    
int  ssl_send_mesgln(SSL* ssl, char* mesg)
{  
	int	cc, sz;
	char* buf;
	
	sz = strlen(mesg)+3;	// for CR+LF+0x00 
	buf = (char*)malloc(sz);
	if (buf==NULL) return -1;
	
	strncpy(buf, mesg, sz);
	strncat(buf, "\r\n", 2);
	cc = ssl_send(ssl, buf, strlen(buf));
	
	free(buf);
	return cc;
}




/**
int  ssl_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)

SSL/TSLoRŃbZ[W()MD

MbZ[W̓bZ[WXg[ obt@ɈUobt@OC̊֐ɂsǂݏoD
mesgɂ͍ő sz-1i[DCobt@̈s̃f[^ sz-1傫ꍇ́C͂ݏô͎ĂD

mesgɊi[鎞Cs̉sR[h͍폜Csɂ͕K '\0' D
^CAEg̐ݒ肪\Ń^CAEg 0w肵ꍇ, Ăяo_
ǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D
bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_ŊmۂD

Ů֐gpāCMf[^obt@OC\PbgN[Y܂ŁC
ǂݎɂ͕KXg[gpĂ̊֐Ăяo΂
΂ȂȂDŖꍇ͎Mf[^͕̐ۏ؂ȂD

@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  mesg    Mpf[^obt@D\ߏ\ȃ̈mۂĂD
@param  sz      f[^obt@̃TCY
@param  sb      Oobt@^̃Xg[obt@Dobt@mۂĂȂ΁CIɊmۂD
@param  tm      ^CAEgԁDbPʁD

@retval  1ȏ  mesgɊi[bZ[W̃oCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2       NULL̃f[^D
@retval -3      bZ[Wobt@̂Ŋmۂ悤ƂCmۂɎsD
@retval -4      bZ[Wobt@Ƀf[^݂͑͂Cs̗RɂlɎsD
@retval -5      bZ[Wobt@̃f[^̒Cmesg̒傫D͂ݏô͎ĂꂽD
@retval RECV_TIMEOUTED   ^CAEgD
*/
int  ssl_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)
{
	int  cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	memset(mesg, 0, sz);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_recv_wait(sock, ssl, mesg, sz, tm);
		if (cc<=0) return cc;
		put_mstream(sb, (unsigned char*)mesg);
		memset(mesg, 0, sz);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	if (strlen((const char*)pp)>=(unsigned int)sz) {
		memcpy(mesg, pp, sz-1);
		free(pp);
		return -5;
	}
	memcpy(mesg, pp, strlen((const char*)pp));

	free(pp);
	return strlen(mesg);
}






/////////////////////////////////////////////////////////////////
// SSL with Buffer

/**
int  ssl_recv_Buffer(SSL* ssl, Buffer* str)

SSLoRŃf[^MDobt@OȂD

@param  ssl     SSLpXg[
@param  str     Mpf[^obt@D\߃mۂĂD

@retval  1ȏ  MoCgD
@retval  0      炭͑葤ZbVN[YDؒf
@retval -1      MG[D
*/
int  ssl_recv_Buffer(SSL* ssl, Buffer* str)
{
	int cc;

	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;

	cc = SSL_read(ssl, str->buf, str->bufsz-1);
	if (cc>=0) str->vldsz = cc;

	return cc;
}




/**
int  ssl_send_Buffer(SSL* ssl, Buffer* str)

SSLoRŃf[^𑗐MD

@param  ssl    SSLpXg[
@param  str    Mpf[^obt@D

@retval  0ȏ MoCgD
@retval -1     s(send()̖߂l)D
*/
int  ssl_send_Buffer(SSL* ssl, Buffer* str)
{
	int cc;

	if (str->vldsz<0) str->vldsz = strlen((const char*)str->buf);
	cc = SSL_write(ssl, str->buf, str->vldsz);
	return cc;
}





/**
int  ssl_recv_Buffer_wait(int sock, SSL* ssl, Buffer* str, int tm)

SSLoRŃf[^MD

^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, recv_wait()
֐Ăяo_œǂݍ݉\f[^Ȃ΂Ƀ^CAEg
ƂȂ (RECV_TIMEOUTEDԂ)D

@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  str     Mpf[^obt@D\߃mۂĂD
@param  tm      ^CAEgԁDbPʁD

@retval  1ȏ  MoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval RECV_TIMEOUTED    ^CAEgD
*/
int  ssl_recv_Buffer_wait(int sock, SSL* ssl, Buffer* str, int tm)
{
	int cc;

	str->vldsz = 0;
	cc = ssl_recv_wait(sock, ssl, (char*)str->buf, str->bufsz, tm);
	if (cc>=0) str->vldsz = cc;

	return cc;
}




/**
int  ssl_send_sBuffer(SSL* ssl, Buffer* str)

SSLoRŕf[^𑗐MD

@param  ssl    SSLpXg[
@param  str    MpbZ[Wobt@D

@retval  0ȏ MoCgD
@retval -1     s(send()̖߂l)D
*/
int  ssl_send_sBuffer(SSL* ssl, Buffer* str)
{
	int cc;

	cc = SSL_write(ssl, str->buf, strlen((const char*)str->buf));
	return cc;
}





/**
int  ssl_send_sBufferln(SSL* ssl, Buffer* str)

SSLbZ[W()ɉs(@\r@\n)tđMD

@param  ssl    SSLpXg[
@param  str    MpbZ[Wobt@D

@retval  0ȏ MoCgis܂ށjD
@retval -1     s(send()̖߂l)D
*/
int  ssl_send_sBufferln(SSL* ssl, Buffer* str)
{
	int	cc;
	Buffer buf;

	buf = dup_Buffer(*str);
	cat_s2Buffer("\r\n", &buf);
	cc = SSL_write(ssl, buf.buf, strlen((const char*)buf.buf));
	free_Buffer(&buf);

	return cc;
}




/**
int  ssl_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)

SSLoRŃbZ[W()MD@n
MbZ[W̓bZ[WXg[ɈUobt@OC̊֐ɂsǂݏoD

mesgɊi[鎞Cs̉sR[h͍폜Csɂ͕K '\0' D
^CAEg̐ݒ肪\Ń^CAEg 0w肵ꍇ, Ăяo_
ǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D
bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_
mۂD

Ů֐gpāCMf[^obt@OC\PbgN[Y܂ŁC
ǂݎɂ͕KXg[gpĂ̊֐Ăяo΂΂ȂȂD
Ŗꍇ͎Mf[^͕̐ۏ؂ȂD

@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  mesg    Mpf[^obt@Dobt@mۂKv͂ȂD
@param  sb      bZ[Wobt@iO^̃Xg[obt@jDobt@mۂĂȂ΁CIɊmۂD
@param  tm      ^CAEgԁDbPʁD

@retval  1ȏ  mesgɊi[bZ[W̃oCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2       NULL̃f[^D
@retval -3      bZ[Wobt@̂Ŋmۂ悤ƂCmۂɎsD
@retval -4      bZ[Wobt@Ƀf[^݂͑͂Cs̗RɂlɎsD
@retval RECV_TIMEOUTED   ^CAEgD
*/
int  ssl_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)
{
	int	cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	*mesg = make_Buffer(LBUF);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_recv_Buffer_wait(sock, ssl, mesg, tm);
		if (cc<=0) {
			free_Buffer(mesg);
			return cc;
		}
		put_mstream(sb, mesg->buf);
		clear_Buffer(mesg);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	copy_s2Buffer((char*)pp, mesg);
	free(pp);

	return mesg->vldsz;
}




/**
int  ssl_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)

SSLoRŃbZ[W()MDsi\nŏI邱Ƃۏ؂j̃f[^
oƂ̂łȈՃobt@@\tD炳Ɉs̃f[^oɂ́Cget_line() ȂǂgpD

lbg[N蒼ڈsÂoɂ́Ctcp_recv_mstreamBuffer() gقǂD

@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  *mesg   Mpf[^obt@D\߃mۂĂD
@param  tm      ^CAEgԁDbPʁD

@retval  1ȏ  MꂽoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2      buf NULL
@retval RECV_TIMEOUTED    ^CAEgD

@bug Mf[^KLFŏI邱ƂۏႳĂꍇɂgpłȂD܂ėpIɂ́ugȂv
@see tcp_recv_mstreamBuffer() 
*/
int  ssl_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)
{
	int	cc;
	Buffer msg, buf;

	if (mesg==NULL) return -2;
	buf = make_Buffer(LBUF);

	cc = ssl_recv_Buffer_wait(sock, ssl, &buf, tm);
	while (cc>0) {
		cat_Buffer(&buf, &msg);
		if (buf.buf[cc-1]==CHAR_LF) break;
		clear_Buffer(&buf);
		cc = ssl_recv_Buffer_wait(sock, ssl, &buf, tm);
	}
	free_Buffer(&buf);
		
	if (cc<=0) {
		free_Buffer(mesg);
		return cc;
	}

	return mesg->vldsz;
}




/////////////////////////////////////////////////////////////////
// SSL abd TCP compati communications

/**    
int  ssl_tcp_recv(int sock, SSL* ssl, char* rmsg, int size)
     
ssl NULLłȂSSLŎMsCNULLȂΒʏ̃\PbgŎMsD
     
@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  rmsg    Mpf[^obt@
@param  size    f[^obt@̃TCY
     
@retval  1ȏ  MoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval RECV_TIMEOUTED  ^CAEgD

@see tcp_recv() 
*/  
int  ssl_tcp_recv(int sock, SSL* ssl, char* rmsg, int size)
{
	int cc;

	memset(rmsg, 0, size);
	
	if (ssl!=NULL) cc = SSL_read(ssl, rmsg, size-1);
	else           cc = recv(sock, rmsg, size, 0);
	 
	return cc;
}




/**    
int  ssl_tcp_send(int sock, SSL* ssl, char* smsg, int size)
     
ssl NULLłȂSSLőMsCNULLȂΒʏ̃\PbgőMsD

f[^(smsg)̃TCY size0ȉw肵ꍇ́Asmsg͕łƌȂ,TCYIɌvZD
     
@param  sock   \PbgLqq
@param  ssl    SSLpXg[
@param  smsg   Mf[^
@param  size   Mf[^ismsgj̃TCYDTCY 0ȉ̏ꍇ smsg͕łƂ݂ȂD
     
@retval  0ȏ MoCgD
@retval -1     sD

@see tcp_send() 
*/
int  ssl_tcp_send(int sock, SSL* ssl, char* smsg, int size)
{
	int cc;

	if (size<=0) size = strlen(smsg);

	if (ssl!=NULL) cc = SSL_write(ssl, smsg, size);
	else           cc = send(sock, smsg, size, 0);
	
	return cc;
}




/**    
int  ssl_tcp_recv_wait(int sock, SSL* ssl, char* mesg, int sz, int tm)
      
ssl NULLłȂ΁CSSLoRŃf[^MDsslNULLȂʏ̃\PbgŎMD

oCiMD^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, 
recv_wait()֐Ăяo_œǂݍ݉\f[^Ȃ΂Ƀ^CAEg
ƂȂ (RECV_TIMEOUTEDԂ)D
   
@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  mesg    Mpf[^obt@
@param  sz      f[^obt@̃TCY
@param  tm      ^CAEgԁDbPʁD
   
@retval  1ȏ  MoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval RECV_TIMEOUTED  ^CAEgD

@see tcp_recv_wait() 
*/  
int  ssl_tcp_recv_wait(int sock, SSL* ssl, char* mesg, int sz, int tm)
{
	int  cc;
				 
	if (recv_wait(sock, tm)) {
		cc = ssl_tcp_recv(sock, ssl, mesg, sz);
		if (cc<=0) DEBUG_MESG("SSL_RECV_MESG: Session Closed.\n");
	}
	else {
		DEBUG_MESG("SSL_RECV_MESG: Time Out.\n");
		return RECV_TIMEOUTED;
	}		
	return cc;
}




/**    
int  ssl_tcp_send_mesgln(int sock, SSL* ssl, char* mesg)
      
SSL or TCPbZ[W()ɉs(@\r@\n)tđMD
   
@param  sock   \PbgLqq
@param  ssl    SSLpXg[
@param  mesg   MpbZ[W
   
@retval  0ȏ MoCgis܂ށjD
@retval -1     s(send()̖߂l)D
*/    
int  ssl_tcp_send_mesgln(int sock, SSL* ssl, char* mesg)
{  
	int	cc, sz;
	char* buf;
	
	sz = strlen(mesg)+3;	// for CR+LF+0x00 
	buf = (char*)malloc(sz);
	if (buf==NULL) return -1;
	
	strncpy(buf, mesg, sz);
	strncat(buf, "\r\n", 2);
	cc = ssl_tcp_send(sock, ssl, buf, strlen(buf));
	
	free(buf);
	return cc;
}




/**
int  ssl_tcp_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)

SSL/TSL/TCPoRŃbZ[W()MD
 
MbZ[W̓bZ[WXg[ obt@ɈUobt@OC̊֐ɂsǂݏoD
mesgɂ͍ő sz-1i[DCobt@̈s̃f[^ sz-1傫ꍇ́C
͂ݏô͎ĂD

mesgɊi[鎞Cs̉sR[h͍폜Csɂ͕K '\0' D
^CAEg̐ݒ肪\Ń^CAEg 0w肵ꍇ, Ăяo_
ǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D
bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_ŊmۂD

Ů֐gpāCMf[^obt@OC\PbgN[Y܂ŁC
ǂݎɂ͕KXg[gpĂ̊֐Ăяo΂΂ȂȂD
Ŗꍇ͎Mf[^͕̐ۏ؂ȂD

@param  sock   \PbgLqq
@param  ssl    SSLpXg[
@param  mesg   Mpf[^obt@D\ߏ\ȃ̈mۂĂD
@param  sz     f[^obt@̃TCY
@param  sb     Oobt@^̃Xg[obt@Dobt@mۂĂȂ΁CIɊmۂD
@param  tm     ^CAEgԁDbPʁD

@retval  1ȏ mesgɊi[bZ[W̃oCgD
@retval  0     炭͑葤ZbVN[YD
@retval -1     MG[D
@retval -2      NULL̃f[^D
@retval -3     bZ[Wobt@̂Ŋmۂ悤ƂCmۂɎsD
@retval -4     bZ[Wobt@Ƀf[^݂͑͂Cs̗RɂlɎsD
@retval -5     bZ[Wobt@̃f[^̒Cmesg̒傫D͂ݏô͎ĂꂽD
@retval RECV_TIMEOUTED   ^CAEgD
*/
int  ssl_tcp_recv_mstream(int sock, SSL* ssl, char* mesg, int sz, mstream* sb, int tm)
{
	int  cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	memset(mesg, 0, sz);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_tcp_recv_wait(sock, ssl, mesg, sz, tm);
		if (cc<=0) return cc;
		put_mstream(sb, (unsigned char*)mesg);
		memset(mesg, 0, sz);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	if (strlen((const char*)pp)>=(unsigned int)sz) {
		memcpy(mesg, pp, sz-1);
		free(pp);
		return -5;
	}
	memcpy(mesg, pp, strlen((const char*)pp));

	free(pp);
	return strlen(mesg);
}






/////////////////////////////////////////////////////////////////
// SSL with Buffer

/**
int  ssl_tcp_recv_Buffer(int sock, SSL* ssl, Buffer* str)

SSL or TCPoRŃf[^MDobt@OȂD

@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  str     Mpf[^obt@D\߃mۂĂD

@retval  1ȏ  MoCgD
@retval  0      ؒf
@retval -1      s-1ԂD
*/
int  ssl_tcp_recv_Buffer(int sock, SSL* ssl, Buffer* str)
{
	int cc;

	memset(str->buf, 0, str->bufsz);
	str->vldsz = 0;

	if (ssl!=NULL) cc = SSL_read(ssl, str->buf, str->bufsz-1);
	else           cc = recv(sock, str->buf, str->bufsz, 0);

	if (cc>=0) str->vldsz = cc;

	return cc;
}






/**
int  ssl_tcp_send_Buffer(int sock, SSL* ssl, Buffer* str)

SSL or TCPoRŃf[^𑗐MD

@param  sock   \PbgLqq
@param  ssl    SSLpXg[
@param  str    Mpf[^obt@D

@retval  0ȏ MoCgD
@retval -1     s(send()̖߂l)D
*/
int  ssl_tcp_send_Buffer(int sock, SSL* ssl, Buffer* str)
{
	int cc;

	if (str->vldsz<0) str->vldsz = strlen((const char*)str->buf);

	if (ssl!=NULL) cc = SSL_write(ssl, str->buf, str->vldsz);
	else           cc = send(sock, str->buf, str->vldsz, 0);

	return cc;
}




/**
int  ssl_tcp_recv_Buffer_wait(int sock, SSL* ssl, Buffer* str, int tm)

SSL or TCPoRŃf[^MD

^CAEg̐ݒ肪\D^CAEg 0w肵ꍇ, recv_wait()
֐Ăяo_œǂݍ݉\f[^Ȃ΂Ƀ^CAEg
ƂȂ (RECV_TIMEOUTEDԂ)D

@param  sock   \PbgLqq
@param  ssl	   SSLpXg[
@param  str    Mpf[^obt@D\߃mۂĂD
@param  tm     ^CAEgԁDbPʁD

@retval  1ȏ MoCgD
@retval	 0	   炭͑葤ZbVN[YD
@retval -1	   MG[D
@retval	RECV_TIMEOUTED  ^CAEgD
*/
int  ssl_tcp_recv_Buffer_wait(int sock, SSL* ssl, Buffer* str, int tm)
{
	int cc;

	str->vldsz = 0;
	cc = ssl_tcp_recv_wait(sock, ssl, (char*)str->buf, str->bufsz, tm);
	if (cc>=0) str->vldsz = cc;

	return cc;
}





/**
int  ssl_tcp_send_sBuffer(int sock, SSL* ssl, Buffer* str)

SSL or TCPoRŕf[^𑗐MD

@param  sock   \PbgLqq
@param  ssl	   SSLpXg[
@param  str	   Mpf[^obt@D

@retval  0ȏ MoCgD
@retval -1     s(send()̖߂l)D
*/
int  ssl_tcp_send_sBuffer(int sock, SSL* ssl, Buffer* str)
{
	int cc;

	if (ssl!=NULL) cc = SSL_write(ssl, str->buf, strlen((const char*)str->buf));
	else           cc = send(sock, str->buf, strlen((const char*)str->buf), 0);

	return cc;
}






/**
int  ssl_tcp_send_sBufferln(int sock, SSL* ssl, Buffer* str)

SSL or TCPbZ[W()ɉs(@\r@\n)tđMD

@param  sock   \PbgLqq
@param  ssl	   SSLpXg[
@param  str    MpbZ[Wobt@D

@retval  0ȏ MoCg(܂މs)D
@retval -1     s(send()̖߂l)D
*/
int  ssl_tcp_send_sBufferln(int sock, SSL* ssl, Buffer* str)
{
	int	cc;
	Buffer buf;

	buf = dup_Buffer(*str);
	cat_s2Buffer("\r\n", &buf);

	if (ssl!=NULL) cc = SSL_write(ssl, buf.buf, strlen((const char*)buf.buf));
	else           cc = send(sock, buf.buf, strlen((const char*)buf.buf), 0);

	free_Buffer(&buf);

	return cc;
}





/**
int  ssl_tcp_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)

SSL or TCPoRŃbZ[W()MDMbZ[W̓bZ[WXg[
ɈUobt@OC̊֐ɂsǂݏoD

mesgɊi[鎞Cs̉sR[h͍폜Csɂ͕K '\0' D
^CAEg̐ݒ肪\Ń^CAEg 0w肵ꍇ, Ăяo_
ǂݍ݉\f[^Ȃ΂Ƀ^CAEgƂȂ (RECV_TIMEOUTED Ԃ)D
bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_ŊmۂD

Ů֐gpāCMf[^obt@OC\Pbg
N[Y܂ŁCǂݎɂ͕KXg[gpĂ̊֐Ăяo΂
΂ȂȂDŖꍇ͎Mf[^͕̐ۏ؂ȂD

@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  mesg    Mpf[^obt@Dobt@mۂKv͂ȂD
@param  sb      bZ[Wobt@iO^̃Xg[obt@jDobt@mۂĂȂ΁CIɊmۂD
@param 	tm      ^CAEgԁDbPʁD

@retval  1ȏ	mesgɊi[bZ[W̃oCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2       NULL̃f[^D
@retval -3      bZ[Wobt@̂Ŋmۂ悤ƂCmۂɎsD
@retval -4      bZ[Wobt@Ƀf[^݂͑͂Cs̗RɂlɎsD
@retval RECV_TIMEOUTED  ^CAEgD
*/
int  ssl_tcp_recv_mstreamBuffer(int sock, SSL* ssl, Buffer* mesg, mstream* sb, int tm)
{
	int	cc;
	unsigned char* pp;

	if (mesg==NULL || sb==NULL) return -2;
	*mesg = make_Buffer(LBUF);

	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return -3;
	}

	while (sb->datano==0) {
		cc = ssl_tcp_recv_Buffer_wait(sock, ssl, mesg, tm);
		if (cc<=0) {
			free_Buffer(mesg);
			return cc;
		}
		put_mstream(sb, mesg->buf);
		clear_Buffer(mesg);
	}

	pp = get_mstream(sb);
	if (pp==NULL) return -4;
	copy_s2Buffer((char*)pp, mesg);
	free(pp);

	return mesg->vldsz;
}




/**
int  ssl_tcp_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)

SSL or TCPoRŃbZ[W()MDsi\nŏI邱Ƃۏ؂j̃f[^
oƂ̂łȈՃobt@@\tD炳Ɉs̃f[^oɂ́C
get_line() ȂǂgpD@n
܂Clbg[N蒼ڈsÂoɂ́Ctcp_recv_mstreamBuffer() gقǂD

@param  sock    \PbgLqq
@param  ssl     SSLpXg[
@param  *mesg   Mpf[^obt@D\߃mۂĂD
@param  tm      ^CAEgԁDbPʁD

@retval  1ȏ  MꂽoCgD
@retval  0      炭͑葤ZbVN[YD
@retval -1      MG[D
@retval -2      buf NULL
@retval RECV_TIMEOUTED  ^CAEgD

@bug Mf[^KLFŏI邱ƂۏႳĂꍇɂgpłȂD܂ėpIɂ́ugȂv
@see tcp_recv_mstreamBuffer()

*/
int  ssl_tcp_recv_linesBuffer(int sock, SSL* ssl, Buffer* mesg, int tm)
{
	int	cc;
	Buffer msg, buf;

	if (mesg==NULL) return -3;
	buf = make_Buffer(LBUF);

	cc = ssl_tcp_recv_Buffer_wait(sock, ssl, &buf, tm);
	while (cc>0) {
		cat_Buffer(&buf, &msg);
		if (buf.buf[cc-1]==CHAR_LF) break;
		clear_Buffer(&buf);
		cc = ssl_tcp_recv_Buffer_wait(sock, ssl, &buf, tm);
	}
	free_Buffer(&buf);
		
	if (cc<=0) {
		free_Buffer(mesg);
		return cc;
	}

	return mesg->vldsz;
}





#endif
