#ifndef  __JBXL_FACET_BASE_H_
#define  __JBXL_FACET_BASE_H_


/**
3D Facetp{f[^

*/


#include <vector>
#include <algorithm>

#include "Vector.h"
#include "Rotation.h"
#include "buffer.h"




namespace  jbxl {



class  FacetBaseData;
class  TriPolyData;





//////////////////////////////////////////////////////////////////////////////////////
//
// Facet Base Data (CfbNXꂽf[^)
//

class  FacetBaseData
{
public:
	int		num_index;				///< CfbNX̐D(index ̗vfj
	int     num_data;				///< f[^Divertex, normal, texcrd ̗vfj
	int 	vcount;					///< |S̒_Dʏ3 

	int*    index;					///< CfbNXf[^
	Vector<double>* vertex;			///< _f[^
	Vector<double>* normal;			///< @xNg
	UVMap<double>*  texcrd;			///< eNX`}bv

public:
	FacetBaseData(int idx=0, int num=0) { init(idx, num);}
    virtual ~FacetBaseData(void) {}	

	void  init(int idx=0, int num=0);
	void  free(void);
	bool  getm(void);
	void  dup(FacetBaseData a);

public:
	void  execScale(Vector<double> scale);
	void  execShift(Vector<double> shift);
	void  execRotate(Quaternion quat);
};



//FacetBaseData* joinFacetBaseData(FacetBaseData*& first, FacetBaseData*& next);

inline void  freeFacetBaseData(FacetBaseData*& facet) { if(facet!=NULL){ facet->free(); delete facet; facet = NULL;}}





//////////////////////////////////////////////////////////////////////////////////////
//
//  Triangle Polygon Data
//

class  TriPolyData
{
public:
	int 			facetNum;		///< ʔԍ
	bool			has_normal;		///< zf[^̏ꍇCԍŏ̃f[^lĂΏ\łD
	bool			has_texcrd;		///< zf[^̏ꍇCԍŏ̃f[^lĂΏ\łD

	Vector<double> 	vertex[3];
	Vector<double> 	normal[3];
	UVMap<double>  	texcrd[3];

public:
	TriPolyData(void) { init();}
    virtual ~TriPolyData(void) {}	

	void  init(void);
	void  free(void) { init();}
	void  dup(TriPolyData a);

public:
	void  execScale(Vector<double> scale);
	void  execShift(Vector<double> shift);
	void  execRotate(Quaternion quat);
};



TriPolyData* dupTriPolyData(TriPolyData* data, int num);
TriPolyData* joinTriPolyData(TriPolyData*& first, int num_f, TriPolyData*& next, int num_n);

inline void  freeTriPolyData(TriPolyData*& tridata) { if(tridata!=NULL){ tridata->free(); delete tridata; tridata = NULL;}}
void  freeTriPolyData(TriPolyData*& tridata, int n);





}		// namespace

#endif

