
#ifndef  __JBXL_CPP_MESHOBJECTDATA_H_
#define  __JBXL_CPP_MESHOBJECTDATA_H_


#include  "xtools++.h"
#include  "txml.h"

#include  "TriBrep.h"
#include  "Rotation.h"
#include  "FacetBaseData.h"
#include  "MaterialParam.h"




namespace jbxl {



class  MeshObjectNode;
class  MeshObjectData;




/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// MeshObjectNode: for Facet Data 
//

/**
@brief MeshObject  Polygonf[^i[NXDXg\D

*/
class  MeshObjectNode
{
public:
	Buffer 	material_id;			///< }eAʂID
	bool	same_material;			///<  Node ɓ}eAgpĂD

	int		facet_no;				///< ʔԍ
	MaterialParam material_param;	///< }eAp[^

	int  	num_vertex;				///< _̃f[^Divertex_value, normal_value ̗vfj
	int  	num_texcrd;				///< eNX`摜̍WDʏ num_vertex ɓDitexcrd_value ̗vfj
	int  	num_polygon;			///< |S̐
	int  	num_index;				///< _̉אDnum_polygon*MeshObjectData::num_vcount idata_index ̗vfj

	int* 	data_index; 			///< CfbNXf[^

	Vector<double>* vertex_value;
	Vector<double>* normal_value;
	UVMap<double>*  texcrd_value;

	MeshObjectNode*	next;
	MeshObjectNode*	prev;

public:
	MeshObjectNode(void) { init();}
	virtual ~MeshObjectNode(void) {}

	void  init(void);
	void  free(void);
	void  free_value(void);
	void  clear(void);

	void  set (int vertex,   int polygon,   int vcount=3);
	bool  getm(int vertex=0, int polygon=0, int vcount=0);

	//
	void  setFacetNo(int no) { if (no>=0) facet_no = no;}
	void  setMaterialParam(MaterialParam param) { setMaterial(param);}
	void  setMaterial(MaterialParam param);
	void  delMaterialParam(void) { delMaterial();}
	void  delMaterial(void) { material_param.clear();}

	void  setMaterialID (const char* str=NULL);
	void* getMaterialID (void) { return _tochar(material_id.buf);}

public:
	bool  computeVertexDirect(FacetBaseData* facetdata);
	bool  computeVertexDirect(Vector<double>* vtx, Vector<double>* nml, UVMap<double>* map, int num, int vcount=3);
	bool  computeVertexByBREP(Vector<double>* vtx, Vector<double>* nml, UVMap<double>* map, int num, int vcount=3);
};




inline void  freeMeshObjectNode(MeshObjectNode*& node) { if(node!=NULL) { node->free(); delete node; node=NULL;} }
void  freeMeshObjectList(MeshObjectNode*& node);

MeshObjectNode*  DelMeshObjectNode(MeshObjectNode* node);
MeshObjectNode*  AddMeshObjectNode(MeshObjectNode* list, MeshObjectNode* node);





/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// MeshObject Data: for Object
//

/**

*/
class  MeshObjectData
{
public:
	Buffer 	data_name;				///< f[^

	int  	ttl_vertex;				///< _̑D
	int  	ttl_texcrd;				///< eNX`摜̍WD
	int		num_node;				///< eNX`[Pʂ̖ʂ̐inodelist̐j
	int  	num_vcount;				///< 1|S ̒_D݂ 3̂݃T|[g
	int		num_import;				///< ̓f[^̐

	Vector<double>* impvtx_value;	///< ͂ꂽ_f[^D3 1|S\D@͉E菇D
	Vector<double>* impnrm_value;	///< ͂ꂽ_̖@xNgDimpvtx_value ƑΉD
	UVMap<double>*  impmap_value;	///< ͂ꂽeNX`Wf[^Dimpvtx_value ƑΉD
	//
	AffineTrans* 	affine_trans;	///< AtBϊDŎgp̂́Cshift, rotate, scale(size) ̂

	MeshObjectNode* nodelist;		///< eNX`[Pʂ̖ʂ̃f[^̃Xgւ̃|C^
	MeshObjectNode* endplist;		///< eNX`[Pʂ̖ʂ̃f[^̃Xg̍Ō̃f[^ւ̃|C^

public:
	MeshObjectData(const char* name=NULL) { init(name);}
	virtual	~MeshObjectData(void)   {}

	void	init(const char* name=NULL);
	void	free(void);
	void	free_value(void);
	void	clear(void);

	//
	void	setName(const char* str) { free_Buffer(&data_name); data_name=make_Buffer_str(str);}
	char*	getName(void) { return _tochar(data_name.buf);}
	
	void	setAffineTrans(AffineTrans a) { delAffineTrans(); affine_trans = new AffineTrans(); affine_trans->dup(a);}
	void	delAffineTrans(void) { freeAffineTrans(affine_trans);}

public:
	bool	addData(FacetBaseData* facetdata, MaterialParam* param=NULL);
	bool	addData(Vector<double>* vct, Vector<double>* nrm, UVMap<double>* map, int vnum, MaterialParam* param=NULL);
	bool	addData(TriPolyData* tridata, int tnum, int fnum=-1, MaterialParam* param=NULL);		///< FACETIł

	void	joinData(MeshObjectData*& data);	///< data ͍폜D
	void	setMaterial(MaterialParam param, int num=-1);
	void	setMaterialParam(MaterialParam param, int num=-1) { setMaterial(param, num);}
	//
	bool	importTriData(TriPolyData* tridata, int tnum, int fnum=-1);
	bool	importTriData(Vector<double>* vct, Vector<double>* nrm, UVMap<double>* map, int vnum);
	bool	addNode(FacetBaseData* facetdata);
	bool	addNode(void);
};



inline void  freeMeshObjectData(MeshObjectData*& data) { if(data!=NULL) { data->free(); delete data; data=NULL;} }







}		// namespace

#endif


