

#include  "ExClass.h"


using namespace jbxl;
using namespace jbxwl;




//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//

//
//  eIuWFNgԂ̊֘At
//
bool  jbxwl::SetExLink(CExDocument* pdoc, CExFrame* pfrm, CExView* pviw, CAppCallBack* papp)
{
	if (pdoc==NULL) return  false;
	if (pfrm==NULL) return  false;
	if (pviw==NULL) return  false;
	
	pdoc->pView  = pfrm->pView  = pviw;
	pdoc->pFrame = pviw->pFrame = pfrm;
	pviw->pDoc   = pfrm->pDoc   = pdoc;
	pviw->pApp   = pfrm->pApp   = pdoc->pApp = papp;
	return  true;
}






	
	
CExFrame*  jbxwl::CreateDocFrmView(CMultiDocTemplate* pDocTempl, CAppCallBack* papp)
{	
	// NX̎擾
	CExDocument* pdoc = (CExDocument*)pDocTempl->CreateNewDocument();
	CExFrame*    pfrm = (CExFrame*)pDocTempl->CreateNewFrame(pdoc, NULL);
	CExView*     pviw = (CExView*)pdoc->GetView();
	
	bool rslt = SetExLink(pdoc, pfrm, pviw, papp);
	if (!rslt) {
		if (pdoc!=NULL) {
			DEBUG_ERR("jbxwl::CreateDocFrmView(): ERROR: Document is NULL");
			deleteNull(pdoc);
		}
		if (pviw!=NULL) {
			DEBUG_ERR("jbxwl::CreateDocFrmView(): ERROR: View is NULL");
			deleteNull(pviw);
		}
		if (pfrm!=NULL) {
			DEBUG_ERR("jbxwl::CreateDocFrmView(): ERROR: Frame is NULL");
			deleteNull(pfrm);
		}
		return  NULL;
	}

	pfrm->pTempl = pDocTempl;	
	return pfrm;
}





//
//	Document, View NX̑O
//		t@CI[vC\̏D
//
BOOL  jbxwl::InitialDocView(CExFrame* pfrm, LPCTSTR fname)
{
	BOOL  rslt;
	
	// Document NX̑O
	if (fname==NULL) {
		rslt = pfrm->pDoc->OnNewDocument();
	}
	else {
		rslt = pfrm->pDoc->OnOpenDocument(fname);
	}
	if (!rslt) return FALSE;

	// View NX̑O
	pfrm->pView->OnInitialUpdate();
	if (!pfrm->pView->hasViewData) return FALSE;
	return  TRUE;
}




//
//  t[Ɋ֘AtꂽNXgpāCf[^ǂݍ݁C\sD
//  f[^̓ǂݍ݂ɂ InitialDocView() gp
//
int  jbxwl::ExecDocFrmView(CExFrame* pfrm, LPCTSTR fname)
{
	if (pfrm ==NULL) return 1;
	if (fname!=NULL) pfrm->pDoc->Title = get_file_name_t(fname);

	//
	BOOL rslt = InitialDocView(pfrm, fname);
	if (!rslt) {
		int ret;
		// ̏ꏊł̃bZ[W\͂ȂD
		if      ( pfrm->doneErrorMessage)   ret = MSG_DFV_NOT_DISP;
		else if ( pfrm->cancelOperation)    ret = MSG_DFV_CANCEL;
		else if (!pfrm->pDoc->hasReadData)  ret = MSG_DFV_ERR_READ;
		else if (!pfrm->pDoc->hasViewData)  ret = MSG_DFV_UNVISIBLE;
		else if (!pfrm->pView->hasViewData) ret = MSG_DFV_FAIL_VIEW;

		delete pfrm;	// Debug\ŃRpCƁCCDxSRenderViewŒ_0̏ꍇCŃZOe[VG[NH 
		return ret;
	}

	pfrm->ShowWindow(SW_SHOW);
	pfrm->SetFocus();
	pfrm->pView->SetFocus();

	// pfrm->Title ŖƂ́CeNX̒Ń^Cgݒ肳 ͂D
	if (pfrm->Title.IsEmpty()) {
		pfrm->pView->SetTitle(pfrm->pDoc->Title);
		//pfrm->Title = pfrm->pView->Title = pfrm->pDoc->Title;
		//pfrm->SetTitle(pfrm->Title);
		//pfrm->SetWindowText(pfrm->Title);
		//pfrm->pDoc->SetTitle(pfrm->Title);
	}
	return 0;
}





void  jbxwl::ExecDocFrmViewError(HWND hwnd, int ret)
{
	if (ret>0) {  // !=MSG_DFV_NOT_DISP (-1)
		CString mesg;
		int err_flag = false;

		if (ret==MSG_DFV_FR_NULL) {
			mesg.LoadString(IDS_STR_NULLPT_FRM);	// Frameւ̃|C^ NULLł
			err_flag = true;
		}
		else if (ret==MSG_DFV_CANCEL){
			mesg.LoadString(IDS_STR_CANCEL_OPRTN);	// 삪LZ܂
			err_flag = true;
		}
		else if (ret==MSG_DFV_ERR_READ) {
			mesg.LoadString(IDS_STR_ERR_OPEN_FILE);	// t@C̓ǂݍ݃G[ł
			err_flag = true;
		}
		else if (ret==MSG_DFV_UNVISIBLE) {
			mesg.LoadString(IDS_STR_ERR_UNDISP);	// \s\ȃt@Cł
			err_flag = true;
		}
		else if (ret==MSG_DFV_FAIL_VIEW) {
			mesg.LoadString(IDS_STR_ERR_PREDISP);	// \̏Ɏs܂
			err_flag = true;
		}
		if (err_flag) MessageBox(hwnd, mesg, NULL, MB_OK);
	}
	return;
}





/**
int   ExecTemplate(CMultiDocTemplate* ptemp, ExMSGraph<sWord>* pmsGraph, ExCmnHead* pcmnHead, CExFrame* prntFrm)

	ev[gND

		nf[^ɑ΂ăǗ@\D
		ǗĂȂf[^nꍇ́CNAD
*/
int   jbxwl::ExecTemplate(CMultiDocTemplate* ptemp, ExMSGraph<sWord>* pmsGraph, ExCmnHead* pcmnHead, CExFrame* prntFrm, int viewPoint)
{
	int   ret,  color = GRAPH_COLOR_MONO;
	BOOL  hasReadData = FALSE;
	BOOL  hasViewData = FALSE;
	HWND  hWnd = NULL;
	CExFrame* pfrm = NULL;
	CExDocument* prntDoc = NULL;


	if (prntFrm!=NULL) {
		hWnd    = prntFrm->m_hWnd;
		prntDoc = prntFrm->pDoc;
		color	= prntFrm->colorMode;
	}

	if (pmsGraph!=NULL) {
		if (!pmsGraph->isNull()) hasReadData = TRUE;
	}	
	if (pcmnHead!=NULL) {
		if (!pcmnHead->isNull()) hasViewData = TRUE;
	}
	

	if (hasViewData) {
		pfrm = CreateDocFrmView(ptemp, NULL);
		pfrm->pDoc->hasReadData = TRUE;
		pfrm->pDoc->hasViewData	= TRUE;
		pfrm->pDoc->cmnHead		= *pcmnHead;
		pfrm->pDoc->colorMode	= color;
		pfrm->pDoc->preTitle	= _T("");
		pfrm->pDoc->Title		= prntFrm->pDoc->Title;
		pfrm->pDoc->pstTitle	= prntFrm->pDoc->pstTitle;
		if (prntDoc!=NULL) pfrm->pDoc->ctrlCntrst = prntDoc->ctrlCntrst;
		pfrm->pView->vSBpos		= viewPoint;
		ret = ExecDocFrmView(pfrm);
	}

	else if (hasReadData) {
		pfrm = CreateDocFrmView(ptemp, NULL);
		pfrm->pDoc->hasReadData = TRUE;
		pfrm->pDoc->msGraph		= *pmsGraph;
		pfrm->pDoc->colorMode	= color;
		pfrm->pDoc->preTitle	= _T("");
		pfrm->pDoc->Title		= prntFrm->pDoc->Title;
		pfrm->pDoc->pstTitle	= prntFrm->pDoc->pstTitle;
		if (prntDoc!=NULL) pfrm->pDoc->ctrlCntrst = prntDoc->ctrlCntrst;
		pfrm->pView->vSBpos		= viewPoint;
		ret = ExecDocFrmView(pfrm);
	}	

	else {
		CString mesg;
		mesg.LoadString(IDS_STR_OPEN_FILE);
		CString fname = EasyGetOpenFileName(mesg, hWnd);
		if (fname.IsEmpty()) return -1;

		pfrm = CreateDocFrmView(ptemp, NULL);
		pfrm->pDoc->multiSliceData = TRUE;
		pfrm->pDoc->colorMode = color;
		if (prntDoc!=NULL) pfrm->pDoc->ctrlCntrst = prntDoc->ctrlCntrst;
		ret = ExecDocFrmView(pfrm, fname);
	} 

	ExecDocFrmViewError(hWnd, ret);

	return ret;
}




CString  jbxwl::EasyGetOpenFileName(LPCTSTR title, HWND hWnd) 
{	
	OPENFILENAME ofn;
	TCHAR fn[LMESG];
	CString  str = _T(""); 

	memset(fn, 0, LNAME);
	memset(&ofn, 0, sizeof(OPENFILENAME));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner  = hWnd;
	ofn.Flags	   = OFN_HIDEREADONLY;
	ofn.lpstrFile  = fn;
	ofn.nMaxFile   = LMESG;
	ofn.lpstrTitle = title;

	//DEBUG_INFO("jbxwl::EasyGetOpenFileName(): GetOpenFileName() Start => %d", GetMsecondsTimer());
	BOOL ret = GetOpenFileName(&ofn);
	//DEBUG_INFO("jbxwl::EasyGetOpenFileName(): GetOpenFileName() End   => %d", GetMsecondsTimer());
	if (ret) str = fn;

	return str;
}




CString  jbxwl::EasyGetSaveFileName(LPCTSTR title, LPCTSTR extnt, HWND hWnd) 
{	
	OPENFILENAME ofn;
	TCHAR fn[LNAME];
	CString  str = _T(""); 

	memset(fn, 0, LNAME);
	memset(&ofn, 0, sizeof(OPENFILENAME));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.Flags = 0;
	ofn.lpstrFile = fn;
	ofn.nMaxFile  = LNAME;
	ofn.lpstrDefExt = extnt;
	ofn.lpstrTitle  = title;

	BOOL ret = GetSaveFileName(&ofn);
	if (ret) str = fn;

	return str;
}



CString  jbxwl::EasyGetSaveFolderName(LPCTSTR folder, LPCTSTR title, HWND hWnd) 
{	
	BROWSEINFO   bri;
	LPITEMIDLIST pilst;

	TCHAR fldr[LNAME];
	CString  str = _T(""); 

	memset(fldr, 0, LNAME);
	memset(&bri, 0, sizeof(BROWSEINFO));

	bri.hwndOwner = hWnd;
	bri.lpszTitle = title;
	bri.ulFlags = BIF_RETURNONLYFSDIRS;

    bri.lpfn = &EasyGetSaveFolderNameCallBack;	// R[obN֐
    bri.lParam = (LPARAM)folder;				// R[obN֐̈

	pilst = SHBrowseForFolderW(&bri);
	if (pilst!=NULL) {
		SHGetPathFromIDListW(pilst, fldr);
		str = fldr;
		CoTaskMemFree(pilst);
	}
	return str;
}



int CALLBACK jbxwl::EasyGetSaveFolderNameCallBack(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
        SendMessage(hwnd, BFFM_SETSELECTION, (WPARAM)TRUE, lpData);
    }
    return 0;
}