//
// ExTextFrame.cpp : Cve[V t@C
//

#include  "ExTextFrame.h"
//#include  "appCallBack.h"



using namespace jbxwl;





/////////////////////////////////////////////////////////////////////////////
// CExTextFrame

IMPLEMENT_DYNCREATE(CExTextFrame, CMDIChildWnd)

CExTextFrame::CExTextFrame()
{
	//DEBUG_INFO("CONSTRUCTOR: CExTextFrame");

	pDoc		= NULL;
	pView		= NULL;
	pApp		= NULL;
	pTempl		= NULL;

	toolBar		= NULL;

	Title		= _T("");
	preTitle	= _T("");

	cancelOperation  = false;
	doneErrorMessage = false;

	reSizeMoving	 = false;
}




CExTextFrame::~CExTextFrame()
{
	DEBUG_INFO("DESTRUCTOR: CExTextFrame: START");

	if (pApp!=NULL) {
		DEBUG_INFO("Call Application FrameDestructor()");
		pApp->FrameDestructor(this);	// ʃAvP[Vɒʒm
	}

	if (!isNull(pView)) pView->pFrame = NULL;
	pView = NULL;
	pDoc  = NULL;

	DEBUG_INFO("DESTRUCTOR: CExTextFrame: END");
}





//
// bZ[W}bv
//

BEGIN_MESSAGE_MAP(CExTextFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CExTextFrame)
	//}}AFX_MSG_MAP

#ifdef ON_WM_ENTERSIZEMOVE
	ON_WM_ENTERSIZEMOVE()
	ON_WM_EXITSIZEMOVE()
#else
	ON_MESSAGE(WM_ENTERSIZEMOVE, OnEnterSizeMove)
	ON_MESSAGE(WM_EXITSIZEMOVE,  OnExitSizeMove)
#endif
	ON_WM_ERASEBKGND()
	ON_WM_SIZING()
	ON_WM_MOVE()
END_MESSAGE_MAP()





/////////////////////////////////////////////////////////////////////////////
// CExTextFrame bZ[W nh


BOOL  CExTextFrame::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CMDIFrameWnd* pParentWnd, CCreateContext* pContext) 
{
	dwStyle = dwStyle | WS_CLIPCHILDREN;
	dwStyle = dwStyle & (~WS_MAXIMIZEBOX);	// ő剻{^֎~
	return CMDIChildWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, pContext);
}




#ifdef ON_WM_ENTERSIZEMOVE

void CExTextFrame::OnEnterSizeMove()
{
	CMDIChildWnd::OnEnterSizeMove();
	reSizeMoving = true;
}


void CExTextFrame::OnExitSizeMove()
{
	CMDIChildWnd::OnExitSizeMove();
	reSizeMoving = false;
}


#else


LRESULT CExTextFrame::OnEnterSizeMove(WPARAM wParam, LPARAM lParam)
{
	reSizeMoving = true;
	return 0;
}


LRESULT CExTextFrame::OnExitSizeMove(WPARAM wParam, LPARAM lParam)
{
	reSizeMoving = false;
	return 0;
}

#endif



BOOL CExTextFrame::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂D
	return CMDIChildWnd::OnEraseBkgnd(pDC);
}



void CExTextFrame::OnSizing(UINT fwSide, LPRECT pRect)
{
	POINT pt;
	pt.x = pRect->right - pRect->left;
	pt.y = pRect->bottom - pRect->top;

	pt = pView->GetClientSize(pt);
	pt = pView->GetWindowReSize(pt);
	pt = pView->GetWindowSize(pt);

	pRect->right  = pRect->left + pt.x;
	pRect->bottom = pRect->top  + pt.y;
	CMDIChildWnd::OnSizing(fwSide, pRect);

	pView->doReSize = true;
}



void CExTextFrame::OnMove(int x, int y)
{
	CMDIChildWnd::OnMove(x, y);

	// TODO: ɃbZ[W nh[ R[hǉ܂D
	this->OnPaint();
}
