/* vi: set tabstop=4 nocindent noautoindent: */


/**
@brief   Buffer^T|[gvO 
@file    buffer.c
@version 1.3
@author  Fumi.Iseki (C)
@date    2012 7/23
@see     Buffer
*/


#include "buffer.h"


/**
Buffer*  new_Buffer(void)

Buffer^ϐoD

@return o Buffer^ϐւ̃|C^D쐬ɎsꍇNULLԂD
*/
Buffer*  new_Buffer(void)
{
	Buffer*  buf;

	buf = (Buffer*)malloc(sizeof(Buffer));
	if (buf==NULL) return NULL;

	memset(buf, 0, sizeof(Buffer));
	buf->vldsz = -1;

	return buf;
}



/**
Buffer  init_Buffer()

Buffer^ϐԂD

@attention a = init_Buffer() ƂꍇCaɌXlĂĂC̒l freeȂ̂ŒӁD
@return ꂽBuffer^ϐD
*/
Buffer  init_Buffer()
{
	Buffer  buf;

	memset(&buf, 0, sizeof(Buffer));
	buf.vldsz = -1;

	return buf;
}



/**
Buffer  make_Buffer(int sz)

Buffer^ϐ̃obt@oD

sz  Buffer^ϐ̃obt@̑傫D
obt@ 0x00ŏDbufsz=sz, vldsz=0 ƂȂD@n
obt@̍쐬Ɏsꍇ,obt@̃TCY(bufsz) 0,obt@ւ̃|C^ NULLƂȂD

@param  sz Buffer^ϐ̃obt@̑傫D
@return	o Buffer^ϐD
*/
Buffer  make_Buffer(int sz)
{
	Buffer  buf;

	memset(&buf, 0, sizeof(Buffer));
	if (sz<=0) return buf;

	buf.bufsz = sz;
	buf.buf = (unsigned char*)malloc(buf.bufsz+1);

	if (buf.buf==NULL) {
		buf.bufsz = 0;
		buf.vldsz = -1;
	}
	else memset(buf.buf, 0, buf.bufsz+1);

	return buf;
}



/**
Buffer  make_Buffer_bychar(unsigned char cc)

CBuffer^ϐ̃obt@oD

make_Buffer_bychar('\0')  Bufferϐ̏ɂgpD

@param  cc  Buffer^ϐ̃obt@Ɋi[镶
@return o Buffer^ϐDobt@̍쐬Ɏsꍇ,
@return	obt@̃TCY(bufsz) 0,obt@ւ̃|C^ NULLƂȂD

@see make_Buffer_bystr()
*/
Buffer  make_Buffer_bychar(unsigned char cc)
{
	Buffer  buf;
	
	buf = make_Buffer(LADDR);
	if (buf.buf==NULL) return buf;

	buf.buf[0] = cc;
	buf.vldsz = 1;
	return buf;
}



/**
void  free_Buffer(Buffer* buf)

Buffer^ϐ̃obt@JD

@param  buf  Jobt@ Bufferf[^ւ̃|C^D
*/
void  free_Buffer(Buffer* buf)
{
	if (buf!=NULL) {
		if (buf->buf!=NULL) free(buf->buf);
		buf->buf = NULL;
		memset(buf, 0, sizeof(Buffer));
		buf->vldsz = -1;
	}
}



/**
void   del_Buffer(Buffer** buf)

new_Buffer()ōo Buffer^ϐ폜D

@param  buf  폜 Bufferf[^̃|C^ւ̃|C^D
@see new_Buffer()
*/
void   del_Buffer(Buffer** buf)
{
	if (buf!=NULL && *buf!=NULL) {
		if ((*buf)->buf!=NULL) free((*buf)->buf);
		(*buf)->buf = NULL;
		free(*buf);
		*buf = NULL;
	}
}



/**
Buffer  set_Buffer(void* buf, int len)

Buffer^ϐ̃obt@V, ̃obt@ bufRs[D@n
len̓Rs[f[^D len 0̏ꍇ, buf͕ƂĈD
buf ̏ꍇ make_Buffer_bystr() gp\D

@param  buf  Rs[obt@ւ̃|C^D
@param  len  obt@(oCgP)D
@return Vꂽ Buffer^f[^D
*/
Buffer  set_Buffer(void* buf, int len)
{
	Buffer  str;

	str = init_Buffer();
	if (buf==NULL) return str;

	if (len<0) len = (int)strlen((char*)buf);
	str = make_Buffer((int)((len+1)*BUFFER_FACT));
	if (str.buf==NULL) return str;

	memcpy(str.buf, buf, len);
	str.vldsz = len;
	return  str;
}



Buffer  make_Buffer_randomstr(int n)
{
	char* str = random_str(n);

	Buffer buf = set_Buffer(str, -1);
	free(str);

	return buf;
}



/**
Buffer  dup_Buffer(Buffer buf)

Buffer^ϐ̃Rs[D

@param  buf  Rs[ϐD
@return Vꂽ Buffer^f[^D
*/
Buffer  dup_Buffer(Buffer buf)
{
	Buffer  str;

	str = make_Buffer(buf.bufsz);
	memcpy(str.buf, buf.buf, buf.bufsz);
	str.vldsz = buf.vldsz;
	str.state = buf.state;
	return  str;
}



/**
Buffer  rept_Buffer(unsigned char cc, int n)

cc nJԂBuffer^f[^ԂD

@param  cc  JԂD
@param  n   JԂ񐔁D
@return Vꂽ Buffer^f[^D
*/
Buffer  rept_Buffer(unsigned char cc, int n)
{
	int  i;
	Buffer  str;
	
	if (n<=0) n = 1;
	str = make_Buffer(n);
	for (i=0; i<n; i++) str.buf[i] = cc;
	str.vldsz = n;
	return  str;
}



void  expand_Buffer(Buffer* buf, int len)
{
	if (buf->bufsz>len) return;

	Buffer expand = make_Buffer(len);
	copy_Buffer(buf, &expand);
	free_Buffer(buf);

	*buf = expand;
}



/**
void  clear_Buffer(Buffer* str)

Buffer^ϐ ̃obt@ 0NAD

@param  str  NA Buffer^f[^ւ̃|C^D
*/
void  clear_Buffer(Buffer* str)
{
	if (str->buf!=NULL) memset(str->buf, 0, str->bufsz+1);
	str->vldsz = 0;
	str->state = 0;
}



/**
int  copy_Buffer(Buffer* src, Buffer* dst)

Buffer^ϐ src dstփobt@Rs[D

, dst src̃obt@Rs[邾̃Xy[Xꍇ, 
VɃobt@̈mۂăRs[D

@param  src    Rs[ւ̃|C^D
@param  dst    Rs[ւ̃|C^D

@retval  0ȏ dst̃obt@ɃRs[ꂽD
@retval -1     src܂ dst NULL 
@retval	-2     ̊mۂɎsDsȂD

@attention
(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ͂ȂD
܂ȉ̂悤Ȏg͊ԈႢD
@code
	func(Buffer buf){ 
		...............
		copy_Buffer(&src, &buf);
		...............
	}
@endcode
͉L̂悤ɕύXD
@code
	func(Buffer* buf){ 
		...............
		copy_Buffer(&src, buf);
		...............
	}
@endcode
RF֐Ńobt@̑傫ς\邪C
Ăяoł͂̂Ƃm邱ƂłȂD
*/
int  copy_Buffer(Buffer* src, Buffer* dst)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (src->buf==NULL) return -1;

	sz = src->vldsz;
	if (sz<0)  sz = (int)strlen((const char*)src->buf);
	if (sz==0) return 0;

	if (dst->bufsz < sz) {
		unsigned char* buf;
		//dz  = (int)((src->bufsz+1)*BUFFER_FACT);
		dz  = (int)((sz+1)*BUFFER_FACT);
		buf = (unsigned char*)malloc(dz+1);
		if (buf==NULL) return -2;

	   	free(dst->buf);
		dst->bufsz = dz;
		dst->buf   = buf;
	}

	//memset(dst->buf, 0, dst->bufsz+1);		too late
	memcpy(dst->buf, src->buf, sz);
	dst->buf[sz] = '\0';
	dst->vldsz = sz;
	dst->state = 0;

	return  sz;
}



/**
int  cat_Buffer(Buffer* src, Buffer* dst)

Bufferϐ src dstփobt@ catD

, dst src obt@ cat邾̃Xy[Xꍇ
VɃobt@̈mۂ catD

@param  src    catւ̃|C^D
@param  dst    catւ̃|C^D

@retval  0ȏ dst̃obt@ɃRs[ꂽD
@retval	-1     src܂ dst NULL 
@retval	-2     ̊mۂɎsDsȂD

@attention
(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ͂ȂD
܂ȉ̂悤Ȏg͊ԈႢD
@code
	func(Buffer buf){ 
		...............
		cat_Buffer(&src, &buf);
		...............
	}
@endcode
͉L̂悤ɕύXD
@code
	func(Buffer* buf){ 
		...............
		cat_Buffer(&src, buf);
		...............
	}
@endcode
RF֐Ńobt@̑傫ς\邪C
Ăяoł͂̂Ƃm邱ƂłȂD
*/
int  cat_Buffer(Buffer* src, Buffer* dst)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (src->buf==NULL) return -1;

	sz = src->vldsz;
	if (sz<0) sz = (int)strlen((const char*)src->buf);
	if (sz==0) return 0;

	dz = dst->vldsz;
	if (dz<0) {
		if (dst->buf!=NULL) dz = (int)strlen((const char*)dst->buf);
		else				dz = 0;
	}

	if (dst->bufsz < sz+dz) {
		Buffer buf;
		buf.state = dst->state;
		buf.bufsz = (int)((dst->bufsz+sz+1)*BUFFER_FACT);
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;
   
		memcpy(buf.buf, dst->buf, dz);
		buf.buf[dz] = '\0';
		free_Buffer(dst);
		*dst = buf;

/*
		Buffer buf;			 	// dst̑Ҕ 
		buf.bufsz = dst->bufsz;
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;

		buf.buf[buf.bufsz] = '\0';
		memcpy(buf.buf, dst->buf, buf.bufsz);
		free_Buffer(dst);

		//dst->bufsz = (int)((buf.bufsz+src->bufsz+1)*BUFFER_FACT);
		dst->bufsz = (int)((buf.bufsz+sz+1)*BUFFER_FACT);
		dst->buf   = (unsigned char*)malloc(dst->bufsz+1);
		if (dst->buf==NULL) {
	   		*dst = buf;
	   		return -2;
		}
		memset(dst->buf, 0, dst->bufsz+1);
		memcpy(dst->buf, buf.buf, buf.vldsz);
		free_Buffer(&buf);
*/
	}

	//memset(dst->buf+dz, 0, dst->bufsz-dz+1);  too late
	memcpy(dst->buf+dz, src->buf, sz);
	dst->buf[dz+sz] = '\0';
	dst->vldsz = sz + dz;
	dst->state = 0;

	return  dst->vldsz;
}



/**
int  ins_Buffer(Buffer* src, Buffer* dst)

Bufferϐ dst̑O src}D

@param  src    }̃|C^D
@param  dst    }ւ̃|C^D

@retval  0ȏ dst̃obt@ɃRs[ꂽD
@retval	-1     src܂ dst NULL 
@retval	-2     ̊mۂɎsDsȂD
*/
int  ins_Buffer(Buffer* src, Buffer* dst)
{
	Buffer tmp = make_Buffer(src->bufsz + dst->bufsz);

	int ret = copy_Buffer(src, &tmp);
	if (ret<0) {
		free_Buffer(&tmp);
		return ret;
	}

	ret = cat_Buffer(dst, &tmp);
	if (ret<0) {
		free_Buffer(&tmp);
		return ret;
	}

	free_Buffer(dst);
	*dst = tmp;

	return  dst->vldsz;
}



/**
int  copy_b2Buffer(void* src, Buffer* dst, int len)

Cӂ̃oCif[^src Buffer^ϐdst copyD

, dst src̃obt@ copy邾̃Xy[Xꍇ
VɃobt@̈mۂ copyD@n
len 0̏ꍇ, src͕ƂĈD

@param  src    copy̔CӃf[^ւ̃|C^D
@param  dst    copyBuffer^ϐւ̃|C^D
@param	len    copyoCgD

@retval  0ȏ dst̃obt@ɃRs[ꂽD
@retval	-1     src܂ dst NULL 
@retval	-2     ̊mۂɎsDsȂD

@attention
(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ͂ȂD
܂ȉ̂悤Ȏg͊ԈႢD
@code
	func(Buffer buf){ 
		...............
		copy_b2Buffer(&src, &buf, n);
		...............
	}
@endcode
͉L̂悤ɕύXD
@code
	func(Buffer* buf){ 
		...............
		copy_b2Buffer(&src, buf, n);
		...............
	}
@endcode
RF֐Ńobt@̑傫ς\邪C
func Ăяoł͂̂Ƃm邱ƂłȂD
*/
int  copy_b2Buffer(void* src, Buffer* dst, int len)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (len<0) sz = (int)strlen((const char*)src);
	else	   sz = len;
	if (sz<=0) return 0;

	if (dst->bufsz < sz) {
		unsigned char* buf;
		dz  = (int)((sz+1)*BUFFER_FACT);
		buf = (unsigned char*)malloc(dz+1);
		if (buf==NULL) return -2;
	   	free(dst->buf);
		dst->bufsz = dz;
		dst->buf   = buf;
	}

	memcpy(dst->buf, src, sz);
	dst->buf[sz] = '\0';
	dst->vldsz = sz;
	dst->state = 0;

	return  sz;
}



/**
int  cat_b2Buffer(void* src, Buffer* dst, int len)

Cӂ̃oCif[^src Buffer^ϐdst catD

, dst src̃obt@ cat邾̃Xy[Xꍇ
VɃobt@̈mۂ catD@n
len 0̏ꍇ, src͕ƂĈD

@param  src    cat̔CӃf[^ւ̃|C^D
@param	dst    catBuffer^ϐւ̃|C^D
@param	len    catoCgD

@retval	 0ȏ dst̃obt@ɃRs[ꂽD
@retval	-1     src܂ dst NULL 
@retval	-2     ̊mۂɎsDsȂD

@attention
(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ͂ȂD
܂ȉ̂悤Ȏg͊ԈႢD
@code
	func(Buffer buf){ 
		...............
		cat_b2Buffer(&src, &buf, n);
		...............
	}
@endcode
͉L̂悤ɕύXD
@code
	func(Buffer* buf){ 
		...............
		cat_b2Buffer(&src, buf, n);
		...............
	}
@endcode
RF֐Ńobt@̑傫ς\邪C
func Ăяoł͂̂Ƃm邱ƂłȂD
*/
int  cat_b2Buffer(void* src, Buffer* dst, int len)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (len<0) sz = (int)strlen((const char*)src);
	else	   sz = len;
	if (sz<=0) return 0;
   
	dz = dst->vldsz;
	if (dz<0) {
		if (dst->buf!=NULL) dz = (int)strlen((const char*)dst->buf);
		else				dz = 0;
	}

	if (dst->bufsz < sz+dz) {
		Buffer buf;
		buf.state = dst->state;
		buf.bufsz = (int)((dst->bufsz+sz+1)*BUFFER_FACT);
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;
	
		memcpy(buf.buf, dst->buf, dz);
		buf.buf[dz] = '\0';
		free_Buffer(dst);
		*dst = buf;	
		
/*
		Buffer buf;			 // dst̑Ҕ 
		buf.bufsz = dst->bufsz;
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;

 		buf.buf[buf.bufsz] = '\0';
		memcpy(buf.buf, dst->buf, buf.bufsz);
		free_Buffer(dst);

		dst->bufsz = (int)((buf.bufsz+sz+1)*BUFFER_FACT);
		dst->buf   = (unsigned char*)malloc(dst->bufsz+1);
		if (dst->buf==NULL) {
	   		*dst = buf;
	   		return -2;
		}
		memset(dst->buf, 0, dst->bufsz+1);
		memcpy(dst->buf, buf.buf, buf.vldsz);
		free_Buffer(&buf);
*/
	}

	memcpy(dst->buf+dz, src, sz);
	dst->buf[dz+sz] = '\0';
	dst->vldsz = sz + dz;
	dst->state = 0;

	return  dst->vldsz;
}



/**
int  ins_b2Buffer(void* src, Buffer* dst, int len)

Cӂ̃oCif[^src Buffer^ϐdst̑Oɑ}D
len 0̏ꍇ, src͕ƂĈD

@param  src    }̔CӃf[^ւ̃|C^D
@param	dst    }Buffer^ϐւ̃|C^D
@param	len    }oCgD

@retval	 0ȏ dst̃obt@ɃRs[ꂽD
@retval	-1     src܂ dst NULL 
@retval	-2     ̊mۂɎsDsȂD
*/
int  ins_b2Buffer(void* src, Buffer* dst, int len)
{
	Buffer tmp = make_Buffer(dst->bufsz+len);

	int ret = copy_b2Buffer(src, &tmp, len);
	if (ret<0) {
		free_Buffer(&tmp);
		return ret;
	}

	ret = cat_Buffer(dst, &tmp);
	if (ret<0) {
		free_Buffer(&tmp);
		return ret;
	}

	free_Buffer(dst);
	*dst = tmp;

	return  dst->vldsz;
}



/**
 src𕶎ɕϊāCdst copyD

*/
int  copy_i2Buffer(int src, Buffer* dst)
{
	char num[LEN_INT];

	snprintf(num, LEN_INT-1, "%d", src);
	return copy_b2Buffer((void*)num, dst, (int)strlen(num));
}



/**
 src𕶎ɕϊāCdst catD

*/
int  cat_i2Buffer(int src, Buffer* dst)
{
	char num[LEN_INT];

	snprintf(num, LEN_INT-1, "%d", src);
	return cat_b2Buffer((void*)num, dst, (int)strlen(num));
}



/**
 src𕶎ɕϊāCdst }D

*/
int  ins_i2Buffer(int src, Buffer* dst)
{
	char num[LEN_INT];

	snprintf(num, LEN_INT-1, "%d", src);
	return ins_b2Buffer((void*)num, dst, (int)strlen(num));
}




/**
int  cmp_Buffer(Buffer src, Buffer dst, int n)

obt@̔rD

Bufferϐ src dst̃obt@rDn<=0 Ȃ Sv,
n>0 Ȃ 擪 noCgrD

@param src  rւ̃|C^D
@param dst  rւ̃|C^D
@param n    rD

@retval  0  src dst͈vĂD
@retval	 1  src dstƈvĂȂD
@retval -1  obt@ NULL
@retval -2  n  vldsz 傫

@attention f[^̂ݓKpDR[fBOx^x^D
*/
int  cmp_Buffer(Buffer src, Buffer dst, int n)
{
	int i;

	if (src.buf==NULL || dst.buf==NULL) return -1;
	if (n>src.vldsz   || n>dst.vldsz)   return -2;
	
	if (n<=0) {
		if (src.vldsz!=dst.vldsz) return 1;
		else n = src.vldsz;
	}
	
	for (i=0; i<n; i++) {
		if (src.buf[i]!=dst.buf[i]) return 1;
	}
	return 0;
}



/**
Buffer  encode_base64_Buffer(Buffer buf)

oCif[^ buf.buf buf.vldszoCg Base64ɃGR[h D

buf.vldsz -1ȉ̏ꍇ buf.vldsz buf.buf̍ŏ 0x00̂܂ł̒(strlen()+1)ƂȂD
܂ buf.buf ͕ ȂD

̓obt@ 3byte(8bit*3)̏ꍇ, o̓obt@ 4byte(6bit*4)ƂȂD
̓obt@ 6bitEłȂꍇ, 6bitE܂ 0tꂽƌD@n 
o̓obt@ 4byteEłȂꍇ, 4byteE܂ '='tďo͂D
܂,o̓obt@ł 60bytẻs͍sȂD@n
ʂ n byte ͂ꂽꍇ, Base64̏o͂̕ (n+2)/3*4 byte ƂȂD

@param  buf  Base64ɃGR[hf[^D
@return Base64ɃGR[hꂽ(Buffer^)

@par 
@code
	'A',0x00,0x01 𕶎(sz=1)Ƃ݂Ȃĕ "QQ==" ƂȂD
	'A',0x00,0x01  3byte𕄍(sz=3) "QQAB" ƂȂD
@endcode
*/
Buffer  encode_base64_Buffer(Buffer buf)
{
	unsigned char* bas;
	int	 sz;
	Buffer ecd = init_Buffer();
	 
	//
	if (buf.buf==NULL) return ecd;
	if (buf.vldsz<0) sz = (int)strlen((const char*)buf.buf);
	else		 	 sz = buf.vldsz;
	if (sz<=0) return ecd;

	bas = encode_base64(buf.buf, sz);
	if (bas==NULL) return ecd;
	
	sz  = ((sz + 2)/3)*4 + 1;
	ecd = make_Buffer(sz);
	if (ecd.buf==NULL) {
		free(bas);
		return ecd;
	}

	copy_s2Buffer((char*)bas, &ecd);

	free(bas);
	return ecd;
}



/**
Buffer  decode_base64_Buffer(Buffer str)

str̃obt@ Base64fR[hD

ϊ str.buf̐擪珇sDA-Za-z0-9+/ ȊO͖(ႦΉsR[h)D
̓obt@ 4byte(6bit*4)̏ꍇ, o̓obt@ 3byte (8bit*3)ƂȂD@n
̓obt@̃oCg 4̔{łȂꍇ(sȃf[^), Ȃ̓obt@ɂ
'='}Ă̂Ƃ݂ȂD

@param  str  Base64fR[h镶D
@return Base64fR[hꂽf[^(Buffer^)

@par 
@code
	"QQ" fR[h 'A',0x00 ƂȂD
@endcode
*/
Buffer  decode_base64_Buffer(Buffer str)
{
	unsigned char* bas;
	int	sz;
	Buffer dcd = init_Buffer();

	if (str.buf==NULL) return dcd;

	bas = decode_base64(str.buf, &sz);
	if (bas==NULL) return dcd;

	dcd = make_Buffer(sz);
	if (dcd.buf==NULL) {
		free(bas);
		return dcd;
	}

	copy_b2Buffer(bas, &dcd, sz);
	dcd.vldsz = sz;

	free(bas);
	return dcd;
}



/**
Buffer  get_line_Buffer(Buffer str, int n)

s̕obt@Cӂ̍soD

str̃obt@ nsڂoDsR[h͍폜D
n  1琔Dos Buffer^ϐ̃obt@Ɋi[iRs[jĕԂD

@param  str  Ώۂ̕(܂މs)D
@param  n    s̎wD1琔D
@return w肳ꂽ nsڂ̕(Buffer^)Ds͊܂܂ȂD
*/
Buffer  get_line_Buffer(Buffer str, int n)
{
	int i, j, pos, cnt;
	unsigned char* buf;

	Buffer ret = init_Buffer();
    if (str.buf==NULL) return ret;

	buf = str.buf;
	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!=CHAR_LF && buf[i]!=CHAR_CR && buf[i]!='\0') i++;
		while (buf[i]==CHAR_LF || buf[i]==CHAR_CR) i++;
	}
	if (buf[i]=='\0') return ret;

	pos = i;
	while (buf[i]!=CHAR_LF && buf[i]!=CHAR_CR && buf[i]!='\0') i++;
	cnt = i - pos;

    if (cnt>=0) {
		ret = make_Buffer(cnt+1);
		if (ret.buf==NULL) return str;

		for(i=0; i<cnt; i++) ret.buf[i] = buf[pos+i];
    	ret.buf[cnt] = '\0';
	}

	ret.vldsz = (int)strlen((const char*)ret.buf);

	return  ret;
}



/**
Buffer  get_seq_data_Buffer(Buffer buf, int* ptr)

s̕obt@̍sf[^V[PVɎoD

sR[h͍폜DAČĂяoꍇCԍŏ *ptr 0ݒ肵CȌ *ptr̓e͕ςȂD 
os Buffer^ϐ̃obt@Ɋi[ĕԂD@n
obt@zčsǂƂ NULL ԂD obt@̏I valdszŒmD

@param[in]      buf  Ώە Buffer^f[^(܂މs)
@param[in,out]  ptr  in: ǂݍ݂Jnf[^̈ʒuioCgjDout: ̃f[^n܂ʒuioCgjD 
@return              w肳ꂽ|C^ȉ̈s̕Ds͊܂܂ȂD
*/
Buffer  get_seq_data_Buffer(Buffer str, int* ptr)
{
    int   i, pos, cnt;
	unsigned char* buf;

    Buffer ret = init_Buffer();

    if (str.buf==NULL) return ret;
	if (str.vldsz<=0) str.vldsz = (int)strlen((const char*)str.buf);
	if (*ptr >= str.vldsz) return ret;

	buf = str.buf;
    pos = *ptr;
    while (buf[*ptr]!=CHAR_LF && buf[*ptr]!=CHAR_CR && buf[*ptr]!='\0') (*ptr)++;
    cnt = *ptr - pos;

    if (cnt>=0) {
		ret = make_Buffer(cnt+1);
        if (ret.buf==NULL) return ret;

        for(i=0; i<cnt; i++) ret.buf[i] = buf[pos+i];
    	ret.buf[cnt] = '\0';
    }

	ret.vldsz = (int)strlen((const char*)ret.buf);

	// s
    while (buf[*ptr]==CHAR_LF || buf[*ptr]==CHAR_CR) (*ptr)++;

    return  ret;
}



/**
Buffer  awk_Buffer(Buffer str, char cc, int n)

Bufferɑ΂ awkD

cc؂LƂ, str̃obt@ nԖڂ̍ڂԂD

@param  str  ΏەD
@param  cc   ؂蕶D
@param  n    ڂ̎wD1琔D

@return w肳ꂽ nԖڂ̍ڂ̕(Buffer^)D
@see    cawk_Buffer(), awk(), cawk()
*/
Buffer  awk_Buffer(Buffer str, char cc, int n)
{
	int i, j, pos, cnt;
	unsigned char* buf = str.buf;
	Buffer item = init_Buffer();

	if (buf==NULL) return item;
	if (n<=0) n = 1;

	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		if (buf[i]==cc) i++;
	}
	if (buf[i]=='\0') return item;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = make_Buffer(cnt);
	if (item.buf==NULL) return item;

	for (i=0; i<cnt; i++) item.buf[i] = buf[pos+i];
	item.vldsz = (int)strlen((const char*)item.buf);

	return item;
}



/**
Buffer  cawk_Buffer(Buffer str, char cc, int n)

Bufferɑ΂(ό`)awkD

cc؂LƂ, str̃obt@ nԖڂ̍ڂԂD
n  1琔DA cc(؂)͈̋؂Ƃ݂ȂD

@param  str  ΏەD
@param  cc   ؂蕶D
@param  n    ڂ̎wD1琔D

@return w肳ꂽ nԖڂ̍ڂ̕(Buffer^)D
@see    awk_Buffer(), awk(), cawk()
*/
Buffer  cawk_Buffer(Buffer str, char cc, int n)
{
	int i, j, pos, cnt;
	unsigned char* buf = str.buf;
	Buffer item = init_Buffer();

	if (buf==NULL) return item;
	if (n<=0) n = 1;

	i = 0;
	for(j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		while (buf[i]!='\0' && buf[i]==cc) i++;
	}
	if (buf[i]=='\0') return item;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = make_Buffer(cnt);
	if (item.buf==NULL) return item;

	for (i=0; i<cnt; i++) item.buf[i] = buf[pos+i];
	item.vldsz = (int)strlen((const char*)item.buf);

	return item;
}



/**
void  pack_Buffer(Buffer* buf, char cc)

̐擪cc()CIcc()CTAB, CR, LF 폜

̐擪CI蕔łȂꏊɂ cc͍폜ȂD

@param  buf  Ώۂ Buffer^ϐ
@param  cc   폜镶
@return ϊ̕܂ Buffer^ϐD
*/
Buffer  pack_Buffer(Buffer buf, char cc)
{
	Buffer res = init_Buffer();

	if (buf.buf==NULL) return res;

	res.buf = (unsigned char*)pack_char((char*)buf.buf, cc);
	res.vldsz = (int)strlen((char*)res.buf);

	return res;
}



/**
void kanji_convert_Buffer(Buffer* str)

ϐ @b KanjiCode (tools.h) ɏ]ĊR[hϊD

@param[in,out] str  ϊ镶Buffer^f[^DeD

@attention ݂ KanjiCode SJIS̏ꍇ̂ EUC SJISɕϊD
@see       KanjiCode
*/
void kanji_convert_Buffer(Buffer* str)
{
	int i; 
	unsigned char *c1, *c2;

	if (KanjiCode==CODE_SJIS) {
		i = 0;
		while(str->buf[i]!='\0'){
			c1 = &(str->buf[i]);
			c2 = c1 + 1;
			if(*c1>=0xa1 && *c1<=0xfe){
				euc2sjis(c1, c2);	
				i = i + 2;
			} 
			else  i++;
		}
	}			  
	/*
	else if (KanjiCode==CODE_EUC) {
		i = 0;
		while(str->buf[i]!='\0'){
			c1 = (unsigned char) str->buf[i];
			c2 = (unsigned char) str->buf[i+1];
			if((c1>=0x81 && c1<=0x9f) || (c1>=0xe0 && c1<=0xff)) {
				sjis2euc(c1, c2);	
				i = i + 2;
			} 
			else  i++;
		}
	} 
	*/			 
}



/**
Buffer  randstr_Buffer(int n)

_ A-Za-z0-9+/ ܂ł̕ nD

@param  n  o͂镶D
@return _ɐꂽ n̕(Buffer^)D
*/
Buffer  randstr_Buffer(int n)
{
	char   base[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	Buffer pass;
	int	i, sz;

	pass = make_Buffer(n);
	if (pass.buf==NULL) return pass;

	sz = (int)strlen(base);
	for (i=0; i<n; i++) pass.buf[i] = base[rand()%sz];
	pass.vldsz = n;

	return pass;
}



/**
Buffer  randbit_Buffer(int n) 

_ n bit̃oCi𐶐D

@param  n  o͂ bitD
@return _ɐꂽ n bit̃f[^(Buffer^)D
*/
Buffer  randbit_Buffer(int n) 
{
	int   i, sz;
	Buffer str;
	
	sz = (n+7)/8;
	str = make_Buffer(sz);
	if (str.buf==NULL) return str;
	str.vldsz = sz;

	for (i=0; i<n; i++) setBit(str.buf, i, rand()%2);
	return str;	 
}




#define  DUMP_BUFFER_LINE_SIZE	 85  	// 16*5("%02x "+"%c ") + 5("   "+"\r\n");
#define  DUMP_BUFFER_DELI_START	 48 	// 16*3("%02x ") 
#define  DUMP_BUFFER_CHAR_START	 51  	// 16*3("%02x ") + 3("   ") 

/**
Buffer  dump_Buffer(Buffer buf)

Buffer^ϐ̃fobOp 16i Buffer^ϐɏo͂D

buf.buf buf.vldszoCg16i\D
buf.vldsz<0 ̏ꍇ Ƃ݂ȂD

@param  buf  ϊ Buffer^f[^D
@return _vf[^i[ꂽ Buffer^f[^D
*/
Buffer  dump_Buffer(Buffer buf)
{
	int    sz;
	char   wrkbuf[10];
	Buffer str = init_Buffer();

	if (buf.buf==NULL) return str;
	if (buf.vldsz<0) sz = (int)strlen((const char*)buf.buf) + 1;
	else			 sz = buf.vldsz;

	int lineno = (sz + 15)/16;
	str = make_Buffer(lineno*DUMP_BUFFER_LINE_SIZE+1);

	int l;
	for (l=0; l<lineno; l++) {
		int sp = l*DUMP_BUFFER_LINE_SIZE;
		int i  = 0;
		while (i<16) {
			sprintf(wrkbuf, "%02x ", buf.buf[l*16+i]);
			memcpy(str.buf+sp+i*3, wrkbuf, 3);

			if (buf.buf[l*16+i]>=0x20 && buf.buf[l*16+i]<=0x7e) {
				sprintf(wrkbuf, "%c ", buf.buf[l*16+i]);
				memcpy(str.buf+sp+DUMP_BUFFER_CHAR_START+i*2, wrkbuf, 2);
			}
			else {
				memcpy(str.buf+sp+DUMP_BUFFER_CHAR_START+i*2, ". ", 2);
			}

			if (l*16+i>=sz) {
				memcpy(str.buf+sp+i*3, "   ", 3);
				memcpy(str.buf+sp+DUMP_BUFFER_CHAR_START+i*2, "  ", 2);
			}

			i++;
		}
		memcpy(str.buf+sp+DUMP_BUFFER_DELI_START, "   ", 3);
		str.buf[sp+DUMP_BUFFER_LINE_SIZE-2] = '\r';
		str.buf[sp+DUMP_BUFFER_LINE_SIZE-1] = '\n';
	}
	
	str.vldsz = lineno*DUMP_BUFFER_LINE_SIZE;
	return str;
}



/**
int  recalc_strlen_Buffer(Buffer* buf)

Buffer^ϐ̃f[^𕶎ƌȂāC̒ԂD
vldsz ͍ČvZD

@param[in]  buf  Ώە 
@param[out] buf  @b vldsz ̒DČvZD
@return  ̒D
*/
int  recalc_strlen_Buffer(Buffer* buf)
{
	int len = (int)strlen((char*)buf->buf);
	buf->vldsz = len;
	return len;
}



/**
void  chomp_Buffer(Buffer* str)

ŏ̉sR[hȍ~𖳎D
ŏ̉sR[hɏꏊɁC'\0'D

@param[in,out] str  Ώۂ̕(Buffer^)D
*/
void  chomp_Buffer(Buffer* str)
{
	int i, len;
	
	if (str->buf==NULL) return;

	len = (int)strlen((const char*)str->buf);
	for (i=0; i<len; i++) {
		if (str->buf[i]==CHAR_LF || str->buf[i]==CHAR_CR) {
			str->buf[i] = '\0';
			str->vldsz = (int)strlen((const char*)str->buf);
			return;
		}
	}
}



/**
int  isText_Buffer(Buffer buf)

Buffer^ϐ buf̃obt@eLXgǂD

@param  buf   Ώۂ Buffer^ϐD
@retval TRUE  obt@̓eLXgłD
@retval FALSE obt@̓eLXgł͂ȂD
*/
int  isText_Buffer(Buffer buf)
{
	if (buf.vldsz==(int)strlen((const char*)buf.buf)) return TRUE;
	return FALSE;
}






////////////////////////////////////////////////////////////////////////////////////
//
// File I/O
// 

/**
int  fgets_Buffer(Buffer* str, FILE* fp)

gfgetsD̓ǂݍ݂ɎgpDsR[h͍폜D

str̃obt@͗\ߏ\ȑ傫mۂĂȂ΂ȂȂD 

@param  str  ǂ݂ނ߂ Buffer^f[^obt@D
@param	fp   ǂ݂ރt@Cւ̃|C^D
@return ǂݍ񂾕̒isR[h܂ށjD
*/
int  fgets_Buffer(Buffer* str, FILE* fp)
{
	int   n, m;

	memset(str->buf, 0, str->bufsz);
	fgets((char*)str->buf, str->bufsz, fp);
	m = (int)strlen((const char*)str->buf);

	n = 0;
	while(str->buf[n]!=CHAR_LF && str->buf[n]!=CHAR_CR && str->buf[n]!='\0') n++;
	str->buf[n] = '\0';
	str->vldsz  = n;

//	if (KanjiCode!=US) kanji_convert_Buffer(str);

	return m;
}



/**
int  read_lines_Buffer(Buffer* str, FILE* fp)

s̓ǂݍ݁D̓ǂݍ݂ɎgpD

str̃obt@͗\ߏ\ȑ傫mۂĂȂ΂ȂȂD 

@param  str  ǂ݂ނ߂ Buffer^f[^obt@D
@param  fp   ǂ݂ރt@Cւ̃|C^D
@return ǂݍ񂾑Sf[^̒D
*/
int  read_lines_Buffer(Buffer* str, FILE* fp)
{
	Buffer buf;

	buf = make_Buffer(str->bufsz);
	if (buf.buf==NULL) return -1;

	fgets((char*)buf.buf, buf.bufsz, fp);
	buf.vldsz = (int)strlen((const char*)buf.buf);
	copy_Buffer(&buf, str);
	clear_Buffer(&buf);

	while (!feof(fp)) {
		fgets((char*)buf.buf, buf.bufsz, fp);
		buf.vldsz = (int)strlen((const char*)buf.buf);
		cat_Buffer(&buf, str);
		clear_Buffer(&buf);
	}

	free_Buffer(&buf);
	return str->vldsz;
}



/**
Buffer  read_Buffer_file(const char* fn)

t@C fn ̓e Buffer^ϐɓǂݍށD

@param  fn  t@C
@return ǂݍ񂾃t@C̓eێ Buffer^ϐ
*/
Buffer  read_Buffer_file(const char* fn)
{
	int     sz;
	Buffer  buf;
	FILE*   fp;

	buf = init_Buffer();

	sz = file_size(fn);
	if (sz<=0) return buf;

	fp = fopen(fn, "rb");
	if (fp==NULL) return buf;

	buf = read_Buffer_data(fp, sz);
	fclose(fp);
	
	return buf;
}



/**
Buffer  read_Buffer_data(FILE* fp, int sz)

t@C|C^ fp  szoCgBuffer^ϐɓǂݍށD

@param  fp  t@C|C^
@param  sz  ǂݍ݃TCY
@return ǂݍ񂾃t@C̓eێ Buffer^ϐ
*/
Buffer  read_Buffer_data(FILE* fp, int sz)
{
	int     cc;
	Buffer  buf;

	buf = init_Buffer();
	if (sz<0) return buf;

	buf = make_Buffer(sz);
	if (buf.buf==NULL) return buf;
	buf.vldsz = sz;

	cc = (int)fread(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) {
		free_Buffer(&buf);
		return buf;
	}
	
	return buf;
}



/**
int   save_Buffer_file(Buffer buf, char* fn)

t@C fn  Buffer^ϐ bufށD

@param  buf    Buffer^ϐD
@param 	fn    t@C

@retval TRUE  ݐD
@retval FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int   save_Buffer_file(Buffer buf, char* fn)
{
	int   cc;
	FILE* fp;

	fp = fopen(fn, "wb");
	if (fp==NULL) return FALSE;

	cc = (int)fwrite(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) return FALSE;
	fclose(fp);
	
	return TRUE;
}






////////////////////////////////////////////////////////////////////////////////////
//
//  񑀍
// 

/**
Buffer  erase_bBuffer(Buffer buf, char* bin, int len)

buf.buf ɂ bin ̃f[^ie1ByteCsj폜D

@param  buf  삷 Bufferϐ
@param  bin  폜f[^i[ւ̃|C^
@param	len  binf[^̒

@return ϊi[ BufferϐDvfree
*/
Buffer  erase_bBuffer(Buffer buf, char* bin, int len)
{
	int	 i, j, n;
	char cc;

	Buffer res = dup_Buffer(buf);
	Buffer wrk = make_Buffer(buf.vldsz+1);

	for (i=0; i<len; i++) {
		cc = bin[i];
		n  = 0;
		for (j=0; j<res.vldsz; j++) {
			if (cc!=res.buf[j]) wrk.buf[n++] = res.buf[j];
		}
		wrk.vldsz = n;

		copy_Buffer(&wrk, &res);
		clear_Buffer(&wrk);
	}
				
	free_Buffer(&wrk);

	return res;
}



/**
Buffer  replace_sBuffer_bystr(Buffer buf, const char* frm, const char* tos)

buf.buf̕ frm tosŒûԂD

frm  buf.buf ƃ̈悪dȂĂ͂ȂD
^ Bufferɂ̂ݑΉD

@param  buf  삷 Bufferϐ
@param  frm  ϊ镶
@param  tos  ϊ̕

@return ϊi[ BufferϐDstate==-1 ̏ꍇ͎sD
*/
Buffer  replace_sBuffer_bystr(Buffer buf, const char* frm, const char* tos)
{
	int	i, j, flen, tlen;
	Buffer res;

	res = init_Buffer();
	if (buf.buf==NULL || frm==NULL || tos==NULL) return res;

	flen = (int)strlen(frm);
	tlen = (int)strlen(tos);
	if (buf.vldsz<=0) buf.vldsz = (int)strlen((const char*)buf.buf);

	int difsz = tlen - flen;
	if (difsz<0) difsz = 0;
	else         difsz = difsz*100;	// 100܂
	res = make_Buffer((int)((buf.vldsz+difsz+1)*BUFFER_FACT));

	i = j = 0;
	while (i<buf.vldsz && j<res.bufsz) {
		if (!strncmp((const char*)(buf.buf+i), frm, flen)){
			res.vldsz = (int)strlen((const char*)res.buf);
			cat_s2Buffer(tos, &res);
			i += flen;
			j += tlen;
		}
		else {
			res.buf[j++] = buf.buf[i++];
		}
	}

	if (j==res.bufsz) res.state = -1;
	res.vldsz = (int)strlen((const char*)res.buf);

	return res;
}



/**
int  replace_sBuffer_file(char* fn, Buffer frm, Buffer tos)

eLXgt@C frm ̕ tos ɏ

@param  fn    삷t@C
@param  frm   ϊ镶
@param  tos   ϊ̕

@retval TRUE@ݐD
@retval FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int  replace_sBuffer_file(char* fn, Buffer frm, Buffer tos)
{
	int  ret;
	Buffer buf, res;

	buf = read_Buffer_file(fn);
	if (buf.buf==NULL) return FALSE;

	res = replace_Buffer(buf, frm, tos);
	free_Buffer(&buf);
	if (res.buf==NULL) return FALSE;

	ret = save_Buffer_file(res, fn);
	free_Buffer(&buf);

	return ret;
}



/**
void  rewrite_sBuffer_bystr(Buffer* buf, const char* frm, const char* tos)

buf.buf̕ frm tosŒuD
buf.buf̂邱ƈȊO replace_sBuffer_bystr() ƓD

@param  buf  삷 Bufferϐ
@param  frm  ϊ镶
@param  tos  ϊ̕
*/
void  rewrite_sBuffer_bystr(Buffer* buf, const char* frm, const char* tos)
{
	Buffer tmp = replace_sBuffer_bystr(*buf, frm, tos);
	if (tmp.state!=-1) {
		free_Buffer(buf);
		*buf = tmp;
	}
	return;
}




////////////////////////////////////////////////////////////////////////////////////
//
//  wb_ijtt@CI/O
// 

/**
int   save_Buffer2_fp(Buffer key, Buffer buf, FILE* fp)

t@C fp  2Buffer^ϐ key bufށD
f[^pt@C쐬ƂɎgpD

@param  key   ރL[Buffer^ϐD
@param  buf   ރf[^Buffer^ϐD
@param  fp    t@CfBXNv^

@retval TRUE@ݐD
@retval FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int   save_Buffer2_fp(Buffer key, Buffer buf, FILE* fp)
{
	int   cc;
	
	cc = save_Buffer_fp(key, fp);
	if (!cc) return FALSE;

	cc = save_Buffer_fp(buf, fp);
	if (!cc) return FALSE;
	
	return TRUE;
}



/**
int   save_Buffer_fp(Buffer buf, FILE* fp)

t@C fp  Buffer^ϐ bufށD
bufɐ旧Cbuf̑傫 intŏ܂D

@param  buf    Buffer^ϐD
@param  fp    t@CfBXNv^

@retval TRUE@ݐD
@retval FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int   save_Buffer_fp(Buffer buf, FILE* fp)
{
	int   cc, sz;

	sz = htonl(buf.vldsz);
	cc = (int)fwrite(&sz, sizeof(sz), 1, fp);
	if (cc!=1) return FALSE;

	cc = (int)fwrite(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) return FALSE;
	
	return TRUE;
}



/**
Buffer  read_Buffer_fp(FILE* fp)

t@C fp  Buffer^ϐ bufǂݍށD
t@C̐擪Ƀt@CTCY4Byte̒lKv

@param  fp  t@CfBXNv^
@return ǂݍ buf Buffer^ϐD
*/
Buffer  read_Buffer_fp(FILE* fp)
{
	int     cc, sz;
	Buffer  buf;

	buf = init_Buffer();
	cc = (int)fread(&sz, sizeof(sz), 1, fp);
	if (cc!=1) return buf;
	sz = ntohl(sz);

	buf = make_Buffer(sz);
	if (buf.buf==NULL) return buf;
	buf.vldsz = sz;
	cc = (int)fread(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) {
		free_Buffer(&buf);
		return buf;
	}
	
	return buf;
}



/**
int  read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp)

t@C fp  2Buffer^ϐ key bufǂݍށD
f[^pt@C̓ǂݍݎɎgpD

@param  key   ǂݍރL[Buffer^ϐւ̃|C^D
@param  buf   ǂݍރf[^Buffer^ϐւ̃|C^D
@param  fp    t@CfBXNv^

@retval TRUE  ǂݍݐD
@retval	FALSE ǂݍ݂ɎsD
*/
int  read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp)
{
	if (key==NULL || buf==NULL) return FALSE;

	*key = init_Buffer();
	*buf = init_Buffer();
	
	*key = read_Buffer_fp(fp);
	if (key->buf==NULL) return FALSE;

	*buf = read_Buffer_fp(fp);
	if (buf->buf==NULL) {
		free_Buffer(key);
		return FALSE;
	}

	return TRUE;
}






/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// etc. etc.
//

// Ȉ char^ ringbuffer
char  get_char_ringbuffer(Buffer* buf)
{
    buf->vldsz--;
    if (buf->vldsz<0) buf->vldsz = buf->bufsz - 1;

    return  (char)buf->buf[buf->vldsz];
}



void  put_char_ringbuffer(Buffer* buf, char cc)
{
    buf->buf[buf->vldsz] = (unsigned char)cc;
    buf->vldsz++;
    if (buf->vldsz==buf->bufsz) buf->vldsz = 0;

    return;
}




