/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBXL_BUFFER_H_
#define  __JBXL_BUFFER_H_


/** 
@brief   Buffer^T|[gwb_
@file    buffer.h
@version 1.3
@author  Fumi.Iseki (C)
@date    2012 7/23
@see     Buffer
*/


#include "tools.h"




/** 
<b>Buffer^</b>

Buffer^͕񑀍쎞̔zjh~Dbuffer.c Buffer^Ή֐g, 
vO}(Cup)͔zjlKv͖D
ʏ, vldsz̓vO}(Cup)ۏ؂Ȃ΂ȂȂD

Buffer^ϐԂ֐ł͏ vldszݒ肳Ă邩ӂׂłD
,f[^̏ꍇ -1ȉɂĂĂ悢D
 bufsz̓obt@̒ϐłCvO}Ă͂ȂD

Buffer^ϐ̓obt@̈𓮓IɊmۂ̂,gpIK
del_Buffer(܂ free_Buffer)Ńobt@̈JȂ΂ȂȂD

@attention
buf[bufsz]̓VXegp̂,vO} buf[bufsz]͖̂ƂĈƁD

@see del_Buffer(), free_Buffer()
*/

typedef struct _Buffer {
	int   bufsz; 			//!< mۂĂobt@̑傫 - 1D
	int   vldsz; 			//!< f[^̒DoCif[^̏ꍇgp\D
	int   state; 			//!< ϐ̏Ԃ\D 0
	unsigned char* buf; 	//!< obt@̐擪ւ̃|C^Dstr[bufsz]͕K 0x00ƂȂD
} Buffer;




// Buffer ϐ̗̈mۂ̂߂̗̈m۔{
#define  BUFFER_FACT   (1.5)



Buffer* new_Buffer(void);
Buffer  init_Buffer(void);
Buffer  make_Buffer(int sz);
Buffer  make_Buffer_bychar(unsigned char cc);
Buffer  make_Buffer_randomstr(int sz);
Buffer  set_Buffer(void* buf, int sz);
Buffer  dup_Buffer(Buffer buf);
Buffer  rept_Buffer(unsigned char cc, int n);

void    expand_Buffer(Buffer* buf, int len);

void	del_Buffer(Buffer** buf);
void	free_Buffer(Buffer* buf);
void	clear_Buffer(Buffer* buf);


/** 
Buffer make_Buffer_bystr(const char* str)

񂩂CBuffer^ϐ̃obt@oD@n
make_Buffer_bystr("")  Bufferϐ̏ɂgpD
oCif[^ Bufferϐoɂ́Cset_Buffer()pD@n
obt@̍쐬Ɏsꍇ, obt@̃TCY(bufsz) 0, obt@ւ̃|C^ NULLƂȂD

@param  str Buffer^ϐ̃obt@Ɋi[镶
@return o Buffer^ϐD
@see    set_Buffer()
*/
#define make_Buffer_bystr(str)		set_Buffer((void*)(str), -1)
#define make_Buffer_byrandomstr(sz)	make_Buffer_randomstr(sz)

#define make_Buffer_bybin(str, len)	set_Buffer((void*)(str), (len))
#define make_Buffer_bin(str, len)	set_Buffer((void*)(str), (len))
#define make_Buffer_str(str)		set_Buffer((void*)(str), -1)
#define make_Buffer_char(str)  		make_Buffer_bychar(str)


int		copy_Buffer(Buffer* src, Buffer* dst);
int		cat_Buffer (Buffer* src, Buffer* dst);
int		ins_Buffer (Buffer* src, Buffer* dst);

int		copy_b2Buffer(void* src, Buffer* dst, int sz);
int		cat_b2Buffer (void* src, Buffer* dst, int sz);
int		ins_b2Buffer (void* src, Buffer* dst, int sz);

int		copy_i2Buffer(int src, Buffer* dst);
int		cat_i2Buffer (int src, Buffer* dst);
int		ins_i2Buffer (int src, Buffer* dst);


/** 
int copy_s2Buffer(char* src, Buffer* dst)

char*ϐ src Buffer^ϐdst֕ copyD@n
, dst srcRs[邾̃Xy[Xꍇ, VɃobt@̈mۂăRs[D

@param  src Rs[ւ̃|C^D
@param  dst Rs[ւ̃|C^D
@retval 0     src܂ dst NULL
@retval -1    ̊mۂɎsDsȂD
@retval 1ȏ dst̃obt@ɃRs[ꂽD
*/
#define copy_s2Buffer(src, dst) 	copy_b2Buffer((void*)(src), (dst), (int)strlen((char*)(src)))


/** 
int cat_s2Buffer(char* src, Buffer* dst)

char*ϐ src Buffer^ϐdst֕ catD@n
, dst src̕ cat邾̃Xy[Xꍇ͐VɃobt@̈mۂ catD

@param src catւ̃|C^D
@param dst catւ̃|C^D
@retval  0    src܂ dst NULL
@retval -1    ̊mۂɎsDsȂD
@retval 1ȏ dst̃obt@ɃRs[ꂽD
*/
#define cat_s2Buffer(src, dst) 	 	cat_b2Buffer( (void*)(src), (dst), (int)strlen((char*)(src)))

#define ins_s2Buffer(src, dst) 	 	ins_b2Buffer( (void*)(src), (dst), (int)strlen((char*)(src)))


// c[
void	kanji_convert_Buffer(Buffer* mesg);
Buffer  encode_base64_Buffer(Buffer buf);
Buffer  decode_base64_Buffer(Buffer buf);

Buffer  get_line_Buffer(Buffer buf, int n);  
Buffer  get_seq_data_Buffer(Buffer str, int* ptr);
Buffer  awk_Buffer (Buffer buf, char cc, int n);
Buffer  cawk_Buffer(Buffer buf, char cc, int n);
Buffer	pack_Buffer(Buffer buf, char cc);

int	 	cmp_Buffer(Buffer src, Buffer dst, int n);
void	chomp_Buffer(Buffer* buf);
int		isText_Buffer(Buffer buf);
Buffer	dump_Buffer(Buffer buf);
int		recalc_strlen_Buffer(Buffer* buf);

//#define strlen_Buffer(b) 			strlen((char*)((b).buf))
#define strcmp_Buffer(a, b)			cmp_Buffer((a), (b), 0)
#define strncmp_Buffer(a, b, n)		cmp_Buffer((a), (b), (n))
#define bincmp_Buffer(a, b)			cmp_Buffer((a), (b), 0)
#define binncmp_Buffer(a, b, n)		cmp_Buffer((a), (b), (n))

Buffer  randstr_Buffer(int n);			   //!< p n
Buffer  randbit_Buffer(int n);			   //!< rbg n 


// t@CI/O
int	 	fgets_Buffer(Buffer* str, FILE* fp);	// gfgets
int		read_lines_Buffer(Buffer* str, FILE* fp);

Buffer  read_Buffer_file(const char* fn);
Buffer  read_Buffer_data(FILE* fp, int sz);
int	 	save_Buffer_file(Buffer buf, char* fn);


// 폜
Buffer  erase_bBuffer(Buffer buf, char* bin, int len);
#define erase_Buffer(b, f)			erase_bBuffer((b), (char*)((f).buf), (f).vldsz)
#define erase_sBuffer(b, f)			erase_bBuffer((b), (char*)(f), strlen(f))



// u
Buffer  replace_sBuffer_bystr(Buffer buf, const char* frm, const char* tos);
int	 	replace_sBuffer_file(char* fn, Buffer frm, Buffer tos);
#define replace_sBuffer_str(b, f, t) 	replace_sBuffer_bystr((b), (f), (t))


/** 
Buffer  replace_sBuffer(Buffer buf, char* frm, char* tos)

buf.buf  frm  tos ŒûԂD@n
frm  buf.buf ƃ̈悪dȂĂ͂ȂD^ Buffer ɂ̂ݑΉD

@param  buf 삷 Bufferϐ
@param  frm ϊ镶
@param  tos ϊ̕
@return ϊi[ BufferϐD
@see    replace_sBuffer_bystr()
*/
#define replace_sBuffer(buf, frm, tos)	replace_sBuffer_bystr((buf), (frm), (tos))


/** 
Buffer  replace_Buffer(Buffer buf, Buffer frm, Buffer tos)

buf.buf  frm.buf  tos.buf ŒûԂD@n
frm.buf  buf.buf ƃ̈悪dȂĂ͂ȂD^ Buffer ɂ̂ݑΉD

@param  buf 삷 Bufferϐ
@param  frm ϊ镶i[Bufferϐ
@param  tos ϊ̕i[Bufferϐ
@return ϊi[ BufferϐDstate==-1 ̏ꍇ͎sD
@see    replace_sBuffer_bystr()
*/
#define replace_Buffer(buf, frm, tos)	replace_sBuffer_bystr((buf), (char*)((frm).buf), (char*)((tos).buf))


/**
buf.buf̂D
́Creplace_sBufferƓ
*/
void	rewrite_sBuffer_bystr(Buffer* buf, const char* frm, const char* tos);
#define rewrite_sBuffer_str(b, f, t) 	rewrite_sBuffer_bystr((b), (f), (t))
#define rewrite_sBuffer(buf, frm, tos)	rewrite_sBuffer_bystr((buf), (frm), (tos))
#define rewrite_Buffer(buf, frm, tos)	reweite_sBuffer_bystr((buf), (char*)((frm).buf), (char*)((tos).buf))



// wb_()tt@CI/O
int	 	save_Buffer_fp(Buffer, FILE*);
Buffer  read_Buffer_fp(FILE*);
int   	save_Buffer2_fp(Buffer  key, Buffer  buf, FILE* fp);
int  	read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp);



// Buffer^𗘗p Ȉchar^Oobt@[
char    get_char_ringbuffer(Buffer* buf);
void    put_char_ringbuffer(Buffer* buf, char cc);

//#define char_ringbuffer(b, n)       (b).buf[((n)%((b).bufsz))]





#endif


