/* vi: set tabstop=4 nocindent noautoindent: */


/** 
@brief   Tiny Tree Graph \Cu
@file    ttree.c
@version 
@author  Fumi.Iseki (C)
@date    2008 2/1
*/



#include  "ttree.h"




/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// m[h
//


/**
tTree*  new_tTree_node(void)

c[p̋m[h𓮓IɐD
@return ꂽm[hւ̃|C^D
*/
tTree*  new_tTree_node(void)
{
	tTree* pp;

    pp = (tList*)malloc(sizeof(tTree));
    if (pp==NULL) return NULL;
    memset(pp, 0, sizeof(tTree));
    pp->ldat  = init_tListdata();

    return pp;
}



/**
tList  make_tTree_node(tList_data d)

c[pm[hÓIɐD
@param  d m[hf[^
@return ꂽm[hD
*/
tTree   make_tTree_node(tList_data data)
{
	tTree pp;

    memset(&pp, 0, sizeof(tTree));
    pp.ldat  = data;

    return pp;
}



/**
tTree*  add_tTree_node(tTree* pp, tTree* node) 

c[ ppփm[h nodeǉD|C^ ppwm[h̎qiqjm[hƂ nodeî́jǉD@n
node qm[hꍇ́CǉD@n
node om[hĂĂ͖iȂjD@n

@param  pp    ǉm[h̐eƂȂm[hւ̃|C^D
@param  node  ǉm[hւ̃|C^Dnode->next ȉc[łǂD
@return ǉm[hւ̃|C^Dsꍇ NULL
*/
tTree*  add_tTree_node(tTree* pp, tTree* node) 
{
	if (node==NULL) return NULL;
	if (pp==NULL) return node;

	node->prev = pp;
	node->ysis = NULL;
	node->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = node;
	if (pp->next==NULL) pp->next = node;
	pp->back = node;

	node->depth = pp->depth + 1;
	pp->num++;
	
	if (node->next!=NULL) {
		node->next->depth = node->depth + 1;
		adjust_tTree_depth(node->next);
	}

	return node;
}



/**
tTree*  add_tTree_node_bydata(tTree* pp, tList_data ldat) 

f[^ Treem[ho, pp̎qm[hiqjƂĒǉD
ldat ͎w肳ꂽ̂̂܂܎gpD

@param  pp    ǉm[h̐eƂȂm[hւ̃|C^D
@param  ldat  ǉm[hf[^D̃f[^̂܂܎gpD
@return ǉm[hւ̃|C^D
*/
tTree*  add_tTree_node_bydata(tTree* pp, tList_data ldat) 
{
	tTree* pt;

	pt = new_tTree_node();
	pt->ldat  = ldat;
	pt->depth = 1;

	if (pp==NULL) return pt;

	pt->prev = pp;
	pt->ysis = NULL;
	pt->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = pt;
	if (pp->next==NULL) pp->next = pt;
	pp->back = pt;

	pt->depth = pp->depth + 1;
	pp->num++;
	
	return pt;
}



/**
tTree*  add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 

f[^m[ho,𖖂qƂăXgɒǉD
Xg|C^ ppwm[ȟɂo m[h}D

@param  pp   ǉꏊ̎Õm[hւ̃|C^D
@param  id   ǉf[^D
@param  lv   ǉf[^D
@param  key  ǉf[^D        
@param  val  ǉf[^D        
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY
@return ǉm[hւ̃|C^D
*/
tTree*  add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata(id, lv, key, val, ptr, sz);
	pt   = add_tTree_node_bydata(pp, ldat);

	return pt;
}



/**
tTree*  add_tTree_node_bystr(tTree* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz) 

f[^m[ho,𖖂qƂăXgɒǉD
Xg|C^ ppwm[ȟɂo m[h}D

@param  pp   ǉꏊ̎Õm[hւ̃|C^D
@param  id   ǉf[^D
@param  lv   ǉf[^D
@param  key  ǉf[^D        
@param  val  ǉf[^D        
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY
@return ǉm[hւ̃|C^D
*/
tTree*  add_tTree_node_bystr(tTree* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata_bystr(id, lv, key, val, ptr, sz);
	pt   = add_tTree_node_bydata(pp, ldat);

	return pt;
}



/**
tTree*  insert_tTree_node(tTree* pp, tTree* node) 

c[ ppփm[h nodeǉD|C^ ppwm[h̎qiqjm[hƂ nodeî́jǉD@n
node qm[hꍇ́CǉD@n
node om[hĂĂ͖iȂjD@n

@param  pp    ǉm[h̐eƂȂm[hւ̃|C^D
@param  node  ǉm[hւ̃|C^Dnode->next ȉc[łǂD
@return  ǉm[hւ̃|C^Dsꍇ NULL
*/
tTree*  insert_tTree_node(tTree* pp, tTree* node) 
{
	if (node==NULL) return NULL;
	if (pp==NULL) return node;

	if (pp->next!=NULL) pp->next->esis = node;
	node->ysis = pp->next;
	node->esis = NULL;

	pp->next = node;
	node->prev = pp;

	node->depth = pp->depth + 1;
	pp->num++;
	
	if (node->next!=NULL) {
		node->next->depth = node->depth + 1;
		adjust_tTree_depth(node->next);
	}

	return node;
}



/**
tTree*  insert_tTree_node_bydata(tTree* pp, tList_data ldat) 

f[^ Treem[ho, pp̎qm[hiqjƂĒǉD
ldat ͎w肳ꂽ̂̂܂܎gpD

@param  pp    ǉm[h̐eƂȂm[hւ̃|C^D
@param  ldat  ǉm[hf[^D̃f[^̂܂܎gpD
@return ǉm[hւ̃|C^D
*/
tTree*  insert_tTree_node_bydata(tTree* pp, tList_data ldat) 
{
	tTree* pt;

	pt = new_tTree_node();
	pt->ldat  = ldat;
	pt->depth = 1;

	if (pp==NULL) return pt;
	//
	if (pp->next!=NULL) pp->next->esis = pt;
	pt->ysis = pp->next;
	pt->esis = NULL;

	pp->next = pt;
	pt->prev = pp;

	pt->depth = pp->depth + 1;
	pp->num++;
	
	return pt;
}



/**
tTree*  insert_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 

f[^m[ho,𒷎qƂăXgɒǉD
Xg|C^ ppwm[ȟɂo m[h}D

@param  pp   ǉꏊ̎Õm[hւ̃|C^D
@param  id   ǉf[^D
@param  lv   ǉf[^D
@param  key  ǉf[^D        
@param  val  ǉf[^D        
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY
@return ǉm[hւ̃|C^D
*/
tTree*  insert_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata(id, lv, key, val, ptr, sz);
	pt   = insert_tTree_node_bydata(pp, ldat);

	return pt;
}



/**
tTree*  insert_tTree_node_bystr(tTree* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz) 

f[^m[ho,𒷎qƂăXgɒǉD
Xg|C^ ppwm[ȟɂo m[h}D

@param  pp   ǉꏊ̎Õm[hւ̃|C^D
@param  id   ǉf[^D
@param  lv   ǉf[^D
@param  key  ǉf[^D        
@param  val  ǉf[^D        
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY
@return ǉm[hւ̃|C^D
*/
tTree*  insert_tTree_node_bystr(tTree* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata_bystr(id, lv, key, val, ptr, sz);
	pt   = insert_tTree_node_bydata(pp, ldat);

	return pt;
}




/**	
tTree*  del_tTree_node(tTree** node) 

c[m[h̍폜D폜ꂽm[hqm[hꍇ́C̎qm[hiグi؍\l߂j@n
node ͓IɊmۂꂽϐłȂ΂ȂȂD

@param  *node  폜m[hւ̃|C^D
@return 폜m[h̑ɋl߂ꂽqm[hւ̃|C^DYm[hȂi폜m[hqm[hȂjꍇ NULL
*/
tTree*  del_tTree_node(tTree** node) 
{
	tTree* pp = NULL;

	if (node==NULL || *node==NULL) return pp;

	if ((*node)->next!=NULL) {	// 	qm[hꍇ
		tTree* ss;
		(*node)->next->depth--;
		adjust_tTree_depth((*node)->next);

		ss = (*node)->next;
		ss->prev = (*node)->prev;
		while (ss->ysis!=NULL) {
			ss = ss->ysis;
			ss->prev = (*node)->prev;
		} 

		ss->ysis = (*node)->ysis;
		(*node)->next->esis = (*node)->esis;
		if ((*node)->ysis!=NULL) (*node)->ysis->esis = ss;
		if ((*node)->esis!=NULL) (*node)->esis->ysis = (*node)->next;

		if ((*node)->prev!=NULL) {
			if ((*node)->prev->next==(*node)) (*node)->prev->next = (*node)->next;
			if ((*node)->prev->back==(*node)) (*node)->prev->back = ss;
		}
	}

	else {					// qm[hȂꍇ
		if ((*node)->prev!=NULL) {
			if ((*node)->prev->next==(*node)) (*node)->prev->next = (*node)->ysis;
			if ((*node)->prev->back==(*node)) (*node)->prev->back = (*node)->esis;
		}
		if ((*node)->ysis!=NULL) (*node)->ysis->esis = (*node)->esis;
		if ((*node)->esis!=NULL) (*node)->esis->ysis = (*node)->ysis;
	}

	pp = (*node)->prev;
  	free_tListdata(&((*node)->ldat));
	if ((*node)->prev!=NULL) (*node)->prev->num += (*node)->num - 1;

	free(*node);
	*node = NULL;

	return pp;
}




/**	
tTree*  move_tTree_node(tTree* pp, tTree* node) 

nodẽ݂c[؂藣CppֈړD

̃c[ɉāCnodeqm[hꍇ́C̎qm[hiグi؍\l߂j@n
ړɉẮCnode om[hĂĂ͖D
node폜Ȃ del_tTree_node(), add_tTree_node() s悤Ȃ́D

@param  pp    ړŐeƂȂm[hւ̃|C^D
@param  node  ړm[hւ̃|C^Dnode->next ȉc[łǂD
@return ړm[hm[hւ̃|C^D
*/
tTree*  move_tTree_node(tTree* pp, tTree* node) 
{
	if (node==NULL || pp==NULL) return NULL;

	// m[h̐؂藣
	if (node->next!=NULL) {	// 	qm[hꍇ
		tTree* ss;
		node->next->depth--;
		adjust_tTree_depth(node->next);

		ss = node->next;
		ss->prev = node->prev;
		while (ss->ysis!=NULL) {
			ss = ss->ysis;
			ss->prev = node->prev;
		} 

		ss->ysis = node->ysis;
		node->next->esis = node->esis;
		if (node->ysis!=NULL) node->ysis->esis = ss;
		if (node->esis!=NULL) node->esis->ysis = node->next;

		if (node->prev!=NULL) {
			if (node->prev->next==node) node->prev->next = node->next;
			if (node->prev->back==node) node->prev->back = ss;
		}
	}
	else {					// qm[hȂꍇ
		if (node->prev!=NULL) {
			if (node->prev->next==node) node->prev->next = node->ysis;
			if (node->prev->back==node) node->prev->back = node->esis;
		}
		if (node->ysis!=NULL) node->ysis->esis = node->esis;
		if (node->esis!=NULL) node->esis->ysis = node->ysis;
	}
	if (node->prev!=NULL) node->prev->num += node->num - 1;


	// m[h̍Čiړj
	node->prev = pp;
	node->ysis = NULL;
	node->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = node;
	if (pp->next==NULL) pp->next = node;
	pp->back = node;

	node->depth = pp->depth + 1;
	pp->num++;
	
	if (node->next!=NULL) {
		node->next->depth = node->depth + 1;
		adjust_tTree_depth(node->next);
	}

	return node;
}




/**
void  replace_all_tTree_node(tTree* pp, char* key, char* src, char* dst, int len)

c[ pp keyL[Csrcm[hlƂĎSẴm[h̃m[hl dst ɏD

@param  tp   uΏۂ̃c[
@param  key  T[`L[
@param  src  uΏۂ̃m[hl
@param  dst  ũm[hl
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D

@return um[h̐
*/
int  replace_all_tTree_node(tTree* tp, char* key, char* src, char* dst, int len)
{
	int nn = 0;

	do { 
		if (ex_strncmp((char*)(tp->ldat).key.buf, (char*)key, len)) {
			if (ex_strncmp((char*)(tp->ldat.val.buf), (char*)src, len)) {
				free_Buffer(&(tp->ldat.val));
				tp->ldat.val = make_Buffer_bystr(dst);
				nn++;
			}
		}

		if (tp->next!=NULL) nn += replace_all_tTree_node(tp->next, key, src, dst, len);

		tp = tp->ysis;
	} while(tp!=NULL);

	return nn;
}







/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// c[
//

/**
tTree*  del_tTree(tTree** pp) 

w肵m[hȉ̃c[폜D

@param  *pp  폜c[̐擪m[h
@return 폜c[̐em[hւ̃|C^D
*/
tTree*  del_tTree(tTree** pp) 
{
	tTree* pt;

	if (pp==NULL || *pp==NULL) return NULL;

	// qm[h̍폜
	if ((*pp)->next!=NULL) del_sisters_children_tTree(&((*pp)->next));

	// g̍폜
	pt = (*pp)->prev;
	if (pt!=NULL) {
		if (pt->next==*pp) pt->next = (*pp)->ysis;
		if (pt->back==*pp) pt->back = (*pp)->esis;
		pt->num--;
	}
	if ((*pp)->ysis!=NULL) (*pp)->ysis->esis = (*pp)->esis;
	if ((*pp)->esis!=NULL) (*pp)->esis->ysis = (*pp)->ysis;

 	free_tListdata(&((*pp)->ldat));
	free(*pp);
	*pp = NULL;

	return pt;
}




/**
tTree*  del_children_tTree(tTree** pp) 

w肵m[h̎qc[폜Dw肵m[h͍폜ȂD

@param  *pp  폜qc[̐em[h
@return 폜c[̐em[hւ̃|C^D*pp ̂܂ܕԂD
*/
tTree*  del_children_tTree(tTree** pp) 
{	
	if (pp==NULL || *pp==NULL) return NULL;

	if ((*pp)->next!=NULL) del_sisters_children_tTree(&((*pp)->next));

	(*pp)->num  = 0;
	(*pp)->next = NULL;
	(*pp)->back = NULL;

	return *pp;
}




/**
tTree*  del_sisters_children_tTree(tTree** pp) 

w肵m[h̎oc[Cqc[폜D
w肵m[h폜D

@param  *pp  폜c[̋N_m[h
@return 폜c[S̐em[hւ̃|C^D

@attention ċApDem[hɑ΂鏈͍sȂ̂ŁCʓrĂяoōsƁD
*/
tTree*  del_sisters_children_tTree(tTree** pp) 
{
	tTree* pm;
	tTree* pt;

	if (pp==NULL || *pp==NULL) return NULL;
	pt = (*pp)->prev;

	pm = *pp;
	while (pm->esis!=NULL) pm = pm->esis;
	while (pm!=NULL) {
		tTree* pw = pm;
		if (pm->next!=NULL) del_sisters_children_tTree(&(pm->next)); 
		pm = pm->ysis;

  		free_tListdata(&(pw->ldat));
		free(pw);
	}
	*pp = NULL;

	pt->next = NULL;
	pt->back = NULL;

	return pt;
}




/**
void  del_all_tTree(tTree** pp)

c[̑Sm[h̍폜D|C^ pp̃m[h܂ރc[Ŝ폜D@n
*pp ̓c[ł΁CǂwĂĂǂD

@param  *pp  폜Jnm[hւ̃|C^Dc[ł΁CǂwĂĂǂD
*/
void  del_all_tTree(tTree** pp)
{
	tTree* pm;

	if (pp==NULL || *pp==NULL) return;

	pm = *pp;
	while (pm->prev!=NULL) pm = pm->prev;
	del_tTree(&pm);

	*pp = NULL;
	return;
}






/**
tTree*  add_tTree(tTree* tp, tTree* tt)

c[ tp c[ ttǉD
add_tTree_node() Ƃ̑́Cadd_tTree()擪(tt)̎om[hc[ tpɒǉ_ɂD

@param  tp  ǉc[̐eƂȂm[hւ̃|C^D
@param  tt  ǉc[ւ̃|C^D
		   
@return ǉc[̃m[hւ̃|C^Dsꍇ NULL
*/
tTree*  add_tTree(tTree* tp, tTree* tt)
{
	int	nn;
	tTree* tm;
	tTree* tw;

	if (tt==NULL) return NULL;
	if (tp==NULL) return tt;

	while(tt->esis!=NULL) tt = tt->esis;
	tt->esis = tp->back;
	if (tp->back!=NULL) tp->back->ysis = tt;
	if (tp->next==NULL) tp->next = tt;

	nn = 0;
	tm = tw = tt;
	while (tm!=NULL) {
		nn++;
		tm->prev  = tp;
		tm->depth = tp->depth + 1;

		if (tm->next!=NULL) {
			tm->next->depth = tm->depth + 1;
			adjust_tTree_depth(tm->next);
		}
		tw = tm;
		tm = tm->ysis;
	}

	tp->back = tw;
	tp->num += nn;

	return tt;
}




/**
tTree*  div_tTree(tTree* tp, tTree* tt)

c[ tp  c[ tt𕪗D

@param  tt  c[ւ̕|CgD
@return c[̌em[hւ̃|C^Dsꍇ NULL
*/
tTree*  div_tTree(tTree* tt)
{
	if (tt==NULL) return NULL;
	if (tt->prev==NULL) return tt;

	if (tt->prev->next==tt) tt->prev->next = tt->ysis;
	if (tt->prev->back==tt) tt->prev->back = tt->esis;

	if (tt->ysis!=NULL) tt->ysis->esis = tt->esis;
	if (tt->esis!=NULL) tt->esis->ysis = tt->ysis;

	tt->depth = 1;
	if (tt->next!=NULL) {
		tt->next->depth = 2;
		adjust_tTree_depth(tt->next);
	}

	tt->prev->num--;
	tt->prev = NULL;

	return tt;
}




/**
tTree*  dup_merge_tTree(tTree* pp, tTree* tp)

c[ pp̒Ƀc[ tp𕡐D
pp NULL̏ꍇ́Cc[̐[͒Ȃ

@param  pp  ꂽc[̃gbvƂȂm[h
@param  tp  c[

@return ꂽc[ւ̃|C^Dpp NULLłȂꍇ pp 
@return pp NULL̏ꍇ́CVc[̃gbvD
*/			 
tTree*  dup_merge_tTree(tTree* pp, tTree* tp)
{
	if (tp==NULL) return pp;

	if (pp!=NULL) {
		while(tp->esis!=NULL) tp = tp->esis;
		while(tp!=NULL) {
			tTree* pt = dup_tList_node(tp);
			pt->next = pt->prev = pt->back = pt->ysis = pt->esis = NULL;
			add_tTree(pp, pt);
			if (tp->next!=NULL) dup_merge_tTree(pt, tp->next);
			tp = tp->ysis;
		}		
	}
	else {
		pp = dup_tList_node(tp);
		pp->next = pp->prev = pp->back = pp->ysis = pp->esis = NULL;
		if (tp->next!=NULL) dup_merge_tTree(pp, tp->next);
	}

	return pp;
}





/**
void  merge_tTree(tTree* tp, tTree* tt)

c[ tp Ƀc[ tt DCtt ̓e͉(tpƃm[h`ɂȂ)D

tt  tp̈ꕔƓ\(L[l)ꍇC[m[h tt̃m[hŒuDtp ɑ݂Ȃ}͒ǉD@n
c[̐[ tp[ɍČvZD
		  
@param[in,out] tp  in: tt ̌|CgDout: ̃c[D
@param[in,out] tt  in: c[Dout: e͔j󂳂Dv

@par 
@code
tp							tr
A --> B --> M				A --> B --> X
  --> C --> M --> X			  --> C --> M
			  --> Y			  --> D
		--> N
@endcode
ȏ̏ꍇCmerge_tTree(tp, tr) sƈȉ̂悤ɂȂD
@code
tp
A --> B --> M 
		--> X (tr)
  --> C --> M (tr)
		--> N 
  --> D (tr)

tt
A --> B 
  --> C --> M --> X (tp)
			  --> Y (tp)
@endcode
*/
void  merge_tTree(tTree* tp, tTree* tt)
{
	tTree* tl;
	tTree* nt;
	tTree* nl;
	int	depth;

	if (tp==NULL || tt==NULL) return;

	depth = tp->depth;
	tl = tp;
	while (tt!=NULL) {
		if ((tt->ldat).key.buf==NULL) return;
		if (tl!=NULL && (tl->ldat).key.buf==NULL) return;
		while (tl!=NULL && strcmp((char*)((tl->ldat).key.buf), (char*)((tt->ldat).key.buf))) tl = tl->ysis;

		nt = tt;
		nl = tl;
		tt = tt->ysis;

		if (tl==NULL) {	
			div_tTree(nt);
			add_tTree(tp->prev, nt);
			tl = nt;
			return;
		}
		else if (nl->next!=NULL && nt->next!=NULL) {
			merge_tTree(nl->next, nt->next);
			tl = tl->ysis;
		}
		else {
			tl = tl->ysis;
			exchange_tTree(nl, nt);
		}
	}

	tp->depth = depth;
	adjust_tTree_depth(tp);

	return;
}




/**
void  exchange_tTree(tTree* tl, tTree* tt)

c[ tl c[ ttD

@param  tl  Ώۂ̃c[
@param  tt  Ώۂ̃c[
*/
void  exchange_tTree(tTree* tl, tTree* tt)
{
	int	dt = tt->depth;
	tTree* pt = tt->prev;
	tTree* yt = tt->ysis;
	tTree* et = tt->esis;


	if (tl->esis!=NULL) tl->esis->ysis = tt;
	if (tl->ysis!=NULL) tl->ysis->esis = tt;
	if (tl->prev!=NULL) {
		if (tl->prev->next==tl) tl->prev->next = tt;
		if (tl->prev->back==tl) tl->prev->back = tt;
	}

	tt->ysis  = tl->ysis;
	tt->esis  = tl->esis;
	tt->prev  = tl->prev;
	tt->depth = tl->depth;
	if (tt->next!=NULL) {
		tt->next->depth = tt->depth + 1;
		adjust_tTree_depth(tt->next);
	}


	if (et!=NULL) et->ysis = tl;
	if (yt!=NULL) yt->esis = tl;
	if (pt!=NULL) {
		if (pt->next==tt) pt->next = tl;
		if (pt->back==tt) pt->back = tl;
	}

	tl->ysis  = yt;
	tl->esis  = et;
	tl->prev  = pt;
	tl->depth = dt;
	if (tl->next!=NULL) {
		tl->next->depth = dt + 1;
		adjust_tTree_depth(tl->next);
	}
}




/**
void   adjust_tTree_depth(tTree* pp)

w肵m[h ppɂāC؂̐[𑪂蒼

@param  pp  ƂȂm[hւ̃|C^
*/
void   adjust_tTree_depth(tTree* pp)
{
	int depth;
	tTree* pt;
	
	if (pp==NULL) return;

	depth = pp->depth;
	pt = pp;
	while (pt->ysis!=NULL) {
		pt = pt->ysis;
		pt->depth = depth;
		if (pt->next!=NULL) {
			pt->next->depth = depth + 1;
			adjust_tTree_depth(pt->next);
		}
	}

	pt = pp;
	while (pt->esis!=NULL) {
		pt = pt->esis;
		pt->depth = depth;
		if (pt->next!=NULL) {
			pt->next->depth = depth + 1;
			adjust_tTree_depth(pt->next);
		}
	}

	if (pp->next!=NULL) {
		pp->next->depth = depth + 1;
		adjust_tTree_depth(pp->next);
	}

	return;
}




/**
void   print_tTree(FILE* fp, tTree* pp, const char* space)

c[̕\D|C^ ppȍ~̑SẴm[h̃L[̃obt@WG[o͂ɕ\D

@param  fp     o͂t@Cւ̃|C^DNULL̏ꍇ stderr
@param  pp     \Jnm[hւ̃|C^D
@param  space  o𑵂͂̏邽߂̋󔒁D
*/
void   print_tTree(FILE* fp, tTree* pp, const char* space)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp->esis!=NULL) pp = pp->esis;
		do { 
			int i;
			tList_data ld = pp->ldat;

			if (pp->depth>1) fprintf(fp, " -> ");
			fprintf(fp, "%d: %d %d %s %s", pp->depth, ld.id, ld.lv, ld.key.buf, ld.val.buf);
			//fprintf(fp, "%d: %d %d %s %s, %04x", pp->depth, ld.id, ld.lv, ld.key.buf, ld.val.buf, pp->altp);
			//if (pp->ldat.lst!=NULL) print_tTree(fp, pp->ldat.lst, space);

			if (pp->next!=NULL) print_tTree(fp, pp->next, space);
			else fprintf(fp, "\n");

			pp = pp->ysis;
			if (pp!=NULL) {
        		for(i=1; i<pp->depth; i++)   fprintf(fp, space);
        		for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");      // for " -> "
			}
		} while(pp!=NULL);
	}
	else {
		fprintf(fp, "(Tree is NULL)\n");
	}
	fflush(fp);

	return;
}




/**
tTree*  find_tTree_end(tTree* pp)

c[̍ŏIm[hD
*/
tTree*  find_tTree_end(tTree* pp)
{
	if (pp==NULL) return NULL;

	while(pp->prev!=NULL) pp = pp->prev;	// Top T
	while(pp->back!=NULL) pp = pp->back;

	return pp;
}





/**
int  count_tTree(tTree* pp)

c[ ppm[hȍ~̃m[h̐𐔂D

@param  pp  n߂m[hւ̃|C^Dom[hD
@return m[h̐D
*/
int  count_tTree(tTree* pp)
{
	int cnt = 0;

	if (pp==NULL) return 0;
	while(pp->esis!=NULL) pp = pp->esis;

	do { 
		cnt++;
		if (pp->next!=NULL) cnt += count_tTree(pp->next);
		pp = pp->ysis;
	} while(pp!=NULL);

	return cnt;
}






////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Pattern Matching
//

/**
tTree*  strncmp_tTree(tTree* pp, const char* key, int len, int no)

c[m[h̃L[l̃T[`D

|C^ ppȍ~̃m[h,L[̕ keyƑOviIjm[h̓
noԖڂɂ̂{oD

@param  pp   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ijD
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tTree*  strncmp_tTree(tTree* pp, const char* key, int len, int no)
{
	tTree* pt = NULL;
	int nn = 0;

	if (pp==NULL) return NULL;
	if (len<=-3)  return NULL;
	if (no<=0) no = 1;

	if (ex_strncmp((char*)(pp->ldat).key.buf, key, len)) {
		nn++;
		if (no==nn) return pp;
	}
	if (pp->next!=NULL) pt = next_strncmp_vertical_tTree(pp->next, key, len, no, &nn);

	return pt;
}



/**
tTree*  strncasecmp_tTree(tTree* pp, const char* key, int len, int no)

c[m[h̃L[l̃T[`D啶𖳎D

|C^ ppȍ~̃m[h,L[̕ keyƑOviIjm[h̓
noԖڂɂ̂{oD

@param  pp   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ijD啶CʂȂD
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tTree*  strncasecmp_tTree(tTree* pp, const char* key, int len, int no)
{
	tTree* pt = NULL;
	int nn = 0;

	if (pp==NULL) return NULL;
	if (len<=-3)  return NULL;
	if (no<=0) no = 1;

	if (ex_strncasecmp((char*)(pp->ldat).key.buf, key, len)) {
		nn++;
		if (no==nn) return pp;
	}
	if (pp->next!=NULL) pt = next_strncasecmp_vertical_tTree(pp->next, key, len, no, &nn);

	return pt;
}



/**
tTree*  cmp_sisters_tTree(tTree* tp, tTree* tr)

m[htp̎om[h m[htr̎om[hƓp^[iL[lrĂ邩ǂD

Ctr->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
܂ tp->ctrl  TREE_ALREADY_FOUND_NODE ̏ꍇ́CɈvȂD
m[hp^[ꍇCtr̊em[h altpɂ͑Ή tp̊em[hւ̃|C^i[D

@param  tp   ׂom[h̒m[h
@param  tr   Tom[hp^[̒m[h

@return tp trƓp^[n܂m[hւ̃|C^Dtr̊em[h altpɂ͑Ή tp̊em[hւ̃|C^i[D
@retval NULL tpɓop^[͖D̏ꍇCtraltp̒l͕sƂȂD

@par 
ȉ̏ꍇCcmp_sisters_tTree(tp, tr)  (3)ւ̃|C^ԂD܂ tr Am[h
 altp ɂ (3) ւ̃|C^Ctr Xm[haltpɂ(4)ւ̃|C^i[D
ŏɌp^[̂ݕ]D
@code
tp				tr
--> A (1)		 --> A 		A, B, X  L[l(ldat.key.buf)
--> B (2)		 --> X
--> A (3)
--> X (4)
--> A (5)
--> X (6)
@endcode
*/
tTree*  cmp_sisters_tTree(tTree* tp, tTree* tr)
{
	tTree* ta;
	tTree* tb = NULL;
	tTree* ts;

	ts = tp;
	while (ts!=NULL){
		ta = ts;
		tb = tr;
		while (ta!=NULL && tb!=NULL) {
			if (ta->ctrl==TREE_ALREADY_FOUND_NODE) break;
			if (tb->ctrl!=TREE_NOCMP_NODE && tb->ctrl!=TREE_NOCMP_COPY_NODE) {
				if ((ta->ldat).key.buf!=NULL && (tb->ldat).key.buf!=NULL) {
					if (strcmp((char*)((ta->ldat).key.buf), (char*)((tb->ldat).key.buf))) break;
				}
				else break;
			}
			tb->altp = ta;
			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (tb==NULL) return ts;

		ts = ts->ysis;
	}
	if (tb!=NULL) return NULL;

	return ts;
}



/**
int  check_match_tTree(tTree* tp, tTree* tr)

c[ tp c[ trƓp^[(L[l)Ă邩ǂD@n
tp ̃gbv tr ̃gbv̓L[lvĂKvDvĂȂ΁Cp^[͖ƂD
Ctr->ctrl  @b TREE_NOCMP_NODE ܂ @b TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D

x tp̎}̍Ō̃m[hɑ΂Ă ctrl @b TREE_ALREADY_FOUND_NODE ݒ肷̂ŁCă`FbN
ꍇȂǂ ctrl NAKvD

c[p^[ꍇCtr̊em[h altpɂ́CԍŏɌΉ tp̊em[hւ̃|C^i[D

@param  tp    Ώۂ̃c[
@param  tr    p^[̃c[

@retval TRUE  tp trƓc[p^[݂Dtr̊em[h altpɂ́CԍŏɌΉ tp̊em[hւ̃|C^i[D
@retval	FALSE tpɓc[p^[͖D̏ꍇCtraltp̒l͕sƂȂD

*/
int  check_match_tTree(tTree* tp, tTree* tr)
{
	int  ret;
	tTree* ts;
	tTree* tt;
	tTree* ta;
	tTree* tb;
	tTree* te;


	if (tp==NULL || tr==NULL) return FALSE;

	te = find_tList_end(tr);

	ts = tp;
	while (ts!=NULL) {
		tt = cmp_sisters_tTree(ts, tr);		// ̊KwŃL[lSĈvĂ邩mF
		if (tt==NULL) return FALSE;			// vĂȂ΁CFALSE
		
		ta  = tt;							// ׂc[
		tb  = tr;							// ׂp^[
		ret = TRUE;
		while (tb!=NULL && ret) {
			if (tb->next==NULL) ret = TRUE;
			// ->ta, ->tb->tx: FALSE
			else if (tb->next!=NULL && ta->next==NULL) ret = FALSE;
			// ->ta->xa, ->tb->xb: xaxb`FbN
			else ret = check_match_tTree(ta->next, tb->next);

			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (ret) {
			if (tr==te) tt->ctrl = TREE_ALREADY_FOUND_NODE;
			return TRUE;
		}

		ts = tt->ysis;
	}

	return FALSE;
}



/**
int find_match_tTree(tTree* pp, tTree* pt)

c[ pp c[ ptƓp^[̎}TD@n 
p^[̒Tł L[l݂̂rCm[hl͔rȂD
Cpt->ctrl  @b TREE_NOCMP_NODE ܂ @b TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
	
c[p^[ꍇCtr̊em[h altpɂ́CԍŏɌΉ pp̊em[h
̃|C^i[D

check_match_tTree() Ƃ̈ႢD
- check_match_tTree() łׂ͔}̊Jnm[hppɌŒ肳D
- find_match_tTree()  ppړȂ猟łD

@param  pp    Ώۂ̃c[
@param  pt    p^[̃c[

@retval TRUE  pp ptc[p^[݂Dpt̊em[h altpɂ́CԍŏɌΉ pp̊em[hւ̃|C^i[D
@retval	FALSE ppɓc[p^[͖D̏ꍇCptaltp̒l͕sƂȂD
*/
int  find_match_tTree(tTree* pp, tTree* pt)
{
	int   ret;
	tTree* pm;

	pm = pp;
	while(pp!=NULL) {
		ret = check_match_tTree(pp, pt);
		if (ret) return TRUE;

		if (pp->next!=NULL) {
			ret = find_match_tTree(pp->next, pt);
			if (ret) {
				clear_tTree_ctrl(pm);
				return TRUE;
			}
		}
		pp = pp->ysis;
	}

	return FALSE;
}




/**
void   clear_tTree_ctrl(tTree* pp)

ppc[ ctrlNAD
*/
void   clear_tTree_ctrl(tTree* pp)
{
	while (pp->esis!=NULL) pp = pp->esis;

	while (pp!=NULL) {
		pp->ctrl = TREE_NOCTRL_NODE;
		if (pp->next!=NULL) clear_tTree_ctrl(pp->next);
		pp = pp->ysis;
	}
}




/**
tList*  find_match_tTree_endlist(tTree* pp, tTree* pt)

c[ pp c[ ptƓp^[̎}SĒTāC̎}̍Ō̃m[hւ̏XgɂĕԂD@n
Ym[hւ̃|C^ ԂꂽeXgaltp ێĂD 

rł L[l݂̂rCm[hl͔rȂD
܂Cpt->ctrl  @b TREE_NOCMP_NODE ܂ @b TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
	
@param  pp  Ώۂ̃c[
@param  pt  p^[̃c[

@return Ym[hւ̃|C^ێ郊XgD
*/
tList*  find_match_tTree_endlist(tTree* pp, tTree* pt)
{
	tTree* te;
	tList* lp;

	te = find_tTree_end(pt);
	while(pp->esis!=NULL) pp = pp->esis;

	lp = find_match_tTree_endlist_rcsv(pp, pt, te);
	if (lp!=NULL) clear_tTree_ctrl(pp);
	
	return lp;
}




/**
tList*  find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te)

find_match_tTree_endlist() ̕⏕֐
*/
tList*  find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te)
{
	tList* lt = NULL;
	tList* lp = NULL;

	while(pp!=NULL) {
		int ret = check_match_tTree(pp, pt);
		if (ret && te->altp!=NULL) {
			tList* lm = new_tList_node();
			lm->altp = te->altp;
			lt = insert_tList(lt, lm);
			if (lp==NULL) lp = lt;
			te->altp = NULL;
		}
			
		if (pp->next!=NULL) {
			tList* lm = find_match_tTree_endlist_rcsv(pp->next, pt, te);
			if (lm!=NULL) {
				lt = insert_tList(lt, lm);
				if (lp==NULL) lp = lt;
				clear_tTree_ctrl(pp->next);
			}
		}
	
		if (!ret) pp = pp->ysis;	// ꍇ͂xDȂꍇ֎ցD
	}
	
	return lp;
}




/**
void  replace_tTree_node(tTree* pp, tTree* pt)

c[ pp c[ ptƓp^[iL[lrj̎}CppɈvp^[̎}΁C
̎}̊em[hɑ΂āCΉ邻ꂼ́ipt->ctrl  TREE_COPY_NODE ܂ TREE_NOCMP_COPY_NODE łj
pt̃m[h̑ŒuD@n
p^[̈vijł ldat.keyiL[ljrD

u鑮 ldat.id, ldat.lv, ldat.sz, ldat.key, ldat.val, ldat.ptr, ldat.lst @n
uŝ pt->ctrl  @b TREE_COPY_NODE ܂ @b TREE_NOCMP_COPY_NODE ̏ꍇ݂̂łD(dv) @n
ldat.val, ldat.ptr, ldat.lst ɂẮCptŒlݒ肳ĂȂ΁CusȂD
	
@param  pp    uΏۂ̃c[
@param  pt    uc[

@retval TRUE  u}Dɒuꂽǂ͕sD
@retval FALSE u}ȂD
*/
int replace_tTree_node(tTree* pp, tTree* pt)
{
	int ret;

	if (pp==NULL || pt==NULL) return FALSE;
	while(pp->esis!=NULL) pp = pp->esis;
	
	ret = find_match_tTree(pp, pt);
	if (ret) {
		copy_tTree_byctrl(pt);
		adjust_tTree_depth(pp);
	}

	return ret;
}




/**
void  copy_tTree_byctrl(tTree* pt)

replace_tTree_node()̕⏕֐D

c[ ptɂāCpt->ctrl  TREE_COPY_NODE ܂ TREE_NOCMP_COPY_NODE ̏ꍇC
pt->altp ̃m[h pt̑Rs[D@n
pt->ldat.sz ɂ͐m pt->ldat.ptr̃TCYݒ肳ĂKvD
*/
void  copy_tTree_byctrl(tTree* pt)
{
	while(pt!=NULL) {
		if (pt->altp!=NULL) {
			if (pt->ctrl==TREE_COPY_NODE || pt->ctrl==TREE_NOCMP_COPY_NODE) {
				pt->altp->ldat.id = pt->ldat.id;		
				pt->altp->ldat.lv = pt->ldat.lv;
				pt->altp->ldat.sz = pt->ldat.sz;

				if (pt->ldat.key.buf!=NULL) {
					free_Buffer(&(pt->altp->ldat.key));
					pt->altp->ldat.key = dup_Buffer(pt->ldat.key);
				}
				if (pt->ldat.val.buf!=NULL) {
					free_Buffer(&(pt->altp->ldat.val));
					pt->altp->ldat.val = dup_Buffer(pt->ldat.val);
				}

				if (pt->ldat.ptr!=NULL && pt->ldat.sz>0) {
					if (pt->altp->ldat.ptr!=NULL) free(pt->altp->ldat.ptr);
					pt->altp->ldat.ptr = (void*)malloc(pt->ldat.sz);
					if (pt->altp->ldat.ptr!=NULL) memcpy(pt->altp->ldat.ptr, pt->ldat.ptr, pt->ldat.sz);
				}

				if (pt->ldat.lst!=NULL) {
					del_all_tList(&(pt->altp->ldat.lst));
					pt->altp->ldat.lst = dup_tList(pt->ldat.lst);
				}
			}
		}

		if (pt->next!=NULL) copy_tTree_byctrl(pt->next);
		pt = pt->ysis;
	}

	return;
}




/**
Buffer  get_value_tTree(tTree* pp, tTree* pt)

c[ pp c[ ptƓp^[̎}CppɈvp^[
}΁C@̎}̍Ō̃m[h̒lԂD

@param  pp  Ώۂ̃c[
@param  pt  p^[
@return pt̍Ō̃m[hɑΉ pp̃m[h̃m[hl

@par 
ȉ̏ꍇCY(*) ̃m[hlԂD
@code
tp							tr
A --> B --> M				C --> M --> Y
  --> C --> M --> X 			  
			  --> Y(*)		 
		--> N
@endcode
*/
Buffer  get_value_tTree(tTree* pp, tTree* pt)
{
	int fnd;
	Buffer val;

	val = init_Buffer();
	if (pp==NULL || pt==NULL) return val;

	while(pp->esis!=NULL) pp = pp->esis;
	
	fnd = find_match_tTree(pp, pt);
	if (fnd) {
		tTree* tt = find_tTree_end(pt);
		if (tt->altp!=NULL) {
			val = dup_Buffer(tt->altp->ldat.val);
		}
	}

	return val;
}







/////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
tTree*  next_strncmp_vertical_tTree(tTree* pp, const char* key, int len, int no, int* nn)

tTree p⏕֐Dhorizon ͋[IȉTiSȉTł͂Ȃj
*/
tTree*  next_strncmp_vertical_tTree(tTree* pp, const char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncmp((char*)(pp->ldat).key.buf, key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->next!=NULL) {
			tTree* tt = next_strncmp_vertical_tTree(pp->next, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->ysis;
	} while(pp!=NULL);

	return NULL;
}




/**
tTree*  next_strncmp_horizon_tTree (tTree* pp, const char* key, int len, int no, int* nn)

tTree p⏕֐Dhorizon ͋[IȉTiSȉTł͂Ȃj
*/
tTree*  next_strncmp_horizon_tTree(tTree* pp, const char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncmp((char*)(pp->ldat).key.buf, key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->ysis!=NULL) {
			tTree* tt = next_strncmp_horizon_tTree(pp->ysis, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->next;
	} while(pp!=NULL);

	return NULL;
}




/**
tTree*  next_strncasecmp_vertical_tTree(tTree* pp, const char* key, int len, int no, int* nn)

tTree p⏕֐Dhorizon ͋[IȉTiSȉTł͂Ȃj
*/
tTree*  next_strncasecmp_vertical_tTree(tTree* pp, const char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->next!=NULL) {
			tTree* tt = next_strncasecmp_vertical_tTree(pp->next, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->ysis;
	} while(pp!=NULL);

	return NULL;
}




/**
tTree*  next_strncasecmp_horizon_tTree (tTree* pp, const char* key, int len, int no, int* nn)

tTree p⏕֐Dhorizon ͋[IȉTiSȉTł͂Ȃj
*/
tTree*  next_strncasecmp_horizon_tTree(tTree* pp, const char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->ysis!=NULL) {
			tTree* tt = next_strncasecmp_horizon_tTree(pp->ysis, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->next;
	} while(pp!=NULL);

	return NULL;
}



