/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBXL_EXTEND_TOOLS_H_
#define  __JBXL_EXTEND_TOOLS_H_
 

/** 
@brief   ėpgc[wb_ 
@file    xtools.h
@version 1.1
@author  Fumi.Iseki (C)
@date    2009 2/13
*/



#include "tlist.h"
#include "network.h"

#ifndef WIN32
	#include <dirent.h>
#endif






// File Save & Load Mode
#define  FBRTL_ANY		 	0x0000
#define  FBRTL_IPADDRESS	0x0001
#define  FBRTL_PRIV_KEY	 	0x000a
#define  FBRTL_PUB_KEY	  	0x000b
#define  FBRTL_SPKI		 	0x000c

#define  FBRTL_ORIGINAL	 	0x0000	  // {̃f[^`DB!!
#define  FBRTL_BIN		  	0x0000
#define  FBRTL_DER		  	0x0000
#define  FBRTL_BASE64	   	0x0010
#define  FBRTL_STRING	   	0x0030
#define  FBRTL_AES		  	0x00a0
#define  FBRTL_DES		  	0x00b0
#define  FBRTL_3DES		 	0x00c0


/**/

// Network
int	 	udp_recv_Buffer(int sock, Buffer* buf, struct sockaddr_in* sv);
int	 	udp_send_Buffer(int sock, Buffer* buf, struct sockaddr_in* sv);
int	 	tcp_recv_Buffer(int sock, Buffer* buf);
int	 	tcp_send_Buffer(int sock, Buffer* buf);

int		tcp_recv_Buffer_wait(int sock, Buffer* buf, int tm);
int  	udp_recv_Buffer_wait(int sock, Buffer* buf, struct sockaddr_in* sv_addr, int tm);

int	 	udp_send_sBuffer  (int sock, Buffer* buf, struct sockaddr_in* sv);
int	 	tcp_send_sBuffer  (int sock, Buffer* buf);
int	 	tcp_send_sBufferln(int sock, Buffer* buf);   


int  	tcp_recv_mstreamBuffer(int sock, Buffer* buf, mstream* sb, int tm);
int  	tcp_recv_linesBuffer(int sock, Buffer* buf, int tm);

Buffer	comp_hostport(char* ipaddr, unsigned short port);
int		decomp_hostport(Buffer buf, Buffer* ipaddr, unsigned short* port);

Buffer  comp_url(char* protocol, char* host, unsigned short port, char* dir);
//int		decomp_url(Buffer url, Buffer* srvurl, Buffer* srvfqdn, unsigned short* sport, Buffer* srvdir);
int		decomp_url(Buffer url, Buffer* srvurl, Buffer* protocol, Buffer* srvfqdn, unsigned short* sport, Buffer* srvdir);

#define make_hostport(h, p) 	comp_hostport((h), (p))
#define make_url(t, h, p, d) 	comp_url((t), (h), (p), (d))

struct  sockaddr_in  get_sockaddr_Buffer(Buffer buf);
Buffer  get_hostport_sockaddr(struct sockaddr_in addr); 


// File I/O
int	 	save_taggedBuffer(Buffer buf, FILE* fp, unsigned int mode, int prfm);
Buffer  read_taggedBuffer(FILE* fp, unsigned int* mode);
Buffer  fgets_mstreamBuffer(Buffer buf, mstream* sb);


// RunLength
int  	get_runlength_byte(unsigned char* buf, int len, int pos);
Buffer	decode_runlength  (unsigned char* buf, int len, int sz);
Buffer	encode_runlength  (unsigned char* buf, int len);

#define get_runlength_byte_Buffer(b, s) 	get_runlength_byte((b).buf, (b).vldsz, (s))
#define decode_runlength_Buffer(b, s)  		decode_runlength((b).buf, (b).vldsz, (s))
#define encode_runlength_Buffer(b)  		encode_runlength((b).buf, (b).vldsz)


// z
Buffer* get_Buffer_dim_tList(tList* lp);			///< Xg𕪉ăL[(key)̔z𑢂
Buffer* get_Buffer_dim_tList_value(tList* lp);		///< Xg𕪉ăo[(val)̔z𑢂

Buffer* awk_Buffer_dim (Buffer  buf, char cc);		///<  awkŕĔz
Buffer* cawk_Buffer_dim(Buffer  buf, char cc);		///<  cawkŕĔz
Buffer  join_Buffer_dim(Buffer* dim, const char* deli);	///< z̗vf dliԂɓČq

Buffer* decompline_Buffer_dim(Buffer buf, int mode);///< f[^sPʂɕDs @\r@\n

void    del_Buffer_dim(Buffer** buf);				///< z폜D


// tList and Buffer
tList*  get_tList_line_Buffer(Buffer buf, int n);
tList*  get_tList_seq_data_Buffer(Buffer buf, int* ptr);


// Extend tList
int		set_item_tList(tList* list, char* key, int no, char deli, int nm, char* value);
int		replace_item_tList(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value);
int		set_item_tList_node(tList* list, char deli, int nm, char* value);
int		replace_item_tList_node(tList* list, char deli, int nm, char* srcval, char* value);


// File, Directory
tList*  get_dir_files(const char* dirn);
tList*  get_dir_files_rcsv(const char* dirn);

void    cut_file_extension(Buffer* path);
void    change_file_extension(Buffer* path, const char* ext);


// Resource List
char*   get_resource_path(char* name, tList* lp);
tList*  add_resource_list(const char* path, int keylen, tList* list);


#endif




