
#ifndef  __JBXL_BVH_TOOL_H_
#define  __JBXL_BVH_TOOL_H_


/**
@brief   BVHc[vO wb_
@file    bvh_tool.h
@author  Fumi.Iseki (C)
*/


#include "ttree.h"
#include "matrix.h"



//
#define  BVH_TAG_HIERARCHY  0
#define  BVH_TAG_ROOT      	1
#define  BVH_TAG_JOINT     	2
#define  BVH_TAG_END  		3



#define  BVH_STR_HIERARCHY  "HIERARCHY"
#define  BVH_STR_MOTION     "MOTION"

#define  BVH_STR_ROOT       "ROOT"
#define  BVH_STR_JOINT      "JOINT"
#define  BVH_STR_END        "End"

#define  BVH_STR_OFFSET     "OFFSET"
#define  BVH_STR_CHANNELS   "CHANNELS"

#define  BVH_STR_FRAMES		"Frames:"
#define  BVH_STR_FRAME		"Frame"
#define  BVH_STR_TIME		"Time:"

#define  BVH_STR_FRAME_TIME	"Frame Time:"
#define  BVH_STR_PX   		"Xposition"
#define  BVH_STR_PY   		"Yposition"
#define  BVH_STR_PZ   		"Zposition"
#define  BVH_STR_RX   		"Xrotation"
#define  BVH_STR_RY   		"Yrotation"
#define  BVH_STR_RZ   		"Zrotation"




/*
hierarchy f[^
    int     ldat.id     ^O̎ʁDBVH_TAG_HIERARCHY, BHV_TAG_ROOT, BVH_TAG_JOINT, BVH_TAG_END
    int     ldat.lv     CHANNELS 6/3
    int     ldat.sz     sizeof(vector)
    Buffer  ldat.key    ֐ߖ
    Buffer  ldat.val    Rx "P#P#P#R#R#R#" ̌`
    void*   ldat.ptr    OFFSET  vector ւ̃|C^
    tTree*  ldat.lst    NULL

    tTree*  next        q^Oijւ̃|C^
    tTree*  prev        e^Oւ̃|C^
    tTree*  altp        ̑ւ̃|C^iėpj 
    tTree*  back        q^Oiqjւ̃|C^ 
    tTree*  esis        O̎oioj^Oւ̃|C^
    tTree*  ysis        ̎oij^Oւ̃|C^

    int     depth       [                    
    int     num         qm[h̐iSĂ̎qm[h̐j  
    int     ctrl        p
    int     state       m[h̏  BVH_PARSED, BVH_PARSE_ERROR, ....
*/




struct _bvh_data
{
	int		joint_num;		// ֐߂̐
	int  	frame_num;		// t[̐
	double	frame_time;		// t[Ԃ̎ sec
	int		framepsec;		// FPS = (int)(1.0/frame_time)
	int  	channels;		// `lD`l̍vD[Vf[^̐D
	int		state;			// f[^̏
	
	tTree*  hierarchy;		// ֐ߕ̃c[f[^ւ̃|C^DLQƁD
	double* motion;			// MOTION f[^ւ̃|C^ joint_num*frame_num
	vector* offset;			// ֐߂OFFSET
};

typedef struct _bvh_data  BVHData;





///////////////////////////////////////////////////////////////////////////
// Basic

BVHData*	new_BVHData(void);
void		del_BVHData(BVHData** bvh);

void		init_BVHData (BVHData* bvh);
void		clear_BVHData(BVHData* bvh);

#define		free_BVHData(t) 	del_BVHData(t)



///////////////////////////////////////////////////////////////////////////
// Tiny Tool

tList*  	bvh_get_seq_data(FILE* fp);
tList*  	bvh_find_line(FILE* fp, const char* key);

int			bvh_count_joints(tTree* tree);
int			bvh_count_channels(tTree* tree);
void		bvh_get_offset(tTree* tree, vector** vect);
void  		bvh_get_parameter(BVHData* bvh);

void	    _bvh_recsv_get_parameter(tTree* tree, BVHData* bvh);
void  		_bvh_space_format(FILE* fp, int depth);



///////////////////////////////////////////////////////////////////////////
// File I/O

BVHData*  	bvh_read_file (const char* fn);
int			bvh_write_file(const char* fn, BVHData* bvh);

#define		bvh_read_data(f)	bvh_parse_data((f))

int 		bvh_print_data(FILE* fp, BVHData* bvh);
int 		bvh_print_hierarchy(FILE* fp, BVHData* bvh);
int 		bvh_print_motion(FILE* fp, BVHData* bvh);

int 		_bvh_recsv_print_hierarchy(FILE* fp, tTree* tree);



///////////////////////////////////////////////////////////////////////////
// Parser

BVHData*  	bvh_parse_data(FILE* fp);
tTree* 		bvh_parse_hierarchy(tTree* tree, FILE* fp);
void 		bvh_parse_motion(BVHData* bvh, FILE* fp);



#endif
