

/**
@brief    Ǘ@\tOtBbNf[^`Cu 
@file     ExGdata.cpp
@author   Fumi.Iseki
*/




#include  "ExGdata.h"



using namespace jbxl;



////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ExCmnHead 
//

//
void  ExCmnHead::init(void)
{	
	init_CmnHead(this);
	dbyte = 0;
	state = 0;
	refno = NULL;
}




//
void  ExCmnHead::set(RBound<int> rb, int d, int* rn) {
	set(rb.xmax-rb.xmin+1, rb.ymax-rb.ymin+1, rb.zmax-rb.zmin+1, d, rn);
	return;
}




//
void  ExCmnHead::set(int x, int y, int z, int d, int* rn) 
{ 
	init_CmnHead(this);
	state = 0;
	getm(x, y, z, d); 

	if (rn!=NULL) setRefer(rn);
	else if (refno!=NULL) {
		if (grptr==NULL) *refno = -1;
		else             *refno =  1;
	}

	return;
}




//
void  ExCmnHead::getm(int x, int y, int z, int d)
{
	if (x<=0) x = 1;
	if (y<=0) y = 1;
	if (z<=0) z = 1;
	if (d<=0) d = 8;

	xsize = x;
	ysize = y;
	zsize = z;
	depth = d;
	state = 0;

	dbyte = (d+7)/8;
	lsize = x*y*z*dbyte;

	grptr = (uByte*)malloc(lsize*sizeof(uByte));
	if (grptr==NULL) {
		init_CmnHead(this);
		state = ERROR_GRAPH_MEMORY;
		return;
	}
	memset(grptr, 0, lsize);
}




//
void  ExCmnHead::setRefer(int* rn)
{
	refno = rn;
	if (refno!=NULL) {
		if (grptr==NULL) *refno = -1;
		else			 *refno =  1;
	}
}




//
bool  ExCmnHead::isNull(void)
{
	if (grptr==NULL) return true;

#ifdef WIN32
	if (grptr==(uByte*)WIN_DD_NULL) return true;
#endif

	if (refno!=NULL) {
		if (*refno<0) return true;
		else		  return false;
	}
	return false;
}





/**
void  ExCmnHead::mfree(bool azero)

OtBbNf[^J

ǗĂꍇ́CQƐ炷D
ǗĂȂꍇ́CȂD
*/
void  ExCmnHead::mfree(bool azero)
{
	if (refno!=NULL) {
		(*refno)--;
		if (!azero && *refno==0) {
			free_CmnHead(this);
			*refno = -1;
		}
		else if (*refno==-1) {
			DEBUG_MODE print_messageln("ExCmnHead::free(): [x] ʏ킠肦ȂQƐ 0");
		}
		else if (*refno<-1) {
			 *refno = -1;
		}
	}

	return;
}




/**
void  ExCmnHead::free(void)

OtBbNf[^J

ǗĂꍇ́CQƐ炷D
ǗĂȂꍇ́CIɊJD
*/
void  ExCmnHead::free(void)
{
	if (refno==NULL) {
		if (!isNull()) {
			free_CmnHead(this);
		}
	}
	else {
		mfree();
	}
	return;
}




/**
void  ExCmnHead::ffree(void)

OtBbNf[^IɊJ
*/
void  ExCmnHead::ffree(void)
{  
	if (refno==NULL) {
		if (!isNull()) {
			free_CmnHead(this);
		}
	}
	else {
		if (*refno>=0) {
			free_CmnHead(this);
			*refno = -1;
		}
	}

	return;
}






///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// ExCmnHead Iy[^
//

ExCmnHead  ExCmnHead::operator= (ExCmnHead& s)
{ 
	ExCmnHead dm = *this;
	
	kind  = s.kind;
	xsize = s.xsize;
	ysize = s.ysize;
	zsize = s.zsize;
	dbyte = s.dbyte;
	depth = s.depth;
	bsize = s.bsize;
	lsize = s.lsize;
	buf	  = s.buf;
	grptr = s.grptr;
	state = s.state;

	if (!s.isNull()) {							// Rs[̓f[^ĂD
		if (s.refno!=NULL) {						// Rs[͎QƕϐĂD
			if (*s.refno>=0) {						// ̎QƕϐgD
				refno = s.refno;
				(*refno)++;
			}
			else {
				DEBUG_MODE print_messageln("ExCmnHead::= (ExCmnHead): Rs[Qƕϐ̕s!!");
			}
		}
		else {										// Rs[͎QƕϐĂȂD
			if (refno!=NULL) {							// ̎QƕϐĂD
				if (*refno<=-1) *refno = 1;				// ̎QƕϐgpȂ炻gD
				else  refno = NULL;							// Qƕϐ͒NgĂ̂ŁC͎QƕϐɂȂD
			}	
		}
	}

	else {										// Rs[̓f[^ĂȂ
		grptr = NULL;
		if (s.refno!=NULL) {						// Rs[͎QƕϐĂD
			refno = s.refno;							// ̎QƕϐgD
			*refno = -1;								// f[^͖̂ -1 ɁD
		}										
		else {										// Rs[͎QƕϐĂȂD
			if (refno!=NULL) {							// ̎QƕϐĂD
				if (*refno<=-1) *refno = -1;			// ̎QƕϐgpȂ炻gD
				else refno = NULL;							// Qƕϐ͒NgĂ̂ŁC͎QƕϐɂȂD
			}
		}
	}

	if (!dm.isNull()) dm.free();
	return *this;
}




//
// 
//
ExCmnHead  ExCmnHead::operator= (CmnHead& s)
{ 
	if (!isNull()) free();

	kind  = s.kind;
	xsize = s.xsize;
	ysize = s.ysize;
	zsize = s.zsize;
	depth = s.depth;
	bsize = s.bsize;
	lsize = s.lsize;
	buf	  = s.buf;
	grptr = s.grptr;
	state = 0;
	dbyte = (depth+7)/8;

	if (s.grptr!=NULL) {						// Rs[̓f[^ĂD
		if (refno!=NULL) {							// ̎QƕϐĂD
			if (*refno<=-1) *refno =  1;			// ̎QƕϐgpȂ炻gD
			else  refno = NULL;							// Qƕϐ͒NgĂ̂ŁC͎QƕϐɂȂD
		}	
	}

	else {										// Rs[̓f[^ĂȂ
		grptr = NULL;
		if (refno!=NULL) {							// ̎QƕϐĂD
			if (*refno<=-1) *refno = -1;			// ̎QƕϐgpȂ炻gD
			else refno = NULL;							// Qƕϐ͒NgĂ̂ŁC͎QƕϐɂȂD
		}
	}

	return *this;
}




