
#ifndef __JBXL_STL_H_
#define __JBXL_STL_H_



/**
@brief    STL t@Co͗pCu wb_
@file     STL.h
@author   Fumi.Iseki (C)

@note
GfBAϊ
*/


#include  "Brep.h"



namespace jbxl {


/// f[^ǂݍݗpꎞf[^
typedef struct {
	unsigned char tmp[50]; 
} tmpSTLData;	// 50Byte



/// Op`f[^p
///   v[0] ` v[2] : @xNg
///   v[3] ` v[5] : P̒_ X,Y,ZW   
///   v[6] ` v[8] : Q̒_ X,Y,ZW   
///   v[9] ` v[11]: R̒_ X,Y,ZW   
typedef struct {
	float  vect[12];
	unsigned short pad; 
} STLData;		// 52Byte







DllExport STLData* ReadSTLFile (char* fname,  long int* fno);
DllExport int      WriteSTLFile(char* fname,  BREP_SOLID* solid, bool ascii=false);

DllExport STLData* ReadSTLFileA (char* fname, long int* fno);
DllExport STLData* ReadSTLFileB (char* fname, long int* fno);
DllExport int      WriteSTLFileA(char* fname, BREP_SOLID* solid);
DllExport int      WriteSTLFileB(char* fname, BREP_SOLID* solid);

DllExport void     println_FacetAsciiSTL(BREP_CONTOUR* contour);

DllExport void     freeSTL(STLData* stldata);



}		// namespace

#endif

