/* vi: set tabstop=4 nocindent noautoindent: */

/**  
@brief   IP Address Tool
@file    ipaddr_tool.c
@author  Fumi Iseki 
@date    2005 09/21
*/



#include "ipaddr_tool.h"




/**
tList*  read_ipaddr_file(char* fn)

t@C IPAhXǂݍŁC[IPAhX]/[lbg}XN]@̌`
ϊāCXgɊi[DFQDNIPAhXɕϊD@n
FQDNłȂhCC / Ȍ𖳎ĕ̂܂܃XgɊi[D

f[^̓ǂݎ莞Ɏ̏sȂD
- Ő,CR,LF͍폜
- s͖D
- # ȍ~͖D

@param  fn  t@C
@return Xgւ̃|C^
*/
tList*  read_ipaddr_file(char* fn)
{
	tList* lp;
	tList* lt;

	lp = read_tList_file(fn, 2);
	if (lp==NULL) return NULL;

	lt = to_ipaddress_list(lp);
	del_all_tList(&lp);

	return lt;
}




/**
tList*  read_ipaddr_fp(FILE* fp)

t@C IPAhXǂݍŁC[IPAhX]/[lbg}XN]@̌`
ϊāCXgɊi[DFQDNIPAhXɕϊD@n
FQDNłȂhCC / Ȍ𖳎ĕ̂܂܃XgɊi[D

f[^̓ǂݎ莞Ɏ̏sȂD
- Ő,CR,LF͍폜
- s͖D
- # Ŏn܂C܂ ()# Ŏn܂s͖D

@param  fp  t@C|C^
@return Xgւ̃|C^
*/
tList*  read_ipaddr_fp(FILE* fp)
{
	tList* lp;
	tList* lt;

	lp = read_tList_fp(fp, 1);
	if (lp==NULL) return NULL;

	lt = to_ipaddress_list(lp);
	del_all_tList(&lp);

	return lt;
}




/**
tList*  to_ipaddress_list(tList* lp)

Xg IPAhX [IPAhX]/[lbg}XN]@̌`
ϊāCVXgɊi[DFQDNIPAhXɕϊD@n
ϊ to_address_num8() gpDCIDERΉD

FQDNłȂhCC / Ȍ𖳎ĕ̂܂ VXgɊi[D
 is_host_in_list()ȂǂɍsȂ߂̑OD

@param  lp  ϊOit@CȂǂǂݍ񂾂܂܁j̃f[^̓Xg
@return ϊĐVXgD
*/
tList*  to_ipaddress_list(tList* lp)
{
	unsigned char* num;
	char*          addr;
	tList* ls = NULL;
	tList* lt = NULL;

	if (lp==NULL) return NULL;
	if (lp->ldat.key.buf==NULL) return NULL;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			if ((lp->ldat.key.buf)[0]!='#') {
				num = to_address_num8((char*)lp->ldat.key.buf, 1);
				if (num!=NULL) {
					addr = to_address_char8(num);
					free(num);
					if (addr!=NULL) {
						ls = add_tList_node_str(ls, addr, NULL);
						free(addr);
					}	//  addr==NULL ƂȂꍇ̓ŝ
				}
				else {
					addr = awk((char*)lp->ldat.key.buf, '/', 1);
					if (addr!=NULL) {
						int i = 0;
						while(addr[i]!='\0' && addr[i]!=',' && addr[i]!=' ') i++;
						addr[i] = '\0';
						ls = add_tList_node_str(ls, addr, NULL);
						free(addr);
					}
				}
				if (lt==NULL) lt = ls;
			}
		}
		lp = lp->next;
	}
	
	return lt;
}




/**
int  is_host_in_list(tList* lp, unsigned char* num, char* hname)

Xglp L[Ɋi[Ă zXg num, hname lbg[Nɑ邩
ǂ`FbNDnum  hname ͂ǂ炩w肳ĂΏ\łD

悸Clp̃L[iFQDNj hname rD܂CL[hC̈ꕔ̏ꍇ 
hnameƔrivjD@n
ɁClp̃L[hCłȂꍇiIPAhX̏ꍇj num ƔrD
	
@param  lp     `FbNIPAhXij̊i[Ă郊XgD
@param  num    rIPAhXi1byte unsigned ^j4ByteD
               8Byte^(addr/mask)ł쓮邪Clbg}XN͂D
@param  hname  rzXgijDʏ numtꂽ́D

@retval TRUE   Xgɓlbg[NɑGg݂D
@retval FALSE  Xgɓlbg[NɑGg݂͑ȂD
*/
int  is_host_in_list(tList* lp, unsigned char* num, char* hname)
{
	unsigned char* addr;

	if (lp==NULL) return FALSE;
	if (lp->ldat.key.buf==NULL) return FALSE;
	if (hname==NULL && num==NULL) return FALSE;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 0);
			if (addr==NULL && hname!=NULL) {
				if (!strnrvscmp((const char*)lp->ldat.key.buf, hname, (int)strlen((const char*)lp->ldat.key.buf))) return TRUE;
			}
			else if(addr!=NULL && num!=NULL) {
				if (is_same_network_num(addr, num, &(addr[4]))) return TRUE;
			}
		}
		lp = lp->next;
	}
	
	return FALSE;
}




/**
int  is_ipaddr_num_in_list(tList* lp, unsigned char* num)

Xglp L[Ɋi[Ă zXg num lbg[Nɑ邩ǂ`FbND@n
Xg̃L[FQDNłĂ`FbN\D

@param  lp    `FbNIPAhXij̊i[Ă郊XgD
@param  num   rIPAhXioCij4ByteD
              8Byte^(addr/mask)ł쓮邪Clbg}XN͖D

@retval TRUE  Xgɓlbg[NɑGg݂D
@retval FALSE Xgɓlbg[NɑGg݂͑ȂD
*/
int  is_ipaddr_num_in_list(tList* lp, unsigned char* num)
{
	unsigned char* addr;

	if (lp==NULL || num==NULL) return FALSE;
	if (lp->ldat.key.buf==NULL) return FALSE;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 1);
			if (addr!=NULL) {
				if (is_same_network_num(num, addr, &(addr[4]))) return TRUE;
			}
		}
		lp = lp->next;
	}
	
	return FALSE;
}




/**
void  print_address_in_list(FILE* fp, tList* lp)

Xg̃hCC܂IPAhX\D
FQDNIPAhXɕϊĕ\D

@param  fp  o͐̃t@CLqq
@param  lp  hC܂IPAhXL[Ɋi[Xgւ̃|C^
*/
void  print_address_in_list(FILE* fp, tList* lp)
{
	unsigned char* addr;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 1);
			if (addr!=NULL) {	
				fprintf(fp, "[%d.%d.%d.%d/%d.%d.%d.%d]\n", addr[0],addr[1],addr[2],addr[3],addr[4],addr[5],addr[6],addr[7]);
			}
			else { 		// 炭hC
				fprintf(fp, "[%s]\n", lp->ldat.key.buf);
			}
		}
		lp = lp->next;
	}
	return;
}



