/* vi: set tabstop=4 nocindent noautoindent: */


/** 
@brief   Tiny List \Cu
@file    tlist.c
@version 
@author  Fumi.Iseki (C)
@date    2008 2/1
@see     _tList
*/



#include  "tlist.h"




/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// List Data
//
//     ÓIɐD 
//

/**
tList_data  init_tListdata(void)

̃m[hf[^ÓIɍ쐬Df[^̂ɎgpD

@return ꂽm[hf[^D
*/
tList_data  init_tListdata(void)
{
	tList_data pp;

	memset(&pp, 0, sizeof(tList_data));
	return pp;
}




/**
tList_data  make_tListdata(int id, int lv, Buffer key, Buffer val, void* ptr, int sz)

f[^w肵ăm[hf[^쐬@n
sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

@param  id   m[hID
@param  lv   m[h̃f[^
@param  key  m[h̃L[   (Buffer)  
@param  val  m[h̃f[^ (Buffer)  
@param  ptr  ėpf[^ւ̃|C^   
@param  sz   *ptr ̃TCY

@return ꂽm[hf[^D
*/
tList_data  make_tListdata(int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	tList_data pp;

	memset(&pp, 0, sizeof(tList_data));

	pp.id  = id;
	pp.lv  = lv;
	pp.sz  = sz;
	pp.key = dup_Buffer(key);	
	pp.val = dup_Buffer(val);

	if (sz>0) {
		pp.ptr = (void*)malloc(sz);
		if (pp.ptr!=NULL) {
			if (ptr!=NULL) memcpy(pp.ptr, ptr, sz);
			else           memset(pp.ptr, 0,   sz);
		}
	}
	
	return pp;
}




/**
tList_data  make_tListdata_bystr(int id, int lv, const char* key, const char* val, void* ptr, int sz)

f[^w肵ăm[hf[^쐬@n
sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

@param  id   m[hID
@param  lv   m[h̃f[^
@param  key  m[h̃L[            
@param  val  m[h̃f[^          
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY

@return ꂽm[hf[^D
*/
tList_data  make_tListdata_bystr(int id, int lv, const char* key, const char* val, void* ptr, int sz)
{
	tList_data pp;
	
	memset(&pp, 0, sizeof(tList_data));

	pp.id  = id;
	pp.lv  = lv;
	pp.sz  = sz;
	pp.key = make_Buffer_bystr(key);	// key==NULLȂ init_Buffer()
	pp.val = make_Buffer_bystr(val);

	if (sz>0) {
		pp.ptr = (void*)malloc(sz);
		if (pp.ptr!=NULL) {
			if (ptr!=NULL) memcpy(pp.ptr, ptr, sz);
			else           memset(pp.ptr, 0,   sz);
		}
	}

	return pp;
}




/**
void  free_tListdata(tList_data* ldat)

m[hf[^̃obt@NADf[^g͍폜ȂD

@param  ldat  NAm[hf[^
*/
void  free_tListdata(tList_data* ldat)
{
	if (ldat==NULL) return;

	ldat->id = 0;
	ldat->lv = 0;
	ldat->sz = 0;

	free_Buffer(&(ldat->key));	
	free_Buffer(&(ldat->val));
	if (ldat->ptr!=NULL) free(ldat->ptr);
	del_all_tList(&(ldat->lst));

	ldat->key = init_Buffer();
	ldat->val = init_Buffer();
	ldat->ptr = NULL;
	ldat->lst = NULL;

	return;
}




/**
tListdata  dup_tListdata(tList_data ldat)

m[hf[^̕쐬D@n
ldat.sz ɂ͐m ldat.ptr̃TCYݒ肳ĂKvD

@param  ldat  m[hf[^
@return m[hf[^ւ̃|C^D
*/
tList_data  dup_tListdata(tList_data ldat)
{
	tList_data dup;	

	memcpy(&dup, &ldat, sizeof(tList_data));
	dup.key = dup_Buffer(ldat.key);
	dup.val = dup_Buffer(ldat.val);
	if (ldat.ptr!=NULL && ldat.sz>0) {
		dup.ptr = (void*)malloc(ldat.sz);
		if (dup.ptr!=NULL) memcpy(dup.ptr, ldat.ptr, ldat.sz);
	}
	dup.lst = dup_tList(ldat.lst);
	
	return dup;
}





/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny List
//

/**
tList*  new_tList_node(void)

Xgp̋m[h𓮓IɐD

@return ꂽm[hւ̃|C^D
*/
tList*  new_tList_node(void)
{
	tList* pp;

	pp = (tList*)malloc(sizeof(tList));
	if (pp==NULL) return NULL;
	memset(pp, 0, sizeof(tList));
	pp->ldat = init_tListdata();

	return pp;
}




/**
tList   make_tList_node(tList_data ldat)

Xgpm[hÓIɐD@n
ldat ͂̂܂ܐVϐŎgpDiPɑj

̊֐Őm[h del_*_tList()֐ō폜Ă͂ȂD

@param  ldat  m[hf[^
@return ꂽm[hD
*/
tList   make_tList_node(tList_data ldat)
{
	tList pp;

	memset(&pp, 0, sizeof(tList));
	pp.ldat = ldat;	

	return pp;
}




/**
tList*  add_tList_node_bydata(tList* pp, tList_data ldat) 

f[^(ldat)烊Xgpm[ho(new),w肵XǧɒǉD@n

Xg|C^ ppwm[ȟɂo m[h}D
ldat ͎w肳ꂽ̂̂܂܎gpD

@param  pp    ǉꏊ̎Õm[hւ̃|C^D
@param  ldat  ǉm[hf[^D̃f[^̂܂܎gpD
		   
@return ǉm[hւ̃|C^D
*/
tList*  add_tList_node_bydata(tList* pp, tList_data ldat) 
{
	tList* pt;

	pt = new_tList_node();
	pt->ldat = ldat;

	if (pp==NULL) return pt;

	pt->next = pp->next;
	pt->prev = pp;
	pp->next = pt;
	if (pt->next!=NULL) (pt->next)->prev = pt;	

	return pt;
}




/**
tList*  add_tList_node_bystr(tList* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz) 

f[^烊Xgpm[ho(new),XgɒǉD

Xg|C^ ppwm[ȟɂo m[h}D
sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

@param  pp   ǉꏊ̎Õm[hւ̃|C^D
@param  id   ǉf[^D
@param  lv   ǉf[^D
@param  key  ǉf[^D        
@param  val  ǉf[^D        
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY
		   
@return ǉm[hւ̃|C^D
*/
tList*  add_tList_node_bystr(tList* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz) 
{
	tList* pt;
	tList_data ldat;

	ldat = make_tListdata_bystr(id, lv, key, val, ptr, sz);
	pt   = add_tList_node_bydata(pp, ldat);

	return pt;
}




/**
tList*  add_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 

f[^烊Xgpm[ho(new),XgɒǉD

Xg|C^ ppwm[ȟɂo m[h}D
sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

@param  pp    ǉꏊ̎Õm[hւ̃|C^D
@param  id    ǉf[^D
@param  lv    ǉf[^D
@param  key   ǉf[^D        
@param  val   ǉf[^D        
@param  *ptr  ėpf[^ւ̃|C^  
@param  sz    *ptr ̃TCY
		   
@return ǉm[hւ̃|C^D
*/
tList*  add_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 
{
	tList* pt;
	tList_data ldat;

	ldat = make_tListdata(id, lv, key, val, ptr, sz);
	pt   = add_tList_node_bydata(pp, ldat);

	return pt;
}




/**	
void   free_tList_node(tList** node)

Xgpm[h̃obt@(f[^)̊JD
*node ɂ NULLD

@param[in]  *node  Jm[hւ̃|C^D
@param[out] *node  NULL
*/
void   free_tList_node(tList** node)
{
	if (node==NULL || *node==NULL) return;

	free_tListdata(&((*node)->ldat));
	free(*node);
	*node = NULL;

	return;
}	




/**	
tList*  del_tList_node(tList* node) 

Xgp̃m[h폜D
Xg|C^ nodewm[h폜,Xg\l߂D

@param  node  폜m[hւ̃|C^D
@return 폜m[h̒̃m[hւ̃|C^D
*/
tList*  del_tList_node(tList* node) 
{	
	tList* pp = NULL;

	if (node==NULL) return NULL;

	free_tListdata(&(node->ldat));

	if (node->prev!=NULL) node->prev->next = node->next;
	if (node->next!=NULL) {
		node->next->prev = node->prev;
		pp = node->next;
	}
	free(node);

	return pp;
}




/**
tList*  dup_tList_node(tList* node)

m[h𕡐 (new)Dm[h̃|C^͕ȂD

*/			 
tList*  dup_tList_node(tList* node)
{
	tList* pp;
	int	sz;

	if (node==NULL) return NULL;

	sz = sizeof(tList);
	pp = (tList*)malloc(sz);
	if (pp==NULL) return NULL;

	memcpy(pp, node, sz);
	pp->ldat = dup_tListdata(node->ldat);
	pp->next = NULL;
	pp->prev = NULL;
	pp->altp = NULL;
	pp->back = NULL;
	pp->esis = NULL;
	pp->ysis = NULL;

	return pp;
}




/**
tList*  move_tList_node(tList* pp, tList* node)

nodẽ݂Xg؂藣CppֈړD@n
node폜Ȃ del_tList_node(), add_tList_node() s悤Ȃ́D

@param  pp    ړŐeƂȂm[hւ̃|C^D
@param  node  ړm[hւ̃|C^D
@return ړm[hm[hւ̃|C^D
*/
tList*  move_tList_node(tList* pp, tList* node)
{
	if (pp==NULL || node==NULL) return NULL;
    
	if (node->prev!=NULL) node->prev->next = node->next;
	if (node->next!=NULL) node->next->prev = node->prev;

	node->prev = pp;
	node->next = pp->next;
	if (pp->next!=NULL) pp->next->prev = node;
	pp->next   = node;
	
	return node;
}




/**
void	set_tList_node_bydata(tList* node, tList_data dat)

Xg̃m[hɒlݒ肷D@n
ldat ͎w肳ꂽ̂̂܂܎gpD

@param  node  ݒ肷m[hւ̃|C^D
@param  dat   ݒ肷m[hf[^D̃f[^̂܂܎gpD
*/
void	set_tList_node_bydata(tList* node, tList_data dat)
{
	if (node==NULL) return;

	free_tListdata(&(node->ldat));
	node->ldat = dat;
}




/**
void	set_tList_node_bystr(tList* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz)

Xg̃m[hɒlݒ肷Dꂼ̃f[^͕Đݒ肳D@n
key, val NULL̏ꍇ́C̒l̓m[h͐ݒ肳ȂD

@param  pp   m[hlݒ肷m[hւ̃|C^
@param  id   m[hID
@param  lv   m[h̃f[^
@param  key  m[h̃L[            
@param  val  m[h̃f[^          
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY
*/
void	set_tList_node_bystr(tList* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz)
{
	if (pp==NULL) return;

	pp->ldat.id = id;
	pp->ldat.lv = lv;
	pp->ldat.sz = sz;

	if (key!=NULL) {
		free_Buffer(&(pp->ldat.key));
		pp->ldat.key = make_Buffer_bystr(key);
	}
	if (val!=NULL) {
		free_Buffer(&(pp->ldat.val));
		pp->ldat.val = make_Buffer_bystr(val);
	}

	if (sz>0 && ptr!=NULL) {
		if (pp->ldat.ptr!=NULL) free(pp->ldat.ptr);
		pp->ldat.ptr = (void*)malloc(sz);
		if (pp->ldat.ptr!=NULL) memcpy(pp->ldat.ptr, ptr, sz);
	}
}




/**
void	set_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)

Xg̃m[hɒlݒ肷Dꂼ̃f[^͕Đݒ肳D@n
key.buf, val.buf NULL̏ꍇ́C̒l̓m[hɂ͐ݒ肳ȂD

@param  pp   m[hlݒ肷m[hւ̃|C^
@param  id   m[hID
@param  lv   m[h̃f[^
@param  key  m[h̃L[   (Buffer) 
@param  val  m[h̃f[^ (Buffer) 
@param  ptr  ėpf[^ւ̃|C^  
@param  sz   *ptr ̃TCY
*/
void	set_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	if (pp==NULL) return;

	pp->ldat.id = id;
	pp->ldat.lv = lv;

	if (pp->ldat.key.buf!=NULL) {
		free_Buffer(&(pp->ldat.key));
		pp->ldat.key = dup_Buffer(key);
	}

	if (pp->ldat.val.buf!=NULL) {
		free_Buffer(&(pp->ldat.val));
		pp->ldat.val = dup_Buffer(val);
	}

	if (sz>0 && ptr!=NULL) {
		if (pp->ldat.ptr!=NULL) free(pp->ldat.ptr);
		pp->ldat.ptr = (void*)malloc(sz);
		if (pp->ldat.ptr!=NULL) memcpy(pp->ldat.ptr, ptr, sz);
	}
}




/**
tList*	update_tList_node(tList* pp, tList* pt)

pp pt->keyŌCYm[h΃m[hRs[D΍ŌɃm[hǉ(new)D

@param  pp  Jnm[hւ̃|C^D
@param  pt  ݒ肷m[hւ̃|C^DL[ pt->key
@return ݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node(tList* pp, tList* pt)
{
	tList* pm;
	tList_data ldat;

	if (pt==NULL) return pp;
	
	ldat = pp->ldat;
	pm = update_tList_node_byBuffer(pp, ldat.id, ldat.lv, ldat.key, ldat.val, ldat.ptr, ldat.sz);
	
	return pm;
}




/**
tList*	update_tList_node_bydata(tList* pp, char* srch, tList_data ldat)

pp srchŌCYm[h΃m[hݒ肷D΍ŌɃm[hǉ(new)D@n
ldat ͎w肳ꂽ̂̂܂܎gpD

@param  pp    Jnm[hւ̃|C^D
@param  srch  L[
@param  ldat  ǉm[hf[^D̃f[^̂܂܎gpD

@return ݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node_bydata(tList* pp, char* srch, tList_data ldat)
{
	tList* pm = NULL;

	if (pp==NULL || srch==NULL) return NULL;

	pm = strncmp_tList(pp, srch, 0, 1);
	if (pm!=NULL) set_tList_node_bydata(pm, ldat);
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_bydata(pm, ldat);
	}
	
	return pm;
}




/**
tList*	update_tList_node_bystr(tList* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz)

pp keyŌCYm[h΃m[hݒ肷D΍ŌɃm[hǉ(new)D@n
ꂼ̃f[^͕D

@param  pp   Jnm[hւ̃|C^D
@param  id   m[hID
@param  lv   m[h̃f[^
@param  key  m[h̃L[DL[	  
@param  val  m[h̃f[^ (Buffer)  
@param  ptr  ėpf[^ւ̃|C^	  
@param  sz   *ptr ̃TCY

@return ݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node_bystr(tList* pp, int id, int lv, const char* key, const char* val, void* ptr, int sz)
{
	tList* pm = NULL;

	if (pp==NULL || key==NULL) return NULL;

	pm = strncmp_tList(pp, key, 0, 1);
	if (pm!=NULL) {
		set_tList_node_bystr(pm, id, lv, NULL, val, ptr, sz);
	}
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_bystr(pm, id, lv, key, val, ptr, sz);
	}
	
	return pm;
}




/**
tList*	update_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)

pp key.bufŌCYm[h΃m[hݒ肷D΍ŌɃm[hǉ(new)D@n
ꂼ̃f[^͕D

@param  pp   Jnm[hւ̃|C^D
@param  id   m[hID
@param  lv   m[h̃f[^
@param  key  m[h̃L[   (Buffer)  
@param  val  m[h̃f[^ (Buffer)  
@param  ptr  ėpf[^ւ̃|C^	  
@param  sz   *ptr ̃TCY

@return ݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	tList* pm = NULL;

	if (pp==NULL || key.buf==NULL) return NULL;

	pm = strncmp_tList(pp, (char*)key.buf, 0, 1);
	if (pm!=NULL) set_tList_node_byBuffer(pm, id, lv, key, val, ptr, sz);
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_byBuffer(pm, id, lv, key, val, ptr, sz);
	}
	
	return pm;
}






/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// tiny List
//

/**	
tList*  del_tList(tList** pp) 

Xgp̎w肵m[hȍ~̃m[h폜D

@param[in]  *pp  폜m[hւ̃|C^D
@param[out] *pp  NULL

@return 폜m[h(s)̒Õm[hւ̃|C^D
*/
tList*  del_tList(tList** pp) 
{	
	tList* pt;
	tList* pm;
	tList* pw;

	if (pp==NULL || *pp==NULL) return NULL;

	pt = (*pp)->prev;
	if (pt!=NULL) pt->next = NULL;

	pm = *pp;
	while (pm!=NULL) {
		pw = pm;
		pm = pm->next;
   		free_tListdata(&(pw->ldat));
		free(pw);
	}
	*pp = NULL;

	return pt;
}




/**
void  del_all_tList(tList** pp)

Xg̑Sm[h̍폜D|C^ pp̃m[h܂ރXgŜ폜D@n
pp ͂Xgł΁CǂwĂĂǂD

@param[in]  *pp  폜Jnm[hւ̃|C^D
@param[out] *pp  NULL
*/
void  del_all_tList(tList** pp)
{
	tList* pm;
	tList* pv;

	if (pp==NULL || *pp==NULL) return;

	pm = *pp;
	pv = (*pp)->prev;

	do {
		pm = del_tList_node(pm);
	} while (pm!=NULL);

	pm = pv;
	while (pm!=NULL) {
		pv = pm->prev;
		del_tList_node(pm);
		pm = pv;
	}

	*pp = NULL;
}




/**	 
int  del_tList_key(tList* pl, const char* key, int no)
		
plT[`āCnoԖڂ keỹm[h폜D
		
@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ijD啶CʂȂD	
@param  no   v̒ŉԖڂ̕폜邩w肷D1琔D0̏ꍇ͑Sč폜D
		
@return 폜m[h̐D
*/	  
int  del_tList_key(tList** pl, const char* key, int no)
{	   
	int dl = 0;
	int nn = 0;
	if (no<0) no = 0;

	tList* pp = *pl;

	while (pp!=NULL) {
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, key, 0)) {
			nn++;
			if (no==0 || no==nn) {
				if (pp->prev==NULL) *pl = pp->next;
				pp = del_tList_node(pp);	
				dl++;
				if (no!=0) break;
			}
			else {
				pp = pp->next;
			}
		}
		else {
			pp = pp->next;
		}
	}

	return dl;
}




/**
tList*  dup_tList(tList* pp)

Xg𕡐D

@param  pp  ̃Xgւ̃|C^D
@return ꂽXgւ̃|C^D
*/			 
tList*  dup_tList(tList* pp)
{
	tList* pt;
	tList* pl;
	tList* tt;

	if (pp==NULL) return NULL;

	pt = pl = dup_tList_node(pp);
	pp = pp->next;

	while(pp!=NULL) {
		tt = dup_tList_node(pp);
		pl = insert_tList(pl, tt);
		pp = pp->next;
	}

	return pt;
}




/**
tList*  add_tList(tList* pp, tList* pt)

Xgpp̍Ō XgptǉD

@param  pp  擪̃Xgւ̃|C^
@param  pt  ǉ郊Xgւ̃|C^
@return Xg̐擪ւ̃|C^

@code 
pp->1->2->3, pt->4->5 => pp->1->2->3->pt->4->5 
@endcode
*/

tList*  add_tList_end(tList* pp, tList* pt)
{
	if (pt==NULL) return pp;
	if (pp==NULL) return pt;

	tList* pe = find_tList_end(pp);
	pe->next = pt;
	pt->prev = pe;

	return pp;
}




/**
tList*  insert_tList(tList* pp, tList* pt)

m[hpp̒ pt}D
	
@param  pp  擪̃Xgւ̃|C^
@param  pt  }郊Xgւ̃|C^
@return }擪̃Xgւ̃AhXD

@code
pp->1->2->3, pt->4->5 => pp->pt->4->5->1->2->3
@endcode
*/
tList*  insert_tList(tList* pp, tList* pt)
{
	tList* pe;
	
	if (pt==NULL) return pp;
	if (pp==NULL) return pt;

	pe = find_tList_end(pt);
	if (pp->next!=NULL) pp->next->prev = pe;
	pe->next = pp->next;
	pp->next = pt;
	pt->prev = pp;
	
	return pt;
}




/**
void  print_tList(File* fp, tList* pp)

Xg̕\D|C^ ppȍ~̑SẴm[h̃L[̃obt@WG[o͂ɕ\D

@param  fp  o͂t@Cւ̃|C^DNULL̏ꍇ stderr
@param  pp  \Jnm[hւ̃|C^D
*/
void  print_tList(FILE* fp, tList* pp)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp!=NULL) {
			tList_data ld = pp->ldat;
			fprintf(fp, "[%d] [%d] [%s] [%s]\n", ld.id, ld.lv, ld.key.buf, ld.val.buf);
			//if (pp->next!=NULL) print_tList(pp->next);
			pp = pp->next;
		}
	}
	else {
		fprintf(fp, "(List is NULL)\n");
	}
	return;
}




void  dump_tList(FILE* fp, tList* pp)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp!=NULL) {
			tList_data ld = pp->ldat;
			fprintf(fp, "[%d] [%d] [%s] [%d]\n", ld.id, ld.lv, ld.key.buf, ld.val.vldsz);
			fdump(fp, (unsigned char*)ld.val.buf, ld.val.vldsz);
			pp = pp->next;
		}
	}
	else {
		fprintf(fp, "(List is NULL)\n");
	}
	return;
}




/**
int  count_tList(tList* pp)

Xg ppm[hȍ~̃m[h̐𐔂D

@param  pp  n߂m[hւ̃|C^D
@return m[h̐D
*/
int  count_tList(tList* pp)
{
	int cnt = 0;

	while (pp!=NULL) {
		cnt++;
		pp = pp->next;
	}	
	return cnt;
}






///////////////////////////////////////////////////////////////////////////////////////////
//
// String Compare
//

/**
tList*  strncmp_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂm[h̃T[`D

|C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strncmp_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncmp((char*)pl->ldat.key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strncasecmp_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂm[h̃T[`D啶𖳎D

|C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strncasecmp_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncasecmp((char*)(pl->ldat).key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}




/**
tList*  strnrvscmp_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂm[h̃T[`DׂD

|C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strnrvscmp_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strnrvscmp((char*)(pl->ldat).key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strncaservscmp_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂm[h̃T[`DׂD啶𖳎D

|C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strncaservscmp_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncaservscmp((char*)(pl->ldat).key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}




/**
tList*  strstr_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂm[h̕T[`D

|C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂m[h̓C
noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[D
@param  len  0ȏ: key  pl̃L[Ɋ܂܂邩ǂD
@param  len  :  pl̃L[ KeyɊ܂܂邩ǂD
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strstr_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (len>=0) {
			if (strstr((char*)(pl->ldat).key.buf, key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstr(key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->next;
	}
	return NULL;
}




/**
tList*  strstrcase_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂm[h̕T[`D啶𖳎D

|C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂m[h̓C
noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[D
@param  len  0ȏ: key  pl̃L[Ɋ܂܂邩ǂD
@param  len  :  pl̃L[ KeyɊ܂܂邩ǂD
@param  no   v̒ŉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strstrcase_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (len>=0) {
			if (strstrcase((char*)(pl->ldat).key.buf, key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstrcase(key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->next;
	}
	return NULL;
}




///////////////////////////////////////////////////////////////////////////////////////////
//
// String Compare Back List
//

/**
tList*  strncmp_back_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂ̃m[h̃T[`D

|C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
납琔 noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒Ō납琔ĉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strncmp_back_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);
	
	while (pl!=NULL) {
		if (ex_strncmp((char*)(pl->ldat).key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}




/**
tList*  strncasecmp_back_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂ̃m[h̃T[`D啶𖳎D

|C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
납琔 noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒Ō납琔ĉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strncasecmp_back_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strncasecmp((char*)(pl->ldat).key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}




/**
tList*  strnrvscmp_back_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂ̃m[h̃T[`D납ׂD

|C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
납琔 noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒Ō납琔ĉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strnrvscmp_back_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strnrvscmp((char*)(pl->ldat).key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}




/**
tList*  strncaservscmp_back_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂ̃m[h̃T[`D납ׂD啶𖳎D

|C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
납琔 noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[ij
@param  len  1ȏ: v钷D
@param  len  @b TLIST_MATCH_COMPLETE   (0): SvD
@param  len  @b TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
@param  len  @b TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
@param  no   v̒Ō납琔ĉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strncaservscmp_back_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strncaservscmp((char*)(pl->ldat).key.buf, key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}




/**
tList*  strstr_back_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂ̃m[h̕T[`D

|C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂
m[h̓C납琔 noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[D
@param  len  0ȏ: key  pl̃L[Ɋ܂܂邩ǂD
@param  len  :  pl̃L[ KeyɊ܂܂邩ǂD
@param  no   v̒Ō납琔ĉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strstr_back_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (len>=0) {
			if (strstr((char*)(pl->ldat).key.buf, key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstr(key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->prev;
	}
	return NULL;
}




/**
tList*  strstrcase_back_tList(tList* pl, const char* key, int len, int no)

char*^ϐɂ̃m[h̕T[`D啶𖳎D

|C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂
m[h̓C납琔 noԖڂɂ̂{oD

@param  pl   T[`Jnm[hւ̃|C^D
@param  key  T[`L[D
@param  len  0ȏ: key  pl̃L[Ɋ܂܂邩ǂD
@param  len  :  pl̃L[ KeyɊ܂܂邩ǂD
@param  no   v̒Ō납琔ĉԖڂ̕Ԃw肷D1琔D

@return vm[hւ̃|C^
@retval NULL v̂
*/
tList*  strstrcase_back_tList(tList* pl, const char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (len>=0) {
			if (strstrcase((char*)(pl->ldat).key.buf, key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstrcase(key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->prev;
	}
	return NULL;
}







///////////////////////////////////////////////////////////////////////////////////////////

/**
tList*  find_tList_top(tList* pl)

Xg̍ŏ̃m[hւTD

@param  pl  T[`Jnm[hւ̃|C^D
@return Xg̍ŏ̃m[hւ̃|C^D
*/
tList*  find_tList_top(tList* pl)
{
	if (pl==NULL) return NULL;

	while (pl->prev!=NULL) pl = pl->prev;
	return pl;
}





/**
tList*  find_tList_end(tList* pl)

Xg̍Ō̃m[hւTD

@attention
Xg\̍Ō̃m[hT֐Ȃ̂ŁCtTree \ɓKpĂm[h邱Ƃ͏oȂD@n
tTreeɑ΂Ă find_tTree_end()gƁD

@param  pl  T[`Jnm[hւ̃|C^D
@return Xg̍Ō̃m[hւ̃|C^D
*/
tList*  find_tList_end(tList* pl)
{
	if (pl==NULL) return NULL;

	while (pl->next!=NULL) pl = pl->next;
	return pl;
}




/**
Buffer  search_key_tList(tList* list, const char* key, int no) 

Xg̒ noԖڂ keym[h(ldat.key)ToCldat.val̃Rs[ԂD
key ̓P[XCZVeBuD

@param  list  sXgւ̃|C^D
@param  key   wb_ʁD啶CʂȂD
@param  no    Ԗڂ̃m[how肷D1琔D

@return ldat.val f[^̃Rs[D
*/
Buffer  search_key_tList(tList* list, const char* key, int no) 
{
	tList* pp;
	Buffer buf;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;
	
	pp = strncasecmp_tList(list, key, 0, no);		// Sv
	if (pp!=NULL) {
		buf = dup_Buffer(pp->ldat.val);
	}
	
	return buf;
}




/**
Buffer  search_key_value_tList(tList* list, const char* key, char* data, int no) 

Xg̒ noԖڂ keym[hToCdata Ŏn܂m[hlԂD
key, data̓P[XCZVeBuD

@param  list  sXgւ̃|C^D
@param  key   wb_ʁD 啶CʂȂD
@param  data  wb_l̍ŏ̕D
@param  no    Ԗڂ̃m[how肷D1琔D

@return m[hl̊i[ꂽ Buffer^ϐD
*/
Buffer  search_key_value_tList(tList* list, const char* key, char* data, int no) 
{
	tList* pp;
	Buffer buf;
	char*  str;
	int	   len;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;

	if (data==NULL) {
		buf = search_key_tList(list, key, no);
		return buf;
	}

	buf = init_Buffer();
	len = (int)strlen(data); 
	
	pp = strncasecmp_tList(list, key, 0, no);
	if (pp!=NULL) {
		str = (char*)pp->ldat.val.buf;
		if (str!=NULL && !strncasecmp(str, data, len)) {
			buf = make_Buffer_bystr(str);
			return buf;
		}
	}

	return buf;
}



/*
int   set_value_tList(tList* list, const char* key, int no, const char* value, int add_mode)

Xg(lt) noԖڂ keym[h̒l valueݒ肷D

no  0ȉ̏ꍇ́CSĂ keym[h̒lɑ΂Đݒ肪sD
keym[h݂C mode==ON ̏ꍇ́CXg̍ŌɒǉD

@param  list    Ώۂ̃Xg
@param  key     ݒsm[h̃L[D啶CʂȂD
@param  value   ݒ肳镶D
@param  no      keyv鉽ڂ̃m[hɑ΂ĐݒsD1琔D0ȉ̏ꍇkeyv邷ׂẴm[hɑ΂ĐݒsD
@param  add_mod ̒lON w肵m[hꍇCm[hXg̍ŌɒǉD

@retval ݒ肳ꂽm[h̐ w肳ꂽm[h݂Ȃꍇ́iǉꂽꍇj0
@retval     G[

*/
int   set_value_tList(tList* list, const char* key, int no, const char* value, int add_mode)
{
	int    cn = 0;
	tList* pm;

	if (list==NULL || key==NULL || value==NULL) return -1;

	if (no>0) {
		pm = strncasecmp_tList(list, key, 0, no);
		if (pm!=NULL) {
			int rep = set_value_tList_node(pm, value);
			if (rep) cn = 1;
		}
	}
	else {		// no<=0
		int nn = 1;
		cn = 0;
		pm = strncasecmp_tList(list, key, 0, nn);
		while (pm!=NULL) {
			int rep = set_value_tList_node(pm, value);
			if (rep) cn++;
			pm = strncasecmp_tList(list, key, 0, ++nn);
		}
	}

	// Not Found
	if (add_mode==ON && cn==0) {
		add_tList_node_str(list, key, value);
	}

	return cn;
}


int   set_value_tList_node(tList* lp, const char* value)
{
	if (lp==NULL || value==NULL) return FALSE;
	
	Buffer buf = make_Buffer_bystr(value);
	free_Buffer(&lp->ldat.val);
	lp->ldat.val = buf;

	return TRUE;
}



/**
int	 replace_value_tList(tList* list, const char* key, int no, const char* srcval, char* value)

Xg(lt) noԖڂ keym[h̒l srcval̕ value ɒuD

no  0ȉ̏ꍇ́CSĂ keym[h̒lɑ΂ĒusD

@param  list   Ώۂ̃Xg
@param  key    usm[h̃L[D啶CʂȂD
@param  srcval uΏۂ̕DNULLȂw肵ڂ̕ŚD
@param  value  usD
@param  no     ڂ̃m[hu邩D1琔D0ȉ̏ꍇkeyvSẴm[hu

@retval ݒ肳ꂽm[h̐ w肳ꂽm[h݂Ȃꍇ́iǉꂽꍇj0
@retval    G[

*/
int	 replace_value_tList(tList* list, const char* key, int no, const char* srcval, char* value)
{
	int	cn = 0;
	tList* pm;

	if (list==NULL || key==NULL || value==NULL) return -1;
	if (srcval==NULL) {
		return set_value_tList(list, key, no, value, OFF);
	}

	if (no>0) {
		pm = strncasecmp_tList(list, key, 0, no);
		if (pm!=NULL) {
			int rep = replace_value_tList_node(pm, srcval, value);
			if (rep) cn = 1;
		}
	}
	else {	  // no<=0
		int nn = 1;
		cn = 0;
		pm = strncasecmp_tList(list, key, 0, nn);
		while (pm!=NULL) {
			int rep = replace_value_tList_node(pm, srcval, value);
			if (rep) cn++;
			pm = strncasecmp_tList(list, key, 0, ++nn);
		}
	}
	
	return cn;
}



int	 replace_value_tList_node(tList* lp, const char* srcval, const char* value)
{
	if (lp==NULL || value==NULL) return FALSE;
	if (srcval==NULL) {
		return set_value_tList_node(lp, value);
	}

	Buffer buf = replace_sBuffer(lp->ldat.val, srcval, value);
	free_Buffer(&lp->ldat.val);
	lp->ldat.val = buf;
	
	return TRUE;
}
	


/**
tList*	awk_tList(char* str, char cc)

؂蕶ŋ؂āCeڂXg̃L[ɓĕԂD@n
ڂ݂ȂꍇłXg͕ԂiL[ buf NULLjD

@param  str  镶
@param  cc   ڂ̋؂蕶
@return ڂL[ɓꂽXgDڂ݂ȂꍇłXg͕ԂD
@see cawk_tList
*/
tList*	awk_tList(char* str, char cc)
{
	int    nn = 1;
	char*  item;
	tList* lp = NULL;

	if (str==NULL) return NULL;

	lp = add_tList_node_bystr(NULL, 1, 0, NULL, NULL, NULL, 0);

	// first item
	item = awk(str, cc, nn);
	if (item==NULL) return lp;
	lp->ldat.key = make_Buffer_bystr(item);

	//
	item = awk(str, cc, ++nn);
	while (item!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, item, NULL, NULL, 0);
		free(item);
		item = awk(str, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;
}



/**
tList*	cawk_tList(char* str, char cc)

؂蕶ŋ؂āCeڂXg̃L[ɓĕԂD
̋؂蕶1ƌȂD@n
ڂ݂ȂꍇłXg͕ԂiL[ buf NULLjD

@param  str  镶
@param  cc   ڂ̋؂蕶
@return ڂL[ɓꂽXgDڂ݂ȂꍇłXg͕ԂD
*/
tList*	cawk_tList(char* str, char cc)
{
	int    nn = 1;
	char*  item;
	tList* lp = NULL;

	if (str==NULL) return NULL;

	lp = add_tList_node_bystr(NULL, 1, 0, NULL, NULL, NULL, 0);

	// first item
	item = cawk(str, cc, nn);
	if (item==NULL) return lp;
	lp->ldat.key = make_Buffer_bystr(item);

	//
	item = cawk(str, cc, ++nn);
	while (item!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, item, NULL, NULL, 0);
		free(item);
		item = cawk(str, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;

}



tList*	awk_Buffer_tList(Buffer buf, char cc)
{
	int    nn = 1;
	Buffer item;
	tList* lp = NULL;

	if (buf.buf==NULL) return NULL;

	item = awk_Buffer(buf, cc, nn);
	while (item.buf!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, (char*)item.buf, NULL, NULL, 0);
		free_Buffer(&item);
		item = awk_Buffer(buf, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;
}



tList*	cawk_Buffer_tList(Buffer buf, char cc)
{
	int    nn = 1;
	Buffer item;
	tList* lp = NULL;

	if (buf.buf==NULL) return NULL;

	item = cawk_Buffer(buf, cc, nn);
	while (item.buf!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, (char*)item.buf, NULL, NULL, 0);
		free_Buffer(&item);
		item = cawk_Buffer(buf, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;

}



char*  get_str_join_tList(tList* lp, const char* deli)
{
	Buffer buf = get_Buffer_join_tList(lp, deli);
	return (char*)buf.buf;
}



Buffer  get_Buffer_join_tList(tList* lp, const char* deli)
{
	Buffer buf;
	
	buf = init_Buffer();
	if (lp==NULL) return buf;

	buf = make_Buffer(LBUF);

	if (lp!=NULL && lp->ldat.key.buf!=NULL) {
		cat_s2Buffer((char*)lp->ldat.key.buf, &buf);
		lp = lp->next;

		while (lp!=NULL && lp->ldat.key.buf!=NULL) {
			if (deli!=NULL) cat_s2Buffer(deli, &buf);
			cat_s2Buffer((char*)lp->ldat.key.buf, &buf);
			lp = lp->next;
		}
	}

	return buf;
}





//////////////////////////////////////////////////////////////////////////
// for Configuration File
//

char*  get_str_param_tList(tList* lt, const char* key, const char* dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf==NULL) buf = make_Buffer_bystr(dflt);
		
	return (char*)buf.buf;
}



int  get_int_param_tList(tList* lt, const char* key, int dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf!=NULL) {
		int ret = atoi((char*)buf.buf);
		free_Buffer(&buf);
		return ret;
	}
	return dflt;
}



double  get_double_param_tList(tList* lt, const char* key, double dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf!=NULL) {
		double ret = atof((char*)buf.buf);
		free_Buffer(&buf);
		return ret;
	}
	return dflt;
}



float  get_float_param_tList(tList* lt, const char* key, float dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf!=NULL) {
		float ret = (float)atof((char*)buf.buf);
		free_Buffer(&buf);
		return ret;
	}
	return dflt;
}



int  get_bool_param_tList(tList* lt, const char* key, int dflt)
{
	int   ret = dflt;
	char* val = NULL;

	if (dflt) val = get_str_param_tList(lt, key, "true");
	else      val = get_str_param_tList(lt, key, "false");

	if (val!=NULL) {
		if (!strcasecmp("true", val)) ret = 1;		// TRUE
		else ret = 0;								// FALSE
		free(val);
	}

	return ret;
}






/////////////////////////////////////////////////////////////////////////////
//
// Tiny List File I/O
//

/**
tList*  read_tList_file(const char* fname, int mode) 

t@CsÂǂݍŃXg̃L[Ɋi[Ds̓XgɉȂD

@param  fname  t@CD 
@param  mode   0: t@Ĉ܂ܓǂݍށD
@param  mode   1: 擪 # ̍s̓XgɉȂD܂Ő󔒂폜C̘̑A󔒂1̋󔒂ɕϊD
                  Ƀ^u͈̋󔒂ƂďD
@param  mode   2: 1̏ꍇɉāCr # ȍ~

@return i[Xgւ̃|C^D
*/
tList*  read_tList_file(const char* fname, int mode) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_tList_fp(fp, mode);
		fclose(fp);
	}
	else {
		DEBUG_MESG("READ_TLIST_FILE: cannot file open [%s]\n", fname);
	}

	return lp;
}



/**
tList*  read_tList_fp(FILE* fp, int mode) 

t@C|C^t@CsÂǂݍŃXg̃L[Ɋi[D
s̓XgɉȂD

@param  fp    t@C|C^D 
@param  mode  0: t@Ĉ܂ܓǂݍށD
@param  mode  1: 擪 # ̍s̓XgɉȂD܂Ő󔒂폜C̘̑A󔒂1̋󔒂ɕϊD
                 ܂C^u͈̋󔒂ƂďD
@param  mode  2: 1̏ꍇɉāCr # ȍ~

@return i[Xgւ̃|C^D

@bug fBNgǂ܂ƁC߂ĂȂD
*/
tList*  read_tList_fp(FILE* fp, int mode) 
{
	char	val[LBUF+1];
	char*   str;
	tList*   lp = NULL;
	tList*   lt = NULL;

	if (fp==NULL) return NULL;

	fgets(val, LBUF, fp);
	while (!feof(fp)) {
		if (mode>0) {
			if (mode>1) {
				int i;
				for (i=0; i<(int)strlen(val); i++) {
					if (val[i]=='#') {
						val[i] = '\0';
						break;
					}
					if (i>=LBUF) break;
				}
			}
			str = pack_char(val, ' ');
		}
		else {
			str = (char*)malloc(LBUF+1);
			if (str!=NULL) strncpy(val, str, LBUF);
		}

		if (str!=NULL) {
			if (strlen(str)>0) {	// s̃`FbN
				if (mode==0 || str[0]!='#') {
					lt = add_tList_node_str(lt, str, NULL);
					if (lp==NULL) lp = lt;
				}
			}
			free(str);
		}
		fgets(val, LBUF, fp);
	}
	
	return lp;
}



/**
tList*  read_index_tList_file(const char* fname, char deli) 

t@CsÂǂݍŁCdeli؂蕶ɂăXg̃L[ƃf[^Ɋi[D@n
s̓XgɉȂD#Ŏn܂s̓XgɉȂ

@param  fname  t@CD 
@param  deli   ؂蕶

@return i[Xgւ̃|C^D
*/
tList*  read_index_tList_file(const char* fname, char deli) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_index_tList_fp(fp, deli);
		fclose(fp);
	}
	return lp;
}



/**
tList*  read_index_tList_fp(FILE* fp, char deli)

t@CsÂǂݍŁCdeli؂蕶ɂăXg̃L[ƃf[^Ɋi[D@n
s̓XgɉȂD#Ŏn܂s̓XgɉȂ

@param  fp    t@C|C^D 
@param  deli  ؂蕶

@return i[Xgւ̃|C^D
*/
tList*  read_index_tList_fp(FILE* fp, char deli)
{
	Buffer key, val;
	tList* pl;
	tList* pp;
	tList* lt = NULL;

 	pp = pl = read_tList_fp(fp, 1);
	while (pp!=NULL) {
		key = awk_Buffer(pp->ldat.key, deli, 1);
		val = awk_Buffer(pp->ldat.key, deli, 2);
			
		if (lt==NULL) lt = add_tList_node_byBuffer(NULL, 0, 0, key, val, NULL, 0);
		else               add_tList_node_byBuffer(lt,   0, 0, key, val, NULL, 0);
	
		free_Buffer(&key);
		free_Buffer(&val);
		
		pp = pp->next;
	}
	del_all_tList(&pl);

	return lt;
}



/**
tList*  read_Buffer_tList_file(const char* fname) 

t@C Buffer^ϐ 2ÂǂݍŁCXg̃L[ƃobt@Ɋi[ԂD

@param  fname  t@CD 
@return i[Xgւ̃|C^D
*/
tList*  read_Buffer_tList_file(const char* fname) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_Buffer_tList_fp(fp);
		fclose(fp);
	}
	return lp;
}



/**
tList*  read_Buffer_tList_fp(FILE* fp) 

t@C Buffer^ϐ 2ÂǂݍŁCXg̃L[ƃobt@Ɋi[ԂD

@param  fp  t@C|C^D 
@return i[Xgւ̃|C^D
*/
tList*  read_Buffer_tList_fp(FILE* fp) 
{
	int	cc;
	tList*  lp = NULL;
	tList*  lt = NULL;
	Buffer key, val;

	if (fp==NULL) return NULL;

	cc = read_Buffer2_fp(&key, &val, fp);
	while (!feof(fp) && cc) {
		lt = add_tList_node_Buffer(lt, key, val);
		if (lp==NULL) lp = lt;
		free_Buffer(&key);	
		free_Buffer(&val);	
		cc = read_Buffer2_fp(&key, &val, fp);
	}
	
	free_Buffer(&key);	
	free_Buffer(&val);	
	return lp;
}



/**
int  save_Buffer_tList_file(const char* fname, tList* lp) 

Xg̃L[ƃobt@ Buffer^ϐt@C֏ށD
t@Cɂꍇ́Cǉ݂D

@param  fname  t@CD 
@param  lp     ݂sXgf[^ւ̃|C^D

@retval TRUE   ݐD
@retval FALSE  ݎs
*/
int  save_Buffer_tList_file(const char* fname, tList* lp) 
{
	int   ret=FALSE;
	FILE* fp;

	fp = fopen(fname, "ab");
	if (fp!=NULL) {
		ret = save_Buffer_tList_fp(fp, lp);
		fclose(fp);
	}
	return ret;
}



/**
int   save_Buffer_tList_fp(FILE* fp, tList* lp) 

Xg̃L[ƃobt@ Buffer^ϐt@C֏ށD
t@Cɂꍇ́Cǉ݂D

@param  fp     t@C|C^D 
@param  lp     ݂sXgf[^ւ̃|C^D

@retval TRUE   ݐD
@retval FALSE  ݎs
*/
int   save_Buffer_tList_fp(FILE* fp, tList* lp) 
{
	int cc=TRUE;

	if (fp==NULL) return FALSE;

	while (lp!=NULL && cc) {
		cc = save_Buffer2_fp(lp->ldat.key, lp->ldat.val, fp);	
		lp = lp->next;
	}

	if (!cc) return FALSE;
	return TRUE;
}



