

/**
@brief    OtBbNCu for C++
@file     Graph.cpp
@author   Fumi.Iseki (C)

*/



#include "Graph.h"
 

using namespace jbxl;




/**
void  jbxl::rotate_point(int& x, int& y, double sxc, double syc, double dxc, double dyc, double cst, double snt)

@param[in,out] x    in: XWDout: ]XWD
@param[in,out] y    in: YWDout: ]YWD
@param         sxc  ]O̍W̒S XW
@param         syc  ]O̍W̒S YW
@param         dxc  ]̍W̒S XW
@param         dyc  ]̍W̒S YW
@param         cst  ]p cos
@param         snt  ]p sin
*/
void  jbxl::rotate_point(int& x, int& y, double sxc, double syc, double dxc, double dyc, double cst, double snt)
{
	double a, b, u, t;

	a = x - sxc;
	b = syc - y;
	u = a*cst - b*snt;
	t = a*snt + b*cst;
	x = (int)(u + dxc + 0.5);
	y = (int)(dyc - t + 0.5);

	return;
}




/**
void  jbxl::rotate_point_angle(int& x, int& y, double sxc, double syc, double dxc, double dyc, double th)

@param[in,out] x    in: XWDout: ]XWD
@param[in,out] y    in: YWDout: ]YWD
@param         sxc  ]O̍W̒S XW
@param         syc  ]O̍W̒S YW
@param         dxc  ]̍W̒S XW
@param         dyc  ]̍W̒S YW
@param         th   ]piWAj
*/
void  jbxl::rotate_point_angle(int& x, int& y, double sxc, double syc, double dxc, double dyc, double th)
{
	double cst = cos(th);
	double snt = sin(th);

	rotate_point(x, y, sxc, syc, dxc, dyc, cst, snt);

	return;
}




