

/**
@brief    OpContour(Facet)pCu 
@file     TriBrep.cpp
@author   Fumi.Iseki (C)

@attention
̃t@C̊֐ Contour(=Facet)Op`ł邱ƂOƂD
*/


#include "TriBrep.h"


using namespace jbxl;



/**
void jbxl:: CreateContoursList(BREP_SOLID* solid)

폜}[N̕tContour(Facet)폜CSContour(Facet) ListD@n
Cǂݍ݁ijf[^͍폜ȂD
*/
DllExport void  jbxl::CreateContoursList(BREP_SOLID* solid)
{
	solid->contours.clear();

	BREP_SHELL_LIST shells = solid->shells;
	BREP_SHELL_LIST::iterator ishell;
	for (ishell=shells.begin(); ishell!=shells.end(); ishell++){
		BREP_FACET* pbfc;
		BREP_FACET_LIST::iterator ifacet;
		for (ifacet =(*ishell)->facets.begin(); ifacet!=(*ishell)->facets.end(); ifacet++){
			if ((*ifacet)->deletable && !(*ifacet)->notdelete) {
				pbfc = *ifacet;
				ifacet = (*ishell)->facets.erase(ifacet);
				ifacet--;
				pbfc->shell = NULL;
				delete(pbfc);
			}
			else {
				BREP_CONTOUR_LIST::iterator icon;
				for (icon=(*ifacet)->outer_contours.begin(); icon!=(*ifacet)->outer_contours.end(); icon++) {
					(*ifacet)->deletable = false;
					solid->contours.push_back(*icon);
				}
			}
		}
	}
	solid->facetno = (int)solid->contours.size();
}




/**
void  jbxl::CreateWingsList(BREP_SOLID* solid)

S Wing ListD(ContourɌѕtĂȂ̂܂) @n
CreateContoursList()ɈˑD
*/
DllExport void  jbxl::CreateWingsList(BREP_SOLID* solid)
{
	solid->wings.clear();

	BREP_CONTOUR_LIST::iterator icon;
	for (icon=solid->contours.begin(); icon!=solid->contours.end(); icon++) {
		BREP_WING* first = (*icon)->wing;
		if (first!=NULL) {
			BREP_WING* next = first;
			do {
				BREP_WING* wing = next;
				next = wing->next;
				solid->wings.push_back(wing);
				if (!wing->edge->complete) solid->wings.push_back(GetWingOtherSide(wing));
			} while(next!=first);
		}
	}
}




/**
void  jbxl::CreateSurplusContoursList(BREP_SOLID* solid)

dEdge Contour ListD@n
CreateContoursList()ɈˑD
*/
DllExport void  jbxl::CreateSurplusContoursList(BREP_SOLID* solid)
{
//	DEBUG_MODE print_messageln("Start CreateSurplusContoursList");
	solid->surplus_contours.clear();

	BREP_CONTOUR_LIST::iterator icon;
	for (icon=solid->contours.begin(); icon!=solid->contours.end(); icon++){
		if (DupEdgeNumber(*icon)>0) {
			solid->surplus_contours.push_back(*icon);
		}
	}
//	DEBUG_MODE print_messageln("END CreateSurplusContoursList");
}





/**
void  jbxl::CreateShortageWingsList(BREP_SOLID* solid)

sS Wing ListDWingsList𗘗pD@n
CreateContoursList(), CreateWingsList()ɈˑD
*/
DllExport void  jbxl::CreateShortageWingsList(BREP_SOLID* solid)
{
	solid->shortage_wings.clear();

	BREP_WING_LIST::iterator iwing;
	for (iwing=solid->wings.begin(); iwing!=solid->wings.end(); iwing++){
		if ((*iwing)->contour==NULL) solid->shortage_wings.push_back(*iwing);
	}
}





//---------------------------------------------------------------------------------------------------------

/**
void  jbxl::DeleteSurplusContours(BREP_SOLID* solid)

dEdge Contour(Facet)̍폜 @n
Contours List  Wings List̓e͕ۏႳD

@par vf[^
- SĂContour(Facet) List (Contours List)D
	- O̊֐ōsDCreateContoursList()gpĂǂD
- dGbW̐PȏContour(Facet)i[ꂽListiSurplusContours ListjD
	- O̊֐ōsDCreateSuplusContoursList()gpĂǂ

@par ASY
-# List̒ɂRӂdEdgeFacetɍ폜}[Nî߁j 
	- YFacet(Contour)폜CFacet(Contour)𗠕Ԃēo^ iReverseContoursj
	- dEdgełꍇ͓o^𒆎~
-# QӂdEdge Facetɍ폜}[NDPƓl̏sD
-# PӂdEdge Facetɍ폜}[NDPƓl̏sD
-# ̒iKŁCList̒ɂ Facet݂͑Ȃ͂D܂݂ꍇ̓G[D
*/
DllExport void  jbxl::DeleteSurplusContours(BREP_SOLID* solid)
{
	if (solid->surplus_contours.empty()) return;
//	DEBUG_MODE print_messageln("Start DeleteSurplusContours");
	
	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax((int)solid->surplus_contours.size()*3);
	
	BREP_CONTOUR_LIST::iterator icon;
	// R̑dEdge Facet̏
	for (icon=solid->surplus_contours.begin(); icon!=solid->surplus_contours.end(); icon++){
		if ((*icon)->dup_edge==3) (*icon)->facet->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}
	ReverseContours(solid);			// RӂdEdge Facet𗠕Ԃ
	CreateShortageWingsList(solid);
	JoinShortageWings(solid);		// ɂ܂Ƃ܂Edge͈ɂ܂Ƃ߂D

	CreateSurplusContoursList(solid);
	if (solid->surplus_contours.empty()) {
//		DEBUG_MODE print_messageln("End   DeleteSurplusContours");
		return;
	}

	// Q̑dEdge Facet̏
	for (icon=solid->surplus_contours.begin(); icon!=solid->surplus_contours.end(); icon++){
		if ((*icon)->dup_edge==2) (*icon)->facet->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}
	ReverseContours(solid);			// QӂdEdge Facet𗠕Ԃ
	CreateShortageWingsList(solid);
	JoinShortageWings(solid);	

	CreateSurplusContoursList(solid);
	if (solid->surplus_contours.empty()) {
//		DEBUG_MODE print_messageln("End   DeleteSurplusContours");
		return;
	}

	// P̑dEdge Facet̏
	for (icon=solid->surplus_contours.begin(); icon!=solid->surplus_contours.end(); icon++){
		if ((*icon)->dup_edge==1) (*icon)->facet->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}
	ReverseContours(solid);			// PӂdEdge Facet𗠕Ԃ
	CreateShortageWingsList(solid);
	JoinShortageWings(solid);	
		
	CreateSurplusContoursList(solid);
	if (!solid->surplus_contours.empty()) {
//		DEBUG_MODE print_messageln("EraseSurplusContour: dEdge Facetf[^cĂH");
	}
//	DEBUG_MODE print_messageln("End   DeleteSurplusContours");
	return;
}




/**
void  jbxl::DeleteStraightEdges(BREP_SOLID* solid)

Vertexɕ񂾏ꍇC[VertexԂɍꂽ Edge(Wing)Ɋ֘A Contour(Facet)폜D@n
Contours List  Wings List̓e͕ۏႳD

@par vf[^
- SĂWing ListiWings ListjD
	- O̊֐ōsDCreateWingsList()gpĂǂD
- ContourɊ֘AtĂȂigpĂȂjWingi[ꂽListiShortageWings ListjD
	- O̊֐ōsDCreateShortageWingsList() gpĂǂD
*/
DllExport void  jbxl::DeleteStraightEdges(BREP_SOLID* solid)
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start DeleteStraightEdges");

	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax((int)solid->shortage_wings.size());

	BREP_WING_LIST::iterator wing1;
	for (wing1=solid->shortage_wings.begin(); wing1!=solid->shortage_wings.end(); wing1++){
		BREP_VERTEX* vert[3];
		vert[0] = (*wing1)->vertex;
		BREP_WING_LIST::iterator wing2;
		for (wing2=solid->shortage_wings.begin(); wing2!=solid->shortage_wings.end(); wing2++){
			if (IsConnectEdges(*wing1, *wing2)) {
				vert[1] = (*wing2)->vertex;
				vert[2] = GetWingOtherSide(*wing2)->vertex;
				IsForbiddenEdge(vert);	// ɕ Vertex֎~D
			}
		}
		if (counter!=NULL) counter->StepIt();
	}
	CreateContoursList(solid);			// YContour(Facet)폜CSĂContour(Facet) List蒼D
	CreateWingsList(solid);				// WingsList蒼D
	
//	DEBUG_MODE print_messageln("End   DeleteStraightEdges");
	return;
}




/**
void  jbxl::DeleteShortageWings(BREP_SOLID* solid) 

sS Wing(Edge)Facet(Contour)폜 @n
Contours List  Wings List̓e͕ۏႳD

@par vf[^
- ShortageWings ListDCreateShortageWingsList()ō쐬Ăǂ
*/
DllExport void  jbxl::DeleteShortageWings(BREP_SOLID* solid) 
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start DeleteShortageWings");

	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax((int)solid->shortage_wings.size());

	BREP_WING_LIST::iterator iwing;
	for (iwing=solid->shortage_wings.begin(); iwing!=solid->shortage_wings.end(); iwing++){
		if ((*iwing)->contour!=NULL) (*iwing)->contour->facet->deletable = true;
		BREP_WING* othwing = GetWingOtherSide(*iwing);
		if (othwing->contour!=NULL)  othwing->contour->facet->deletable = true;
		if (counter!=NULL) counter->StepIt();
	}

	CreateContoursList(solid);
	CreateWingsList(solid);
//	DEBUG_MODE print_messageln("End   DeleteShortageWings");
	return;
}





#define  JBXL_BREP_MAX_LOOPCNT  20

/**
void  jbxl::FillShortageWings(BREP_SOLID* solid, int method, bool mode)

ȂContour[iSĂ̕sContourȂ邩C[s\ɂȂ܂ŁjD@n
Contours List, Wings List, SohrtageWins List̓e͕ۏႳD

@par vf[^
- ShortageWings ListDCreateShortageWingsList()ō쐬Ăǂ

@param  solid   \bhf[^ւ̃|C^
@param  method  @b 1: OԖڂVertexTASY Next.
@param  method  @b 2: OԖڂVertexTASY Near.
@param  mode    @b true : dEdgeF߂D
@param  mode    @b false: dEdgeF߂ȂD
*/
DllExport void  jbxl::FillShortageWings(BREP_SOLID* solid, int method, bool mode)
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start FillShortageWings");

	int wmax = (int)solid->shortage_wings.size();
	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
	if (counter!=NULL) counter->SetMax(wmax);

	int lpc = 0;
	int pno = 1;
	while (solid->shortage_wings.size()>1 && pno!=0 && lpc<JBXL_BREP_MAX_LOOPCNT) {
		if      (method==1) pno = FillShortageWings_Next(solid, mode);
		else if (method==2) pno = FillShortageWings_Near(solid, mode);
		else {
//			DEBUG_MODE print_messageln("FillShortageWings: mȂ@w肳ꂽ %d", method);
//			DEBUG_MODE print_messageln("End   FillShortageWings");
			return;
		}
		CreateShortageWingsList(solid);
		//DEBUG_MODE print_messageln("FillShortageWings: sSWingf[^ %d/%d   %d", solid->shortage_wings.size(), wmax, pno);
		lpc++;
	}

//	DEBUG_MODE print_messageln("End   FillShortageWings");
	return;
}




/**
int  jbxl::FillShortageWings_Next(BREP_SOLID* solid, bool mode)

ȂContour[î݁jDNextASY

EdgeɌqĂEdgeTĂVertexOp`(Contour)D@n
Contours List  Wings List̓e͕ۏႳD

@par vf[^
- ShortageWings ListDCreateShortageWingsList()ō쐬Ăǂ

@param  solid  \bhf[^ւ̃|C^
@param  mode   @b true : dEdgeF߂D
@param  mode   @b false: dEdgeF߂ȂD
*/
DllExport int  jbxl::FillShortageWings_Next(BREP_SOLID* solid, bool mode)
{
	int patchno = 0;

	BREP_WING_LIST::iterator wing1;
	for (wing1=solid->shortage_wings.begin(); wing1!=solid->shortage_wings.end(); wing1++){
		if (!IsIncludeCompleteEdge(*wing1)) {
			BREP_VERTEX* vert[3];

			vert[0] = (*wing1)->vertex;
			BREP_WING_LIST::iterator wing2;
			for (wing2=solid->shortage_wings.begin(); wing2!=solid->shortage_wings.end(); wing2++){
				if (!IsIncludeCompleteEdge(*wing2) && IsConnectEdges(*wing1, *wing2)) {
					vert[1] = (*wing2)->vertex;
					vert[2] = GetWingOtherSide(*wing2)->vertex;	// vert[]: Contour\钸_
					BREP_SHELL* shell = GetWingOtherSide(*wing1)->contour->facet->shell;
					if (PatchupContour(shell, vert, mode)) patchno++;
				}
			}
		}
	}
	CreateContoursList(solid);
	CreateWingsList(solid);

	return patchno;
}





#define  JBXL_BREP_MAX_QUEUESIZE  1


/**
DllExport int  jbxl::FillShortageWings_Near(BREP_SOLID* solid, bool mode)

ȂContour[î݁jDNearASY

Edge̒S߂VertexTĎOp`(Contour)D@n
Contours List  Wings List̓e͕ۏႳD

@par vf[^
- ShortageWings ListDCreateShortageWingsList()ō쐬Ăǂ

@param  solid  \bhf[^ւ̃|C^
@param  mode   @b true : dEdgeF߂D
@param  mode   @b false: dEdgeF߂ȂD
*/
DllExport int  jbxl::FillShortageWings_Near(BREP_SOLID* solid, bool mode)
{
	int patchno = 0;
	BREP_VERTEX_LIST  vertex_list;

	BREP_WING_LIST::iterator wing1;
	for (wing1=solid->shortage_wings.begin(); wing1!=solid->shortage_wings.end(); wing1++){
		if (!IsIncludeCompleteEdge(*wing1)) {
			BREP_VERTEX* vert[3];
			vert[0] = (*wing1)->vertex;
			vert[1] = GetWingOtherSide(*wing1)->vertex;
			vert[2] = NULL;
			vertex_list.clear();

			BREP_WING_LIST::iterator wing2;
			for (wing2=solid->shortage_wings.begin(); wing2!=solid->shortage_wings.end(); wing2++){
				if (wing1!=wing2) {
					BREP_VERTEX* vrtx = (*wing2)->vertex;
					if (vrtx!=vert[0] && vrtx!=vert[1]) {
					/*	int cnt = 0;
						BREP_VERTEX* v = vert[1];
						do {
							v = FindConnectEdgeVertex(v);
							cnt++;
						} while (v!=vert[0] && v!=vert[1] && v!=vrtx && v!=NULL && cnt<100);
					*/	
					//	if (v!=vrtx) {
							VECTOR<double> vect = (*wing1)->edge->center - vrtx->point;  
							vrtx->distance2 = vect.norm2();
							SetMinVertex(&vertex_list, vrtx);
					//	}
					}
				}
			}

			int cnt=0;
			BREP_SHELL* shell = GetWingOtherSide(*wing1)->contour->facet->shell;
			BREP_VERTEX_LIST::iterator ivert;
			for (ivert=vertex_list.begin(); ivert!=vertex_list.end(); ivert++){
				vert[2] = *ivert;
				if (PatchupContour(shell, vert, mode)) {
					patchno++;
					break;
				}
				cnt++;
				if (cnt>=JBXL_BREP_MAX_QUEUESIZE) break;
			}

		}
	}
	CreateContoursList(solid);
	CreateWingsList(solid);

	return patchno;
}




/**
void  jbxl::SetMinVertex(BREP_VERTEX_LIST* list, BREP_VERTEX* vrtx)

FillShortageWings_Near()p
*/
DllExport void  jbxl::SetMinVertex(BREP_VERTEX_LIST* list, BREP_VERTEX* vrtx)
{
	BREP_VERTEX_LIST::iterator ivert;
	for (ivert=list->begin(); ivert!=list->end(); ivert++){
		if (vrtx==(*ivert)) return;	// ɓo^ς
		if (vrtx->distance2 < (*ivert)->distance2) {
			list->insert(ivert, vrtx);
			return;
		}
	}
	if (ivert==list->end()) list->push_back(vrtx);
	return;
}




/**
BREP_VERTEX*  jbxl::FindConnectEdgeVertex(BREP_VERTEX* vert)

vertex EdgeŌq vertex̓CŏɌ̂ԂD
*/
DllExport BREP_VERTEX*  jbxl::FindConnectEdgeVertex(BREP_VERTEX* vert)
{
	BREP_WING_LIST::iterator iwing;
	for (iwing=vert->wing_list.begin(); iwing!=vert->wing_list.end(); iwing++){
		if ((*iwing)->contour==NULL) {
			return GetWingOtherSide(*iwing)->vertex;
		}
	}
	return NULL;
}




/**
bool  jbxl::PatchupContour(BREP_SHELL* shell, BREP_VERTEX** vert, bool mode)

Shellɑ΂āCvert[0]`vert[2]̎Op`Contour[D

@param          shell  VFf[^ւ̃|C^
@param[in,out]  vert   _DUꂽOp`̒_񂪒ǉD
@param          mode   @b true:  dEdgeF߂D
@param          mode   @b false: dEdgeF߂ȂD
*/
DllExport bool  jbxl::PatchupContour(BREP_SHELL* shell, BREP_VERTEX** vert, bool mode)
{
	if (vert[0]->forbidden_list!=NULL) {
		BREP_VERTEX_LIST::iterator vertex; 
		vertex = std::find(vert[0]->forbidden_list->begin(), vert[0]->forbidden_list->end(), vert[2]);
		if (vertex!=vert[0]->forbidden_list->end()) return false;	// ֎~List̒ɌD 
	}

	BREP_SOLID* solid  = shell->solid;
	CVCounter* counter = NULL;
	if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();

	BREP_FACET* facet  = new BREP_FACET(shell);
	BREP_CONTOUR* contour = CreateContourByVertex(facet, vert); 	
	if (contour!=NULL) {
		if (DupEdgeNumber(contour)==0 || mode) {
			BREP_CONTOUR* collision;
			facet->CloseData();
			if (!IsCollisionContours(solid, contour, &collision)) {
				solid->contours.push_back(contour);
//				PrintFacetAsciiSTL(contour);
				if (counter!=NULL) counter->StepIt();
				return true;
			}
			else FastDeleteFacet(facet);
		}
		else FastDeleteFacet(facet);
	}
	else FastDeleteFacet(facet); 

	return  false;
}




/**
void  jbxl::ReverseContours(BREP_SOLID* solid)

폜}[N̕tFacet(Contour)폜C_Contour𗠕Ԃēo^.
Co^ Contourɑd Edgeꍇ͓o^𒆎~D@n
Cǂݍ݁ijf[^͍폜ȂD

Contours List  Wings List̓e͕ۏႳD
*/
DllExport void  jbxl::ReverseContours(BREP_SOLID* solid)
{
	// SĂ Facetɑ΂
	BREP_SHELL_LIST shells = solid->shells;
	BREP_SHELL_LIST::iterator ishell;
	for (ishell=shells.begin(); ishell!=shells.end(); ishell++){
		BREP_FACET_LIST::iterator ifacet;
		for (ifacet =(*ishell)->facets.begin(); ifacet!=(*ishell)->facets.end(); ifacet++){
			// 폜}[NtĂȂ
			if ((*ifacet)->deletable && !(*ifacet)->notdelete) {
				// tŒ_ VECTOR vɊi[
				BREP_VERTEX*  v[3];
				BREP_FACET*   pbfc;
				BREP_CONTOUR* pbcn;
				BREP_CONTOUR_LIST::iterator icon;
				for (icon=(*ifacet)->outer_contours.begin(); icon!=(*ifacet)->outer_contours.end(); icon++) {
					BREP_WING* wing = (*icon)->wing;
					for (int i=0; i<3; i++) {
						v[i] = wing->vertex;
						wing = wing->prev;
					}
				}

				// 폜}[NtĂ Facet폜
				pbfc   = *ifacet;
				ifacet = (*ishell)->facets.erase(ifacet);
				ifacet--;
				pbfc->shell = NULL;
				delete(pbfc);

				// Ԃ Contouro^
				pbfc = new BREP_FACET(*ishell);
				pbcn = CreateContourByVertex(pbfc, v); 
				if (pbcn!=NULL) {
					if (DupEdgeNumber(pbcn)==0) {
						pbfc->CloseData();
					}
					else {
						FastDeleteFacet(pbfc);
					}
				}
				else {
					FastDeleteFacet(pbfc);
				}
			}
		}
	}

	CreateContoursList(solid);	
	CreateWingsList(solid);
}




/**
void  jbxl::JoinShortageWings(BREP_SOLID* solid)

sSdEdgeɂȂĂ邪C͈Edgeɂ܂Ƃ߂邱Ƃł̂ɂ܂Ƃ߂D@n
Contours List  Wings List̓e͕ۏႳD

@par vf[^
- ShortageWings ListDCreateShortageWingsList()ō쐬Ăǂ
*/
DllExport void  jbxl::JoinShortageWings(BREP_SOLID* solid)
{
	if (solid->shortage_wings.empty()) return;
//	DEBUG_MODE print_messageln("Start JoinShortageWings");

	BREP_WING_LIST::iterator iwing;
	for (iwing=solid->shortage_wings.begin(); iwing!=solid->shortage_wings.end(); iwing++){
		BREP_WING* wingA = (*iwing);

		if (GetWingOtherSide(wingA)->contour==NULL) {		// NULL
			delete (wingA->edge);
			continue;
		}
		
		if (wingA->edge->edge_list!=NULL) {
			BREP_EDGE_LIST* edge_list = wingA->edge->edge_list;
			BREP_EDGE_LIST::iterator iedge;
			for (iedge=edge_list->begin(); iedge!=edge_list->end(); iedge++){
				if (wingA==(*iedge)->wing1 || wingA==(*iedge)->wing2) continue;
				if ((*iedge)->wing1->contour!=NULL && (*iedge)->wing2->contour!=NULL) continue;

				BREP_WING* wingB;
				if      ((*iedge)->wing1->contour!=NULL) wingB = (*iedge)->wing1;
				else if ((*iedge)->wing2->contour!=NULL) wingB = (*iedge)->wing2;
				else continue;  // NULL炪ɌD deleteR[hɔCD

				if (wingA->vertex==wingB->vertex) {
					if      (wingA->edge->wing1==wingA) wingA->edge->wing1 = wingB;
					else if (wingA->edge->wing2==wingA) wingA->edge->wing2 = wingB;
					if      (wingB->edge->wing1==wingB) wingB->edge->wing1 = wingA;
					else if (wingB->edge->wing2==wingB) wingB->edge->wing2 = wingA;

					BREP_EDGE* sedge = wingB->edge;
					wingB->edge = wingA->edge;
					wingA->edge = sedge;
					wingB->edge->complete = true;
					wingA->edge->complete = false;
					break;
				}
			}
		}
	}
	CreateContoursList(solid);
	CreateWingsList(solid);

//	DEBUG_MODE print_messageln("End   JoinShortageWings");
	return;
}






//--------------------------------------------------------------------------------------------

/**
int  jbxl::DupEdgeNumber(BREP_CONTOUR* contour)

ContouȓdEdge̐𐔂D
*/
DllExport int  jbxl::DupEdgeNumber(BREP_CONTOUR* contour)
{
	contour->dup_edge = 0;

	BREP_WING* first = contour->wing;
	if (first!=NULL) {
		BREP_WING* next = first;
		do {
			BREP_WING* wing = next;
			next = wing->next;
			if (wing->edge->edge_list!=NULL) contour->dup_edge++;
		} while(next!=first);
	}
	return  contour->dup_edge;
}




/**
BREP_CONTOUR*  jbxl::CreateContourByVector(BREP_FACET* facet, VECTOR<double>* vect, VECTOR<double>* nrml, UVMAP<double>* uvmp, bool dupli)

Facet  VECTOR[]  Contour D

vect[0]`vect[2] ͂R_̈ʒuxNgitĂj
nrml[0]`nrml[2] ͂R_̖@xNgiNULL ȂČvZj
uvmp[0]`uvmp[2] ͂R_̋ȖʍWf[^D

@param  facst FACETf[^ւ̃|C^
@param  vect  3̒_f[^ vect[3] ւ̃|C^
@param  nrml  _̖@xNgf[^ւ̃|C^D
@param  uvmp  _̋ȖʍWf[^ւ̃|C^D
@param  dupli true: _̏do^Dfalse: do^ȂD
*/
DllExport BREP_CONTOUR*  jbxl::CreateContourByVector(BREP_FACET* facet, VECTOR<double>* vect, VECTOR<double>* nrml, UVMAP<double>* uvmp, bool dupli)
{
	BREP_SOLID*   solid;
	BREP_CONTOUR* contour;
	BREP_VERTEX*  vertex[3];

	solid = facet->shell->solid;

	// Vertex ̐
	for (int i=0; i<3; i++) {
		vertex[i] = new BREP_VERTEX();
		vertex[i]->point = vect[i];
		if (nrml!=NULL) {
			vertex[i]->calc_normal = false;
			vertex[i]->normal = nrml[i];
		}
		if (uvmp!=NULL) {
			vertex[i]->uvmap  = uvmp[i];
		}
		vertex[i]->CloseData();
	}

	// _D܂͂R_ɂD
	if (vertex[0]==vertex[1] || vertex[1]==vertex[2] || vertex[0]==vertex[2]) return NULL;
	if (IsForbiddenEdge(vertex)) return NULL;

	// Vertex\bh Octreeɓo^
	BREP_VERTEX* vert;
	for (int i=0; i<3; i++) {
		vert = AddVertex2Octree(vertex[i], solid->octree, dupli);
		if (vert!=vertex[i]) {
			delete vertex[i];
			vertex[i] = vert;
		}
	}

	contour = CreateContourByVertex(facet, vertex);	

	return  contour;
}




/**
BREP_CONTOUR*  jbxl::CreateContourByVertex(BREP_FACET* facet, BREP_VERTEX** vertex)

Facet  Vertex[3]  Vertex D
vertex[0]`vertex[2]  3_ VertexitĂj
*/
DllExport BREP_CONTOUR*  jbxl::CreateContourByVertex(BREP_FACET* facet, BREP_VERTEX** vertex)
{
	// _D܂͂R_ɂD
	if (vertex[0]==vertex[1] || vertex[1]==vertex[2] || vertex[0]==vertex[2]) return NULL;
	if (IsForbiddenEdge(vertex)) return NULL;

	BREP_CONTOUR* contour = new BREP_CONTOUR(facet);

	// WingD
	BREP_WING*      wing = contour->CreateWing(vertex[0], vertex[1]);
	if (wing!=NULL) wing = contour->CreateWing(vertex[1], vertex[2]);
	if (wing!=NULL) wing = contour->CreateWing(vertex[2], vertex[0]);
	if (wing!=NULL) {
		contour->CloseData();  // ʂ̖@xNgvZD
	}
	else {
		delete(contour);
		contour = NULL;
	}

	return  contour;
}




/**
bool  jbxl::IsIncludeCompleteEdge(BREP_WING* wing)

WingɊ֘AEdgeyт̑dEdge͊SH @n
ɂEdge̓CŒ͕Ă邩H
*/
DllExport bool  jbxl::IsIncludeCompleteEdge(BREP_WING* wing)
{
	BREP_EDGE* edge = wing->edge;
	if (edge->complete) return true;
	if (edge->edge_list!=NULL) {
		BREP_EDGE_LIST::iterator iedge;
		for (iedge=edge->edge_list->begin(); iedge!=edge->edge_list->end(); iedge++){
			if ((*iedge)->complete) return true;
		}
	}
	return false;
}




/**
void  jbxl::FastDeleteFacet(BREP_FACET* facet)

Oɐ Facetɍ폜D
 
Oɐ̂łȂ Facetw肵ꍇ͌쓮D@n
Facet̐ꍇCdelete(Facet) ܂ ~BREP_FACET()sƈXfind()ĂяôŎԂ|D
*/
DllExport void  jbxl::FastDeleteFacet(BREP_FACET* facet)
{
	if (facet==NULL) return;
	if (facet->shell!=NULL) {
		facet->shell->facets.pop_back();
		facet->shell = NULL;
	}

	// Destroy its contours
	BREP_CONTOUR*  bpcn;
	BREP_CONTOUR_LIST::iterator contour = facet->outer_contours.begin();

	while (contour!=facet->outer_contours.end()) {
		bpcn = *contour;
		contour = facet->outer_contours.erase(contour);
		bpcn->facet = NULL;
		delete (bpcn);	
	}
	free(facet);
	
	return;
}




/**
void  jbxl::SetDeletableContoursByEdge(BREP_EDGE* edge)

EdgeɊ֘Atꂽ Contourɍ폜\̃}[ND폜͍sȂD
*/
DllExport void  jbxl::SetDeletableContoursByEdge(BREP_EDGE* edge)
{
	if (edge->edge_list!=NULL) {
		BREP_EDGE_LIST::iterator iedge;
		for (iedge=edge->edge_list->begin(); iedge!=edge->edge_list->end(); iedge++){
			if ((*iedge)->wing1->contour!=NULL) {
				(*iedge)->wing1->contour->facet->deletable = true;
			}
			if ((*iedge)->wing2->contour!=NULL) {
				(*iedge)->wing2->contour->facet->deletable = true;
			}
		}
	}
	else {
		if (edge->wing1->contour!=NULL) {
			edge->wing1->contour->facet->deletable = true;
		}
		if (edge->wing2->contour!=NULL) {
			edge->wing2->contour->facet->deletable = true;
		}
	}
}






//----------------------------------------------------------------------------------------------

/*
int  jbxl::IsAtLine(BREP_VERTEX** v) 

R_ *v[0], *v[1], *v[2] ꒼ɂ邩ǂ𒲂ׂ.

@attention
tolerancěvZ͍člKvH
*/
DllExport int  jbxl::IsAtLine(BREP_VERTEX** v) 
{
	TVECTOR<double> vect  = Vertex2TVector(v[0]);
	TVECTOR<double> vect1 = Vertex2TVector(v[1]);
	TVECTOR<double> vect2 = Vertex2TVector(v[2]) - vect;
	TVECTOR<double> vect3 = Vertex2TVector(v[2]) - vect1;
	vect1 = vect1 - vect;

	int mode = 0;
	double tt;
	double th = ProportionVector(vect2, vect1, tt);
	tt = Max(tt, Zero_Eps);
	if (th>1.-tt) mode = 1;			// 0->1->2
	else {
		th = ProportionVector(vect1, vect2, tt);
		tt = Max(tt, Zero_Eps);
		if (th>1.-tt) mode = 2;		// 0->2->1
		else {
			th = ProportionVector(vect3, vect2, tt);
			tt = Max(tt, Zero_Eps);
			if (th>1.-tt) mode = 3;	// 1->0->2
		}
	}
	return  mode;
}




/**
bool  jbxl::IsForbiddenEdge(BREP_VERTEX** vert)

Vertex vert[0]`vert[2] ꒼ɕł邩ׂD@n
꒼̏ꍇ́CYEdge֎~D܂Cɂ Edgeꍇ͊֘A Contour폜D
*/
DllExport bool  jbxl::IsForbiddenEdge(BREP_VERTEX** vert)
{
	BREP_EDGE* edge = NULL;
	int mode = IsAtLine(vert);
	if (mode==1) {		// 0->1->2
		if (vert[0]->forbidden_list==NULL) vert[0]->forbidden_list = new BREP_VERTEX_LIST();
		if (vert[2]->forbidden_list==NULL) vert[2]->forbidden_list = new BREP_VERTEX_LIST();
		vert[0]->forbidden_list->push_back(vert[2]);
		vert[2]->forbidden_list->push_back(vert[0]);
		edge = FindEdge(vert[0], vert[2]);
	}
	else if (mode==2) {	// 0->2->1
		if (vert[0]->forbidden_list==NULL) vert[0]->forbidden_list = new BREP_VERTEX_LIST();
		if (vert[1]->forbidden_list==NULL) vert[1]->forbidden_list = new BREP_VERTEX_LIST();
		vert[0]->forbidden_list->push_back(vert[1]);
		vert[1]->forbidden_list->push_back(vert[0]);
		edge = FindEdge(vert[0], vert[1]);
	}
	else if (mode==3) {	// 2->0->1
		if (vert[1]->forbidden_list==NULL) vert[1]->forbidden_list = new BREP_VERTEX_LIST();
		if (vert[2]->forbidden_list==NULL) vert[2]->forbidden_list = new BREP_VERTEX_LIST();
		vert[1]->forbidden_list->push_back(vert[2]);
		vert[2]->forbidden_list->push_back(vert[1]);
		edge = FindEdge(vert[1], vert[2]);
	}
	if (edge!=NULL) SetDeletableContoursByEdge(edge);

	if (mode==0) return false;
	return true;
}






//----------------------------------------------------------------------------------------------

/**
bool jbxl::IsCollisionContours(BREP_SOLID* solid, BREP_CONTOUR* contour, BREP_CONTOUR** collision)

Contour  ContourƏՓ˂Ă邩ǂ`FbND

@note
Xs[h͒x
*/
DllExport bool jbxl::IsCollisionContours(BREP_SOLID* solid, BREP_CONTOUR* contour, BREP_CONTOUR** collision)
{
	*collision = NULL;

	BREP_CONTOUR_LIST::iterator icon;
	for (icon=solid->contours.begin(); icon!=solid->contours.end(); icon++){
		if (!disJunctBounds(contour->facet->rbound, (*icon)->facet->rbound)) {
		if (!(*icon)->facet->deletable || (*icon)->facet->notdelete) {
			int svrtx = CommonVertex(*icon, contour);
			if (svrtx==3) {
				*collision = *icon;
				return true;
			}
			
			int lineno;
			if (SamePlaneContour(*icon, contour, lineno)) {
				// Rp`̓_
				if (!contour->hasCollisionVector) contour->ComputeDirectRS();
				if (IsInTriangle(*icon, contour)) {
					*collision = *icon;
					return true;
				}
				if (!(*icon)->hasCollisionVector) (*icon)->ComputeDirectRS();
				if (IsInTriangle(contour, *icon)) {
					*collision = *icon;
					return true;
				}
				
				// 2DՓˌ
				if (CollisionTriContour2D(*icon, contour)) {
					*collision = *icon;
					return true;
				}
			}
			else {
				if (lineno==1) continue;
				// 3DՓˌ
				if (!contour->hasCollisionVector) contour->ComputeDirectRS();
				if (CollisionTriContour3D(*icon, contour)) {
					*collision = *icon;
					return true;
				}
				if (!(*icon)->hasCollisionVector) (*icon)->ComputeDirectRS();
				if (CollisionTriContour3D(contour, *icon)) {
					*collision = *icon;
					return true;
				}
			}
		}
		}
	}
	return false;
}




/**
bool  jbxl::CollisionTriContour3D(BREP_CONTOUR* contour1, BREP_CONTOUR* contour2)

contour1 contour2Փ˂Ă邩ǂ`FbND@n
contour2->directRS, directR, directS \ߌvZĂȂ΂ȂȂDႦ ComputeDirectRS() gp 
*/
DllExport bool  jbxl::CollisionTriContour3D(BREP_CONTOUR* contour1, BREP_CONTOUR* contour2)
{
	double  tc, uc, vc, tm, um, ut, vt, tt, tmt, umt;
	BREP_WING* wing  = contour1->wing;
	TVECTOR<double> directR  = contour2->directR;
	TVECTOR<double> directS  = contour2->directS;
	TVECTOR<double> directRS = contour2->directRS;
	TVECTOR<double> directT;
	TVECTOR<double> directB;
	TVECTOR<double> directQB;
	TVECTOR<double> directN;

	// eӂɂՓˌo
	for (int i=0; i<3; i++) {
		TVECTOR<double> point   = Vertex2TVector(wing->vertex);
		TVECTOR<double> directQ = Vertex2TVector(contour2->wing->vertex) - point;

		for (int j=0; j<2; j++) {		
			directN = Vertex2TVector(wing->next->vertex);
			if (j==0) directB = directN - point;
			else	  directB = directB + (Vertex2TVector(wing->next->next->vertex) - directN)*0.5;
			directQB = directQ^directB;

			um  = directRS*directB;
			tm  = directQB*directS;
			umt = TVectorMultiTolerance(directRS, directB);
			tmt = TVectorMultiTolerance(directQB, directS);

			if (Xabs(um)>Max(umt, Zero_Eps) && Xabs(tm)>Max(tmt, Zero_Eps)) {
				uc =  tm;
				tc = -directQB*directR;
				vc =  directRS*directQ;
				ut = tmt;
				tt = TVectorMultiTolerance(directQB, directR);
				vt = TVectorMultiTolerance(directRS, directQ);

				ut = Max(Collision_Tolerance, (um*ut+umt*uc)/(um*um));
				tt = Max(Collision_Tolerance, (tm*tt+tmt*tc)/(tm*tm));
				vt = Max(Collision_Tolerance, (um*vt+umt*vc)/(um*um));
				uc  = uc/um;
				tc  = tc/tm;
				vc  = vc/um;
				directT = directR + tc*directS;

				if (uc>ut && 1.-uc>ut && tc>tt && 1.-tc>tt && vc>vt && 1.-vc>vt &&
					uc*directT.n>directT.t && (1.-uc)*directT.n>directT.t &&
					tc*directS.n>directS.t && (1.-tc)*directS.n>directS.t && 
					vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
				//	DEBUG_MODE print_messageln("3DՓ %d !!!!  %e  %e  %e", j+1, uc, tc, vc);
				//	PrintFacetAsciiSTL(contour1);
				//	PrintFacetAsciiSTL(contour2);
					return true;
				}
			}
		}
		wing = wing->next;
	}

	return false;
}




DllExport bool  jbxl::CollisionTriContour2D(BREP_CONTOUR* contour1, BREP_CONTOUR* contour2)
{
	double  uc, vc, tm, um, ut, vt, tmt, umt;
	BREP_WING* wing = contour1->wing;
	TVECTOR<double> directR  = contour2->directR;
	TVECTOR<double> directS  = contour2->directS;
	TVECTOR<double> directRS = contour2->directRS;
	
	wing = contour1->wing;
	for (int i=0; i<3; i++) {
		TVECTOR<double> point    = Vertex2TVector(wing->vertex);
		TVECTOR<double> directB  = Vertex2TVector(wing->next->vertex) - point;
		TVECTOR<double> directQ  = Vertex2TVector(contour2->wing->vertex) - point;
		TVECTOR<double> directQB = directQ^directB;
		directB.norm();

		tm  = directQB*directS;
		um  = directRS*directB;
		tmt = TVectorMultiTolerance(directQB, directS);
		umt = TVectorMultiTolerance(directRS, directB);

		if (Xabs(tm)<=Max(tmt, Zero_Eps) || Xabs(um)<=Max(umt, Zero_Eps)) {
			TVECTOR<double> directBR = directB^directR;
			TVECTOR<double> directQR = directQ^directR;
			TVECTOR<double> directQB = directQ^directB;
			uc = ProportionVector(directQB, directBR, ut);
			vc = ProportionVector(directQR, directBR, vt);
			ut = Max(ut, Collision_Tolerance);
			vt = Max(vt, Collision_Tolerance);
			if (uc>ut && 1.-uc>ut && vc>vt && 1.-vc>vt && 
				uc*directR.n>directR.t && (1.-uc)*directR.n>directR.t &&
				vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
	//				DEBUG_MODE print_messageln("ꕽʏ1  %e  %e    %e  %e", uc, vc, ut, vt);
	//				PrintFacetAsciiSTL(contour1);
	//				PrintFacetAsciiSTL(contour2);
					return true;
			}

			directBR = directB^directS;
			directQR = (directQ+directR)^directS;
			directQB = (directQ+directR)^directB;
			uc = ProportionVector(directQB, directBR, ut);
			vc = ProportionVector(directQR, directBR, vt);
			ut = Max(ut, Collision_Tolerance);
			vt = Max(vt, Collision_Tolerance);
			if (uc>ut && 1.-uc>ut && vc>vt && 1.-vc>vt &&  
				uc*directS.n>directS.t && (1.-uc)*directS.n>directS.t &&
				vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
//				DEBUG_MODE print_messageln("ꕽʏ2  %e  %e    %e  %e", uc, vc, ut, vt);
//				PrintFacetAsciiSTL(contour1);
//				PrintFacetAsciiSTL(contour2);
				return true;
			}

			TVECTOR<double> directT = directR + directS;
			directBR = directB^directT;
			directQR = directQ^directT;
			directQB = directQ^directB;
			uc = ProportionVector(directQB, directBR, ut);
			vc = ProportionVector(directQR, directBR, vt);
			ut = Max(ut, Collision_Tolerance);
			vt = Max(vt, Collision_Tolerance);
			if (uc>ut && 1.-uc>ut && vc>vt && 1.-vc>vt &&
				uc*directT.n>directT.t && (1.-uc)*directT.n>directT.t &&
				vc*directB.n>directB.t && (1.-vc)*directB.n>directB.t) { /**/
//				DEBUG_MODE print_messageln("ꕽʏ3  %e  %e    %e  %e", uc, vc, ut, vt);
//				PrintFacetAsciiSTL(contour1);
//				PrintFacetAsciiSTL(contour2);
				return true;
			}
		}

		wing = wing->next;
	}

	return false;
}




DllExport bool  jbxl::IsInTriangle(BREP_CONTOUR* contour1, BREP_CONTOUR* contour2)
{
	double  tc, uc, tt, ut;
	TVECTOR<double>  directS  = contour2->directS;
	TVECTOR<double>  directRS = contour2->directRS;
	TVECTOR<double>  directQ, directT, directN;
	BREP_WING* wing = contour1->wing;

	for (int i=0; i<3; i++) {
		for (int j=0; j<2; j++) {
			directN = Vertex2TVector(wing->vertex);
			if (j==0) directQ = Vertex2TVector(contour2->wing->vertex) - directN;
			else      directQ = directQ - (Vertex2TVector(wing->next->vertex) - directN)*0.5;

			TVECTOR<double>  directSQ = directS^directQ;
			TVECTOR<double>  directQR = directQ^contour2->directR;
			tc = ProportionVector(directQR, directSQ, tt);
			uc = ProportionVector(directSQ, directRS, ut);
			directT = contour2->directR + tc*directS;
			ut = Max(ut, Collision_Tolerance);
			tt = Max(tt, Collision_Tolerance);
			if (tc>tt && 1.-tc>tt && uc>ut && 1.-uc>ut &&
				tc*directS.n>directS.t && (1.-tc)*directS.n>directS.t &&
				uc*directT.n>directT.t && (1.-uc)*directT.n>directT.t) {
//				DEBUG_MODE print_messageln("Op`̓ %d : %e  %e    %e  %e", j+1, tc, uc, tt, ut);
				//PrintFacetAsciiSTL(contour1);
				//PrintFacetAsciiSTL(contour2);
				return true;
			}
		}
	}
	return false;
}




DllExport bool  jbxl::SamePlaneContour(BREP_CONTOUR* contour1, BREP_CONTOUR* contour2, int& lineno)
{
	double  um, umt, tm, tmt;
	BREP_WING* wing = contour1->wing;
	TVECTOR<double>  directB, directQ;

	lineno = 0;
	for (int i=0; i<3; i++) {
		directB = Vertex2TVector(wing->next->vertex)     - Vertex2TVector(wing->vertex);
		directQ = Vertex2TVector(contour2->wing->vertex) - Vertex2TVector(wing->vertex);
		um  = contour2->directRS*directB;
		tm  = contour2->directRS*directQ;
		umt = TVectorMultiTolerance(contour2->directRS, directB);
		tmt = TVectorMultiTolerance(contour2->directRS, directQ);
		if (Xabs(um)<Max(umt, Zero_Eps) && Xabs(tm)<Max(tmt, Zero_Eps)) {
			lineno++;
		}
	}

	if (lineno>=2) return true;
	return  false;
}




DllExport int  jbxl::CommonVertex(BREP_CONTOUR* contour1, BREP_CONTOUR* contour2)
{
	BREP_VERTEX_LIST  vertex_list;

	int cnt = 0;
	BREP_WING* wing1 = contour1->wing;
	for (int i=0; i<3; i++) {
		bool common = false;
		BREP_WING* wing2 = contour2->wing;
		for (int j=0; j<3; j++) {
			if (wing1->vertex==wing2->vertex) {
				cnt++;
				common = true;
				break;
			}
			wing2 = wing2->next;
		}
		if (!common) vertex_list.push_back(wing1->vertex);
		wing1 = wing1->next;
	}
	return cnt;

}



/**
int  jbxl::CreateTriSolidFromSTL(BREP_SOLID* solid, STLData* stldata, int fno, bool check)

STLData BREP_SOLID𐶐DBREP_SOLIDɎgpꂽLȃt@Zbg̐ԂD@n
STLData̖@xNg͖čČvZD@n
JE^gp\D

@param  solid   \bhf[^ւ̃|C^
@param  stldata STLf[^ւ̃|C^
@param  fno     Facet(STLf[^)̐
@param  check   f[^̕ssH

@retval -1  \bhNULLCstldataNULL ܂̓\bh Octree NULL
@retval -3  삪LZꂽD
*/
DllExport int  jbxl::CreateTriSolidFromSTL(BREP_SOLID* solid, STLData* stldata, int fno, bool check)
{
	BREP_SHELL*   shell;
	BREP_FACET*   facet;
	BREP_CONTOUR* contour;
	CVCounter* counter = NULL;
	VECTOR<double> v[4];

	if (solid==NULL || stldata==NULL) return -1;
	if (solid->octree==NULL) return -1; 

	solid->contours.clear();

	// JE^
	int intvl = 1;
	if (solid->counter!=NULL) {
		counter = solid->counter->GetUsableCounter();
		if (counter!=NULL) {
			counter->SetMax(100);
			counter->ResetRate(80, 100);
			intvl = Max(1, fno/100);
		}
	}

	shell = new BREP_SHELL(solid);
	for (int i=0; i<fno; i++) {
		// ǂݍ STLf[^ƗpVECTORϐɊi[
		v[0].x = stldata[i].vect[3]; v[0].y = stldata[i].vect[4];  v[0].z = stldata[i].vect[5];
		v[1].x = stldata[i].vect[6]; v[1].y = stldata[i].vect[7];  v[1].z = stldata[i].vect[8]; 
		v[2].x = stldata[i].vect[9]; v[2].y = stldata[i].vect[10]; v[2].z = stldata[i].vect[11];
		// ł͖@xNg ČvZD

		facet = new BREP_FACET(shell); 
		contour = CreateContourByVector(facet, v, NULL, NULL, false);
		if (contour!=NULL) {
/*
			if (check) {	
				// Փ˔
				BREP_CONTOUR* collision;
				facet->CloseData();
				if (!IsCollisionContours(solid, contour, &collision)) {
					solid->contours.push_back(contour);				// IsCollisionContours()p
				}
				else {
					collision->facet->deletable = true;				// ՓˑD
					FastDeleteFacet(facet);
				}
			}
			else  solid->contours.push_back(contour);
*/
			solid->contours.push_back(contour);
		}
		else  {
			deleteNull(facet);			// g͋
		}

		if (counter!=NULL && i%intvl==0) {
			counter->StepIt();
			if (counter->isCanceled()) {
				deleteNull(facet);
				return -3;
			}
		}
	}
	if (counter!=NULL) counter->PutFill();

	// 
	fno = CloseTriSolid(solid, check, counter);

	return fno;
}




/**
int  jbxl::CreateTriSolidFromVector(BREP_SOLID* solid, int vno, VECTOR<double>* vect, VECTOR<double>* nrml, VECTOR<double>* uvmp, bool check)

VECTOR<double> BREP_SOLID𐶐DBREP_SOLIDɎgpꂽLȃt@Zbg̐ԂD@n
JE^gp\D

@param  solid \bhf[^ւ̃|C^
@param  vno   _f[^̐
@param  vect  _̍Wf[^ւ̃|C^D
@param  nrml  _̖@xNgf[^ւ̃|C^D
@param  uvm   _̋ȖʍWf[^ւ̃|C^D
@param  dupli true: _̏do^Dfalse: do^ȂD
@param  check f[^̕ssH

@retval -1  \bhNULLCstldataNULL ܂̓\bh Octree NULL
@retval -3  삪LZꂽD
*/
DllExport int  jbxl::CreateTriSolidFromVector(BREP_SOLID* solid, int vno, VECTOR<double>* vect, VECTOR<double>* nrml, UVMAP<double>* uvmp, bool dupli, bool check)
{
	BREP_SHELL*   shell;
	BREP_FACET*   facet;
	BREP_CONTOUR* contour;
	CVCounter* counter = NULL;
	int fno = vno/3;

	if (solid==NULL || vect==NULL) return -1;
	if (solid->octree==NULL) return -1; 

	solid->contours.clear();

	// JE^
	int intvl = 1;
	if (solid->counter!=NULL) {
		counter = solid->counter->GetUsableCounter();
		if (counter!=NULL) {
			counter->SetMax(100);
			counter->ResetRate(80, 100);
			intvl = Max(1, fno/100);
		}
	}

	VECTOR<double>* normal = NULL;
	UVMAP<double>*  uvmap  = NULL;
	shell = new BREP_SHELL(solid);
	//
	for (int i=0; i<fno; i++) {
		facet = new BREP_FACET(shell); 
		if (nrml!=NULL) normal = nrml + i*3;
		if (uvmp!=NULL) uvmap  = uvmp + i*3;
		contour = CreateContourByVector(facet, vect+i*3, normal, uvmap, dupli);

		if (contour!=NULL) {
/*
			if (check) {	
				// Փ˔D
				BREP_CONTOUR* collision;
				facet->CloseData();
				if (!IsCollisionContours(solid, contour, &collision)) {
					solid->contours.push_back(contour);				// IsCollisionContours()p
				}
				else {
					collision->facet->deletable = true;				// ՓˑD
					FastDeleteFacet(facet);
				}
			}
			else  solid->contours.push_back(contour);
*/
			solid->contours.push_back(contour);
		}
		else  {
			deleteNull(facet);			// g͋
		}

		if (counter!=NULL && i%intvl==0) {
			counter->StepIt();
			if (counter->isCanceled()) {
				deleteNull(facet);
				return -3;
			}
		}
	}
	if (counter!=NULL) counter->PutFill();

	//
	fno = CloseTriSolid(solid, check, counter);
	
	return fno;
}




/**
void  jbxl::AddVector2TriSolid(BREP_SOLID* solid, BREP_SHELL* shell, VECTOR<double>* vect, VECTOR<double>* nrml, UVMAP<double>* uvmp, bool dupli)

vect[3] BREP_SOLIDɂPV[PVɒǉD
f[^̒ǉICK CloseSolid() ĂԂƁD@n

JE^͖DOŗp邱ƁD

@param  solid \bhf[^ւ̃|C^
@param  shell VFf[^ւ̃|C^
@param  vect  3̒_f[^ vect[3] ւ̃|C^
@param  nrml  _̖@xNgf[^ւ̃|C^D
@param  uvmp  _̋ȖʍWf[^ւ̃|C^D
@param  dupli true: _̏do^Dfalse: do^ȂD
*/
DllExport void  jbxl::AddVector2TriSolid(BREP_SOLID* solid, BREP_SHELL* shell, VECTOR<double>* vect, VECTOR<double>* nrml, UVMAP<double>* uvmp, bool dupli)
{
	BREP_FACET*   facet;
	BREP_CONTOUR* contour;

	if (solid==NULL || shell==NULL || vect==NULL) return;
	if (solid->octree==NULL) return; 

	facet = new BREP_FACET(shell); 
	contour = CreateContourByVector(facet, vect, nrml, uvmp, dupli);
	if (contour!=NULL) {
/*
		if (check) {	
			// Փ˔
			BREP_CONTOUR* collision;
			facet->CloseData();
			if (!IsCollisionContours(solid, contour, &collision)) {
				solid->contours.push_back(contour);				// IsCollisionContours()p
			}
			else {
				collision->facet->deletable = true;				// ՓˑD
				FastDeleteFacet(facet);
			}
		}
		else  solid->contours.push_back(contour);
*/
		solid->contours.push_back(contour);
	}
	else {
		deleteNull(facet);
	}

	return;
}



/**
int  jbxl::CloseTriSolid(BREP_SOLID* solid, bool check, CVCounter* counter)

AddVector2TriSolid() ̍ŌɌĂŁCf[^N[YD
BREP_SOLIDɎgpꂽLȃt@Zbg̐ԂD

@param  solid    \bhf[^ւ̃|C^
@param  check    f[^̃G[`FbNs? sꍇCsf[^͍폜D
@param  counter  zJE^D
@retval -1  \bhNULL
*/
DllExport int  jbxl::CloseTriSolid(BREP_SOLID* solid, bool check, CVCounter* counter)
{
	if (solid==NULL) return -1;

	// deletableɂȂĂContour邩Ȃ̂ŁCCreateContoursList()ō蒼D 	
	CreateContoursList(solid);
	CreateWingsList(solid);

	if (check) {
		// dEdge̍폜
		CreateSurplusContoursList(solid);	
		if (counter!=NULL) counter->MakeChildCounter(10);
		DeleteSurplusContours(solid);
		if (counter!=NULL) counter->DeleteChildCounter();
		// ɕ Edge̍폜
		CreateShortageWingsList(solid);
		if (counter!=NULL) counter->MakeChildCounter(10);
		DeleteStraightEdges(solid);     	
		if (counter!=NULL) counter->DeleteChildCounter();
	}

	CreateSurplusContoursList(solid);	// 蒼	
	CreateShortageWingsList(solid); 
	solid->vcount = 3;					// for Triangle Facet
	solid->CloseData();					// Close Octree
	//
	return  (int)solid->contours.size();
}



DllExport  bool  jbxl::IsConnectEdges(BREP_WING* wing1, BREP_WING* wing2)
{
	if (GetWingOtherSide(wing1)->vertex==wing2->vertex) return true;
	return false;
}


