/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBXL_PROTOCOL_H_
#define  __JBXL_PROTOCOL_H_


/**
@brief   vgR̓Cu wb_
@file    protocol.h
@author  Fumi.Iseki (C)
@date    2009 2/5


Example)
@code
	tList* lp  = get_protocol_header_list(buf, ':', TRUE, TRUE);
	Buffer cnt = restore_protocol_contents(lp);
	.........
	.........
	.........
	set_protocol_contents(lp, cnt);
	Buffer snd = restore_protocol_header(lp, ": ", ON, NULL);

	free_Buffer(&cnt);
	del_tList(&lp);
@endcode
*/


#include "xtools.h"



/**/

// Header tList ̃L[
#define HDLIST_FIRST_LINE_KEY  		"FIRST_LINE"
#define HDLIST_CONTENTS_KEY			"CONTENTS_DATA"
#define HDLIST_CONTINUE  			"HEADER_CONTINUE"
#define HDLIST_END_KEY				"HEADER_END"






//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Protocol Header
//

tList*  get_protocol_header_list(Buffer buf, char deli, int fstline, int rcntnt);
Buffer  restore_protocol_header (tList* pp, char* deli, int mode, int* hdsz);

Buffer  restore_protocol_contents(tList* pp);
void	set_protocol_contents(tList* pp, Buffer cnt);

tList*  get_protocol_header_list_seq(tList* list, Buffer buf, char deli, int fstline, int rcntnt);
tList*  get_protocol_header_list_file(char* fname, char deli, int fstline, int rcntnt);

// wb_f[^̍쐬
#define create_protocol_header(p, k, v)           			add_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define create_protocol_header_Buffer(p, k, v)    			add_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)
#define add_protocol_header(p, k, v)           				add_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define add_protocol_header_Buffer(p, k, v)    				add_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)
#define delete_protocol_header(p, k, n)    					del_tList_key((p), (k), (n))



//     ldat.val̃Rs[Ԃ
Buffer  search_protocol_header(tList* list, char* key, int no);
Buffer  search_protocol_header_item (tList* list, char* key, int no, char deli, int nm);
Buffer  search_protocol_header_value(tList* list, char* key, char* data, int no);
Buffer  search_protocol_header_partvalue(tList* list, char* key, char* data, int no);

#define get_protocol_header(l, k, n) 						search_protocol_header((l), (k), (n))
#define get_protocol_header_item (l, k, n, d, n) 			search_protocol_header_item ((l), (k), (n), (d), (n))
#define get_protocol_header_value(l, k, d, n) 				search_protocol_header_value((l), (k), (d), (n)) 
#define get_protocol_header_partvalue(l, k, d, n) 			search_protocol_header_partvalue((l), (k), (d), (n))


// ݒCu
int 	set_protocol_header(tList* list, char* key, int no, char* value, int mode);

#define	set_protocol_record_item(l, d, m, v)				set_item_tList_node((l), (d), (m), (v))
#define replace_protocol_record_item(l, d, m, s, v)			replace_item_tList_node((l), (d), (m), (s), (v))


/**
int		replace_protocol_header(tList* list, char* key, int no, char* srcval, char* value)

Xg(lt) noԖڂ keym[h̒l srcval̕ value ɒuD
no  0ȉ̏ꍇ́CSĂ keym[h̒lɑ΂ĒusD@n
replace_valute_tList() Ɠ֐ (in Lib/tlist.c)
@param  list    Ώۂ̃Xg
@param  key     usm[h̃L[
@param  no      ڂ̍ڂu邩D1琔D0ȉ̏ꍇkeyvSĂ̍ڂu
@param  srcval  uΏۂ̕D
@param  value   usD

@retval 0ȏ   ύXꂽm[h̐Dw肳ꂽm[h݂Ȃ́iǉꂽꍇj0
@retval     G[D
*/
#define	replace_protocol_header(list, key, no, srcval, value)	replace_value_tList((list), (key), (no), (srcval), (value))


/**
int     replace_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)

key L[ɂ noԖڂ̃m[h̒l̒ŁCdeli؂ɂ nmԖڂ̍ځij srcval valueŒuD
@param  list    Ώۂ̃wb_i[Xg
@param  key     wb_ʁD
@param  no      wb_ʂꍇCԖڂ̃m[hw肷D1琔D
                no 0ȉ̏ꍇ keyvSẴm[hɑ΂đsD
@param  deli    m[hlij̋؂蕶D
@param  nm      deli ؂蕶ƂĉԖڂ̍ڂH 1琔D
@param  srcval  uΏۂ̕DNULLȂw肵ڂ̕S
@param  value   u镶D
@return usm[hD
*/
#define replace_protocol_header_item(list, key, no, deli, nm, srcval, value)  replace_item_tList((list), (key), (no), (deli), (nm), (srcval), (value))


/**
int     set_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* value)

key L[ɂ noԖڂ̃m[h̒l̒ŁCdeli؂ɂ nmԖڂ̍ځijvalue ݒ肷D
@param  list   Ώۂ̃wb_i[Xg
@param  key    wb_ʁD
@param  no     wb_ʂꍇCԖڂ̃m[hw肷D1琔D
               no 0ȉ̏ꍇ keyvSẴm[hɑ΂đsD
@param  deli   m[hlij̋؂蕶D
@param  nm     deli ؂蕶ƂĉԖڂ̍ڂH 1琔D
@param  value  ݒ肷镶D
@return ݒsm[hD
*/
#define	set_protocol_header_item(list, key, no, deli, nm, value)		set_item_tList((list), (key), (no), (deli), (nm), (value))




//
int  	search_crlfcrlf(char* mesg);
int  	is_header_continue(tList* pp);



/**/



#endif



