
#ifndef  __JBXL_CPP_GRAPHIC_IO_H_
#define  __JBXL_CPP_GRAPHIC_IO_H_


/**
@brief    OtBbNpt@Co͊֐wb_  
@file     Gio.h
@author   Fumi.Iseki (C)

CTt@Cւ̓o͂T|[gD܂Ct@Co͂̓֐T|[g@n
JPEG ɂĂ JpegTool.cpp QƁD
*/


#ifdef WIN32
#pragma warning(disable:4995)
#endif




#include "Gdata.h"



//
namespace jbxl {



/**
@file   Gio.h

t@C`ƃwb_
---
@par Common`
@code
	CmnHead  cmhd   : common header. 36Byte. 
	Graphic  Header : 摜f[^ŗL̃wb_
	Graphic  Data   : f[^
@endcode
Cӂ̉摜f[^ۑ鎞C̉摜f[^Ɏʃwb_(CmnHead) tĕۑ́D

@par UN_KNOWN_DATA


@par MOON_DATA


@par DICOM_DATA


@par USERSET_DATA


@par RAS_DATA


@par JPEG_RGB_DATA


@par JPEG8_DATA


@par CT_DATA
@code
	CmnHead  cmhd : common header. 36Byte. iȗj
	CTHead   cthd : CT header (Moon Header). 64Byte. o Word^. 
	Graphic  Data : f[^
@endcode
Common Header͏ȗD@n
 Moon^̃wb_ CT摜f[^D݂ CT摜ۑꍇ́CftHgł̌^ŕۑD@n
CTHead  cthd.anydata[0]ɉfԊuCcthd.anydata[1]ɉ摜Ԋu 1/RZXY_RATE mmPʂŕۑĂꍇD@n
t@Cǂݍ܂CCmnHead Ɋi[ꂽꍇ́CCT_3DMƋʂȂD  


@par CT_3DM    
@code
	CmnHead  cmhd : common header. 36Byte. 
	CTHead   cthd : CT header (Moon Header). 64Byte. 
	Graphic  Data : f[^
@endcode
3D CTf[^ۑꍇɎgpf[^̌^D
CTHead  cthd.anydata[0]ɉfԊuCcthd.anydata[1]ɉ摜Ԋu 1/RZXY_RATE mmPʂŕۑĂꍇD@n
ŎgpꍇiCmnHeadɊi[ꂽꍇj CT_Data ƋʂȂD


@par CT_3D_VOL

*/    
    


//////////////////////////////////////////////////////////////////////////////////////////////////////////
//  for Simple
//
//template <typename T>  int  writeRasFile(const char *fname, MSGraph<T> vp);
//template <typename T>  MSGraph<T>  readRasFile(const char *fname);




//////////////////////////////////////////////////////////////////////////////////////////////////////////
//  for SUN Raster & User Define
//
CmnHead	readUserSetData(FILE* fp, CmnHead* ch, bool cnt=false);	///< read_user_data() for C  // [Uw(ch)̃f[^`Ńt@Cǂݍ
CmnHead	readRasData(FILE* fp);									///< read_ras_data()  for C  // SUN RASTER`̃t@Cǂݍ 
int		writeRasData(FILE* fp, CmnHead* ch, int obit=8);		///< write_ras_data() for C



//////////////////////////////////////////////////////////////////////////////////////////////////////////
//  for CT摜
//
CmnHead	readMoonFile(const char* fn, bool no_ntoh=false);	
CmnHead	readMoonData(FILE* fp, unsigned int fsz=0, bool no_ntoh=false);	// MOON_DATA`̃t@CǂݍށD

int		dicomHeader(FILE* fp, int fsize, int* dsize, int* xsize, int* ysize, int* depth, float* rzxy);
MSGraph<sWord> readDicomFile(const char* fn);
MSGraph<sWord> readDicomData(FILE* fp, int fsz);



/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  for I/O   t@CΉ
//

//template <typename T> MSGraph<T> readGraphicFile  (const char* fname, CmnHead* chd=NULL, bool cnt=false);
//template <typename T> MSGraph<T> readGraphicSlices(const char* frmt, int fst, int fnd, CmnHead* chd);
//template <typename T> int writeGraphicFile(const char *fname, MSGraph<T> vp, int kd=0, int fn=0, int tn=-1, bool cnt=false);

CmnHead readXHead      (const char* fn, CmnHead* ch=NULL);				 ///< wb_̂ݓǂݍ 
CmnHead	readXHeadFile  (const char* fn, CmnHead* ch=NULL, bool cnt=false); ///< gread֐Dt@CʂēǂݍށD
CmnHead	readCmnHeadFile(const char* fn, CmnHead* ch, bool cnt=false);		 ///< gread֐Dt@Cʂw肵ēǂݍށD

int		writeCmnHeadFile(const char* fn, CmnHead* hd, bool cnt=false);
int 	writeCmnHeadData(FILE* fp, CmnHead* hd, bool cnt=false);





/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  bƂ̊֐Ή
/*
CmnHead	   readRasData()		 	read_ras_data()  for C 
CmnHead	   readUserSetData()		read_user_data() for C 
int		   writeRasData()			write_ras_data() for C
int		   writeRasFile()			write_ras_file() for C
MSGraph<T> readRasFile()			read_ras_file()  for C
int		   dicomHeader() 			dicom_header()   for C
*/






///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// t@CɂI/OT|[g

/**
template <typename T>  MSGraph<T> readGraphicFile(const char* fname, CmnHead* chd=NULL, bool cnt=false)

FXȃOtBbNt@CǂݍŁCMSGraph<T>Ɋi[D@n

T|[gĂf[^`, 
- Common `    : Common `ɂēǂݍށD(CT_RGN_SL͖T|[g)
- Sun Raster     : Common `ɕϊDwb_ RAS_DATA ɂȂ 
- Moon(CT)       : Common `ɕϊDwb_ MOON_DATA ɂȂD
- USERSET_DATA   : CmnHead* chd Ńwb_w肵āCǂݍ݂sDwb_ USERSET_DATAɂȂD
- DICOM_DATA     : DICOM t@C
- JPEG_RGB_DATA  : JPEG t@C
- JPEG_MONO_DATA : mN JPEG
- unkonwn        : t@Ĉ܂܁Chd->grptr֓ǂݍށDwb_ UN_KNOWN_DATA ɂȂD

CUN_KNOWN_DATȀꍇ CmnHaed hd->kind, hd->lsize, hd->gptr ̂ݗLD

@param      fname  ǂݍނst@CD
@param[in]  chd    USERSET_DATAw̏ꍇCt@C̃wb_ꂽ CmnHead
@param[out] chd    CmnHeadɂi[ꍇ́C̃AhXwD 			
@param      cnt    JE^ivOXo[jgp邩ǂH
			
@return ǂݍ񂾃OtBbNf[^ƁCLq鋤ʃwb_D

G[Ȃ MSGraph.isNull()^C܂  CmnHead.kind = HEADER_ERROR ƂȂD@n
܂G[̎ނɂ MSGraph.stateω.@n

@retval ERROR_GRAPH_HEADER  @b state t@C̃wb_ǂݎG[D
@retval ERROR_GRAPH_MEMORY  @b state G[D

@par CmnHead̃wb_ (chd!=NULL̂Ƃ̂) @b chd->kind 
- HEADER_ERROR:  f[^ǂݍݎsD
- UN_KNOWN_DATA: wb_͂łȂ̂Ńt@CC[Ŵ܂ chd->grptrɊi[D
	- chd->kind, chd->lsize, chd->gptr̂ݗLDMSGraph<T>.gp  NULLD
- ̑: MSGraph<T> ɉ摜f[^D*chd ɂ̓wb_݂̂D
	- chd->buf, chd->gptr  NULL.  CT_DATA, RAS_DATA, CT_3DM ȂǁD

@bug Common `̉f[x 24,32bit̏ꍇ̃GfBA
*/
template <typename T>  MSGraph<T> readGraphicFile(const char* fname, CmnHead* chd=NULL, bool cnt=false)
{
    MSGraph<T> vp;
	CmnHead    hd;
	CVCounter* counter = NULL;

	counter = GetUsableGlobalCounter();
	if (counter!=NULL) {
		counter->SetMax(100);
		counter->MakeChildCounter(80);
	}

	vp.init();

    hd = readXHeadFile(fname, chd, cnt);
	if (counter!=NULL) counter->DeleteChildCounter();	

	// Error
	if (hd.kind==HEADER_ERROR) {
		free_CmnHead(&hd);
		if (hd.xsize<0) vp.state = hd.xsize;
		else            vp.state = ERROR_GRAPH_HEADER;
		return vp;
	}

	// Unknown Data
	int chk = hd.kind & 0x00ff;
  	if (chk==UN_KNOWN_DATA) {
		if (chd!=NULL) *chd = hd;
		else  free_CmnHead(&hd);
		vp.state = ERROR_GRAPH_HEADER;
		return vp;
	}

	if (counter!=NULL) counter->MakeChildCounter(80);

	if (cnt) {
		CVCounter* counter = GetUsableGlobalCounter();
		if (counter!=NULL) counter->SetTitle("摜f[^֕ϊ");
	} 

	if (chd!=NULL) {
		*chd = hd;
		chd->grptr = chd->buf = NULL;
	}

	vp = copyCmnHead2MSGraph<T>(hd, CH2MG_NORMAL, cnt);
	free_CmnHead(&hd);
	if (vp.gp==NULL) return vp;


	if (ZeroBase!=0) {
		vp.base += ZeroBase;
		for (int i=0; i<vp.xs*vp.ys*vp.zs; i++) vp.gp[i] += (T)ZeroBase;
	}

	if (counter!=NULL){
		counter->DeleteChildCounter();
		counter->PutFill();
	}

  	return  vp;
}




/**
template <typename T>  MSGraph<T>  readGraphicSlices(const char* fmt, int fst, int fnd, CmnHead* chd=NULL, bool cnt=false)

FXȃOtBbNt@CXCXf[^ƂēǂݍŁC3D摜Ƃ
MSGraph<T>Ɋi[D܂Cchd!=NULL ȂCommon(CmnHead)`ɂϊD

Z̘cT|[giCmnHead, Moon`̃t@Ĉ݁j@n
O[oJE^gp\DJE^ɂLZ@\D

readGraphicFile()ƖwǓ@pĂ̂ŁC̑ readGraphicFile()ɏD

@param fmt  ǂݍނst@Ci%dȂǂ̓jD
@param fst  ŏɓǂݍރt@C̔ԍit@C̒ɂ̐Ȃ΂ȂȂj
@param fnd  Ōɓǂݍރt@C̔ԍit@C̒ɂ̐Ȃ΂ȂȂj
@param chd  CmnHeadɂf[^i[ꍇ͂̃AhXwD@n
            ܂ DICOM_DATA, USERSET_DATAw莞̃wb_i[D
@param cnt  zJE^gp邩?

@return MSGraph^̓ǂݍ񂾉摜f[^

@par 
@code
	vp = readGraphicSlices("i%02d", 0, 10); // i00 ` i10 ܂ł11̉摜f[^ǂݍŁCvpɊi[D
@endcode
*/
template <typename T>  MSGraph<T>  readGraphicSlices(const char* fmt, int fst, int fnd, CmnHead* chd=NULL, bool cnt=false)
{
    int   i, k, l, m, chk, kind;
	int   xsize, ysize, zsize, nsize, psize;	// zsize: 1̉摜ZTCYD
												// nsize: oオ 3D摜ZTCY
    char* fr_name;						
    CmnHead    dhd, hd;
	MSGraph<T> vp, gd;


	if (chd!=NULL) {
		DEBUG_MESGLN("readGraphicSlices: Called with kind = 0x%04x", chd->kind);
	}
	else {
		DEBUG_MESGLN("readGraphicSlices: Called with NULL Header");
	}

	gd.init();
	vp.init();

	// 1ځiwb_j̓ǂݏo
    fr_name = numbering_name(fmt, fst);
    dhd = readXHead(fr_name, chd);
    freeNull(fr_name);

	chk = dhd.kind & 0x00ff;
    if (dhd.kind==HEADER_ERROR || chk==UN_KNOWN_DATA) {
		DEBUG_MESGLN("readGraphicSlices: wb_ǂݍ݃G[F kind = %d", dhd.kind);
		free_CmnHead(&dhd);
		vp.state = ERROR_GRAPH_HEADER;
		vp.zs = fst;
		return vp;
	}
	kind  = dhd.kind;
	xsize = dhd.xsize;
	ysize = dhd.ysize;
	zsize = Max(dhd.zsize, 1);
	nsize = zsize*(Xabs(fnd - fst) + 1);
	psize = xsize*ysize*zsize;
	if (dhd.depth==16) gd.color = GRAPH_COLOR_MONO16;
	else               gd.color = GRAPH_COLOR_MONO;

	// JE^
	CVCounter* counter = NULL;
	if (nsize>=10 && cnt) {
		counter = GetUsableGlobalCounter();
		if (counter!=NULL) {
			//counter->SetTitle("}`t@Cǂݍݒ");
			counter->SetMax(nsize/10);
			counter->SetPos(1);
		}
	}

	// Z̘c, x[XCrbound ̐ݒ
	if (dhd.buf!=NULL && (chk==CT_DATA || chk==CT_3DM || chk==DICOM_DATA)) {
		sWord* rz  = (sWord*)dhd.buf;
		if (rz[9]==RZXY_RATE || checkBit(dhd.kind, HAS_RZXY)) {
			float rzm = (float)(rz[8])/rz[9];
			if (rzm<5.0 && rzm>0.) gd.RZxy = rzm;
		}

		if (rz[10]!=0 && checkBit(dhd.kind, HAS_BASE)) {
			gd.base = (T)rz[10];
		}

		if (checkBit(dhd.kind, HAS_RBOUND)) {
			gd.rbound.xmin = rz[6];
			gd.rbound.xmax = rz[7];
			gd.rbound.ymin = rz[4];
			gd.rbound.ymax = rz[5];
			gd.rbound.zmin = rz[2];
			gd.rbound.zmax = rz[3];
		}
	}
	free_CmnHead(&dhd);

	dhd.kind = kind;
	if (chd!=NULL) dhd.kind |= chd->kind & 0xff00;		// IvV
	*chd = getinfo_CmnHead(dhd);


	// f[^ǂݍ݁iZj 1ڂ
    gd.getm(xsize, ysize, nsize);
	if (gd.isNull()) return gd;

	l = 0;
    k = fst;
	m = Sign(fnd - fst);
	while(k != fnd+m){
		fr_name = numbering_name(fmt, k);
		hd = readCmnHeadFile(fr_name, &dhd, false);	// JE^
		free(fr_name);

		chk = hd.kind & 0x00ff;
		if (hd.kind==HEADER_ERROR || chk==UN_KNOWN_DATA) {
			DEBUG_MESGLN("readGraphicSlices: f[^ǂݍ݃G[F n = %d, kind = %d", k, hd.kind);
			free_CmnHead(&hd);
			if (l==0) {		// 1ڂŃG[
				gd.free();
				vp.state = ERROR_GRAPH_HEADER;
				vp.zs = k;
				return vp;
			}
			else {			// r܂ł͓ǂݍ݊
				gd.state = l;
				gd.zs = l*zsize;
				break;
			}
		}

		vp = copyCmnHead2MSGraph<T>(hd, CH2MG_NOPARM, false);	// JE^
		if (vp.isNull()) {
			free_CmnHead(&hd);
			gd.free();
			vp.free();
			vp.state = ERROR_GRAPH_MEMORY;
			vp.zs = k;
			return vp;
		}

        // gd փRs[
		for (i=0; i<psize; i++) gd.gp[i + psize*l] = vp.gp[i] + ZeroBase;
		if (l==0) {
			gd.min = vp.min;
			gd.max = vp.max;
		}
		else {
			gd.min = Min(gd.min, vp.min);
			gd.max = Max(gd.max, vp.max);
		}

		// n
		free_CmnHead(&hd);
		vp.free();
        k += m;
		l++;

		// JE^
		if (counter!=NULL && l%10==0) {
			counter->StepIt();
			if (counter->isCanceled()) {	// LZ
				gd.free();
				vp.state = ERROR_GRAPH_CANCEL;
				vp.zs = k;
				return vp;
			}
		}
	}
	gd.state = l;
	gd.base += ZeroBase;

	if (!checkBit(kind, HAS_RBOUND)) gd.rbound.set(0, gd.xs-1, 0, gd.ys-1, 0, gd.zs-1);
	if (chd!=NULL) {
		if ((chd->kind&0x00ff)==USERSET_DATA) {
			CVCounter* counter = GetUsableGlobalCounter();
			if (counter!=NULL) counter->SetTitle("Converting Data");
			*chd = copyMSGraph2CmnHead(gd);
		}
	}
	if (counter!=NULL) {
		counter->PutFill();
 		//counter->Stop();
	}
   
	return gd;
}




/**
template <typename T>  int  writeGraphicFile(const char *fname, MSGraph<T> vp, int kind=0, int mlt=FALSE, int fnum=0, int tnum=0, bool cnt=false)

OtBbNf[^vpt@CƂďoD

kind Ńt@C̎ʂw\D kind==0 ̏ꍇ
- vp.zs<=1 Ȃ CT_DATAƂĕۑD
- vp.zs >1 Ȃ CT_3DM ƂĕۑD

T|[gf[^` @n
@b CT_DATA, @b CT_3DM, @b MOON_DATA, @b RAS_DATA, @b JPEG_RGB_DATA, @b JPEG_MONO_DATA

RZxy!=1.0 Ȃwb_ɂ̏񂪖ߍ܂D@n
fnum, tnum w肷ƃOtBbNf[^̈ꕔۑłD

@param  fname  ۑۂ̃t@CD
@param  vp     ۑOtBbNf[^D
@param  kind   f[^` + rbg
@param  mlt    3Df[^ƂĕۑȂ
@param  fnum   ۑf[^̎n܂ ZWDftHg 0
@param  tnum   ۑf[^̏I ZWDftHg vp.zs-1
@param  cnt    JE^ivOXo[j\邩H

@retval 1ȏ  ID
@retval ERROR_GRAPH_OPFILE  t@CI[vG[D
@retval ERROR_GRAPH_MEMORY  G[D
@retval ERROR_GRAPH_WRFILE  ݃t@CTCYsv
@retval ERROR_GRAPH_RDFILE  ݃t@C̍ēǂݎs
@retval ERROR_GRAPH_HEADER  ݃t@C̃wb_ُ
@retval ERROR_GRAPH_CANCEL  LZ
*/
template <typename T>  int  writeGraphicFile(const char *fname, MSGraph<T> vp, int kind=0, int mlt=FALSE, int fnum=0, int tnum=0, bool cnt=false)
{
	int		ret;
    CmnHead hd;
	CTHead* chd;

	if (fnum<0)            fnum = 0;
	else if (fnum>vp.zs-1) fnum = vp.zs - 1;
	if (tnum<fnum)         tnum = fnum;
	else if (tnum>vp.zs-1) tnum = vp.zs - 1;


	// for JPEG
	if ((kind&0x00ff)==JPEG_RGB_DATA) {
		if		(vp.color==GRAPH_COLOR_ARGB)   kind = (kind&0xff00) + JPEG_ARGB_DATA;
		else if (vp.color==GRAPH_COLOR_RGBA)   kind = (kind&0xff00) + JPEG_RGBA_DATA;

		if		(vp.color==GRAPH_COLOR_RGB16)  kind = (kind&0xff00) + JPEG16_RGB_DATA;
		else if (vp.color==GRAPH_COLOR_ARGB16) kind = (kind&0xff00) + JPEG16_ARGB_DATA;
		else if (vp.color==GRAPH_COLOR_RGBA16) kind = (kind&0xff00) + JPEG16_RGBA_DATA;
	}

	//
    hd.xsize = vp.xs;
    hd.ysize = vp.ys;
    hd.zsize = tnum - fnum + 1;	//vp.zs;
    hd.depth = sizeof(T)*8;
    hd.grptr = (uByte*)(vp.gp + vp.xs*vp.ys*fnum);
    if (kind==0) {
		hd.kind  = CT_3DM;
		if (hd.zsize==1) hd.kind = CT_DATA;
	}
	else hd.kind = kind;

    hd.lsize = hd.zsize*hd.ysize*hd.zsize*2;
    hd.bsize = sizeof(CTHead);
    hd.buf   = (uByte*)malloc(hd.bsize);
    if (hd.buf==NULL) return ERROR_GRAPH_OPFILE;
   	memset(hd.buf, 0, hd.bsize);

    chd           = (CTHead*)hd.buf;
	chd->xsize    = (sWord)vp.xs;
	chd->ysize    = (sWord)vp.ys;
    chd->ctmin    = (sWord)vp.rbound.zmin;
    chd->ctmax    = (sWord)vp.rbound.zmax;
    chd->cutup    = (sWord)vp.rbound.ymin;
    chd->cutdown  = (sWord)vp.rbound.ymax;
    chd->cutleft  = (sWord)vp.rbound.xmin;
    chd->cutright = (sWord)vp.rbound.xmax;
	hd.kind      |= HAS_RBOUND;

	if (vp.RZxy!=1.0) {
		chd->anydata[0] = (sWord)(vp.RZxy*RZXY_RATE);
        chd->anydata[1] = (sWord)RZXY_RATE;
		hd.kind        |= HAS_RZXY;
    }

	if (vp.base!=0) {
		chd->anydata[2] = (sWord)vp.base + TempBase;
		hd.kind        |= HAS_BASE;
	}


	// ʏ̕ۑ
	if (!mlt) {
		ret = writeCmnHeadFile(fname, &hd, cnt);
	}

	// }`XCX
	else {
		// JE^
		CVCounter* counter = NULL;
		if (hd.zsize>=10 && cnt) {
			counter = GetUsableGlobalCounter();
			if (counter!=NULL) {
				counter->SetMax((hd.zsize+1)/10);
				counter->SetPos(1);
			}
		}

		char filename[LNAME];
		int num = hd.zsize;
		int cnt = fnum;
		hd.zsize = 1;

		for (int i=0; i<num; i++) {
			snprintf(filename, LNAME-2, fname, cnt);
			hd.grptr = (uByte*)(vp.gp + vp.xs*vp.ys*cnt);
			ret = writeCmnHeadFile(filename, &hd, false);
			
			if (counter!=NULL && i%10==0) {
				counter->StepIt();
				if (counter->isCanceled()) {	// LZ
					if (hd.buf!=NULL) free(hd.buf);
					return ERROR_GRAPH_CANCEL;
				}
			}
			if (ret<0) break;
			cnt++;
		}
		if (counter!=NULL) counter->PutFill();
	}

    if (hd.buf!=NULL) free(hd.buf);
    
	return ret;
}





/**
template <typename T>  int  writeRasFile(const char *fname, MSGraph<T> vp)


*/
template <typename T>  int  writeRasFile(const char *fname, MSGraph<T> vp)
{
	if (fname==NULL) return ERROR_GRAPH_IVDARG;

	FILE* fp = fopen(fname, "wb");
	if (fp==NULL) return ERROR_GRAPH_OPFILE;

	CmnHead hd = copyMSGraph2CmnHead(vp);
	writeRasData(fp, &hd);

	fclose(fp);
}




/**
template <typename T>  MSGraph<T>  readRasFile(const char *fname)


*/
template <typename T>  MSGraph<T>  readRasFile(const char *fname)
{
	MSGraph<T> vp;
	CmnHead    hd;
	FILE* fp;

	vp.init();
	fp = fopen(fname, "rb");
	if (fp==NULL) return vp;

	hd = readRasData(fp);
	fclose(fp);

	vp = copyCmnHead2MSGraph<T>(hd, CH2MG_NORMAL);
	return vp;
}



/**/


}		// namespace


#endif
