/**
@brief    Mesh Datap c[
@file     MeshObjectData.cpp
@author   Fumi.Iseki (C)
*/


#include  "MeshObjectData.h"




using namespace jbxl;



///////////////////////////////////////////////////////////////////////////////////////////////////
//
// MeshObjectNode NX
//

void  MeshObjectNode::init(void)
{
	same_material= false;
	material_id  = init_Buffer();
	facet_no	 = -1;
	material_param.init();

	num_vertex   = 0;
	num_texcrd   = 0;
	num_polygon	 = 0;
	num_index	 = 0;

	data_index 	 = NULL;
	vertex_value = NULL;
	normal_value = NULL;
	texcrd_value = NULL;

	next		 = NULL;
	prev		 = NULL;

	setMaterialID();
}



/**
@brief m[hɃ}eAp[^ݒ肵C̃m[hɓ}eA݂邩`bND
*/
void  MeshObjectNode::setMaterial(MaterialParam mparam)
{
	material_param.free();
	material_param.dup(mparam);
	material_param.enable = true;

	MeshObjectNode* node = prev;
	while (node!=NULL) {
		if (isSameMaterial(material_param, node->material_param)) {
			setMaterialID(_tochar(node->material_id.buf));
			same_material = true;
			return;
		}
		node = node->prev;
	}

	node = next;
	while (node!=NULL) {
		if (isSameMaterial(material_param, node->material_param)) {
			setMaterialID(_tochar(node->material_id.buf));
			same_material = true;
			return;
		}
		node = node->next;
	}

	return;
}



void  MeshObjectNode::setMaterialID(const char* str)
{
	free_Buffer(&material_id);
	
	if (str!=NULL) {
		material_id = make_Buffer_str(str);
	}
	else {
		Buffer randomstr = make_Buffer_randomstr(8);
		material_id = make_Buffer_str("#MATERIAL_");
		cat_Buffer(&randomstr, &material_id);
		free_Buffer(&randomstr);
	}

	return;
}



void  MeshObjectNode::set(int vertex, int polygon, int vcount)
{
	num_vertex  = vertex;
	num_texcrd  = num_vertex;
	num_polygon = polygon;
	num_index   = num_polygon*vcount;

	return;
}



void  MeshObjectNode::free(void)
{
	delMaterialParam();
	free_Buffer(&material_id);

	free_value();
}



void  MeshObjectNode::free_value(void)
{
	freeNull(data_index); 
	freeNull(vertex_value); 
	freeNull(normal_value); 
	freeNull(texcrd_value); 
}



void  MeshObjectNode::clear(void)
{
	this->free();
	init();
}



/**
bool  MeshObjectNode::getm(int vertex, int polygon, int vcount)

KvȃmۂD
sCɌW炸CȑÕ͊JD

@retval true  ̊mۂɐD
@retval	false ̊mۂɎsD

@param vertex  _̐
@param polyon  |S̐
@param vcount  P|S̒_iŒj
*/
bool  MeshObjectNode::getm(int vertex, int polygon, int vcount)
{
	free_value();

	if (vertex >0) num_vertex  = vertex;
	if (polygon>0) num_polygon = polygon;
	if (vcount >0) num_index   = num_polygon*vcount;

	if (num_vertex<=0 || num_polygon<=0) return false;
	num_texcrd = num_vertex;

	vertex_value = (Vector<double>*)malloc(num_vertex*sizeof(Vector<double>));
	normal_value = (Vector<double>*)malloc(num_vertex*sizeof(Vector<double>));
	texcrd_value = (UVMap<double>*) malloc(num_texcrd*sizeof(UVMap<double>));
	data_index   = (int*)malloc(num_index*sizeof(int));

	if (data_index==NULL || vertex_value==NULL || normal_value==NULL || texcrd_value==NULL) {
		this->free();
		return false;
	}

	return true;
}



/**
CfbNXꂽ_f[^𒼐 MeshObject̃f[^ƂăC|[gD
*/
bool  MeshObjectNode::computeVertexDirect(FacetBaseData* facetdata)
{
	if (facetdata==NULL) return false;
	if (facetdata->index==NULL || facetdata->vertex==NULL || facetdata->normal==NULL) return false;

	set(facetdata->num_data, facetdata->num_index/facetdata->vcount, facetdata->vcount);
	if (!getm()) return false;

	for (int i=0; i<facetdata->num_index; i++) {
		data_index[i]   = facetdata->index[i];
	}
	for (int i=0; i<num_vertex; i++) {
		normal_value[i] = facetdata->normal[i];
		vertex_value[i] = facetdata->vertex[i];
	}

	if (facetdata->texcrd!=NULL) {
		for (int i=0; i<num_texcrd; i++) {
			texcrd_value[i] = facetdata->texcrd[i];
		}
	}

	return true;
}



/**
񉻁iCfbNXł͂Ȃjꂽ_f[^𒼐 MeshObject̃f[^ƂăC|[gD

̃f[^̍ČǂDԂD@n
@xNgK{Df[^TCY͑傫ȂD@n

@param impvtx C|[g钸_̍Wf[^iK{j
@param impnrm C|[g@xNgf[^iK{j
@param impmap C|[g钸_UV}bvf[^iIvVj
@param impnum C|[gf[^̐
@param vcoint |S̒_Dʏ 3
@return C|[gɐǂD
*/
bool  MeshObjectNode::computeVertexDirect(Vector<double>* impvtx, Vector<double>* impnrm, UVMap<double>* impmap, int impnum, int vcount)
{
	if (impvtx==NULL || impnrm==NULL) return false;

	set(impnum, impnum/vcount, vcount);
	if (!getm()) return false;

	for (int i=0; i<num_vertex; i++) {
		vertex_value[i] = impvtx[i];
		normal_value[i] = impnrm[i];
		data_index[i]   = i;
	}

	if (impmap!=NULL) {
		for (int i=0; i<num_vertex; i++) {
			texcrd_value[i] = impmap[i];
		}
	}

	return true;
}



/**
BREPgpāC_f[^D_f[^͍ăCfbNX@n

f[^CfbNXĂȂꍇCd_폜̂Ńf[^TCYȂD@n
@xNgvZĂȂꍇiipnrmNULL̏ꍇjC@xNgvZD@n
_ꍇ́CɎԂ|D@n

@param impvtx C|[g钸_̍Wf[^DiK{j
@param impnrm C|[g@xNgf[^DNULL̏ꍇCČvZsDiIvVj
@param impmap C|[g钸_UV}bvf[^DiIvVj
@param impnum C|[gf[^̐
@param vcoint |S̒_Dʏ 3
@return C|[gɐǂD
*/
bool  MeshObjectNode::computeVertexByBREP(Vector<double>* impvtx, Vector<double>* impnrm, UVMap<double>* impmap, int impnum, int vcount)
{
	if (impvtx==NULL) return false;

    BREP_SOLID* brep = new BREP_SOLID();
	if (brep==NULL) return false;
	CreateTriSolidFromVector(brep, impnum, impvtx, impnrm, impmap, false, false);	// do^ȂDf[^`FbN͂ȂD

	long int  vnum;
	BREP_VERTEX** vertex_data = GetOctreeVertices(brep->octree, &vnum);
	if (vertex_data==NULL) {
    	freeBrepSolid(brep);
		return false;
	}

	// ̊m
	set((int)vnum, brep->facetno, vcount);
	if (!getm()) {
		::free(vertex_data);
		freeBrepSolid(brep);
		return false;
	}

	// Vertex & Normal & Texcoord
	for (int i=0; i<num_vertex; i++) {
		vertex_value[i] = vertex_data[i]->point;
		normal_value[i] = vertex_data[i]->normal;
		texcrd_value[i] = vertex_data[i]->uvmap;
	}

	// Index
	int polyn = 0;
    BREP_CONTOUR_LIST::iterator icon;
    for (icon=brep->contours.begin(); icon!=brep->contours.end(); icon++){
        BREP_WING* wing = (*icon)->wing;
        for (int i=0; i<vcount; i++) {
			BREP_VERTEX* vertex = wing->vertex;
			if (vertex!=NULL) {
				data_index[polyn*vcount+i] = vertex->index;
			}
            wing = wing->next;
        }
		polyn++;
    }

	::free(vertex_data);
	freeBrepSolid(brep);

	return true;
}





///////////////////////////////////////////////////////////////////

void  jbxl::freeMeshObjectList(MeshObjectNode*& node)
{
	if (node==NULL) return;

	MeshObjectNode* next = node->next;
	if (next!=NULL) freeMeshObjectList(next);

	freeMeshObjectNode(node);

	return;
}



//
MeshObjectNode*  jbxl::DelMeshObjectNode(MeshObjectNode* node)
{
	if (node==NULL) return NULL;

	if (node->prev!=NULL) node->prev->next = node->next;
	if (node->next!=NULL) node->next->prev = node->prev;
			
	MeshObjectNode* next = node->next;
	freeMeshObjectNode(node);

	return next;
}



MeshObjectNode*  jbxl::AddMeshObjectNode(MeshObjectNode* list, MeshObjectNode* node)
{
	if (list==NULL) return node;
	if (node==NULL) return list;

	node->prev = list;
	node->next = list->next;

	if (list->next!=NULL) list->next->prev = node;
	list->next = node;

	return node;
}






///////////////////////////////////////////////////////////////////////////////////////////////////
//
// MeshObjectData NX
//

void  MeshObjectData::init(const char* name)
{
	data_name 	 = make_Buffer_str(name);

	ttl_vertex   = 0;
	ttl_texcrd   = 0;
	num_node	 = 0;
	num_import	 = 0;
	num_vcount	 = 3;

	impvtx_value = NULL;
	impnrm_value = NULL;
	impmap_value = NULL;

	affine_trans = NULL;

	nodelist	 = NULL;
	endplist	 = NULL;
}



void  MeshObjectData::free(void)
{
	free_Buffer(&data_name);
	free_value();

	delAffineTrans();

	freeMeshObjectList(nodelist);
	nodelist = endplist = NULL;
}



void  MeshObjectData::free_value(void)
{
	freeNull(impvtx_value);
	freeNull(impnrm_value);
	freeNull(impmap_value);
}


void  MeshObjectData::clear(void)
{
	this->free();
	init();
}



/**
CfbNXꂽ FacetBaseData importTriData()ɁC Nodef[^ɏށD@n
FACETIIɏ邱Ƃ͂łȂD\ FACETɕĂCFACET1݂̂̏ꍇɎgpD

*/
bool  MeshObjectData::addData(FacetBaseData* facetdata, MaterialParam* param)
{
	bool ret = addNode(facetdata);
	//
	if (ret && param!=NULL) endplist->setMaterialParam(*param);

	return ret;
}



/**
w肵_xNg̃f[^ǉCMeshObject̃f[^iʏFACETPʁj쐬D@n
vct, nrm, map 3ÂgɂȂĎOp|S\D] vnum͕K3̔{ɂȂ͂D@n
FACETIIɏ邱Ƃ͂łȂD\ FACETɕĂCFACET1݂̂̏ꍇɎgpD

@param vect  	ǉΏۂ̒_Wf[^ւ̃|C^
@param nrm   	ǉΏۂ̒_̖@xNg̃f[^ւ̃|C^
@param map   	ǉΏۂ̃eNX`W̃f[^ւ̃|C^
@param vnum  	f[^
@param param 	}eApp[^ւ̃|C^
*/
bool  MeshObjectData::addData(Vector<double>* vct, Vector<double>* nrm, UVMap<double>* map, int vnum, MaterialParam* param)
{
	bool ret = importTriData(vct, nrm, map, vnum);
	if (ret) ret = addNode();
	//
	if (ret && param!=NULL) endplist->setMaterialParam(*param);

	return ret;
}



/**
TriPolyData (Op|Sf[^) PʂƂăf[^ǉCMeshObject̃f[^쐬D@n
num w肷ƁCw肳ꂽFACETiʁj̃f[^݂̂ǉDɂʂƂ̃f[^\`邱ƂłD@n

@param tridata 	ǉΏۂ̎Op|Sf[^ւ̃|C^
@param tnum    	Op|Sf[^̐
@param fnum     ǉf[^FACET̔ԍiIIɒǉꍇɎw肷jD-1ȉȂSĂFACETf[^ǉD
@param param   	}eApp[^ւ̃|C^
*/
bool  MeshObjectData::addData(TriPolyData* tridata, int tnum, int fnum, MaterialParam* param)
{
	bool ret;

	ret = importTriData(tridata, tnum, fnum);
	if (ret) ret = addNode();
	if (ret) {
		if (fnum>=0)     endplist->setFacetNo(fnum);
		if (param!=NULL) endplist->setMaterialParam(*param);
	}

	return ret;
}



/**
w肵_xNg̃f[^荞ށD@n
vct, nrm, map 3ÂgɂȂĎOp|S\D] vnum͕K3̔{ɂȂ͂D

@param vect  	_Wf[^ւ̃|C^
@param nrm   	_̖@xNg̃f[^ւ̃|C^
@param map   	eNX`W̃f[^ւ̃|C^
@param vnum  	f[^
*/
bool  MeshObjectData::importTriData(Vector<double>* vct, Vector<double>* nrm, UVMap<double>* map, int vnum)
{
	if (vct==NULL) return false;
	//
	free_value();

	int lsize = sizeof(Vector<double>)*vnum;
	impvtx_value = (Vector<double>*)malloc(lsize);
	if (impvtx_value!=NULL) memcpy(impvtx_value, vct, lsize);
	else return false;

	if (nrm!=NULL) {
		impnrm_value = (Vector<double>*)malloc(lsize);
		if (impnrm_value!=NULL) {
			memcpy(impnrm_value, nrm, lsize);
		}
		else {
			freeNull(impvtx_value);
			return false;
		}
	}

	if (map!=NULL) {
		int msize = sizeof(UVMap<double>)*vnum;
		impmap_value = (UVMap<double>*)malloc(msize);
		if (impmap_value!=NULL) {
			memcpy(impmap_value, map, msize);
		}
		else {
			freeNull(impvtx_value);
			freeNull(impnrm_value);
			return false;
		}
	}

	num_vcount = 3;
	num_import = vnum;

	return true;
}



/**
TriPolyData (Op|Sf[^) PʂƂăf[^荞ށD@n
num w肷ƁCw肳ꂽFACETiʁj̃f[^݂̂ǉDɂʂƂ̃f[^\`邱ƂłD

@param tridata 	Op|Sf[^ւ̃|C^
@param tnum    	Op|Sf[^̐
@param fnum     ǉf[^FACET̔ԍiIIɒǉԍjD-1ȉȂSĂFACETf[^ǉD
*/
bool  MeshObjectData::importTriData(TriPolyData* tridata, int tnum, int fnum)
{
	if (tridata==NULL) return false;

	free_value();

	int pnum = 0;
	if (fnum>=0) {
		for (int i=0; i<tnum; i++) {
			if (tridata[i].facetNum==fnum) pnum++;
		}
		if (pnum==0) return false;
	}
	else pnum = tnum;

	int vnum  = pnum*3;
	int lsize = sizeof(Vector<double>)*vnum;

	impvtx_value = (Vector<double>*)malloc(lsize);
	if (impvtx_value!=NULL) {
		for (int i=0, n=0; i<tnum; i++) {
			if (tridata[i].facetNum==fnum || fnum<0) {
				impvtx_value[n*3]   = tridata[i].vertex[0];
				impvtx_value[n*3+1] = tridata[i].vertex[1];
				impvtx_value[n*3+2] = tridata[i].vertex[2];
				n++;
			}
		}
	}
	else return false;

	impnrm_value = NULL;
	if (tridata[0].has_normal) {
		impnrm_value = (Vector<double>*)malloc(lsize);
		if (impnrm_value!=NULL) {
			for (int i=0, n=0; i<tnum; i++) {
				if (tridata[i].facetNum==fnum || fnum<0) {
					impnrm_value[n*3]   = tridata[i].normal[0];
					impnrm_value[n*3+1] = tridata[i].normal[1];
					impnrm_value[n*3+2] = tridata[i].normal[2];
					n++;
				}
			}
		}
		else {
			freeNull(impvtx_value);
			return false;
		}
	}

	impmap_value = NULL;
	if (tridata[0].has_texcrd) {
		int msize = sizeof(UVMap<double>)*vnum;
		impmap_value = (UVMap<double>*)malloc(msize);
		if (impmap_value!=NULL) {
			for (int i=0, n=0; i<tnum; i++) {
				if (tridata[i].facetNum==fnum || fnum<0) {
					impmap_value[n*3]   = tridata[i].texcrd[0];
					impmap_value[n*3+1] = tridata[i].texcrd[1];
					impmap_value[n*3+2] = tridata[i].texcrd[2];
					n++;
				}
			}
		}
		else {
			freeNull(impvtx_value);
			freeNull(impnrm_value);
			return false;
		}
	}

	num_vcount = 3;
	num_import = vnum;

	return true;
}



bool  MeshObjectData::addNode(FacetBaseData* facetdata)
{
	bool ret = false;

	MeshObjectNode* node = new MeshObjectNode();
	if (node==NULL) return ret;
	
	ret = node->computeVertexDirect(facetdata);

	if (ret) {
		if (nodelist==NULL) nodelist = endplist = node;
		else                endplist = AddMeshObjectNode(endplist, node);
		//
		num_node++;
		ttl_vertex += node->num_vertex;
		ttl_texcrd += node->num_texcrd;
	}
	//
	return ret;
}



/**


*/
bool  MeshObjectData::addNode(void)
{
	bool ret = false;
	if (impvtx_value==NULL) return ret;

	MeshObjectNode* node = new MeshObjectNode();
	if (node==NULL) return ret;
	
//	ret = node->computeVertexDirect(impvtx_value, impnrm_value, impmap_value, num_import, num_vcount);
	ret = node->computeVertexByBREP(impvtx_value, impnrm_value, impmap_value, num_import, num_vcount);
	if (ret) {
		if (nodelist==NULL) nodelist = endplist = node;
		else                endplist = AddMeshObjectNode(endplist, node);
		//
		num_node++;
		ttl_vertex += node->num_vertex;
		ttl_texcrd += node->num_texcrd;
	}
	//
	freeNull(impvtx_value);
	freeNull(impnrm_value);
	freeNull(impmap_value);

	return ret;
}



void  MeshObjectData::setMaterial(MaterialParam param, int num)
{
	MeshObjectNode* node = nodelist;

	if (num>=0) {
		while (node!=NULL) {
			if (node->facet_no==num) {
				node->setMaterialParam(param);
				return;
			}
			node = node->next;
		}
	}
	else {
		while (node!=NULL) {
			if (!node->material_param.enable) {
				node->setMaterialParam(param);
				return;
			}
			node = node->next;
		}
	}

	return;
}



/**
݂̌`f[^ɁCdataʂ̈ꕔ(Node)ƂČDAtBϊ̃p[^̈Ⴄ̂͌łȂD

@param data MeshObjectf[^Df[^͍폜Df[^̃AtBϊ͖D
*/
void  MeshObjectData::joinData(MeshObjectData*& data)
{
	if (data==NULL) return;

	ttl_vertex += data->ttl_vertex;
	ttl_texcrd += data->ttl_texcrd;
	num_node   += data->num_node;

	if (endplist==NULL) {	// 	ŏ̃f[^
		setAffineTrans(*data->affine_trans);
		nodelist = data->nodelist;
		endplist = data->endplist;
	}
	else if (data->nodelist!=NULL) {
		endplist->next = data->nodelist;
		data->nodelist->prev = endplist;
		endplist = data->endplist;
	}

	data->nodelist = NULL;
	freeMeshObjectData(data);

	return;
}



