
integer data_channel  = 844;

integer debug_mode    = FALSE;
integer starting      = FALSE;

integer stop_time     = 0;
integer stop_sound    = FALSE;
string  station_name  = "";
string  next_station  = "";
string  range         = "shout";
float   dtime         = 1.0;


// note cord
string  notecard_name = "conffile";
key     notecard_key  = "";
integer notecard_line = 0;




// ノートカードの読み込み
parse_conf_file(string str) 
{
    list   items = llParseString2List(str,["=", ",", " ", "\n"], []);
    string name  = llList2String(items,0);
    string value = llList2String(items,1);

    if (name == "debug_mode") {
        integer flg = (integer)value;
        if (flg>0) {
            debug_mode = TRUE;
            llSay(0, "Debug Mode is ON");
        }
        else {
            debug_mode = FALSE;
        }
    }
    else if (name == "data_channel") {
        data_channel = (integer)value;
        if (debug_mode) llSay(0, "Shout Channel is " + value);
    }
    else if (name == "time_interval") {
        dtime = (string)value;
        if (debug_mode) llSay(0, "Shout Interval Time is " + value + " s");
    }
    
    else if (name == "range") {
        range = (string)value;
        if (llToLower(range)=="whisper") {
            if (debug_mode) llWhisper(0, "Message range is Whisper(10m) Range");
        }
        else if (llToLower(range)=="say") {
            if (debug_mode) llSay(0, "Message range is Say(20m) Range");
        }
        else if (llToLower(range)=="region") {
            if (debug_mode) llShout(0, "Message range is Region Range");
        }
        else {
            range = "shout";
            if (debug_mode) llSay(0, "Message range is Shout(100m) Range");
        }
    }

    else if (name == "stop_time") {
        stop_time = (integer)value;
        if (debug_mode) llSay(0, "Stop Time is " + value + " s");
    } 
    else if (name == "stop_sound") {
        integer flg = (integer)value;
        if (flg>0) {
            stop_sound = TRUE;
            if (debug_mode) llSay(0, "Stop Sound is ON");
        }
        else {
            stop_sound = FALSE;
            if (debug_mode) llSay(0, "Stop Sound is OFF");
        }
    }
    
    else if (name == "station_name") {
        station_name = (string)value;
        if (debug_mode) llSay(0, "Station Name is " + value);
    }
    else if (name == "next_station") {
        next_station = (string)value;
        if (debug_mode) llSay(0, "Next Station Name is " + value);
    }

    return;
}




init_lsl()
{
    starting = FALSE;
    llSetColor(<0.0, 1.0, 0.0>, ALL_SIDES);
    llSetTimerEvent(0.0);    
}



read_conf()
{
    notecard_line = 0;
    if (llGetInventoryType(notecard_name)==INVENTORY_NOTECARD) {
        notecard_key = llGetNotecardLine(notecard_name, 0); 
    }
    else {
        setting_params();
    }
}



setting_params()
{
    starting = TRUE;
    llSetColor(<1.0, 0.0, 0.0>, ALL_SIDES);
    llSetTimerEvent(dtime);
}




default
{
    // ノートカードが一行読まれる度に発生するイベント
    dataserver(key requested_key, string data)
    {
        if (requested_key == notecard_key ){
            notecard_key = NULL_KEY;
            if (data != EOF){
                parse_conf_file(data);
                notecard_line++;
                notecard_key = llGetNotecardLine(notecard_name, notecard_line);
            }
            else {
                setting_params();
            }
        }
    }

    
    
    state_entry()
    {
        init_lsl();
    }
    
    
    
    timer()
    {            
        vector pos = llGetPos();
        string mesg = "DATA <"+(string)pos.x+","+(string)pos.y+","+(string)pos.z+">:"+(string)stop_time;
        if (stop_sound) mesg = mesg + "s";
        mesg = mesg + ":" + station_name + ":" + next_station;
        
        if (llToLower(range)=="say") {
            llSay(data_channel, mesg);
            if (debug_mode) llSay(0, mesg);
        }
        else if (llToLower(range)=="whisper") {
            llWhisper(data_channel, mesg);
            if (debug_mode) llWhisper(0, mesg);
        }
        else if (llToLower(range)=="shout") {
            llShout(data_channel, mesg);
            if (debug_mode) llShout(0, mesg);
        }
        else if (llToLower(range)=="region") {
            llRegionSay(data_channel, mesg);
            if (debug_mode) llShout(0, mesg);
        }        
    }
    
    
    
    on_rez(integer num)
    {
        llResetScript();
    }
    
    
    
    touch_start(integer num)
    {
        key avatar = llDetectedKey(0);
        
        if (avatar==llGetOwner()) {
            if (starting) {
                init_lsl();
                llSay(0, "Device Stop");
            }
            else {
                starting = TRUE;
                read_conf();
                llSetColor(<1.0, 0.0, 0.0>, ALL_SIDES);
                llSetTimerEvent(dtime);
                llSay(0, "Device Start");
            }
        }
    }
    
    
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY)         
        {
            init_lsl();
        }
    }
}
