///////////////////////////////////////////////////////////////////////////
//
//
//

integer dat_channel = 844;
integer drv_channel = 846;

integer listen_dat = 0;
integer listen_drv = 0;


vector  prev_point = <0.0, 0.0, 0.0>;
vector  crnt_point = <0.0, 0.0, 0.0>;
vector  next_point = <0.0, 0.0, 0.0>;
string  next_mesg  = "";

float   scan_area  = 0.0;
float   scan_range = 25.0;



init_lsl()
{
    if (listen_dat!=0) llListenRemove(listen_dat);
    listen_dat = llListen(dat_channel, "", "", "");
    if (listen_dat<0) {
        llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_dat);
    }
    
    prev_point = <0.0, 0.0, 0.0>;    
    crnt_point = llGetPos();
    next_point = <0.0, 0.0, 0.0>;
    next_mesg  = "";
}

 



//
queue_point(string recv_mesg)
{
    integer indx = llSubStringIndex(recv_mesg, ":");
    if (indx<0) return;
    vector recv_point = (vector)llGetSubString(recv_mesg, 0, indx-1);    
    
    //llShout(0, "PREV = "+(string)prev_point);    
    //llShout(0, "CRNT = "+(string)crnt_point);    
    //llShout(0, "NEXT = "+(string)next_point);    
    //llShout(0, "RECV = "+(string)recv_point);    
    
    //
    vector ahd = <0.0,0.0,1.0>*llGetRot();            
    vector rvt = recv_point - crnt_point;
    float  rrx = llVecMag(rvt);
    if (rrx==0.0 || rrx>scan_range) return;            
    float  rmt = (ahd.x*rvt.x + ahd.y*rvt.y + ahd.z*rvt.z)/rrx;
    if (rmt<scan_area) return;
    
    
    // First Case
    if (next_mesg=="") {
        //llShout(0, "First Point Detected = " + recv_mesg);
        llSetObjectDesc(recv_mesg);
        crnt_point = llGetPos();
        next_point = recv_point;
        next_mesg  = recv_mesg;
        //llShout(0, "First SET "+recv_mesg);
        return;
    }
      
    if (recv_point!=next_point && recv_point!=crnt_point && recv_point!=prev_point) {
        string dat = llGetObjectDesc();
        if (dat!="") {
            if (dat!="STOP") {            
                vector nvt = next_point - crnt_point;
                float  nrx = llVecMag(nvt);
                float  nmt = (ahd.x*nvt.x + ahd.y*nvt.y + ahd.z*nvt.z)/(nrx*nrx*nrx);
                rmt = rmt/(rrx*rrx);
                
                if ((rmt>0.0 && rmt>nmt) || (nmt<0.0 && rmt<nmt)) {
                    llSetObjectDesc(recv_mesg);
                    next_mesg  = recv_mesg;
                    next_point = recv_point;
                    //llShout(0, "CURRENT = "+(string)nmt);
                    //llShout(0, "RECIVED = "+(string)rmt);
                    //llShout(0, "CHANGE SQUEUE "+recv_mesg);
                }
            }
        }
        else {
            llSetObjectDesc(recv_mesg);
            prev_point = crnt_point;
            crnt_point = next_point;
            next_mesg  = recv_mesg;
            next_point = recv_point;
            //llShout(0, "SET QUEUE "+recv_mesg);
        }
    }
}





default
{
    state_entry()
    {
        if (listen_drv!=0) llListenRemove(listen_drv);
        listen_drv = llListen(drv_channel, "", "", "");
        if (listen_drv<0) {
            llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_drv);
        }
    }
    

        
    link_message(integer from, integer num, string str, key id)
    {
        if (num==1) {
            if (str=="AWAKES") {
                llShout(0, "DATA RECEIVE START");
                init_lsl();
            }
            else if (str=="STOP") {
                if (listen_dat!=0) {
                    llListenRemove(listen_dat);
                    listen_dat = 0;
                }
                llSetObjectDesc("STOP");
                llShout(0, "DRIVER STOP");                
                llResetScript();
            }
        }

    }
    
    

    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    
    
    touch_start(integer total_number)
    {
    }

    
    
    listen(integer ch, string name, key id, string mesg) 
    {
        //llSay(0, "LISTEN: "+(string)ch+" "+name+" "+mesg);
        
        if (ch==dat_channel) {
            //if (listen_dat!=0) {
            //    llListenRemove(listen_dat);
            //    listen_dat = 0;
            //}
        
            list items = llParseString2List(mesg, ["=", " ", "\n"], []);
            string cmd = llList2String(items, 0);
        
            if (cmd=="DATA") {
                string point_mesg = llList2String(items, 1);
                queue_point(point_mesg);
            }
            
            //if (listen_dat!=0) llListenRemove(listen_dat);
            //listen_dat = llListen(dat_channel, "", "", "");
            //if (listen_dat<0) {
            //    llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_dat);
            //}
        }
        
        else if (ch==drv_channel) {
            //if (listen_drv!=0) {
            //    llListenRemove(listen_drv);
            //    listen_dat = 0;
            //}
            
            list items = llParseString2List(mesg, ["=", " ", "\n"], []);
            string cmd = llList2String(items, 0);
            
            if (llToLower(cmd)=="start") {
                llMessageLinked(LINK_THIS, 2, "START", "");
                llShout(0, "DRIVER START");
            }
                
            else if (llToLower(cmd)=="stop") {
                if (listen_dat!=0) {
                    llListenRemove(listen_dat);
                    listen_dat = 0;
                }
                llSetObjectDesc("STOP");
                llMessageLinked(LINK_THIS, 2, "STOP", "");
                llShout(0, "DRIVER STOP");                
                llResetScript();
            }
            
            //if (listen_drv!=0) llListenRemove(listen_drv);
            //listen_drv = llListen(drv_channel, "", "", "");
            //if (listen_drv<0) {
            //   llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_drv);
            //}
            
        }        
    }    

}
