
list point_list = [];
integer point = 1;

integer point_len = 0;



// note cord
string  notecard_name = "route_list";
key     notecard_key  = "";
integer notecard_line = 0;




// ノートカードの読み込み
parse_conf_file(string str) 
{
    list   items = llParseString2List(str,["=", ",", " ", "\n"], []);
    string name  = llList2String(items,0);
    string value = llList2String(items,1);

    if (name == "route") {
        integer route = (integer)value;
        if (route>0) {
            point_list += route;
        }
        //llSay(0, (string)point_list);
    }
    point_len  = llGetListLength(point_list);

    return;
}




read_conf()
{
    notecard_line = 0;
    if (llGetInventoryType(notecard_name)==INVENTORY_NOTECARD) {
        notecard_key = llGetNotecardLine(notecard_name, 0); 
    }
}





default
{
    // ノートカードが一行読まれる度に発生するイベント
    dataserver(key requested_key, string data)
    {
        if (requested_key == notecard_key ){
            notecard_key = NULL_KEY;
            if (data != EOF){
                parse_conf_file(data);
                notecard_line++;
                notecard_key = llGetNotecardLine(notecard_name, notecard_line);
            }
        }
    }


    state_entry()
    {
        llSetText("Point (Touch Me)", <1.,1.,1.>, 1.);
        read_conf();
    }
    
    
    
    on_rez(integer num)
    {
        llResetScript();
    }
    
    
    
    touch_start(integer num)
    {
        point++;
        if (point>=point_len) point = 0;
        
        integer i;
        for (i=0; i<point_len; i++) {
            integer channel = (integer)llList2String(point_list, i);
            if (i==point) {
                llShout(channel, "ON");
                llShout(0, "Route "+(string)channel+" ON");
            }
            else {
                llShout(channel, "OFF");
                llShout(0, "Route "+(string)channel+" OFF");
            }
        }
    }
}