///////////////////////////////////////////////////////////////////////////
//
//


// vvv Configuration/Settings vvv

integer drv_channel = 846;


// Speed
float speed = 1.0;
float warm_time = 5.0;


/////////////////////////////////////////////////////
// Sounds
// Arrive at Station
string stop = "";
float  stopvolume = 1.0;

// Running
string running = "";
float  runningvolume = 1.0;

// Idle
string idle = "";
float  idlevolume = 1.0;

// Leave Station
string start = "";
float  startvolume = 1.0;
float  startsoundlength = 0.5;


////////////////////////////////////////////////////// 
// ^^^ Configuration/Settings ^^^
vector   cpoffset;              // Train Offset
integer  checkpoint = 0;
integer  numcheckpoints = 30;
vector   next_pos;
string   cpdata;
string   spause;
float    pause;
string   csname; 
string   nsname;
integer  cpdataloc;
rotation rot;
vector   increment;
integer  i;
integer  soundstart = FALSE;



next_checkpoint()
{
    if (checkpoint >= numcheckpoints)
    {
        checkpoint = 0;
        if (llGetFreeMemory() <= 2000) llResetScript();
    }
    
    pause     = 0.0;
    spause    = "";
    csname    = "";
    nsname    = "";
    next_pos  = ZERO_VECTOR;
    
    //cpdata    = llList2String(checkpoints, checkpoint);
    cpdataloc = llSubStringIndex(cpdata, ":");  // : の位置

    if (cpdataloc==-1)
    {
        next_pos = ((vector)cpdata + cpoffset);
    }
    else
    {
        next_pos  = ((vector)llGetSubString(cpdata, 0, cpdataloc-1) + cpoffset);
    }

    
    if (soundstart && running!="")
    {
        if (llGetTime()>=startsoundlength)
        {
            soundstart = FALSE;
            llLoopSound(running, runningvolume);
        }
    }


    // Move
    vector  pos = llGetPos();
    vector  dtv = llVecNorm(next_pos-pos)*speed;
    integer nn  = (integer)(llVecMag(next_pos-pos)/speed) + 1;
    
    for(i=0;i<nn;++i)
    {
        pos = llGetPos();
        rotation gr = llGetRot();
        vector srce = <0,0,1>*gr;
        vector dist = next_pos - pos;
        vector ndst = srce + (dist - srce)/(nn-i);
        
        //rot = gr*llRotBetween(<0,0,1>*gr, next_pos-pos);
        rot = gr*llRotBetween(<0,0,1>*gr, ndst);
        llSetPrimitiveParams([PRIM_POSITION, pos+dtv, PRIM_ROTATION, rot]);
    }
    
    
    //
    if (cpdataloc!=-1) {
        cpdata    = llDeleteSubString(cpdata, 0, cpdataloc);
        cpdataloc = llSubStringIndex(cpdata, ":");
        spause    = llGetSubString(cpdata, 0, cpdataloc-1);
        
        if (llGetSubString(spause, -1, -1)=="s" && stop != "")
        {
            llStopSound();
            llPlaySound(stop, stopvolume);
            pause = (float)llGetSubString(cpdata, 0, cpdataloc-2);
        }
        else
        {
            pause = (float)llGetSubString(cpdata, 0, cpdataloc-1);
        }

        if (pause > 0.0) llMessageLinked(LINK_ALL_OTHERS, 1, "STOP",  "");
        
               
        cpdata    = llDeleteSubString(cpdata, 0, cpdataloc);
        cpdataloc = llSubStringIndex(cpdata, ":");
        if (cpdataloc != -1)
        {
            if (idle != "")
            {
                llLoopSound(idle, idlevolume);
            }
            csname = llGetSubString(cpdata, 0, cpdataloc-1);
            cpdata = llDeleteSubString(cpdata, 0, cpdataloc);
            nsname = llGetSubString(cpdata, 0, -1);
            if (llStringLength(csname)>0 && csname!=":") llWhisper(0, "Arrived at " + csname + ".");
        }
        
        if (pause > 0.0)
        {
            llSleep(pause);
            llMessageLinked(LINK_ALL_OTHERS, 1, "START",  "");
            
            if (start != "")
            {
                llStopSound();
                llPlaySound(start, startvolume);
                llResetTime();
                soundstart = TRUE;
            }
        }
        if (llStringLength(nsname)>0 && nsname!=":") llWhisper(0, "Next stop " + nsname + ".");
    }
    
}



init_lsl()
{
    llSetObjectDesc("");
    checkpoint = 0;
        
    vector pos = llGetPos();
    cpoffset = <0.0, 0.0, pos.z-llGround(ZERO_VECTOR)>;

    llShout(0, "STEAM ENGINE START");
    llMessageLinked(LINK_ALL_OTHERS, 1, "START",  "");
}



gogo_train()
{
    init_lsl();
    
    while(TRUE) {
        cpdata = llGetObjectDesc();
        
        if (cpdata!="") {
            llSetObjectDesc("");
            if (cpdata=="STOP") {
                llShout(0, "STEAM ENGINE STOP");
                llMessageLinked(LINK_ALL_OTHERS, 1, "STOP",  "");
                llResetScript();
            }
        
            next_checkpoint();
            checkpoint++;
        }
        else {
            llSleep(0.5);
        }
    }
}






default
{
    state_entry()
    {
    }
        
    

    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    
    touch_start(integer total_number)
    {
    }

    
    timer()
    {
        llSetTimerEvent(0.0);
        gogo_train();
    }    
    
    

    link_message(integer from, integer num, string str, key id)
    {
        if (num==2) {
            if (str=="START") {
                llShout(0, "STEAM ENGINE WARMTH");
                llMessageLinked(LINK_THIS, 1, "AWAKES", "");
                llSetTimerEvent(warm_time);
            }
            else if (str=="STOP") {
                llShout(0, "STEAM ENGINE STOP");
                llMessageLinked(LINK_ALL_OTHERS, 1, "STOP",  "");
                llResetScript();

            }

        }
    }
    
    

    listen(integer ch, string name, key id, string mesg) 
    {
    }    
  
}

