///////////////////////////////////////////////////////////////////////////
//
//


// vvv Configuration/Settings vvv

integer drv_channel = 846;

integer max_lost = 30;


// Speed
float speed = 1.0;
float warm_time = 3.0;



/////////////////////////////////////////////////////
// Sounds
// Arrive at Station
string stop = "";
float  stopvolume = 1.0;

// Running
string running = "";
float  runningvolume = 1.0;

// Idle
string idle = "";
float  idlevolume = 1.0;

// Leave Station
string start = "";
float  startvolume = 1.0;
float  startsoundlength = 0.5;


////////////////////////////////////////////////////// 
// ^^^ Configuration/Settings ^^^
integer  firstpoint = TRUE;
integer  lostcount = 0;
vector   cpoffset;              // Train Offset
integer  checkpoint = 0;
integer  numcheckpoints = 30;
vector   next_pos;
string   cpdata;
string   spause;
float    pause;
string   csname; 
string   nsname;
integer  cpdataloc;
rotation rot;
vector   increment;
integer  soundstart = FALSE;




next_checkpoint()
{
    if (checkpoint >= numcheckpoints)
    {
        checkpoint = 0;
        if (llGetFreeMemory() <= 1000) llResetScript();
    }
    
    pause     = 0.0;
    spause    = "";
    csname    = "";
    nsname    = "";
    next_pos  = ZERO_VECTOR;
    
    //cpdata    = llList2String(checkpoints, checkpoint);
    cpdataloc = llSubStringIndex(cpdata, ":");  // : の位置

    if (cpdataloc==-1) next_pos = (vector)cpdata;
    else               next_pos = (vector)llGetSubString(cpdata, 0, cpdataloc-1);

    if (firstpoint) {
        vector pos = llGetPos();
        cpoffset = <0, 0, pos.z-next_pos.z>;
        firstpoint = FALSE;
    }
    next_pos = next_pos + cpoffset; 

    
    if (soundstart && running!="")
    {
        if (llGetTime()>=startsoundlength)
        {
            soundstart = FALSE;
            llLoopSound(running, runningvolume);
        }
    }


    ////////////////////////////////////////////////////////////
    steam_engine();
    ////////////////////////////////////////////////////////////
    

    if (cpdataloc!=-1) {
        cpdata    = llDeleteSubString(cpdata, 0, cpdataloc);
        cpdataloc = llSubStringIndex(cpdata, ":");
        spause    = llGetSubString(cpdata, 0, cpdataloc-1);
        
        if (llGetSubString(spause, -1, -1)=="s" && stop != "")
        {
            llStopSound();
            llPlaySound(stop, stopvolume);
            pause = (float)llGetSubString(cpdata, 0, cpdataloc-2);
        }
        else
        {
            pause = (float)llGetSubString(cpdata, 0, cpdataloc-1);
        }
        if (pause > 0.0) llMessageLinked(LINK_ALL_OTHERS, 1, "STOP",  "");
              
        cpdata    = llDeleteSubString(cpdata, 0, cpdataloc);
        cpdataloc = llSubStringIndex(cpdata, ":");
        if (cpdataloc != -1)
        {
            if (idle != "")
            {
                llLoopSound(idle, idlevolume);
            }
            csname = llGetSubString(cpdata, 0, cpdataloc-1);
            cpdata = llDeleteSubString(cpdata, 0, cpdataloc);
            nsname = llGetSubString(cpdata, 0, -1);
            if (llStringLength(csname)>0 && csname!=":") llWhisper(0, "Arrived at " + csname + ".");
        }
        
        if (pause > 0.0)
        {
            llSleep(pause);
            llMessageLinked(LINK_ALL_OTHERS, 1, "START",  "");
            if (start != "")
            {
                llStopSound();
                llPlaySound(start, startvolume);
                llResetTime();
                soundstart = TRUE;
            }
            llSleep(2);
        }
        if (llStringLength(nsname)>0 && nsname!=":") llWhisper(0, "Next stop " + nsname + ".");
    }
}




init_lsl()
{
    firstpoint = TRUE;
    lostcount  = 0;
    checkpoint = 0;
        
    //vector pos = llGetPos();
    //cpoffset = <0, 0, 0>;

    llShout(0, "STEAM ENGINE START");
    llMessageLinked(LINK_ALL_OTHERS, 1, "START",  "");
    llSleep(2);
}




gogo_train()
{
    init_lsl();
    
    while(TRUE) {
        cpdata = llGetObjectDesc();
        
        if (cpdata!="") {
            lostcount = 0;
            llSetObjectDesc("");
            if (cpdata=="STOP") {
                llShout(0, "STEAM ENGINE STOP");
                llMessageLinked(LINK_ALL_OTHERS, 1, "STOP",  "");
                llSetPrimitiveParams([PRIM_BUMP_SHINY,ALL_SIDES,PRIM_SHINY_NONE,PRIM_BUMP_NONE,
                                      PRIM_GLOW,ALL_SIDES,0.0,
                                      PRIM_FULLBRIGHT,ALL_SIDES,FALSE]);
                llResetScript();
            }
        
            next_checkpoint();
            checkpoint++;
        }
        else {
            lostcount++;
            if (lostcount>max_lost) {
                llShout(0, "Rail Lost!!");
                llShout(0, "STEAM ENGINE STOP");
                llMessageLinked(LINK_THIS, 1, "STOP", "");
                llMessageLinked(LINK_ALL_OTHERS, 1, "STOP",  "");
                llSetPrimitiveParams([PRIM_BUMP_SHINY,ALL_SIDES,PRIM_SHINY_NONE,PRIM_BUMP_NONE,
                                      PRIM_GLOW,ALL_SIDES,0.0,
                                      PRIM_FULLBRIGHT,ALL_SIDES,FALSE]);
                llResetScript();
            }
            llSleep(0.5);
        }
    }
}




steam_engine()
{
    // Move to Next Point
    integer  i;
    vector   pos  = llGetPos();
    rotation grt  = llGetRot();
    vector   dist = next_pos - pos;
    vector   dtv  = llVecNorm(dist)*speed;
    integer  nn   = (integer)(llVecMag(dist)/speed) + 1;
    vector   srce = <0,0,1>*grt;
    
    rot = grt*llRotBetween(srce, dist);
    
    for(i=0; i<nn; i++)
    {
        llSetPrimitiveParams([PRIM_POSITION, llGetPos() + dtv, PRIM_ROTATION, rot]);
    }
    
    // 
    if (checkpoint%10==0) {
        grt  = llGetRot();
        srce = dist = <0,1,0>*grt;
        if (dist.z!=0) {
            dist.z = 0;    
            rot = grt*llRotBetween(srce, dist);
            llSetPrimitiveParams([PRIM_ROTATION, rot]);
        }
    }
}






default
{
    state_entry()
    {
        llSetPrimitiveParams([PRIM_BUMP_SHINY,ALL_SIDES,PRIM_SHINY_NONE,PRIM_BUMP_NONE,
                              PRIM_GLOW,ALL_SIDES,0.0,
                              PRIM_FULLBRIGHT,ALL_SIDES,FALSE]);
        llSetObjectDesc("");
    }
        

    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    
    touch_start(integer total_number)
    {
    }

    
    timer()
    {
        llSetTimerEvent(0.0);
        gogo_train();
    }    
    
    

    link_message(integer from, integer num, string str, key id)
    {
        if (num==2) {
            if (str=="START") {
                llSetObjectDesc("");
                llShout(0, "STEAM ENGINE WARMING UP " + (string)warm_time + "s");
                llMessageLinked(LINK_THIS, 1, "AWAKES", "");
                llSetPrimitiveParams([PRIM_BUMP_SHINY,ALL_SIDES,PRIM_SHINY_HIGH,PRIM_BUMP_NONE,
                                      PRIM_GLOW,ALL_SIDES,1.0,
                                      PRIM_FULLBRIGHT,ALL_SIDES,TRUE]);
                llSetTimerEvent(warm_time);
            }
            else if (str=="STOP") {
                llShout(0, "STEAM ENGINE STOP");
                llMessageLinked(LINK_ALL_OTHERS, 1, "STOP",  "");
                llSetPrimitiveParams([PRIM_BUMP_SHINY,ALL_SIDES,PRIM_SHINY_NONE,PRIM_BUMP_NONE,
                                      PRIM_GLOW,ALL_SIDES,0.0,
                                      PRIM_FULLBRIGHT,ALL_SIDES,FALSE]);
                llResetScript();
            }
        }
    }
    
    

    listen(integer ch, string name, key id, string mesg) 
    {
    }    
  
}

