
integer point_channel = 0;
integer pointing      = FALSE;
integer listen_point  = 0;

vector  start_color = <0.0, 1.0, 0.0>;
vector  stop_color  = <1.0, 0.0, 0.0>;


// note cord
string  notecard_name = "point_conf";
key     notecard_key  = "";
integer notecard_line = 0;



// ノートカードの読み込み
parse_conf_file(string str) 
{
    list   items = llParseString2List(str,["=", ",", " ", "\n"], []);
    string name  = llList2String(items,0);
    string value = llList2String(items,1);

    if (name == "point_channel") {
        point_channel = (integer)value;
        llSay(0, "Point Channel is " + value);
    }
    
    return;
}



read_conf()
{
    notecard_line = 0;
    if (llGetInventoryType(notecard_name)==INVENTORY_NOTECARD) {
        notecard_key = llGetNotecardLine(notecard_name, 0); 
    }
}




init_lsl()
{
    pointing = FALSE;
    llSetColor(stop_color, ALL_SIDES);
    read_conf();
}






default
{
    // ノートカードが一行読まれる度に発生するイベント
    dataserver(key requested_key, string data)
    {
        if (requested_key == notecard_key ){
            notecard_key = NULL_KEY;
            if (data != EOF){
                parse_conf_file(data);
                notecard_line++;
                notecard_key = llGetNotecardLine(notecard_name, notecard_line);
            }
        }
    }

    
    
    state_entry()
    {
        init_lsl();
    }
    
    
        
    on_rez(integer num)
    {
        llResetScript();
    }
    
    
    
    touch_start(integer num)
    {
        key avatar = llDetectedKey(0);
        
        if (avatar==llGetOwner()) 
        {
            if (pointing) {
                pointing = FALSE;
                llSetColor(stop_color, ALL_SIDES);
                llSay(0, "Point Stop");
            }
            else {
                if (listen_point>0) {
                    pointing = TRUE;
                    llSetColor(start_color, ALL_SIDES);
                    llSay(0, "Point Start with "+(string)point_channel);
                }
                else if (point_channel>0) {
                    listen_point = llListen(point_channel, "", "", "");
                    if (listen_point>0) {
                        pointing = TRUE;
                        llSetColor(start_color, ALL_SIDES);
                        llSay(0, "Point Start with "+(string)point_channel);
                    }
                    else {
                        llShout(0, "ERROR: LISTEN CHANNEL is "+(string)listen_point);
                    }
                }
            }
        }
    }
    


    listen(integer ch, string name, key id, string mesg) 
    {
        //llSay(0, "Recieved "+(string)point_channel+" = "+mesg);
        if (!pointing) return;
        
        if (ch==point_channel) {
            list items = llParseString2List(mesg, ["=", " ", "\n"], []);
            string cmd = llList2String(items, 0);
        
            if (cmd=="ON") {
                llMessageLinked(LINK_ALL_OTHERS, 1, "ON", "");
                llMessageLinked(LINK_ALL_OTHERS, 1, "ON", "");
                llMessageLinked(LINK_ALL_OTHERS, 1, "ON", "");
            }
            else if (cmd=="OFF") {
                llMessageLinked(LINK_ALL_OTHERS, 1, "OFF", "");
                llMessageLinked(LINK_ALL_OTHERS, 1, "OFF", "");
                llMessageLinked(LINK_ALL_OTHERS, 1, "OFF", "");
            }
            else if (cmd=="RESET") {
                llResetScript();
            }
        }
    }


 
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY)         
        {
            init_lsl();
        }
    } 

}